/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.subs;

import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.util.Debug;

public class SubscriptionManagerFactory {
    private static final Class<SubscriptionManager> impl_class;
    private static SubscriptionManager singleton;

    static {
        String impl = System.getProperty("az.factory.subscriptionmanager.impl", "com.biglybt.core.subs.impl.SubscriptionManagerImpl");
        Class<?> temp = null;
        if (impl.length() > 0) {
            try {
                temp = SubscriptionManagerFactory.class.getClassLoader().loadClass(impl);
            }
            catch (Throwable e) {
                Debug.out("Failed to load SubscriptionManager class: " + impl);
            }
        }
        impl_class = temp;
    }

    public static void preInitialise() {
        if (impl_class != null) {
            try {
                impl_class.getMethod("preInitialise", new Class[0]).invoke(null, null);
            }
            catch (Throwable e) {
                Debug.out("preInitialise failed", e);
            }
        }
    }

    public static SubscriptionManager getSingleton() {
        Class<SubscriptionManagerFactory> clazz = SubscriptionManagerFactory.class;
        synchronized (SubscriptionManagerFactory.class) {
            if (singleton != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            if (impl_class == null) {
                throw new RuntimeException("No Implementation");
            }
            try {
                singleton = (SubscriptionManager)impl_class.getMethod("getSingleton", Boolean.TYPE).invoke(null, false);
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            catch (Throwable e) {
                throw new RuntimeException("No Implementation", e);
            }
        }
    }
}

