/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.stats.transfer.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.stats.transfer.LongTermStats;
import com.biglybt.core.stats.transfer.impl.LongTermStatsBase;
import com.biglybt.core.util.FileUtil;

public class LongTermStatsGenericImpl
extends LongTermStatsBase {
    private final long[] st;
    private final long[] ss;
    private final String generic_id;
    private final LongTermStats.GenericStatsSource generic_source;

    public LongTermStatsGenericImpl(String id, LongTermStats.GenericStatsSource source) {
        super(source.getEntryCount());
        this.generic_id = id;
        this.generic_source = source;
        this.ss = new long[this.STAT_ENTRY_COUNT];
        this.st = new long[this.STAT_ENTRY_COUNT];
        this.stats_dir = FileUtil.getUserFile("stats");
        this.stats_dir = FileUtil.newFile(this.stats_dir, "gen." + id);
        this.sessionStart();
        CoreFactory.getSingleton().addLifecycleListener(new CoreLifecycleAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopped(Core core) {
                if (LongTermStatsGenericImpl.this.destroyed) {
                    core.removeLifecycleListener(this);
                    return;
                }
                LongTermStatsGenericImpl longTermStatsGenericImpl = LongTermStatsGenericImpl.this;
                synchronized (longTermStatsGenericImpl) {
                    LongTermStatsGenericImpl.this.closing = true;
                    if (LongTermStatsGenericImpl.this.active) {
                        LongTermStatsGenericImpl.this.sessionEnd();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionStart() {
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            if (this.closing) {
                return;
            }
            boolean enabled = COConfigurationManager.getBooleanParameter("long.term.stats.enable");
            if (this.active || !enabled) {
                return;
            }
            this.active = true;
            long[] current = this.generic_source.getStats(this.generic_id);
            int i = 0;
            while (i < current.length) {
                this.ss[i] = current[i];
                this.st[i] = this.ss[i];
                ++i;
            }
            this.write(1, this.st);
            this.sessionStartComplete("LongTermStats:" + this.generic_id);
        }
    }

    @Override
    protected void updateStats(int record_type) {
        long[] current = this.generic_source.getStats(this.generic_id);
        long[] diffs = new long[this.STAT_ENTRY_COUNT];
        int i = 0;
        while (i < this.STAT_ENTRY_COUNT) {
            diffs[i] = current[i] - this.ss[i];
            ++i;
        }
        this.write(record_type, diffs);
    }

    @Override
    protected long[] getNewFileSessionStats(long[] line_stats) {
        int i = 0;
        while (i < this.STAT_ENTRY_COUNT) {
            int n = i;
            this.st[n] = this.st[n] + line_stats[i];
            int n2 = i;
            this.ss[n2] = this.ss[n2] + line_stats[i];
            ++i;
        }
        return this.st;
    }
}

