/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.stats.transfer;

import com.biglybt.core.Core;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.stats.transfer.LongTermStats;
import com.biglybt.core.stats.transfer.OverallStats;
import com.biglybt.core.stats.transfer.impl.LongTermStatsWrapper;
import com.biglybt.core.stats.transfer.impl.OverallStatsImpl;
import java.util.HashMap;
import java.util.Map;

public class StatsFactory {
    private static OverallStats overall_stats;
    private static LongTermStats longterm_stats;
    private static final Map<String, LongTermStats> generic_longterm_stats;

    static {
        generic_longterm_stats = new HashMap<String, LongTermStats>();
    }

    public static OverallStats getStats() {
        return overall_stats;
    }

    public static LongTermStats getLongTermStats() {
        return longterm_stats;
    }

    public static void initialize(Core core, GlobalManagerStats stats2) {
        overall_stats = new OverallStatsImpl(core, stats2);
        longterm_stats = new LongTermStatsWrapper(core, stats2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongTermStats getGenericLongTermStats(String id, LongTermStats.GenericStatsSource source) {
        Map<String, LongTermStats> map = generic_longterm_stats;
        synchronized (map) {
            LongTermStats result = generic_longterm_stats.get(id);
            if (result == null) {
                result = new LongTermStatsWrapper(id, source);
                generic_longterm_stats.put(id, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLongTermStats() {
        longterm_stats.reset();
        Map<String, LongTermStats> map = generic_longterm_stats;
        synchronized (map) {
            for (LongTermStats lts : generic_longterm_stats.values()) {
                lts.reset();
            }
        }
    }
}

