/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl.v2;

import com.biglybt.core.speedmanager.SpeedManagerPingSource;
import com.biglybt.core.util.average.Average;
import com.biglybt.core.util.average.AverageFactory;

public class PingSourceStats {
    final SpeedManagerPingSource source;
    double currPing;
    final Average shortTerm = AverageFactory.MovingImmediateAverage(3);
    final Average medTerm = AverageFactory.MovingImmediateAverage(6);
    final Average longTerm = AverageFactory.MovingImmediateAverage(10);
    final Average forChecks = AverageFactory.MovingImmediateAverage(100);

    public PingSourceStats(SpeedManagerPingSource _source) {
        this.source = _source;
    }

    public void madeChange() {
    }

    public void addPingTime(int ping) {
        this.currPing = ping;
        this.shortTerm.update(ping);
        this.medTerm.update(ping);
        this.longTerm.update(ping);
    }

    public int getTrend() {
        int retVal = 0;
        if (this.currPing < 0.0) {
            --retVal;
        } else {
            retVal = this.currPing < this.shortTerm.getAverage() ? ++retVal : --retVal;
            retVal = this.currPing < this.medTerm.getAverage() ? ++retVal : --retVal;
            retVal = this.currPing < this.longTerm.getAverage() ? ++retVal : --retVal;
        }
        retVal = this.shortTerm.getAverage() < this.medTerm.getAverage() ? ++retVal : --retVal;
        retVal = this.shortTerm.getAverage() < this.longTerm.getAverage() ? ++retVal : --retVal;
        retVal = this.medTerm.getAverage() < this.longTerm.getAverage() ? ++retVal : --retVal;
        int ABSOLUTE_GOOD_PING_VALUE = 30;
        if (this.currPing < 30.0) {
            ++retVal;
        }
        if (this.shortTerm.getAverage() < 30.0) {
            ++retVal;
        }
        if (this.medTerm.getAverage() < 30.0) {
            ++retVal;
        }
        if (this.longTerm.getAverage() < 30.0) {
            ++retVal;
        }
        int ABSOLUTE_BAD_PING_VALUE = 300;
        if (this.currPing > 300.0) {
            --retVal;
        }
        if (this.shortTerm.getAverage() > 300.0) {
            --retVal;
        }
        if (this.medTerm.getAverage() > 300.0) {
            --retVal;
        }
        if (this.longTerm.getAverage() > 300.0) {
            --retVal;
        }
        return retVal;
    }

    public Average getLongTermAve() {
        return this.longTerm;
    }

    public Average getHistory() {
        return this.forChecks;
    }
}

