/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.speedmanager.impl;

import com.biglybt.core.dht.speed.DHTSpeedTester;
import com.biglybt.core.dht.speed.DHTSpeedTesterContact;
import com.biglybt.core.dht.speed.DHTSpeedTesterContactListener;
import com.biglybt.core.dht.speed.DHTSpeedTesterListener;
import com.biglybt.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public abstract class TestPingSourceImpl
implements DHTSpeedTester {
    private final SpeedManagerAlgorithmProviderAdapter adapter;
    private volatile int contact_num;
    private final List listeners = new ArrayList();
    final CopyOnWriteList sources = new CopyOnWriteList();
    private int period;

    protected TestPingSourceImpl(SpeedManagerAlgorithmProviderAdapter _adapter) {
        this.adapter = _adapter;
        SimpleTimer.addPeriodicEvent("TestPingSourceImpl", 1000L, new TimerEventPerformer(){
            private int ticks;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                List<testSource> sources_to_update;
                ++this.ticks;
                CopyOnWriteList copyOnWriteList = TestPingSourceImpl.this.sources;
                synchronized (copyOnWriteList) {
                    while (TestPingSourceImpl.this.sources.size() < TestPingSourceImpl.this.contact_num) {
                        TestPingSourceImpl.this.addContact(new testSource());
                    }
                    sources_to_update = TestPingSourceImpl.this.sources.getList();
                }
                if (TestPingSourceImpl.this.period > 0 && this.ticks % TestPingSourceImpl.this.period == 0) {
                    testSource[] contacts = new testSource[sources_to_update.size()];
                    sources_to_update.toArray(contacts);
                    TestPingSourceImpl.this.update(contacts);
                }
            }
        });
    }

    protected SpeedManagerAlgorithmProviderAdapter getAdapter() {
        return this.adapter;
    }

    protected void update(testSource[] contacts) {
        int[] round_trip_times = new int[contacts.length];
        this.updateSources(contacts);
        int i = 0;
        while (i < round_trip_times.length) {
            round_trip_times[i] = contacts[i].getRTT();
            ++i;
        }
        i = 0;
        while (i < this.listeners.size()) {
            ((DHTSpeedTesterListener)this.listeners.get(i)).resultGroup(contacts, round_trip_times);
            ++i;
        }
    }

    protected abstract void updateSources(testSource[] var1);

    @Override
    public int getContactNumber() {
        return this.contact_num;
    }

    @Override
    public void setContactNumber(int number) {
        this.contact_num = number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContact(testSource contact) {
        CopyOnWriteList copyOnWriteList = this.sources;
        synchronized (copyOnWriteList) {
            this.sources.add(contact);
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((DHTSpeedTesterListener)this.listeners.get(i)).contactAdded(contact);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContact(testSource contact) {
        CopyOnWriteList copyOnWriteList = this.sources;
        synchronized (copyOnWriteList) {
            this.sources.remove(contact);
        }
    }

    @Override
    public void destroy() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DHTSpeedTesterListener)this.listeners.get(i)).destroyed();
            ++i;
        }
    }

    @Override
    public void addListener(DHTSpeedTesterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DHTSpeedTesterListener listener) {
        this.listeners.remove(listener);
    }

    protected class testSource
    implements DHTSpeedTesterContact {
        private final InetSocketAddress address = new InetSocketAddress(1);
        private final List listeners = new ArrayList();
        private int rtt;

        protected testSource() {
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.address;
        }

        @Override
        public String getString() {
            return "test source";
        }

        @Override
        public int getPingPeriod() {
            return TestPingSourceImpl.this.period;
        }

        @Override
        public void setPingPeriod(int period_secs) {
            TestPingSourceImpl.this.period = period_secs;
        }

        protected int getRTT() {
            return this.rtt;
        }

        protected void setRTT(int _rtt) {
            this.rtt = _rtt;
        }

        protected void failed() {
            int i = 0;
            while (i < this.listeners.size()) {
                ((DHTSpeedTesterContactListener)this.listeners.get(i)).contactDied(this);
                ++i;
            }
        }

        @Override
        public void destroy() {
            TestPingSourceImpl.this.removeContact(this);
        }

        @Override
        public void addListener(DHTSpeedTesterContactListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(DHTSpeedTesterContactListener listener) {
            this.listeners.remove(listener);
        }
    }
}

