/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.security;

import com.biglybt.core.security.CryptoManagerException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.gudy.bouncycastle.jce.ECNamedCurveTable;
import org.gudy.bouncycastle.jce.interfaces.ECPrivateKey;
import org.gudy.bouncycastle.jce.interfaces.ECPublicKey;
import org.gudy.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gudy.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.gudy.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.gudy.bouncycastle.jce.spec.ECPublicKeySpec;
import org.gudy.bouncycastle.math.ec.ECPoint;

public class CryptoECCUtils {
    private static final ECNamedCurveParameterSpec ECCparam = ECNamedCurveTable.getParameterSpec("prime192v2");

    public static KeyPair createKeys() throws CryptoManagerException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", BouncyCastleProvider.PROVIDER_NAME);
            keyGen.initialize(ECCparam);
            return keyGen.genKeyPair();
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to create keys", e);
        }
    }

    public static Signature getSignature(Key key) throws CryptoManagerException {
        try {
            Signature ECCsig = Signature.getInstance("SHA1withECDSA", BouncyCastleProvider.PROVIDER_NAME);
            if (key instanceof ECPrivateKey) {
                ECCsig.initSign((ECPrivateKey)key);
            } else if (key instanceof ECPublicKey) {
                ECCsig.initVerify((ECPublicKey)key);
            } else {
                throw new CryptoManagerException("Invalid Key Type, ECC keys required");
            }
            return ECCsig;
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to create Signature", e);
        }
    }

    public static byte[] keyToRawdata(PrivateKey privkey) throws CryptoManagerException {
        if (!(privkey instanceof ECPrivateKey)) {
            throw new CryptoManagerException("Invalid private key");
        }
        return ((ECPrivateKey)privkey).getD().toByteArray();
    }

    public static PrivateKey rawdataToPrivkey(byte[] input) throws CryptoManagerException {
        BigInteger D = new BigInteger(input);
        ECPrivateKeySpec keyspec = new ECPrivateKeySpec(D, ECCparam);
        PrivateKey privkey = null;
        try {
            privkey = KeyFactory.getInstance("ECDSA", BouncyCastleProvider.PROVIDER_NAME).generatePrivate(keyspec);
            return privkey;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to decode private key");
        }
    }

    public static byte[] keyToRawdata(PublicKey pubkey) throws CryptoManagerException {
        if (!(pubkey instanceof ECPublicKey)) {
            throw new CryptoManagerException("Invalid public key");
        }
        return ((ECPublicKey)pubkey).getQ().getEncoded(false);
    }

    public static PublicKey rawdataToPubkey(byte[] input) throws CryptoManagerException {
        ECPoint W = ECCparam.getCurve().decodePoint(input);
        ECPublicKeySpec keyspec = new ECPublicKeySpec(W, ECCparam);
        try {
            return KeyFactory.getInstance("ECDSA", BouncyCastleProvider.PROVIDER_NAME).generatePublic(keyspec);
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to decode public key", e);
        }
    }
}

