/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.proxy.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.proxy.AEProxyAddressMapper;
import com.biglybt.core.proxy.impl.AEPluginProxyHandler;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AEProxyAddressMapperImpl
implements AEProxyAddressMapper {
    protected static final AEProxyAddressMapper singleton = new AEProxyAddressMapperImpl();
    protected boolean enabled;
    protected String prefix;
    protected long next_value;
    protected final Map<String, String> map = new HashMap<String, String>();
    protected final Map<String, String> reverse_map = new HashMap<String, String>();
    protected final AEMonitor this_mon = new AEMonitor("AEProxyAddressMapper");
    final Map<Integer, PortMappingImpl> port_mappings = new HashMap<Integer, PortMappingImpl>();

    public static AEProxyAddressMapper getSingleton() {
        return singleton;
    }

    protected AEProxyAddressMapperImpl() {
        if (COConfigurationManager.getBooleanParameter("Enable.Proxy") && COConfigurationManager.getBooleanParameter("Enable.SOCKS")) {
            String host = COConfigurationManager.getStringParameter("Proxy.Host");
            try {
                if (host.length() > 0 && InetAddress.getByName(host).isLoopbackAddress()) {
                    this.enabled = true;
                    byte[] b = new byte[120];
                    int i = 0;
                    while (i < b.length) {
                        b[i] = (byte)RandomUtils.nextInt(256);
                        ++i;
                    }
                    this.prefix = ByteFormatter.encodeString(b);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public String internalise(String address) {
        String target;
        if (!this.enabled) {
            return address;
        }
        if (address.length() < 256) {
            return address;
        }
        try {
            this.this_mon.enter();
            target = this.reverse_map.get(address);
            if (target == null) {
                StringBuilder target_b = new StringBuilder(256);
                target_b.append(this.prefix);
                target_b.append(this.next_value++);
                while (target_b.length() < 255) {
                    target_b.append("0");
                }
                target = target_b.toString();
                this.map.put(target, address);
                this.reverse_map.put(address, target);
            }
        }
        finally {
            this.this_mon.exit();
        }
        return target;
    }

    @Override
    public String externalise(String address) {
        if (!this.enabled || address.length() < 255) {
            return address;
        }
        String target = this.map.get(address);
        if (target == null) {
            target = address;
        }
        return target;
    }

    @Override
    public URL internalise(URL url) {
        if (!this.enabled) {
            return url;
        }
        String host = url.getHost();
        if (host.length() < 256) {
            return url;
        }
        String new_host = this.internalise(host);
        String url_str = url.toString();
        int pos = url_str.indexOf(host);
        if (pos == -1) {
            Debug.out("inconsistent url '" + url_str + "' / '" + host + "'");
            return url;
        }
        String new_url_str = String.valueOf(url_str.substring(0, pos)) + new_host + url_str.substring(pos + host.length());
        try {
            return new URL(new_url_str);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return url;
        }
    }

    @Override
    public URL externalise(URL url) {
        if (!this.enabled) {
            return url;
        }
        String host = url.getHost();
        if (host.length() < 255) {
            return url;
        }
        String new_host = this.externalise(host);
        String url_str = url.toString();
        int pos = url_str.indexOf(host);
        if (pos == -1) {
            Debug.out("inconsistent url '" + url_str + "' / '" + host + "'");
            return url;
        }
        String new_url_str = String.valueOf(url_str.substring(0, pos)) + new_host + url_str.substring(pos + host.length());
        try {
            return new URL(new_url_str);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.PortMapping registerPortMapping(int proxy_port, String remote_ip) {
        PortMappingImpl mapping2 = new PortMappingImpl(proxy_port, null, 6881, remote_ip, 6881, null);
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            this.port_mappings.put(proxy_port, mapping2);
        }
        return mapping2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.PortMapping registerPortMapping(int proxy_port, String remote_ip, Map<String, Object> properties) {
        PortMappingImpl mapping2 = new PortMappingImpl(proxy_port, null, 6881, remote_ip, 6881, properties);
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            this.port_mappings.put(proxy_port, mapping2);
        }
        return mapping2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.PortMapping registerPortMapping(int proxy_port, int local_port, String local_ip, int remote_port, String remote_ip, Map<String, Object> properties) {
        PortMappingImpl mapping2 = new PortMappingImpl(proxy_port, local_ip, local_port, remote_ip, remote_port, properties);
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            this.port_mappings.put(proxy_port, mapping2);
        }
        return mapping2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.AppliedPortMapping applyPortMapping(InetAddress address, int port) {
        InetSocketAddress remote_address;
        InetSocketAddress local_address;
        PortMappingImpl mapping2;
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            mapping2 = this.port_mappings.get(port);
        }
        if (mapping2 == null) {
            local_address = null;
            remote_address = new InetSocketAddress(address, port);
        } else {
            InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (bind_ip == null || bind_ip.isAnyLocalAddress()) {
                bind_ip = null;
            }
            if (bind_ip == null && address.isLoopbackAddress() || bind_ip != null && bind_ip.equals(address)) {
                String remote_ip = mapping2.getRemoteIP();
                if (AENetworkClassifier.categoriseAddress(remote_ip) == "Public") {
                    local_address = null;
                    remote_address = new InetSocketAddress(remote_ip, port);
                } else {
                    String local_ip = mapping2.getLocalIP();
                    local_address = local_ip == null ? null : InetSocketAddress.createUnresolved(local_ip, mapping2.getLocalPort());
                    remote_address = InetSocketAddress.createUnresolved(remote_ip, mapping2.getRemotePort());
                }
            } else {
                local_address = null;
                remote_address = new InetSocketAddress(address, port);
            }
        }
        return new AppliedPortMappingImpl(local_address, remote_address, mapping2 == null ? null : mapping2.getProperties());
    }

    @Override
    public InetSocketAddress getLocalAddress(InetSocketAddress remote) {
        return AEPluginProxyHandler.getLocalAddress(remote.getHostName(), remote.getPort());
    }

    private static class AppliedPortMappingImpl
    implements AEProxyAddressMapper.AppliedPortMapping {
        private final InetSocketAddress local_address;
        private final InetSocketAddress remote_address;
        private final Map<String, Object> properties;

        private AppliedPortMappingImpl(InetSocketAddress _local_address, InetSocketAddress _remote_address, Map<String, Object> _properties) {
            this.local_address = _local_address;
            this.remote_address = _remote_address;
            this.properties = _properties;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.remote_address;
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.local_address;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    private class PortMappingImpl
    implements AEProxyAddressMapper.PortMapping {
        private final int proxy_port;
        private final String local_ip;
        private final int local_port;
        private final String remote_ip;
        private final int remote_port;
        private final Map<String, Object> properties;

        private PortMappingImpl(int _proxy_port, String _local_ip, int _local_port, String _remote_ip, int _remote_port, Map<String, Object> _properties) {
            this.proxy_port = _proxy_port;
            this.local_ip = _local_ip;
            this.local_port = _local_port;
            this.remote_ip = _remote_ip;
            this.remote_port = _remote_port;
            this.properties = _properties;
        }

        private String getLocalIP() {
            return this.local_ip;
        }

        private int getLocalPort() {
            return this.local_port;
        }

        private String getRemoteIP() {
            return this.remote_ip;
        }

        private int getRemotePort() {
            return this.remote_port;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister() {
            Map<Integer, PortMappingImpl> map = AEProxyAddressMapperImpl.this.port_mappings;
            synchronized (map) {
                AEProxyAddressMapperImpl.this.port_mappings.remove(this.proxy_port);
            }
        }
    }
}

