/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.proxy.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.plugin.dht.DHTPluginInterface;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AEPluginProxyHandler {
    private static final CopyOnWriteList<PluginInterface> plugins = new CopyOnWriteList();
    private static final int plugin_init_max_wait = 30000;
    private static final AESemaphore plugin_init_complete = new AESemaphore("init:waiter");
    private static boolean enable_plugin_proxies_with_socks;
    private static final Map<Proxy, WeakReference<PluginProxyImpl>> proxy_map;
    private static final CopyOnWriteSet<SocketAddress> proxy_list;
    public static final int LA_EXPLICIT_NET_NONE = 0;
    public static final int LA_EXPLICIT_NET_MIX = 1;
    public static final int LA_EXPLICIT_NET_PURE = 2;
    private static Object tor_install_lock;
    private static Map<String, Long> declines;
    private static boolean tor_installing;
    private static boolean tor_install_fail_reported;

    static {
        COConfigurationManager.addAndFireParameterListener("Proxy.SOCKS.disable.plugin.proxies", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                enable_plugin_proxies_with_socks = !COConfigurationManager.getBooleanParameter(parameterName);
            }
        });
        proxy_map = new IdentityHashMap<Proxy, WeakReference<PluginProxyImpl>>();
        proxy_list = new CopyOnWriteSet(false);
        tor_install_lock = new Object();
        declines = new HashMap<String, Long>();
    }

    public static void initialise(Core core) {
        try {
            PluginInterface[] plugins;
            PluginInterface default_pi = core.getPluginManager().getDefaultPluginInterface();
            default_pi.addEventListener(new PluginEventListener(){

                @Override
                public void handleEvent(PluginEvent ev) {
                    int type = ev.getType();
                    if (type == 8) {
                        AEPluginProxyHandler.pluginAdded((PluginInterface)ev.getValue());
                    }
                    if (type == 9) {
                        AEPluginProxyHandler.pluginRemoved((PluginInterface)ev.getValue());
                    }
                }
            });
            PluginInterface[] pluginInterfaceArray = plugins = default_pi.getPluginManager().getPlugins(true);
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                PluginInterface pi = pluginInterfaceArray[n2];
                if (pi.getPluginState().isOperational()) {
                    AEPluginProxyHandler.pluginAdded(pi);
                }
                ++n2;
            }
            default_pi.addListener(new PluginAdapter(){

                @Override
                public void initializationComplete() {
                    plugin_init_complete.releaseForever();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void pluginAdded(PluginInterface pi) {
        String pid = pi.getPluginID();
        if (pid.equals("aznettor") || pid.equals("azneti2phelper")) {
            plugins.add(pi);
        }
    }

    private static void pluginRemoved(PluginInterface pi) {
        String pid = pi.getPluginID();
        if (pid.equals("aznettor") || pid.equals("azneti2phelper")) {
            plugins.remove(pi);
        }
    }

    private static boolean waitForPlugins(int max_wait) {
        if (PluginInitializer.isInitThread()) {
            Debug.out("Hmm, rework this");
        }
        return plugin_init_complete.reserve(max_wait);
    }

    public static boolean hasPluginProxyForNetwork(String network, boolean supports_data) {
        boolean wait_complete;
        boolean result;
        long start = SystemTime.getMonotonousTime();
        do {
            long rem;
            if ((rem = 30000L - (SystemTime.getMonotonousTime() - start)) <= 0L) {
                return false;
            }
            wait_complete = AEPluginProxyHandler.waitForPlugins(Math.min((int)rem, 1000));
            boolean bl = result = AEPluginProxyHandler.getPluginProxyForNetwork(network, supports_data) != null;
        } while (!result && !wait_complete);
        return result;
    }

    private static PluginInterface getPluginProxyForNetwork(String network, boolean supports_data) {
        for (PluginInterface pi : plugins) {
            String pid = pi.getPluginID();
            if (pid.equals("aznettor") && network == "Tor" && !supports_data) {
                return pi;
            }
            if (!pid.equals("azneti2phelper") || network != "I2P") continue;
            return pi;
        }
        return null;
    }

    public static boolean hasPluginProxy() {
        AEPluginProxyHandler.waitForPlugins(30000);
        for (PluginInterface pi : plugins) {
            try {
                IPCInterface ipc = pi.getIPC();
                if (!ipc.canInvoke("testHTTPPseudoProxy", new Object[]{TorrentUtils.getDecentralisedEmptyURL()})) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isEnabled() {
        Proxy system_proxy = AEProxySelectorFactory.getSelector().getActiveProxy();
        if (system_proxy == null || system_proxy.equals(Proxy.NO_PROXY)) {
            return true;
        }
        return enable_plugin_proxies_with_socks;
    }

    public static PluginProxyImpl getPluginProxy(String reason, URL target, Map<String, Object> properties, boolean can_wait) {
        if (AEPluginProxyHandler.isEnabled()) {
            AEPluginProxyHandler.checkPluginInstallation(null, reason);
            String url_protocol = target.getProtocol().toLowerCase();
            if (url_protocol.startsWith("http") || url_protocol.equals("ftp")) {
                if (can_wait) {
                    AEPluginProxyHandler.waitForPlugins(0);
                }
                if (properties == null) {
                    properties = new HashMap<String, Object>();
                }
                for (PluginInterface pi : plugins) {
                    try {
                        IPCInterface ipc = pi.getIPC();
                        Object[] proxy_details = ipc.canInvoke("getProxy", new Object[]{reason, target, properties}) ? (Object[])ipc.invoke("getProxy", new Object[]{reason, target, properties}) : (Object[])ipc.invoke("getProxy", new Object[]{reason, target});
                        if (proxy_details == null) continue;
                        if (proxy_details.length == 2) {
                            proxy_details = new Object[]{proxy_details[0], proxy_details[1], target.getHost()};
                        }
                        return new PluginProxyImpl(target.toExternalForm(), reason, ipc, properties, proxy_details);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static PluginProxyImpl getPluginProxy(String reason, String host, int port, Map<String, Object> properties) {
        if (AEPluginProxyHandler.isEnabled()) {
            AEPluginProxyHandler.checkPluginInstallation(null, reason);
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            for (PluginInterface pi : plugins) {
                try {
                    IPCInterface ipc = pi.getIPC();
                    Object[] proxy_details = ipc.canInvoke("getProxy", new Object[]{reason, host, port, properties}) ? (Object[])ipc.invoke("getProxy", new Object[]{reason, host, port, properties}) : (Object[])ipc.invoke("getProxy", new Object[]{reason, host, port});
                    if (proxy_details == null) continue;
                    return new PluginProxyImpl(String.valueOf(host) + ":" + port, reason, ipc, properties, proxy_details);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AEProxyFactory.PluginProxy getPluginProxy(Proxy proxy) {
        if (proxy != null) {
            Map<Proxy, WeakReference<PluginProxyImpl>> map = proxy_map;
            synchronized (map) {
                WeakReference<PluginProxyImpl> ref = proxy_map.get(proxy);
                if (ref != null) {
                    return (AEProxyFactory.PluginProxy)ref.get();
                }
            }
        }
        return null;
    }

    public static boolean isPluginProxy(SocketAddress address) {
        return proxy_list.contains(address);
    }

    public static Boolean testPluginHTTPProxy(URL url, boolean can_wait, String reason) {
        if (AEPluginProxyHandler.isEnabled()) {
            AEPluginProxyHandler.checkPluginInstallation(null, reason);
            String url_protocol = url.getProtocol().toLowerCase();
            if (url_protocol.startsWith("http")) {
                if (can_wait) {
                    AEPluginProxyHandler.waitForPlugins(0);
                }
                for (PluginInterface pi : plugins) {
                    try {
                        IPCInterface ipc = pi.getIPC();
                        return (Boolean)ipc.invoke("testHTTPPseudoProxy", new Object[]{url});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                Debug.out("Unsupported protocol: " + url_protocol);
            }
        }
        return null;
    }

    public static PluginHTTPProxyImpl getPluginHTTPProxy(String reason, URL url, boolean can_wait) {
        if (AEPluginProxyHandler.isEnabled()) {
            AEPluginProxyHandler.checkPluginInstallation(null, reason);
            String url_protocol = url.getProtocol().toLowerCase();
            if (url_protocol.startsWith("http")) {
                if (can_wait) {
                    AEPluginProxyHandler.waitForPlugins(0);
                }
                for (PluginInterface pi : plugins) {
                    try {
                        IPCInterface ipc = pi.getIPC();
                        Proxy proxy = (Proxy)ipc.invoke("createHTTPPseudoProxy", new Object[]{reason, url});
                        if (proxy == null) continue;
                        return new PluginHTTPProxyImpl(reason, ipc, proxy);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                Debug.out("Unsupported protocol: " + url_protocol);
            }
        }
        return null;
    }

    public static List<PluginInterface> getPluginHTTPProxyProviders(boolean can_wait) {
        if (can_wait) {
            AEPluginProxyHandler.waitForPlugins(0);
        }
        List<PluginInterface> pis = CoreFactory.getSingleton().getPluginManager().getPluginsWithMethod("createHTTPPseudoProxy", new Class[]{String.class, URL.class});
        return pis;
    }

    public static Map<String, Object> getPluginServerProxy(String reason, String network, String server_uid, Map<String, Object> options) {
        AEPluginProxyHandler.waitForPlugins(30000);
        AEPluginProxyHandler.checkPluginInstallation(network, reason);
        PluginInterface pi = AEPluginProxyHandler.getPluginProxyForNetwork(network, false);
        if (pi == null) {
            return null;
        }
        options = new HashMap<String, Object>(options);
        options.put("id", server_uid);
        try {
            IPCInterface ipc = pi.getIPC();
            Map reply = (Map)ipc.invoke("getProxyServer", new Object[]{reason, options});
            return reply;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static DHTPluginInterface getPluginDHTProxy(String reason, String network, Map<String, Object> options) {
        AEPluginProxyHandler.waitForPlugins(30000);
        AEPluginProxyHandler.checkPluginInstallation(network, reason);
        PluginInterface pi = AEPluginProxyHandler.getPluginProxyForNetwork(network, false);
        if (pi == null) {
            return null;
        }
        try {
            IPCInterface ipc = pi.getIPC();
            DHTPluginInterface reply = (DHTPluginInterface)ipc.invoke("getProxyDHT", new Object[]{reason, options});
            return reply;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static InetSocketAddress getLocalAddress(PluginProxyImpl pp) {
        String host = pp.getHost();
        int port = pp.getPort();
        return AEPluginProxyHandler.getLocalAddress(host, port);
    }

    public static InetSocketAddress getLocalAddress(String host, int port) {
        return AEPluginProxyHandler.getLocalAddress(host, port, 0);
    }

    public static InetSocketAddress getLocalAddress(String host, int port, int network) {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("net", network);
        Object[] args = new Object[]{host, port, options};
        for (PluginInterface pi : plugins) {
            try {
                IPCInterface ipc = pi.getIPC();
                if (!ipc.canInvoke("getLocalProxyEndpoint", args)) continue;
                Map reply = (Map)ipc.invoke("getLocalProxyEndpoint", args);
                String l_host = (String)reply.get("host");
                int l_port = (Integer)reply.get("port");
                return InetSocketAddress.createUnresolved(l_host, l_port);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static void checkPluginInstallation(String network, String reason) {
        if ((network == null || network == "Tor") && plugin_init_complete.isReleasedForever() && CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aznettor", false) == null && !Constants.isAndroid) {
            AEPluginProxyHandler.installTor(reason, "aznettor.install.via.proxy", new boolean[1], null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean installTor(String extra_text, String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean install;
        UIFunctions uif;
        boolean declined;
        boolean installing;
        String decline_key;
        block31: {
            Object object;
            decline_key = remember_id;
            if (decline_key == null) {
                decline_key = extra_text;
            }
            if (decline_key == null) {
                decline_key = "generic";
            }
            Object object2 = tor_install_lock;
            synchronized (object2) {
                block30: {
                    block29: {
                        Long decline = declines.get(decline_key);
                        if (decline == null || SystemTime.getMonotonousTime() - decline >= 60000L) break block29;
                        return false;
                    }
                    if (!tor_installing) break block30;
                    Debug.out("Tor Helper already installing");
                    return false;
                }
                tor_installing = true;
            }
            installing = false;
            declined = false;
            try {
                uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) break block31;
                Debug.out("UIFunctions unavailable - can't install plugin");
                object = tor_install_lock;
            }
            catch (Throwable throwable) {
                Object object3 = tor_install_lock;
                synchronized (object3) {
                    if (!installing) {
                        tor_installing = false;
                    }
                    if (declined) {
                        declines.put(decline_key, SystemTime.getMonotonousTime());
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                if (!installing) {
                    tor_installing = false;
                }
                if (declined) {
                    declines.put(decline_key, SystemTime.getMonotonousTime());
                }
            }
            return false;
        }
        String title = MessageText.getString("aznettor.install");
        String text = "";
        if (extra_text != null) {
            text = String.valueOf(extra_text) + "\n\n";
        }
        text = String.valueOf(text) + MessageText.getString("aznettor.install.text");
        UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
        if (remember_id != null) {
            prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        }
        prompter.setAutoCloseInMS(0);
        prompter.open(null);
        boolean bl = install = prompter.waitUntilClosed() == 0;
        if (install) {
            installing = true;
            uif.installPlugin("aznettor", "aznettor.install", new UIFunctions.actionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionComplete(Object result) {
                    try {
                        if (result instanceof Throwable && !tor_install_fail_reported) {
                            tor_install_fail_reported = true;
                            UIFunctionsUserPrompter prompter = uif.getUserPrompter(MessageText.getString("metasearch.addtemplate.failed.title"), MessageText.getString("plugin.manual.install", new String[]{"https://plugins.biglybt.com/", MessageText.getString("aznettor.plugin.name")}), new String[]{MessageText.getString("Button.ok")}, 0);
                            prompter.setAutoCloseInMS(0);
                            prompter.open(null);
                        }
                        if (callback != null) {
                            if (result instanceof Boolean) {
                                install_outcome[0] = (Boolean)result;
                            }
                            callback.run();
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = tor_install_lock;
                        synchronized (object) {
                            tor_installing = false;
                        }
                        throw throwable;
                    }
                    Object object = tor_install_lock;
                    synchronized (object) {
                        tor_installing = false;
                    }
                }
            });
        } else {
            declined = true;
            Debug.out("Tor Helper install declined (either user reply or auto-remembered)");
        }
        boolean bl2 = install;
        Object object = tor_install_lock;
        synchronized (object) {
            if (!installing) {
                tor_installing = false;
            }
            if (declined) {
                declines.put(decline_key, SystemTime.getMonotonousTime());
            }
        }
        return bl2;
    }

    private static class PluginHTTPProxyImpl
    implements AEProxyFactory.PluginHTTPProxy {
        private final String reason;
        private final IPCInterface ipc;
        private final Proxy proxy;

        private PluginHTTPProxyImpl(String _reason, IPCInterface _ipc, Proxy _proxy) {
            this.reason = _reason;
            this.ipc = _ipc;
            this.proxy = _proxy;
        }

        @Override
        public Proxy getProxy() {
            return this.proxy;
        }

        @Override
        public String proxifyURL(String url) {
            try {
                URL _url = new URL(url);
                InetSocketAddress pa = (InetSocketAddress)this.proxy.address();
                _url = UrlUtils.setHost(_url, pa.getAddress().getHostAddress());
                _url = UrlUtils.setPort(_url, pa.getPort());
                url = _url.toExternalForm();
                url = String.valueOf(url) + (url.indexOf(63) == -1 ? "?" : "&") + "_azpproxy=1";
                return url;
            }
            catch (Throwable e) {
                Debug.out("Failed to proxify URL: " + url, e);
                return url;
            }
        }

        @Override
        public void destroy() {
            try {
                this.ipc.invoke("destroyHTTPPseudoProxy", new Object[]{this.proxy});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private static class PluginProxyImpl
    implements AEProxyFactory.PluginProxy {
        private final long create_time = SystemTime.getMonotonousTime();
        private final String target;
        private final String reason;
        private final IPCInterface ipc;
        private final Map<String, Object> proxy_options;
        private final Object[] proxy_details;
        private final List<PluginProxyImpl> children = new ArrayList<PluginProxyImpl>();
        private volatile int status = 1;
        private CopyOnWriteList<AEProxyFactory.PluginProxy.PluginProxyStatusListener> listeners = new CopyOnWriteList(1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PluginProxyImpl(String _target, String _reason, IPCInterface _ipc, Map<String, Object> _proxy_options, Object[] _proxy_details) {
            this.target = _target;
            this.reason = _reason;
            this.ipc = _ipc;
            this.proxy_options = _proxy_options;
            this.proxy_details = _proxy_details;
            WeakReference<PluginProxyImpl> my_ref = new WeakReference<PluginProxyImpl>(this);
            ArrayList<PluginProxyImpl> removed = new ArrayList<PluginProxyImpl>();
            Map map = proxy_map;
            synchronized (map) {
                Proxy proxy = this.getProxy();
                SocketAddress address = proxy.address();
                if (!proxy_list.contains(address)) {
                    proxy_list.add(address);
                }
                proxy_map.put(proxy, my_ref);
                if (proxy_map.size() > 1024) {
                    long now = SystemTime.getMonotonousTime();
                    Iterator it = proxy_map.values().iterator();
                    while (it.hasNext()) {
                        WeakReference ref = (WeakReference)it.next();
                        PluginProxyImpl pp = (PluginProxyImpl)ref.get();
                        if (pp == null) {
                            it.remove();
                            continue;
                        }
                        if (now - pp.create_time <= 300000L) continue;
                        removed.add(pp);
                        it.remove();
                    }
                }
            }
            for (PluginProxyImpl pp : removed) {
                pp.setOK(false);
            }
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return AEPluginProxyHandler.getLocalAddress(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AEProxyFactory.PluginProxy getChildProxy(String child_reason, URL url) {
            PluginProxyImpl child = AEPluginProxyHandler.getPluginProxy(String.valueOf(this.reason) + " - " + child_reason, url, this.proxy_options, false);
            if (child != null) {
                List<PluginProxyImpl> list = this.children;
                synchronized (list) {
                    this.children.add(child);
                }
            }
            return child;
        }

        @Override
        public Proxy getProxy() {
            return (Proxy)this.proxy_details[0];
        }

        @Override
        public URL getURL() {
            return (URL)this.proxy_details[1];
        }

        @Override
        public String getURLHostRewrite() {
            return (String)this.proxy_details[2];
        }

        @Override
        public String getHost() {
            return (String)this.proxy_details[1];
        }

        @Override
        public int getPort() {
            return (Integer)this.proxy_details[2];
        }

        @Override
        public Throwable getError() {
            try {
                Map status = (Map)this.ipc.invoke("getProxyStatus", new Object[]{this.proxy_details[0]});
                if (status != null) {
                    return (Throwable)status.get("error");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean getConnected() {
            try {
                Boolean connected;
                Map status = (Map)this.ipc.invoke("getProxyStatus", new Object[]{this.proxy_details[0]});
                if (status != null && (connected = (Boolean)status.get("connected")) != null) {
                    return connected;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void setOK(boolean good) {
            block21: {
                changed = false;
                try {
                    var3_3 = this;
                    synchronized (var3_3) {
                        if (this.status == 1) {
                            this.status = good != false ? 2 : 3;
                            changed = true;
                        }
                    }
                    try {
                        this.ipc.invoke("setProxyStatus", new Object[]{this.proxy_details[0], good});
                    }
                    catch (Throwable var3_4) {
                        // empty catch block
                    }
                    var4_5 = this.children;
                    synchronized (var4_5) {
                        kids = new ArrayList<PluginProxyImpl>(this.children);
                        this.children.clear();
                    }
                    for (PluginProxyImpl child : kids) {
                        child.setOK(good);
                    }
                    var4_5 = AEPluginProxyHandler.access$1();
                    synchronized (var4_5) {
                        AEPluginProxyHandler.access$1().remove(this.getProxy());
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 9] lbl40 : MonitorExitStatement: MONITOREXIT : var4_5
                    }
                }
                finally {
                    if (!changed) break block21;
                    ** for (l : this.listeners)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        l.statusChanged(this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    continue;
                }
            }
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public void addListener(AEProxyFactory.PluginProxy.PluginProxyStatusListener l) {
            this.listeners.add(l);
        }
    }
}

