/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.utils;

import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.networkmanager.OutgoingMessageQueue;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.bittorrent.BTPiece;
import com.biglybt.core.peermanager.utils.OutgoingBTPieceMessageHandlerAdapter;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class OutgoingBTPieceMessageHandler {
    private final PEPeer peer;
    private final OutgoingMessageQueue outgoing_message_queue;
    private byte piece_version;
    private final LinkedList<DiskManagerReadRequest> requests = new LinkedList();
    private final ArrayList<DiskManagerReadRequest> loading_messages = new ArrayList();
    private final HashMap<BTPiece, DiskManagerReadRequest> queued_messages = new HashMap();
    private final Map<Integer, int[]> active_pieces = new HashMap<Integer, int[]>();
    private LinkedList<DiskManagerReadRequest> recent_messages;
    private volatile long recent_messages_last_access = -1L;
    private final AEMonitor lock_mon = new AEMonitor("OutgoingBTPieceMessageHandler:lock");
    private boolean destroyed = false;
    private int request_read_ahead = 2;
    final OutgoingBTPieceMessageHandlerAdapter adapter;
    private final DiskManagerReadRequestListener read_req_listener = new DiskManagerReadRequestListener(){

        @Override
        public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    data.returnToPool();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
                BTPiece msg = new BTPiece(request2.getPieceNumber(), request2.getOffset(), data, OutgoingBTPieceMessageHandler.this.piece_version);
                OutgoingBTPieceMessageHandler.this.queued_messages.put(msg, request2);
                OutgoingBTPieceMessageHandler.this.outgoing_message_queue.addMessage(msg, true);
                if (OutgoingBTPieceMessageHandler.this.recent_messages != null) {
                    long now = SystemTime.getMonotonousTime();
                    if (now - OutgoingBTPieceMessageHandler.this.recent_messages_last_access > 60000L) {
                        OutgoingBTPieceMessageHandler.this.recent_messages = null;
                        OutgoingBTPieceMessageHandler.this.recent_messages_last_access = -1L;
                    } else {
                        OutgoingBTPieceMessageHandler.this.trimRecentMessages();
                        OutgoingBTPieceMessageHandler.this.recent_messages.add(request2);
                    }
                }
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.outgoing_message_queue.doListenerNotifications();
        }

        @Override
        public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
                int piece_number = request2.getPieceNumber();
                int[] active = (int[])OutgoingBTPieceMessageHandler.this.active_pieces.get(piece_number);
                if (active == null) {
                    Debug.out("eh?");
                } else {
                    active[0] = active[0] - 1;
                    if (active[0] == 0) {
                        OutgoingBTPieceMessageHandler.this.active_pieces.remove(piece_number);
                    }
                }
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.peer.sendRejectRequest(request2);
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public void requestExecuted(long bytes) {
            OutgoingBTPieceMessageHandler.this.adapter.diskRequestCompleted(bytes);
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        @Override
        public boolean messageAdded(Message message) {
            return true;
        }

        @Override
        public void messageSent(Message message) {
            if (message.getID().equals("BT_PIECE")) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    DiskManagerReadRequest request2 = (DiskManagerReadRequest)OutgoingBTPieceMessageHandler.this.queued_messages.remove(message);
                    if (request2 != null) {
                        request2.setTimeSent(SystemTime.getMonotonousTime());
                        int piece_number = request2.getPieceNumber();
                        int[] active = (int[])OutgoingBTPieceMessageHandler.this.active_pieces.get(piece_number);
                        if (active == null) {
                            Debug.out("eh?");
                        } else {
                            active[0] = active[0] - 1;
                            if (active[0] == 0) {
                                OutgoingBTPieceMessageHandler.this.active_pieces.remove(piece_number);
                            }
                        }
                    }
                }
                finally {
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
                OutgoingBTPieceMessageHandler.this.doReadAheadLoads();
                if (OutgoingBTPieceMessageHandler.this.recent_messages_last_access != -1L) {
                    OutgoingBTPieceMessageHandler.this.trimRecentMessages();
                }
            } else if (OutgoingBTPieceMessageHandler.this.recent_messages_last_access != -1L) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    OutgoingBTPieceMessageHandler.this.trimRecentMessages();
                }
                finally {
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
            }
        }

        @Override
        public void messageQueued(Message message) {
        }

        @Override
        public void messageRemoved(Message message) {
        }

        @Override
        public void protocolBytesSent(int byte_count) {
        }

        @Override
        public void dataBytesSent(int byte_count) {
        }

        @Override
        public void flush() {
        }
    };

    public OutgoingBTPieceMessageHandler(PEPeer _peer, OutgoingMessageQueue _outgoing_message_q, OutgoingBTPieceMessageHandlerAdapter _adapter, byte _piece_version) {
        this.peer = _peer;
        this.outgoing_message_queue = _outgoing_message_q;
        this.adapter = _adapter;
        this.piece_version = _piece_version;
        this.outgoing_message_queue.registerQueueListener(this.sent_message_listener);
    }

    public void setPieceVersion(byte version) {
        this.piece_version = version;
    }

    private void trimRecentMessages() {
        Iterator<DiskManagerReadRequest> it = this.recent_messages.descendingIterator();
        long now = SystemTime.getMonotonousTime();
        while (it.hasNext()) {
            DiskManagerReadRequest req = it.next();
            long sent = req.getTimeSent();
            if (sent >= 0L && (sent <= 0L || now - sent <= 5000L)) break;
            it.remove();
        }
    }

    public boolean addPieceRequest(int piece_number, int piece_offset, int length) {
        if (this.destroyed) {
            return false;
        }
        DiskManagerReadRequest dmr = this.peer.getManager().getDiskManager().createReadRequest(piece_number, piece_offset, length);
        try {
            this.lock_mon.enter();
            this.requests.addLast(dmr);
            int[] active = this.active_pieces.get(piece_number);
            if (active == null) {
                active = new int[1];
                this.active_pieces.put(piece_number, active);
            }
            active[0] = active[0] + 1;
            if (Constants.IS_CVS_VERSION && this.active_pieces.size() > this.requests.size() + this.loading_messages.size() + this.queued_messages.size()) {
                Debug.out("eh?");
            }
        }
        finally {
            this.lock_mon.exit();
        }
        this.doReadAheadLoads();
        return true;
    }

    public void removePieceRequest(int piece_number, int piece_offset, int length) {
        boolean entry_removed;
        DiskManagerReadRequest dmr;
        block24: {
            block25: {
                int[] active;
                block26: {
                    block21: {
                        block22: {
                            int[] active2;
                            block23: {
                                if (this.destroyed) {
                                    return;
                                }
                                dmr = this.peer.getManager().getDiskManager().createReadRequest(piece_number, piece_offset, length);
                                entry_removed = false;
                                this.lock_mon.enter();
                                if (!this.requests.contains(dmr)) break block21;
                                this.requests.remove(dmr);
                                entry_removed = true;
                                if (!entry_removed) break block22;
                                active2 = this.active_pieces.get(piece_number);
                                if (active2 != null) break block23;
                                Debug.out("eh?");
                                break block22;
                            }
                            active2[0] = active2[0] - 1;
                            if (active2[0] == 0) {
                                this.active_pieces.remove(piece_number);
                            }
                        }
                        this.lock_mon.exit();
                        if (entry_removed) {
                            this.peer.sendRejectRequest(dmr);
                        }
                        return;
                    }
                    if (!this.loading_messages.contains(dmr)) break block24;
                    this.loading_messages.remove(dmr);
                    entry_removed = true;
                    if (!entry_removed) break block25;
                    active = this.active_pieces.get(piece_number);
                    if (active != null) break block26;
                    Debug.out("eh?");
                    break block25;
                }
                active[0] = active[0] - 1;
                if (active[0] == 0) {
                    this.active_pieces.remove(piece_number);
                }
            }
            this.lock_mon.exit();
            if (entry_removed) {
                this.peer.sendRejectRequest(dmr);
            }
            return;
        }
        try {
            Iterator<Map.Entry<BTPiece, DiskManagerReadRequest>> i = this.queued_messages.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<BTPiece, DiskManagerReadRequest> entry = i.next();
                if (!entry.getValue().equals(dmr)) continue;
                BTPiece msg = entry.getKey();
                if (this.outgoing_message_queue.removeMessage(msg, true)) {
                    entry_removed = true;
                    i.remove();
                    entry.getValue().setTimeSent(-1L);
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (entry_removed) {
                int[] active = this.active_pieces.get(piece_number);
                if (active == null) {
                    Debug.out("eh?");
                } else {
                    active[0] = active[0] - 1;
                    if (active[0] == 0) {
                        this.active_pieces.remove(piece_number);
                    }
                }
            }
            this.lock_mon.exit();
            if (entry_removed) {
                this.peer.sendRejectRequest(dmr);
            }
            throw throwable;
        }
        if (entry_removed) {
            int[] active = this.active_pieces.get(piece_number);
            if (active == null) {
                Debug.out("eh?");
            } else {
                active[0] = active[0] - 1;
                if (active[0] == 0) {
                    this.active_pieces.remove(piece_number);
                }
            }
        }
        this.lock_mon.exit();
        if (entry_removed) {
            this.peer.sendRejectRequest(dmr);
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void removeAllPieceRequests() {
        if (this.destroyed) {
            return;
        }
        ArrayList<DiskManagerReadRequest> removed = new ArrayList<DiskManagerReadRequest>();
        try {
            this.lock_mon.enter();
            for (Map.Entry<BTPiece, DiskManagerReadRequest> entry : this.queued_messages.entrySet()) {
                BTPiece msg = entry.getKey();
                if (this.outgoing_message_queue.removeMessage(msg, true)) {
                    removed.add(this.queued_messages.get(msg));
                }
                entry.getValue().setTimeSent(-1L);
            }
            this.queued_messages.clear();
            removed.addAll(this.requests);
            this.requests.clear();
            removed.addAll(this.loading_messages);
            this.loading_messages.clear();
            this.active_pieces.clear();
        }
        finally {
            this.lock_mon.exit();
        }
        for (DiskManagerReadRequest request2 : removed) {
            this.peer.sendRejectRequest(request2);
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void setRequestReadAhead(int num_to_read_ahead) {
        this.request_read_ahead = num_to_read_ahead;
    }

    public void destroy() {
        try {
            this.lock_mon.enter();
            this.removeAllPieceRequests();
            this.destroyed = true;
            this.outgoing_message_queue.cancelQueueListener(this.sent_message_listener);
        }
        finally {
            this.lock_mon.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doReadAheadLoads() {
        ArrayList<DiskManagerReadRequest> to_submit = null;
        try {
            this.lock_mon.enter();
            while (this.loading_messages.size() + this.queued_messages.size() < this.request_read_ahead && !this.requests.isEmpty() && !this.destroyed) {
                DiskManagerReadRequest dmr = this.requests.removeFirst();
                this.loading_messages.add(dmr);
                if (to_submit == null) {
                    to_submit = new ArrayList<DiskManagerReadRequest>();
                }
                to_submit.add(dmr);
            }
        }
        finally {
            this.lock_mon.exit();
        }
        if (to_submit != null) {
            int i = 0;
            while (i < to_submit.size()) {
                this.peer.getManager().getAdapter().enqueueReadRequest(this.peer, (DiskManagerReadRequest)to_submit.get(i), this.read_req_listener);
                ++i;
            }
        }
    }

    public int[] getRequestedPieceNumbers() {
        if (this.destroyed) {
            return new int[0];
        }
        try {
            this.lock_mon.enter();
            int num = this.active_pieces.size();
            int[] result = new int[num];
            if (num > 0) {
                int pos = 0;
                for (Integer pn : this.active_pieces.keySet()) {
                    result[pos++] = pn;
                }
            }
            int[] nArray = result;
            return nArray;
        }
        finally {
            this.lock_mon.exit();
        }
    }

    public int getRequestedPieceNumberCount() {
        try {
            this.lock_mon.enter();
            int n = this.active_pieces.size();
            return n;
        }
        finally {
            this.lock_mon.exit();
        }
    }

    public DiskManagerReadRequest[] getRecentMessages() {
        try {
            this.lock_mon.enter();
            this.recent_messages_last_access = SystemTime.getMonotonousTime();
            if (this.recent_messages == null) {
                this.recent_messages = new LinkedList();
            }
            DiskManagerReadRequest[] diskManagerReadRequestArray = this.recent_messages.toArray(new DiskManagerReadRequest[this.recent_messages.size()]);
            return diskManagerReadRequestArray;
        }
        finally {
            this.lock_mon.exit();
        }
    }

    public int getRequestCount() {
        return this.queued_messages.size() + this.loading_messages.size() + this.requests.size();
    }

    public boolean isStalledPendingLoad() {
        return this.queued_messages.size() == 0 && this.loading_messages.size() > 0;
    }
}

