/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent.ltep;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.MessagingUtil;
import com.biglybt.core.peermanager.messaging.azureus.AZStylePeerExchange;
import com.biglybt.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.peermanager.peerdb.PeerItemFactory;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UTPeerExchange
implements AZStylePeerExchange,
LTMessage {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final int IPv4_SIZE_WITH_PORT = 6;
    private static final int IPv6_SIZE_WITH_PORT = 18;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte version;
    private final PeerItem[] peers_added;
    private final PeerItem[] peersAddedNoSeeds;
    private final PeerItem[] peers_dropped;

    public UTPeerExchange(PeerItem[] _peers_added, PeerItem[] _peers_dropped, PeerItem[] peersAddedNoSeeds, byte version) {
        this.peers_added = _peers_added;
        this.peers_dropped = _peers_dropped;
        this.version = version;
        this.peersAddedNoSeeds = peersAddedNoSeeds != null ? peersAddedNoSeeds : _peers_added;
    }

    private void insertPeers(String key_name, Map root_map, boolean include_flags, PeerItem[] peers) {
        if (peers == null) {
            return;
        }
        if (peers.length == 0) {
            return;
        }
        List<PeerItem> v4_peers = null;
        ArrayList<PeerItem> v6_peers = null;
        int i = 0;
        while (i < peers.length) {
            if (!peers[i].isIPv4()) {
                if (v6_peers == null) {
                    v6_peers = new ArrayList<PeerItem>();
                    v4_peers = new ArrayList<PeerItem>(Arrays.asList(peers).subList(0, i));
                }
                v6_peers.add(peers[i]);
            } else if (v4_peers != null) {
                v4_peers.add(peers[i]);
            }
            ++i;
        }
        if (v4_peers == null) {
            v4_peers = Arrays.asList(peers);
        }
        this.insertPeers(key_name, root_map, include_flags, v4_peers, 6);
        this.insertPeers(String.valueOf(key_name) + "6", root_map, include_flags, v6_peers, 18);
    }

    private void insertPeers(String key_name, Map root_map, boolean include_flags, List peers, int peer_byte_size) {
        if (peers == null) {
            return;
        }
        if (peers.isEmpty()) {
            return;
        }
        byte[] raw_peers = new byte[peers.size() * peer_byte_size];
        byte[] peer_flags = include_flags ? new byte[peers.size()] : null;
        int i = 0;
        while (i < peers.size()) {
            PeerItem peer = (PeerItem)peers.get(i);
            byte[] serialised_peer = peer.getSerialization();
            if (serialised_peer.length != peer_byte_size) {
                Debug.out("invalid serialization- " + serialised_peer.length + ":" + peer_byte_size);
            }
            System.arraycopy(serialised_peer, 0, raw_peers, i * peer_byte_size, peer_byte_size);
            if (peer_flags != null && NetworkManager.getCryptoRequired(peer.getCryptoLevel())) {
                int n = i;
                peer_flags[n] = (byte)(peer_flags[n] | 1);
            }
            ++i;
        }
        root_map.put(key_name, raw_peers);
        if (peer_flags != null) {
            root_map.put(String.valueOf(key_name) + ".f", peer_flags);
        }
    }

    private List extractPeers(String key_name, Map root_map, int peer_byte_size, boolean noSeeds) {
        ArrayList<PeerItem> peers = new ArrayList<PeerItem>();
        byte[] raw_peer_data = (byte[])root_map.get(key_name);
        if (raw_peer_data != null) {
            if (raw_peer_data.length % peer_byte_size != 0 && Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "PEX (UT): peer data size not multiple of " + peer_byte_size + ": " + raw_peer_data.length));
            }
            int peer_num = raw_peer_data.length / peer_byte_size;
            byte[] flags = null;
            Object flags_obj = root_map.get(String.valueOf(key_name) + ".f");
            if (flags_obj instanceof byte[]) {
                flags = (byte[])flags_obj;
            }
            if (flags != null && flags.length != peer_num) {
                if (flags.length > 0 && Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "PEX (UT): invalid peer flags: peers=" + peer_num + ", flags=" + flags.length));
                }
                flags = null;
            }
            int i = 0;
            while (i < peer_num) {
                block10: {
                    byte[] full_address = new byte[peer_byte_size];
                    System.arraycopy(raw_peer_data, i * peer_byte_size, full_address, 0, peer_byte_size);
                    byte type = 0;
                    if (flags != null && (flags[i] & 1) != 0) {
                        type = 1;
                    }
                    if (flags == null || (flags[i] & 2) == 0 || !noSeeds) {
                        try {
                            PeerItem peer = PeerItemFactory.createPeerItem(full_address, (byte)2, type, 0, "Public");
                            peers.add(peer);
                        }
                        catch (Exception e) {
                            if (!Logger.isEnabled()) break block10;
                            Logger.log(new LogEvent(LOGID, 1, "PEX (UT): invalid peer received"));
                        }
                    }
                }
                ++i;
            }
        }
        return peers;
    }

    public PeerItem[] getAddedPeers(boolean seeds) {
        return seeds ? this.peers_added : this.peersAddedNoSeeds;
    }

    @Override
    public PeerItem[] getAddedPeers() {
        return this.peers_added;
    }

    @Override
    public PeerItem[] getDroppedPeers() {
        return this.peers_dropped;
    }

    @Override
    public String getID() {
        return "ut_pex";
    }

    @Override
    public byte[] getIDBytes() {
        return LTMessage.ID_UT_PEX_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "LT1";
    }

    @Override
    public int getFeatureSubID() {
        return 1;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            int add_count = this.peers_added == null ? 0 : this.peers_added.length;
            int drop_count = this.peers_dropped == null ? 0 : this.peers_dropped.length;
            this.description = String.valueOf(this.getID().toUpperCase()) + " with " + add_count + " added and " + drop_count + " dropped peers";
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap payload_map = new HashMap();
            this.insertPeers("added", payload_map, true, this.peers_added);
            this.insertPeers("dropped", payload_map, false, this.peers_dropped);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)29);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map root = MessagingUtil.convertBencodedByteStreamToPayload(data, 2, this.getID());
        List added = this.extractPeers("added", root, 6, false);
        List addedNoSeeds = this.extractPeers("added", root, 6, true);
        List dropped = this.extractPeers("dropped", root, 6, false);
        added.addAll(this.extractPeers("added6", root, 18, false));
        addedNoSeeds.addAll(this.extractPeers("added6", root, 18, true));
        dropped.addAll(this.extractPeers("dropped6", root, 18, false));
        PeerItem[] addedArr = added.toArray(new PeerItem[added.size()]);
        PeerItem[] addedNoSeedsArr = addedNoSeeds.toArray(new PeerItem[addedNoSeeds.size()]);
        PeerItem[] droppedArr = dropped.toArray(new PeerItem[dropped.size()]);
        return new UTPeerExchange(addedArr, droppedArr, addedNoSeedsArr, version);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    @Override
    public int getMaxAllowedPeersPerVolley(boolean initial, boolean added) {
        return initial && added ? 500 : 250;
    }
}

