/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.bittorrent.ltep;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.MessagingUtil;
import com.biglybt.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LTHandshake
implements LTMessage {
    private Map data_dict;
    private byte[] bencoded_data;
    private String bencoded_string;
    private String description;
    private final byte version;
    private DirectByteBuffer[] buffer_array;

    public LTHandshake(Map data_dict, byte version) {
        this.data_dict = data_dict == null ? Collections.EMPTY_MAP : data_dict;
        this.version = version;
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) < 1) {
            throw new MessageException("[" + this.getID() + "] decode error: less than 1 byte in payload");
        }
        Map res_data_dict = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        LTHandshake result = new LTHandshake(res_data_dict, this.version);
        return result;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer_array == null) {
            DirectByteBuffer buffer;
            this.buffer_array = new DirectByteBuffer[1];
            this.buffer_array[0] = buffer = DirectByteBufferPool.getBuffer((byte)28, this.getBencodedData().length);
            buffer.put((byte)11, this.getBencodedData());
            buffer.flip((byte)11);
        }
        return this.buffer_array;
    }

    @Override
    public void destroy() {
        this.data_dict = null;
        this.bencoded_data = null;
        this.description = null;
        if (this.buffer_array != null) {
            this.buffer_array[0].returnToPool();
        }
        this.buffer_array = null;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = String.valueOf("lt_handshake".toUpperCase()) + ": " + this.getBencodedString();
        }
        return this.description;
    }

    public String getBencodedString() {
        if (this.bencoded_string == null) {
            this.bencoded_string = new String(this.getBencodedData(), Constants.BYTE_ENCODING_CHARSET);
        }
        return this.bencoded_string;
    }

    public byte[] getBencodedData() {
        if (this.bencoded_data == null) {
            try {
                this.bencoded_data = BEncoder.encode(this.data_dict);
            }
            catch (IOException ioe) {
                this.bencoded_data = new byte[0];
                Debug.printStackTrace(ioe);
            }
        }
        return this.bencoded_data;
    }

    public Map getDataMap() {
        return this.data_dict;
    }

    public String getClientName() {
        byte[] client_name = (byte[])this.data_dict.get("v");
        if (client_name == null) {
            return null;
        }
        return new String(client_name, Constants.DEFAULT_ENCODING_CHARSET);
    }

    public boolean isUploadOnly() {
        String debug;
        Object ulOnly = this.data_dict.get("upload_only");
        if (ulOnly == null) {
            return false;
        }
        if (ulOnly instanceof Number) {
            Number n_ulOnly = (Number)ulOnly;
            return n_ulOnly.longValue() > 0L;
        }
        if (ulOnly instanceof byte[]) {
            String str_val = new String((byte[])ulOnly);
            try {
                int i = Integer.parseInt(str_val);
                return i > 0;
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if (ulOnly instanceof byte[]) {
            byte[] bytes = (byte[])ulOnly;
            debug = String.valueOf(new String(bytes)) + "/";
            int i = 0;
            while (i < bytes.length) {
                debug = String.valueOf(debug) + (i == 0 ? "" : ",") + (bytes[i] & 0xFF);
                ++i;
            }
        } else {
            debug = String.valueOf(ulOnly);
        }
        Debug.out("Invalid entry for 'upload_only' - " + debug + ", map=" + this.data_dict);
        return false;
    }

    public InetAddress getIPv6() {
        byte[] addr = (byte[])this.data_dict.get("ipv6");
        if (addr != null && addr.length == 16) {
            try {
                return InetAddress.getByAddress(addr);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getTCPListeningPort() {
        Long port = (Long)this.data_dict.get("p");
        if (port == null) {
            return 0;
        }
        int val = port.intValue();
        if (val <= 65535 && val > 0) {
            return val;
        }
        return 0;
    }

    public Boolean isCryptoRequested() {
        Long crypto = (Long)this.data_dict.get("e");
        if (crypto == null) {
            return null;
        }
        return crypto == 1L;
    }

    public Map getExtensionMapping() {
        Map result = (Map)this.data_dict.get("m");
        return result == null ? Collections.EMPTY_MAP : result;
    }

    public int getMetadataSize() {
        Long l = (Long)this.data_dict.get("metadata_size");
        if (l != null) {
            return l.intValue();
        }
        return 0;
    }

    public void addDefaultExtensionMappings(boolean enable_pex, boolean enable_md, boolean enable_uo, boolean enable_hp) {
        if (enable_pex || enable_md || enable_uo || enable_hp) {
            HashMap<String, Long> ext = (HashMap<String, Long>)this.data_dict.get("m");
            if (ext == null) {
                ext = new HashMap<String, Long>();
                this.data_dict.put("m", ext);
            }
            if (enable_pex) {
                ext.put("ut_pex", new Long(1L));
            }
            if (enable_md) {
                ext.put("ut_metadata", new Long(3L));
            }
            if (enable_uo) {
                ext.put("upload_only", new Long(4L));
            }
            if (enable_hp) {
                ext.put("ut_holepunch", new Long(5L));
            }
        }
    }

    public void addOptionalExtensionMapping(String id, long subid) {
        HashMap<String, Long> ext = (HashMap<String, Long>)this.data_dict.get("m");
        if (ext == null) {
            ext = new HashMap<String, Long>();
            this.data_dict.put("m", ext);
        }
        ext.put(id, new Long(subid));
    }

    @Override
    public String getFeatureID() {
        return "LT1";
    }

    @Override
    public int getFeatureSubID() {
        return 0;
    }

    @Override
    public String getID() {
        return "lt_handshake";
    }

    @Override
    public byte[] getIDBytes() {
        return ID_LT_HANDSHAKE_BYTES;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }
}

