/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.messaging.azureus;

import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.MessagingUtil;
import com.biglybt.core.peermanager.messaging.azureus.AZMessage;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AZHandshake
implements AZMessage {
    public static final int HANDSHAKE_TYPE_PLAIN = 0;
    public static final int HANDSHAKE_TYPE_CRYPTO = 1;
    private static final byte bss = 11;
    private final byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] identity;
    private final HashWrapper sessionID;
    private final HashWrapper reconnectID;
    private final String client;
    private final String client_version;
    private final String[] avail_ids;
    private final byte[] avail_versions;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private final int handshake_type;
    private final boolean uploadOnly;
    private final InetAddress ipv6;
    private final String localHost;
    private final int md_size;

    public AZHandshake(byte[] peer_identity, HashWrapper sessionID, HashWrapper reconnectID, String _client, String version, int tcp_listen_port, int udp_listen_port, int udp_non_data_listen_port, InetAddress ipv6addr, String localHost, int md_size, String[] avail_msg_ids, byte[] avail_msg_versions, int _handshake_type, byte _version, boolean uploadOnly) {
        this.identity = peer_identity;
        this.sessionID = sessionID;
        this.reconnectID = reconnectID;
        this.client = _client;
        this.client_version = version;
        this.avail_ids = avail_msg_ids;
        this.avail_versions = avail_msg_versions;
        this.tcp_port = tcp_listen_port;
        this.udp_port = udp_listen_port;
        this.udp_non_data_port = udp_non_data_listen_port;
        this.handshake_type = _handshake_type;
        this.version = _version;
        this.uploadOnly = uploadOnly;
        this.ipv6 = ipv6addr;
        this.localHost = localHost;
        this.md_size = md_size;
        if (this.tcp_port < 0 || this.tcp_port > 65535) {
            Debug.out("given TCP listen port is invalid: " + this.tcp_port);
            this.tcp_port = 0;
        }
        if (this.udp_port < 0 || this.udp_port > 65535) {
            Debug.out("given UDP listen port is invalid: " + this.udp_port);
            this.udp_port = 0;
        }
        if (this.udp_non_data_port < 0 || this.udp_non_data_port > 65535) {
            Debug.out("given UDP non-data listen port is invalid: " + this.udp_non_data_port);
            this.udp_non_data_port = 0;
        }
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public HashWrapper getRemoteSessionID() {
        return this.sessionID;
    }

    public HashWrapper getReconnectSessionID() {
        return this.reconnectID;
    }

    public boolean isUploadOnly() {
        return this.uploadOnly;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientVersion() {
        return this.client_version;
    }

    public String[] getMessageIDs() {
        return this.avail_ids;
    }

    public byte[] getMessageVersions() {
        return this.avail_versions;
    }

    public int getTCPListenPort() {
        return this.tcp_port;
    }

    public int getUDPListenPort() {
        return this.udp_port;
    }

    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    public InetAddress getIPv6() {
        return this.ipv6;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public int getMetadataSize() {
        return this.md_size;
    }

    public int getHandshakeType() {
        return this.handshake_type;
    }

    @Override
    public String getID() {
        return "AZ_HANDSHAKE";
    }

    @Override
    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_HANDSHAKE_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "AZ1";
    }

    @Override
    public int getFeatureSubID() {
        return 0;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            String msgs_desc = "";
            int i = 0;
            while (i < this.avail_ids.length) {
                String id = this.avail_ids[i];
                byte ver = this.avail_versions[i];
                if (!id.equals(this.getID())) {
                    msgs_desc = String.valueOf(msgs_desc) + "[" + id + ":" + ver + "]";
                }
                ++i;
            }
            this.description = String.valueOf(this.getID()) + " from [" + ByteFormatter.nicePrint(this.identity, true) + ", " + this.client + " " + this.client_version + ", TCP/UDP ports " + this.tcp_port + "/" + this.udp_port + "/" + this.udp_non_data_port + ", handshake " + (this.getHandshakeType() == 0 ? "plain" : "crypto") + ", upload_only = " + (this.isUploadOnly() ? "1" : "0") + (this.ipv6 != null ? ", ipv6 = " + this.ipv6.getHostAddress() : "") + ", md_size=" + this.md_size + (this.sessionID != null ? ", sessionID: " + this.sessionID.toBase32String() : "") + (this.reconnectID != null ? ", reconnect request: " + this.reconnectID.toBase32String() : "") + "] supports " + msgs_desc;
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Object> payload_map = new HashMap<String, Object>();
            payload_map.put("identity", this.identity);
            if (this.sessionID != null) {
                payload_map.put("session", this.sessionID.getBytes());
            }
            if (this.reconnectID != null) {
                payload_map.put("reconn", this.reconnectID.getBytes());
            }
            payload_map.put("client", this.client);
            payload_map.put("version", this.client_version);
            payload_map.put("tcp_port", new Long(this.tcp_port));
            payload_map.put("udp_port", new Long(this.udp_port));
            payload_map.put("udp2_port", new Long(this.udp_non_data_port));
            payload_map.put("handshake_type", new Long(this.handshake_type));
            payload_map.put("upload_only", new Long(this.uploadOnly ? 1L : 0L));
            if (this.ipv6 != null) {
                payload_map.put("ipv6", this.ipv6.getAddress());
            }
            if (this.localHost != null) {
                payload_map.put("lh", this.localHost.getBytes(Constants.UTF_8));
            }
            if (this.md_size > 0) {
                payload_map.put("mds", new Long(this.md_size));
            }
            ArrayList message_list = new ArrayList();
            int i = 0;
            while (i < this.avail_ids.length) {
                String id = this.avail_ids[i];
                byte ver = this.avail_versions[i];
                if (!id.equals(this.getID())) {
                    HashMap<String, Object> msg = new HashMap<String, Object>();
                    msg.put("id", id);
                    msg.put("ver", new byte[]{ver});
                    message_list.add(msg);
                }
                ++i;
            }
            payload_map.put("messages", message_list);
            if (this.handshake_type == 1) {
                payload_map.put("pad", new byte[RandomUtils.nextInt(64)]);
            }
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)13);
            if (this.buffer.remaining((byte)11) > 1350 && Constants.IS_CVS_VERSION) {
                System.out.println("Generated AZHandshake size = " + this.buffer.remaining((byte)11) + " bytes");
            }
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        byte[] b_lh;
        boolean uploadOnly;
        List raw_msgs;
        Long h_type;
        Long udp2_lport;
        Long udp_lport;
        Map root = MessagingUtil.convertBencodedByteStreamToPayload(data, 100, this.getID());
        byte[] id = (byte[])root.get("identity");
        if (id == null) {
            throw new MessageException("id == null");
        }
        if (id.length != 20) {
            throw new MessageException("id.length != 20: " + id.length);
        }
        byte[] session = (byte[])root.get("session");
        byte[] reconnect = (byte[])root.get("reconn");
        byte[] raw_name = (byte[])root.get("client");
        if (raw_name == null) {
            throw new MessageException("raw_name == null");
        }
        String name = new String(raw_name);
        byte[] raw_ver = (byte[])root.get("version");
        if (raw_ver == null) {
            throw new MessageException("raw_ver == null");
        }
        String client_version = new String(raw_ver);
        Long tcp_lport = (Long)root.get("tcp_port");
        if (tcp_lport == null) {
            tcp_lport = new Long(0L);
        }
        if ((udp_lport = (Long)root.get("udp_port")) == null) {
            udp_lport = new Long(0L);
        }
        if ((udp2_lport = (Long)root.get("udp2_port")) == null) {
            udp2_lport = udp_lport;
        }
        if ((h_type = (Long)root.get("handshake_type")) == null) {
            h_type = new Long(0L);
        }
        InetAddress ipv6 = null;
        if (root.get("ipv6") instanceof byte[]) {
            try {
                InetAddress.getByAddress((byte[])root.get("ipv6"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int md_size = 0;
        Long mds = (Long)root.get("mds");
        if (mds != null) {
            md_size = mds.intValue();
        }
        if ((raw_msgs = (List)root.get("messages")) == null) {
            throw new MessageException("raw_msgs == null");
        }
        String[] ids = new String[raw_msgs.size()];
        byte[] vers = new byte[raw_msgs.size()];
        int pos = 0;
        for (Map msg : raw_msgs) {
            byte[] mid = (byte[])msg.get("id");
            if (mid == null) {
                throw new MessageException("mid == null");
            }
            ids[pos] = new String(mid);
            byte[] ver = (byte[])msg.get("ver");
            if (ver == null) {
                throw new MessageException("ver == null");
            }
            if (ver.length != 1) {
                throw new MessageException("ver.length != 1");
            }
            vers[pos] = ver[0];
            ++pos;
        }
        Long ulOnly = (Long)root.get("upload_only");
        boolean bl = uploadOnly = ulOnly != null && ulOnly > 0L;
        if (name.equals("Azureus")) {
            name = "Vuze";
        }
        String localHost = (b_lh = (byte[])root.get("lh")) == null ? null : new String(b_lh, Constants.UTF_8);
        return new AZHandshake(id, session == null ? null : new HashWrapper(session), reconnect == null ? null : new HashWrapper(reconnect), name, client_version, tcp_lport.intValue(), udp_lport.intValue(), udp2_lport.intValue(), ipv6, localHost, md_size, ids, vers, h_type.intValue(), version, uploadOnly);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

