/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.peer.util.PeerIdentityDataID;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.LightHashMap;
import java.util.Arrays;
import java.util.Map;

public class PeerIdentityManager {
    private static final boolean MUTLI_CONTROLLERS = COConfigurationManager.getBooleanParameter("peer.multiple.controllers.per.torrent.enable", false);
    private static final AEMonitor class_mon = new AEMonitor("PeerIdentityManager:class");
    private static final Map<PeerIdentityDataID, DataEntry> dataMap = new LightHashMap<PeerIdentityDataID, DataEntry>();
    private static int totalIDs = 0;

    public static PeerIdentityDataID createDataID(byte[] data) {
        DataEntry dataEntry2;
        PeerIdentityDataID data_id = new PeerIdentityDataID(data);
        try {
            class_mon.enter();
            dataEntry2 = dataMap.get(data_id);
            if (dataEntry2 == null) {
                dataEntry2 = new DataEntry();
                dataMap.put(data_id, dataEntry2);
            }
        }
        finally {
            class_mon.exit();
        }
        data_id.setDataEntry(dataEntry2);
        return data_id;
    }

    public static boolean addIdentity(PeerIdentityDataID data_id, byte[] peer_id, int local_port, String ip) {
        PeerIdentity peerID = new PeerIdentity(peer_id, local_port);
        try {
            String old;
            class_mon.enter();
            DataEntry dataEntry2 = dataMap.get(data_id);
            if (dataEntry2 == null) {
                dataEntry2 = new DataEntry();
                dataMap.put(data_id, dataEntry2);
            }
            if ((old = dataEntry2.addPeer(peerID, ip)) == null) {
                ++totalIDs;
                return true;
            }
            return false;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void removeIdentity(PeerIdentityDataID data_id, byte[] peer_id, int local_port) {
        try {
            class_mon.enter();
            DataEntry dataEntry2 = dataMap.get(data_id);
            if (dataEntry2 != null) {
                PeerIdentity peerID = new PeerIdentity(peer_id, local_port);
                String old = dataEntry2.removePeer(peerID);
                if (old != null) {
                    --totalIDs;
                } else {
                    Debug.out("id not present: id=" + peerID.getString());
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean containsIdentity(PeerIdentityDataID data_id, byte[] peer_id, int local_port) {
        PeerIdentity peerID = new PeerIdentity(peer_id, local_port);
        try {
            class_mon.enter();
            DataEntry dataEntry2 = dataMap.get(data_id);
            if (dataEntry2 != null && dataEntry2.hasPeer(peerID)) {
                return true;
            }
        }
        finally {
            class_mon.exit();
        }
        return false;
    }

    public static int getTotalIdentityCount() {
        return totalIDs;
    }

    public static int getIdentityCount(PeerIdentityDataID data_id) {
        return data_id.getDataEntry().getPeerCount();
    }

    public static boolean containsIPAddress(PeerIdentityDataID data_id, String ip) {
        try {
            class_mon.enter();
            DataEntry dataEntry2 = dataMap.get(data_id);
            if (dataEntry2 != null && dataEntry2.hasIP(ip)) {
                return true;
            }
        }
        finally {
            class_mon.exit();
        }
        return false;
    }

    protected static final class DataEntry {
        private final Map<PeerIdentity, String> _peerMap = new LightHashMap<PeerIdentity, String>();

        protected DataEntry() {
        }

        private boolean hasIP(String ip) {
            return this._peerMap.containsValue(ip);
        }

        private boolean hasPeer(PeerIdentity peer) {
            return this._peerMap.containsKey(peer);
        }

        private String addPeer(PeerIdentity peer, String ip) {
            return this._peerMap.put(peer, ip);
        }

        private String removePeer(PeerIdentity peer) {
            return this._peerMap.remove(peer);
        }

        private int getPeerCount() {
            return this._peerMap.size();
        }
    }

    private static class PeerIdentity {
        private final byte[] id;
        private final short port;
        private final int hashcode;

        private PeerIdentity(byte[] _id, int local_port) {
            this.id = _id;
            this.port = (short)local_port;
            this.hashcode = new String(this.id).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof PeerIdentity) {
                PeerIdentity other = (PeerIdentity)obj;
                if (MUTLI_CONTROLLERS && this.port != other.port) {
                    return false;
                }
                return Arrays.equals(this.id, other.id);
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        protected String getString() {
            return ByteFormatter.encodeString(this.id);
        }
    }
}

