/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer.impl.control;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.IPFilterListener;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManager;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminASN;
import com.biglybt.core.networkmanager.admin.NetworkAdminASNListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.networkmanager.impl.udp.UDPNetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerAdapter;
import com.biglybt.core.peer.PEPeerManagerListener;
import com.biglybt.core.peer.PEPeerManagerStats;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peer.impl.PEPeerControl;
import com.biglybt.core.peer.impl.PEPeerControlHashHandler;
import com.biglybt.core.peer.impl.PEPeerManagerStatsImpl;
import com.biglybt.core.peer.impl.PEPeerStatsImpl;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peer.impl.PEPeerTransportFactory;
import com.biglybt.core.peer.impl.PEPieceImpl;
import com.biglybt.core.peer.impl.PEPieceWriteImpl;
import com.biglybt.core.peer.impl.control.PEPeerControlHashHandlerImpl;
import com.biglybt.core.peer.impl.control.SuperSeedPeer;
import com.biglybt.core.peer.impl.control.SuperSeedPiece;
import com.biglybt.core.peer.util.PeerIdentityDataID;
import com.biglybt.core.peer.util.PeerIdentityManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.peermanager.PeerManagerRegistration;
import com.biglybt.core.peermanager.control.PeerControlInstance;
import com.biglybt.core.peermanager.control.PeerControlScheduler;
import com.biglybt.core.peermanager.control.PeerControlSchedulerFactory;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.bittorrent.BTHandshake;
import com.biglybt.core.peermanager.nat.PeerNATInitiator;
import com.biglybt.core.peermanager.nat.PeerNATTraverser;
import com.biglybt.core.peermanager.peerdb.PeerDatabase;
import com.biglybt.core.peermanager.peerdb.PeerDatabaseFactory;
import com.biglybt.core.peermanager.peerdb.PeerExchangerItem;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.peermanager.peerdb.PeerItemFactory;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.PiecePickerFactory;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.peermanager.unchoker.Unchoker;
import com.biglybt.core.peermanager.unchoker.UnchokerFactory;
import com.biglybt.core.peermanager.unchoker.UnchokerUtil;
import com.biglybt.core.peermanager.uploadslots.UploadHelper;
import com.biglybt.core.peermanager.uploadslots.UploadSlotManager;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.TrackerPeerSourceAdapter;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.BrokenMd5Hasher;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FeatureAvailability;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.OutgoingMessageQueue;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerDescriptor;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
DiskManagerWriteRequestListener,
PeerControlInstance,
PeerNATInitiator,
DiskManagerCheckRequestListener,
IPFilterListener {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final boolean TEST_PERIODIC_SEEDING_SCAN_FAIL_HANDLING = false;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static final int CHECK_REASON_SEEDING_CHECK = 4;
    private static final int CHECK_REASON_BAD_PIECE_CHECK = 5;
    private static final int SEED_CHECK_WAIT_MARKER = 65526;
    private static final long REQ_TIMEOUT_DATA_AGE_SEED_MILLIS = 120000L;
    private static final long REQ_TIMEOUT_DATA_AGE_LEECH_MILLIS = 60000L;
    private static final long REQ_TIMEOUT_OLDEST_REQ_AGE_MILLIS = 120000L;
    private static final long RESERVED_PIECE_TIMEOUT_MILLIS = 120000L;
    private static final Object CON_HEALTH_DONE_KEY = new Object();
    private static final Object DUP_PEER_CC_KEY = new Object();
    private static final Object DUP_PEER_AS_KEY = new Object();
    private static boolean global_disconnect_seeds_when_seeding;
    private static boolean enable_seeding_piece_rechecks;
    private static int stalled_piece_timeout;
    private static boolean fast_unchoke_new_peers;
    private static float ban_peer_discard_ratio;
    private static int ban_peer_discard_min_kb;
    private static boolean udp_fallback_for_failed_connection;
    private static boolean udp_fallback_for_dropped_connection;
    private static boolean udp_probe_enabled;
    private static boolean global_hide_a_piece;
    private static boolean global_hide_a_piece_ds;
    private static boolean prefer_udp_default;
    private static int dual_ipv4_ipv6_connection_action;
    static volatile Set<String> auto_sequential_file_exts;
    private static final NetworkAdmin network_admin;
    private static final IpFilter ip_filter;
    private static final AtomicInteger UUID_GEN;
    private final int pm_uuid = UUID_GEN.incrementAndGet();
    private volatile boolean is_running = false;
    private volatile boolean is_destroyed = false;
    private volatile ArrayList<PEPeerTransport> peer_transports_cow = new ArrayList();
    private final AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected final PEPeerManagerAdapter adapter;
    private final TOTorrent torrent;
    private final DiskManager disk_mgr;
    private final DiskManagerPiece[] dm_pieces;
    private final boolean is_private_torrent;
    private PEPeerManager.StatsReceiver stats_receiver;
    private final PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private final int _nbPieces;
    private final PEPieceImpl[] pePieces;
    private int nbPiecesActive;
    private long nbBytesRemaining;
    private int nbPeersSnubbed;
    private PeerIdentityDataID _hash;
    private final byte[] _myPeerId;
    private PEPeerManagerStatsImpl _stats;
    private final PEPeerControlHashHandler hash_handler;
    private int stats_tick_count;
    private int _seeds;
    private int _peers;
    private int _remotesTCPNoLan;
    private int _remotesUDPNoLan;
    private int _remotesUTPNoLan;
    private int _tcp_peers_transfering;
    private int _tcpPendingConnections;
    private int _tcpConnectingConnections;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStarted_mono;
    private long _timeStartedSeeding = -1L;
    private long _timeStartedSeeding_mono = -1L;
    private long _timeFinished_mono;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL;
    private static final int MAINLOOP_TWENTY_SECOND_INTERVAL;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL;
    private static final int MAINLOOP_FIVE_MINUTE_INTERVAL;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL;
    private volatile ArrayList<PEPeerManagerListener> peer_manager_listeners_cow = new ArrayList();
    private final List<Object[]> piece_check_result_list = new ArrayList<Object[]>();
    private final AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private boolean global_hide_a_piece_cached;
    private Boolean local_hide_a_piece_opt;
    private int hidden_piece;
    private static final int OB_PS_STATS_HISTORY_SIZE = 100;
    private boolean[][] ob_ps_stats_history = new boolean[PEPeerSource.PS_SOURCES.length][100];
    private int[] ob_ps_stats = new int[PEPeerSource.PS_SOURCES.length];
    private int[] ob_ps_stats_pos = new int[PEPeerSource.PS_SOURCES.length];
    private final AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map<Object, Object> user_data;
    private Unchoker unchoker;
    private List<Object[]> external_rate_limiters_cow;
    private int bytes_queued_for_upload;
    private int connections_with_queued_data;
    private int connections_with_queued_data_blocked;
    private int connections_unchoked;
    private int connections_unchoking;
    private int outbound_message_count;
    private List<PEPeerTransport> sweepList = Collections.emptyList();
    private int nextPEXSweepIndex = 0;
    private final UploadHelper upload_helper = new UploadHelper(){

        @Override
        public int getPriority() {
            return 4;
        }

        @Override
        public ArrayList<PEPeer> getAllPeers() {
            return PEPeerControlImpl.this.peer_transports_cow;
        }

        @Override
        public boolean isSeeding() {
            return PEPeerControlImpl.this.seeding_mode;
        }
    };
    private final PeerDatabase peer_database = PeerDatabaseFactory.createPeerDatabase();
    private int bad_piece_reported = -1;
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_smoothed;
    private long last_eta_calculation;
    private static final int MAX_UDP_CONNECTIONS = 16;
    private static final int PENDING_NAT_TRAVERSAL_MAX = 32;
    private static final int MAX_UDP_TRAVERSAL_COUNT = 3;
    private static final String PEER_NAT_TRAVERSE_DONE_KEY;
    private final Map<String, PEPeerTransport> pending_nat_traversals = new LinkedHashMap<String, PEPeerTransport>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> eldest) {
            return this.size() > 32;
        }
    };
    private int udp_traversal_count;
    private static final int PENDING_HOLE_PUNCH_MAX = 32;
    private final Map<String, Object[]> pending_hole_punches = new LinkedHashMap<String, Object[]>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object[]> eldest) {
            return this.size() > 32;
        }
    };
    private static final int OUTBOUND_IGNORE_ADDRESSES_MAX = 1024;
    private final Map<PeerCacheKey, Integer> outbound_ignore_addresses = new LinkedHashMap<PeerCacheKey, Integer>(1024, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<PeerCacheKey, Integer> eldest) {
            return this.size() > 1024;
        }
    };
    private static final int RECONNECT_SEEDING_MIN = 180000;
    private static final int RECONNECT_DOWNLOADING_MIN = 60000;
    private static final int CONNECT_FAIL_HISTORY_MAX = 512;
    private final Map<PeerCacheKey, Long> connect_fail_history = new LinkedHashMap<PeerCacheKey, Long>(512, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<PeerCacheKey, Long> eldest) {
            return this.size() > 512;
        }
    };
    private static final int UDP_RECONNECT_MAX = 16;
    private final Map<String, PEPeerTransport> udp_reconnects = new LinkedHashMap<String, PEPeerTransport>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> eldest) {
            return this.size() > 16;
        }
    };
    private static final int UDP_RECONNECT_MIN_MILLIS = 10000;
    private long last_udp_reconnect_mono = SystemTime.getMonotonousTime();
    private boolean prefer_udp;
    private static final int PREFER_UDP_BLOOM_SIZE = 10000;
    private volatile BloomFilter prefer_udp_bloom;
    private volatile boolean upload_diabled;
    private volatile boolean download_diabled;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "per_dl_up: " + PEPeerControlImpl.this.getDisplayName();
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            boolean disabled;
            int rate = PEPeerControlImpl.this.adapter.getEffectiveUploadRateLimitBytesPerSecond();
            boolean bl = disabled = rate < 0;
            if (disabled != PEPeerControlImpl.this.upload_diabled) {
                try {
                    PEPeerControlImpl.this.peer_transports_mon.enter();
                    if (disabled != PEPeerControlImpl.this.upload_diabled) {
                        PEPeerControlImpl.this.upload_diabled = disabled;
                        for (PEPeerTransport peer : PEPeerControlImpl.this.peer_transports_cow) {
                            peer.setUploadDisabled(PEPeerControlImpl.this.upload_limited_rate_group, disabled);
                        }
                    }
                }
                finally {
                    PEPeerControlImpl.this.peer_transports_mon.exit();
                }
            }
            if (disabled) {
                return 0;
            }
            return rate;
        }

        @Override
        public boolean isDisabled() {
            return PEPeerControlImpl.this.adapter.getEffectiveUploadRateLimitBytesPerSecond() == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "per_dl_down: " + PEPeerControlImpl.this.getDisplayName();
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            boolean disabled;
            int rate = PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
            boolean bl = disabled = rate < 0;
            if (disabled != PEPeerControlImpl.this.download_diabled) {
                try {
                    PEPeerControlImpl.this.peer_transports_mon.enter();
                    if (disabled != PEPeerControlImpl.this.download_diabled) {
                        PEPeerControlImpl.this.download_diabled = disabled;
                        for (PEPeerTransport peer : PEPeerControlImpl.this.peer_transports_cow) {
                            peer.setDownloadDisabled(PEPeerControlImpl.this.download_limited_rate_group, disabled);
                        }
                    }
                }
                finally {
                    PEPeerControlImpl.this.peer_transports_mon.exit();
                }
            }
            if (disabled) {
                return 0;
            }
            return rate;
        }

        @Override
        public boolean isDisabled() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond() == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private final int partition_id;
    private final boolean is_metadata_download;
    private int metadata_infodict_size;
    private DiskManager.DownloadEndedProgress finish_in_progress;
    private long last_seed_disconnect_time;
    private final BloomFilter naughty_fast_extension_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddRemove4Bit(2000), 2);
    private volatile boolean asfe_activated;
    private final MyPeer my_peer = new MyPeer();
    private static final int HP_BLOOM_FILTER_SIZE = 512;
    private volatile BloomFilter hp_bloom = null;
    private static final int FE_EVENT_LIMIT = 5;
    private int optimisticDisconnectCount = 0;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Disconnect Seed", "Seeding Piece Check Recheck Enable", "peercontrol.stalled.piece.write.timeout", "Peer.Fast.Initial.Unchoke.Enabled", "Ip Filter Ban Discard Ratio", "Ip Filter Ban Discard Min KB", "peercontrol.udp.fallback.connect.fail", "peercontrol.udp.fallback.connect.drop", "peercontrol.udp.probe.enable", "peercontrol.hide.piece", "peercontrol.hide.piece.ds", "peercontrol.prefer.udp", "Dual IPV4 IPV6 Connection Action"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                global_disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed");
                enable_seeding_piece_rechecks = COConfigurationManager.getBooleanParameter("Seeding Piece Check Recheck Enable");
                stalled_piece_timeout = COConfigurationManager.getIntParameter("peercontrol.stalled.piece.write.timeout", 60000);
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                ban_peer_discard_ratio = COConfigurationManager.getFloatParameter("Ip Filter Ban Discard Ratio");
                ban_peer_discard_min_kb = COConfigurationManager.getIntParameter("Ip Filter Ban Discard Min KB");
                udp_fallback_for_failed_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.fail");
                udp_fallback_for_dropped_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.drop");
                udp_probe_enabled = COConfigurationManager.getBooleanParameter("peercontrol.udp.probe.enable");
                global_hide_a_piece = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
                global_hide_a_piece_ds = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece.ds");
                prefer_udp_default = COConfigurationManager.getBooleanParameter("peercontrol.prefer.udp");
                dual_ipv4_ipv6_connection_action = COConfigurationManager.getIntParameter("Dual IPV4 IPV6 Connection Action");
            }
        });
        auto_sequential_file_exts = new HashSet<String>();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"file.auto.sequential.exts"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                HashSet<String> new_exts = new HashSet<String>();
                String extensions = COConfigurationManager.getStringParameter("file.auto.sequential.exts", "");
                if (!(extensions = extensions.trim()).isEmpty()) {
                    String[] bits;
                    extensions = extensions.toLowerCase(Locale.US);
                    extensions = extensions.replace(';', ',');
                    String[] stringArray = bits = extensions.split(",");
                    int n = bits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bit = stringArray[n2];
                        if (!(bit = bit.trim()).isEmpty()) {
                            if (!bit.startsWith(".")) {
                                bit = "." + bit;
                            }
                            new_exts.add(bit);
                        }
                        ++n2;
                    }
                }
                auto_sequential_file_exts = new_exts;
            }
        });
        network_admin = NetworkAdmin.getSingleton();
        ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        UUID_GEN = new AtomicInteger();
        MAINLOOP_ONE_SECOND_INTERVAL = 1000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
        MAINLOOP_FIVE_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 5;
        MAINLOOP_TEN_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 10;
        MAINLOOP_TWENTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 20;
        MAINLOOP_THIRTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 30;
        MAINLOOP_SIXTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 60;
        MAINLOOP_FIVE_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 5;
        MAINLOOP_TEN_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 10;
        PEER_NAT_TRAVERSE_DONE_KEY = String.valueOf(PEPeerControlImpl.class.getName()) + "::nat_trav_done";
    }

    public PEPeerControlImpl(byte[] _peer_id, PEPeerManagerAdapter _adapter, DiskManager _diskManager, int _partition_id) {
        this._myPeerId = _peer_id;
        this.adapter = _adapter;
        this.disk_mgr = _diskManager;
        this.partition_id = _partition_id;
        this.torrent = this.disk_mgr.getTorrent();
        this.hash_handler = this.torrent.getEffectiveTorrentType() == 3 ? new PEPeerControlHashHandlerImpl(this, this.torrent, this.disk_mgr) : new PEPeerControlHashHandler(){

            @Override
            public void sendingRequest(PEPeerTransport peer, DiskManagerReadRequest request2) {
            }

            @Override
            public boolean hashRequest(int piece_number, DiskManagerCheckRequestListener.HashListener listener) {
                return false;
            }

            @Override
            public void receivedHashes(PEPeerTransport peer, byte[] root_hash, int base_layer, int index, int length, int proof_layers, byte[][] hashes) {
            }

            @Override
            public void receivedHashRequest(PEPeerTransport peer, PEPeerControlHashHandler.HashesReceiver receiver, byte[] root_hash, int base_layer, int index, int length, int proof_layers) {
            }

            @Override
            public void rejectedHashes(PEPeerTransport peer, byte[] root_hash, int base_layer, int index, int length, int proof_layers) {
            }

            @Override
            public void update() {
            }

            @Override
            public void stop() {
            }
        };
        this.is_private_torrent = this.torrent.getPrivate();
        this.is_metadata_download = this.adapter.isMetadataDownload();
        if (!this.is_metadata_download) {
            this.metadata_infodict_size = this.adapter.getTorrentInfoDictSize();
        }
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        this.initHiddenPiece();
        this.piecePicker = PiecePickerFactory.create(this);
        ip_filter.addListener(this);
        this.disk_mgr.addListener(new DiskManagerListener(){

            @Override
            public void stateChanged(DiskManager dm, int oldState, int newState) {
            }

            @Override
            public void pieceDoneChanged(DiskManager dm, DiskManagerPiece piece) {
            }

            @Override
            public void filePriorityChanged(DiskManager dm, DiskManagerFileInfo file) {
                PEPeerControlImpl.this.handleFilePriorityChanged();
            }

            @Override
            public void fileCompleted(DiskManager dm, DiskManagerFileInfo file) {
                PEPeerControlImpl.this.checkAutoSequentialFiles(file);
            }
        });
    }

    @Override
    public int getUID() {
        return this.pm_uuid;
    }

    @Override
    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        int i = 0;
        while (i < this._nbPieces) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (!dmPiece.isDone() && dmPiece.getNbWritten() > 0) {
                this.addPiece(new PEPieceImpl(this.piecePicker, dmPiece, 0), i, true, null);
            }
            ++i;
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.checkFinished(true);
        UploadSlotManager.getSingleton().registerHelper(this.upload_helper);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this._timeStarted_mono = SystemTime.getMonotonousTime();
        this.is_running = true;
        PeerManagerRegistration reg = this.adapter.getPeerManagerRegistration();
        if (reg != null) {
            reg.activate(this);
        }
        PeerNATTraverser.getSingleton().register(this);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).register(this);
        this.checkAutoSequentialFiles(null);
    }

    @Override
    public void stopAll() {
        this.is_running = false;
        UploadSlotManager.getSingleton().deregisterHelper(this.upload_helper);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).unregister(this);
        PeerNATTraverser.getSingleton().unregister(this);
        PeerManagerRegistration reg = this.adapter.getPeerManagerRegistration();
        if (reg != null) {
            reg.deactivate();
        }
        this.closeAndRemoveAllPeers("download stopped", 2, false);
        int i = 0;
        while (i < this._nbPieces) {
            if (this.pePieces[i] != null) {
                this.removePiece(this.pePieces[i], i);
            }
            ++i;
        }
        ip_filter.removeListener(this);
        this.piecePicker.destroy();
        for (PEPeerManagerListener listener : this.peer_manager_listeners_cow) {
            try {
                listener.destroyed(this);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.sweepList = Collections.emptyList();
        this.pending_nat_traversals.clear();
        this.pending_hole_punches.clear();
        this.udp_reconnects.clear();
        this.outbound_ignore_addresses.clear();
        this.connect_fail_history.clear();
        this.hash_handler.stop();
        this.is_destroyed = true;
    }

    @Override
    public void removeAllPeers(String reason, int reason_code) {
        for (PEPeer pEPeer : this.peer_transports_cow) {
            this.removePeer(pEPeer, reason, reason_code);
        }
        try {
            this.peer_transports_mon.enter();
            this.udp_reconnects.clear();
            this.pending_nat_traversals.clear();
            this.pending_hole_punches.clear();
        }
        finally {
            this.peer_transports_mon.exit();
        }
    }

    @Override
    public int getPartitionID() {
        return this.partition_id;
    }

    @Override
    public int getTCPListeningPortNumber() {
        return this.adapter.getTCPListeningPortNumber();
    }

    @Override
    public byte[] getTargetHash() {
        return this.adapter.getTargetHash();
    }

    @Override
    public boolean isDestroyed() {
        return this.is_destroyed;
    }

    @Override
    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    @Override
    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    @Override
    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void schedule() {
        if (this.finish_in_progress != null) {
            if (this.finish_in_progress.isComplete()) {
                this.finish_in_progress = null;
            } else {
                return;
            }
        }
        try {
            this.updateStats();
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            if (this.finish_in_progress != null) {
                return;
            }
            if (!this.seeding_mode) {
                this.checkCompletedPieces();
            }
            this.checkBadPieces();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            this.checkCompletionState();
            if (this.finish_in_progress != null) {
                return;
            }
            this.checkSeeds();
            if (this.seeding_mode) {
                if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
                    this.hash_handler.update();
                }
            } else {
                this.checkRequests();
                this.piecePicker.allocateRequests();
                this.checkRescan();
                this.checkSpeedAndReserved();
                this.check99PercentBug();
            }
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
            if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
                this.my_peer.update();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tracker_response) {
        Map extensions;
        TRTrackerAnnouncerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    @Override
    public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        if (this.is_running) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        if (protocols != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            for (String protocol_name : protocols.keySet()) {
                Map protocol = (Map)protocols.get(protocol_name);
                List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
                int i = 0;
                while (i < transports.size()) {
                    PEPeer transport = (PEPeer)transports.get(i);
                    this.addPeer(transport);
                    ++i;
                }
            }
        }
    }

    @Override
    public PEPeer getMyPeer() {
        return this.my_peer;
    }

    @Override
    public List<PEPeer> getPeers() {
        return this.peer_transports_cow;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<PEPeer> getPeers(String address) {
        result = new ArrayList<PEPeer>();
        it = this.peer_transports_cow.iterator();
        if (!address.contains(":")) ** GOTO lbl-1000
        try {
            address_bytes = InetAddress.getByName(address).getAddress();
            while (it.hasNext()) {
                peer = it.next();
                peer_address = peer.getIp();
                if (!peer_address.contains(":")) continue;
                peer_bytes = (byte[])peer.getUserData("ipv6.bytes");
                if (peer_bytes == null) {
                    peer_bytes = InetAddress.getByName(peer_address).getAddress();
                    peer.setUserData("ipv6.bytes", peer_bytes);
                }
                if (!Arrays.equals(address_bytes, peer_bytes)) continue;
                result.add(peer);
            }
            return result;
        }
        catch (Throwable address_bytes) lbl-1000:
        // 4 sources

        {
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            peer = it.next();
            if (!peer.getIp().equals(address)) continue;
            result.add(peer);
            continue;
        }
lbl26:
        // 1 sources

        return result;
    }

    @Override
    public int getPendingPeerCount() {
        return this.peer_database.getDiscoveredPeerCount();
    }

    @Override
    public PeerDescriptor[] getPendingPeers() {
        return this.peer_database.getDiscoveredPeers();
    }

    @Override
    public PeerDescriptor[] getPendingPeers(String address) {
        return this.peer_database.getDiscoveredPeers(address);
    }

    @Override
    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
                transport.start();
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected", 1);
            }
        } else {
            transport.closeConnection("IP address blocked by filters", 5);
        }
    }

    protected byte[] getTorrentHash() {
        try {
            return this.disk_mgr.getTorrent().getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void removePeer(PEPeer _transport, String reason, int reason_code) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.closeAndRemovePeer(transport, reason, reason_code, true);
    }

    private void closeAndRemovePeer(PEPeerTransport peer, String reason, int reason_code, boolean log_if_not_found) {
        boolean removed = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                removed = true;
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (removed) {
            peer.closeConnection(reason, reason_code);
            this.peerRemoved(peer);
        }
    }

    private void closeAndRemoveAllPeers(String reason, int reason_code, boolean reconnect) {
        PEPeerTransport peer;
        ArrayList<PEPeerTransport> peer_transports;
        try {
            this.peer_transports_mon.enter();
            peer_transports = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
        }
        finally {
            this.peer_transports_mon.exit();
        }
        int i = 0;
        while (i < peer_transports.size()) {
            peer = (PEPeerTransport)peer_transports.get(i);
            try {
                peer.closeConnection(reason, reason_code);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.peerRemoved(peer);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        if (reconnect) {
            i = 0;
            while (i < peer_transports.size()) {
                peer = (PEPeerTransport)peer_transports.get(i);
                PEPeerTransport pEPeerTransport = peer.reconnect(false, false, null);
                ++i;
            }
        }
    }

    @Override
    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) throws Exception {
        Boolean f;
        String ps;
        byte type = use_crypto ? (byte)1 : 0;
        String peer_source = "Plugin";
        if (user_data != null && (ps = (String)user_data.get(Peer.PR_PEER_SOURCE)) != null) {
            peer_source = ps;
        }
        PeerItem peer_item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID(peer_source), type, udp_port, (byte)1, 0);
        byte crypto_level = 1;
        boolean force = false;
        if (user_data != null && (f = (Boolean)user_data.get(Peer.PR_FORCE_CONNECTION)) != null) {
            force = f;
        }
        String fail_reason = null;
        if (force || !this.isAlreadyConnected(peer_item)) {
            boolean udp_ok;
            boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0;
            boolean bl = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0;
            fail_reason = tcp_ok && (!this.prefer_udp && !prefer_udp_default || !udp_ok) ? this.makeNewOutgoingConnection(peer_source, ip_address, tcp_port, udp_port, true, use_crypto, crypto_level, user_data) : (udp_ok ? this.makeNewOutgoingConnection(peer_source, ip_address, tcp_port, udp_port, false, use_crypto, crypto_level, user_data) : "No usable protocol");
        } else {
            fail_reason = "Already connected";
        }
        if (fail_reason != null) {
            throw new Exception("Failed to add peer: " + fail_reason);
        }
    }

    @Override
    public void peerDiscovered(String peer_source, String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        if (this.peer_database != null) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int x = 0;
            while (x < peer_transports.size()) {
                PEPeer transport = peer_transports.get(x);
                if (ip_address.equals(transport.getIp())) {
                    boolean same_allowed;
                    boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                    if (!same_allowed || tcp_port == transport.getPort()) {
                        return;
                    }
                }
                ++x;
            }
            byte type = use_crypto ? (byte)1 : 0;
            PeerItem item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID(peer_source), type, udp_port, (byte)1, 0);
            this.peerDiscovered(null, item);
            this.peer_database.addDiscoveredPeer(item);
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] peers) {
        int i = 0;
        while (i < peers.length) {
            TRTrackerAnnouncerResponsePeer peer = peers[i];
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            int x = 0;
            while (x < peer_transports.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (peer.getAddress().equals(transport.getIp())) {
                    boolean same_allowed;
                    boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                    if (!same_allowed || peer.getPort() == transport.getPort()) {
                        already_connected = true;
                        break;
                    }
                }
                ++x;
            }
            if (!already_connected) {
                int http_port;
                if (this.peer_database != null) {
                    byte type = peer.getProtocol() == 2 ? (byte)1 : 0;
                    byte crypto_level = peer.getAZVersion() < 3 ? (byte)1 : 2;
                    PeerItem item = PeerItemFactory.createPeerItem(peer.getAddress(), peer.getPort(), PeerItem.convertSourceID(peer.getSource()), type, peer.getUDPPort(), crypto_level, peer.getUploadSpeed());
                    this.peerDiscovered(null, item);
                    this.peer_database.addDiscoveredPeer(item);
                }
                if ((http_port = peer.getHTTPPort()) != 0 && !this.seeding_mode) {
                    this.adapter.addHTTPSeed(peer.getAddress(), http_port);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeNewOutgoingConnection(String peer_source, String address, int tcp_port, int udp_port, boolean use_tcp, boolean require_crypto, byte crypto_level, Map user_data) {
        Object bytes;
        if (ip_filter.isInRange(address, this.getDisplayName(), this.getTorrentHash())) {
            return "IPFilter block";
        }
        String net_cat = AENetworkClassifier.categoriseAddress(address);
        if (!this.adapter.isNetworkEnabled(net_cat)) {
            return "Network '" + net_cat + "' is not enabled";
        }
        if (!this.adapter.isPeerSourceEnabled(peer_source)) {
            return "Peer source '" + peer_source + "' is not enabled";
        }
        PeerCacheKey key = net_cat == "Public" ? ((bytes = HostNameToIPResolver.hostAddressToBytes(address)) == null ? new PeerUnresolvedCacheKey(address, tcp_port) : new PeerResolvedCacheKey((byte[])bytes, tcp_port)) : new PeerNonPublicCacheKey(address);
        Map<PeerCacheKey, Integer> map = this.outbound_ignore_addresses;
        bytes = map;
        synchronized (map) {
            boolean same_allowed;
            boolean max_reached;
            block15: {
                Long ft;
                Integer rc = this.outbound_ignore_addresses.get(key);
                if (rc != null) {
                    // ** MonitorExit[bytes /* !! */ ] (shouldn't be in output)
                    return "Ignoring outbound connection due to previous close_reason: " + rc;
                }
                if (peer_source == "HolePunch" || (ft = this.connect_fail_history.get(key)) == null || SystemTime.getMonotonousTime() - ft > (long)(this.seeding_mode ? 180000 : 60000)) break block15;
                // ** MonitorExit[bytes /* !! */ ] (shouldn't be in output)
                return "Ignoring outbound connection due to previous connect failure";
            }
            // ** MonitorExit[bytes /* !! */ ] (shouldn't be in output)
            boolean is_priority_connection = false;
            boolean force = false;
            if (user_data != null) {
                Boolean f;
                Boolean pc = (Boolean)user_data.get(Peer.PR_PRIORITY_CONNECTION);
                if (pc != null && pc.booleanValue()) {
                    is_priority_connection = true;
                }
                if ((f = (Boolean)user_data.get(Peer.PR_FORCE_CONNECTION)) != null) {
                    force = f;
                }
            }
            boolean bl = max_reached = this.getMaxNewConnectionsAllowed(net_cat) == 0;
            if (max_reached && (peer_source != "Plugin" || !this.doOptimisticDisconnect(AddressUtils.isLANLocalAddress(address) != 2, is_priority_connection, net_cat))) {
                return "Too many connections";
            }
            boolean bl2 = same_allowed = force || COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
            if (!same_allowed && PeerIdentityManager.containsIPAddress(this._hash, address)) {
                return "Already connected to IP";
            }
            if (PeerUtils.ignorePeerPort(tcp_port)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + address + ":" + tcp_port + " as peer port is in ignore list."));
                }
                return "TCP port '" + tcp_port + "' is in ignore list";
            }
            PEPeerTransport real = PEPeerTransportFactory.createTransport(this, peer_source, address, tcp_port, udp_port, use_tcp, require_crypto, crypto_level, user_data);
            this.addToPeerTransports(real);
            return null;
        }
    }

    private void checkCompletedPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        long remaining = 0L;
        int i = 0;
        while (i < this._nbPieces) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (dmPiece.isNeedsCheck()) {
                dmPiece.setChecking();
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(i, new Integer(1));
                req.setAdHoc(false);
                this.disk_mgr.enqueueCheckRequest(req, this);
            } else {
                remaining += (long)dmPiece.getRemaining();
            }
            ++i;
        }
        this.nbBytesRemaining = remaining;
    }

    @Override
    public boolean hashRequest(int piece_number, DiskManagerCheckRequestListener.HashListener listener) {
        return this.hash_handler.hashRequest(piece_number, listener);
    }

    private boolean checkEmptyPiece(int pieceNumber) {
        if (this.piecePicker.isInEndGameMode()) {
            return false;
        }
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        if (pePiece == null || pePiece.isRequested()) {
            return false;
        }
        if (dmPiece.getNbWritten() > 0 || pePiece.getNbUnrequested() < pePiece.getNbBlocks() || pePiece.getReservedBy() != null) {
            return false;
        }
        pePiece.reset();
        this.removePiece(pePiece, pieceNumber);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int nbPieces = this._nbPieces;
        PEPieceImpl[] pieces = this.pePieces;
        int i = 0;
        while (i < nbPieces) {
            this.checkEmptyPiece(i);
            PEPieceImpl pePiece = pieces[i];
            if (pePiece != null) {
                long timeSinceActivityMillis = pePiece.getTimeSinceLastActivity();
                int pieceSpeed = pePiece.getSpeed();
                if (pieceSpeed > 0 && (double)(timeSinceActivityMillis / 1000L * (long)pieceSpeed) * 0.25 > 16.0) {
                    if (pePiece.getNbUnrequested() > 2) {
                        pePiece.setSpeed(pieceSpeed - 1);
                    } else {
                        pePiece.setSpeed(0);
                    }
                }
                if (timeSinceActivityMillis > 120000L) {
                    pePiece.setSpeed(0);
                    String reservingPeer = pePiece.getReservedBy();
                    if (reservingPeer != null) {
                        PEPeerTransport pt = this.getTransportFromAddress(reservingPeer);
                        if (this.needsMD5CheckOnCompletion(i)) {
                            this.badPeerDetected(reservingPeer, i, "Peer is too slow");
                        } else if (pt != null) {
                            this.closeAndRemovePeer(pt, "Reserved piece data timeout; 120 seconds", 12, true);
                        }
                        pePiece.setReservedBy(null);
                    }
                    if (!this.piecePicker.isInEndGameMode()) {
                        pePiece.checkRequests();
                    }
                    this.checkEmptyPiece(i);
                }
            }
            ++i;
        }
    }

    private void check99PercentBug() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            long now = SystemTime.getCurrentTime();
            int i = 0;
            while (i < this.pePieces.length) {
                DiskManagerPiece dm_piece;
                PEPieceImpl pe_piece = this.pePieces[i];
                if (!(pe_piece == null || (dm_piece = this.dm_pieces[i]).isDone() || !pe_piece.isDownloaded() || now - pe_piece.getLastDownloadTime(now) <= (long)stalled_piece_timeout || this.disk_mgr.hasOutstandingWriteRequestForPiece(i) || this.disk_mgr.hasOutstandingReadRequestForPiece(i) || this.disk_mgr.hasOutstandingCheckRequestForPiece(i))) {
                    Debug.out("Fully downloaded piece stalled pending write, resetting p_piece " + i);
                    pe_piece.reset();
                }
                ++i;
            }
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int cntPeersSnubbed = 0;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            peer.checkInterested();
            if (peer.isSnubbed()) {
                ++cntPeersSnubbed;
            }
            ++i;
        }
        this.setNbPeersSnubbed(cntPeersSnubbed);
    }

    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList<Object[]> pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList<Object[]>(this.piece_check_result_list);
                this.piece_check_result_list.clear();
            }
            finally {
                this.piece_check_result_list_mon.exit();
            }
            for (Object[] data : pieces) {
                this.processPieceCheckResult((DiskManagerCheckRequest)data[0], (Integer)data[1]);
            }
        }
    }

    private void checkBadPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L && this.bad_piece_reported != -1) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this.bad_piece_reported, new Integer(5));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning reported-bad piece " + this.bad_piece_reported));
            }
            this.bad_piece_reported = -1;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkRescan() {
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % (long)PEPeerControlImpl.MAINLOOP_FIVE_SECOND_INTERVAL == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % (long)PEPeerControlImpl.MAINLOOP_TEN_MINUTE_INTERVAL == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        now = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > now) {
            this.rescan_piece_time = now;
        }
        if (now - this.rescan_piece_time >= (millis_per_piece = (piece_size = (long)this.disk_mgr.getPieceLength()) / 250L)) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            this_piece = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[this_piece] != null || this.dm_pieces[this_piece].isDone() || !this.dm_pieces[this_piece].isNeeded()) continue;
            req = this.disk_mgr.createCheckRequest(this_piece, new Integer(3));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), PEPeerControlImpl.LOGID, "Rescanning piece " + this_piece));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                this.rescan_piece_time = now;
                Debug.printStackTrace(e);
            }
            break;
lbl32:
            // 2 sources

            ** while (this.next_rescan_piece != -1)
        }
lbl33:
        // 3 sources

    }

    @Override
    public void badPieceReported(PEPeerTransport originator, int piece_number) {
        Debug.outNoStack(String.valueOf(this.getDisplayName()) + ": bad piece #" + piece_number + " reported by " + originator.getIp());
        if (piece_number < 0 || piece_number >= this._nbPieces) {
            return;
        }
        this.bad_piece_reported = piece_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFastExtensionPermitted(PEPeerTransport originator) {
        try {
            byte[] key = originator.getIp().getBytes(Constants.BYTE_ENCODING_CHARSET);
            BloomFilter bloomFilter = this.naughty_fast_extension_bloom;
            synchronized (bloomFilter) {
                int events = this.naughty_fast_extension_bloom.add(key);
                if (events < 5) {
                    return true;
                }
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Fast extension disabled for " + originator.getIp() + " due to repeat connections"));
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportBadFastExtensionUse(PEPeerTransport originator) {
        try {
            byte[] key = originator.getIp().getBytes(Constants.BYTE_ENCODING_CHARSET);
            BloomFilter bloomFilter = this.naughty_fast_extension_bloom;
            synchronized (bloomFilter) {
                if (this.naughty_fast_extension_bloom.add(key) == 5) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Fast extension disabled for " + originator.getIp() + " due to repeat requests for the same pieces"));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setStatsReceiver(PEPeerManager.StatsReceiver receiver) {
        this.stats_receiver = receiver;
    }

    @Override
    public void statsRequest(PEPeerTransport originator, Map request2) {
        HashMap reply = new HashMap();
        this.adapter.statsRequest(originator, request2, reply);
        if (reply.size() > 0) {
            originator.sendStatsReply(reply);
        }
    }

    @Override
    public void statsReply(PEPeerTransport originator, Map reply) {
        PEPeerManager.StatsReceiver receiver = this.stats_receiver;
        if (receiver != null) {
            receiver.receiveStats(originator, reply);
        }
    }

    private void checkFinished(boolean start_of_day) {
        boolean all_pieces_done;
        boolean bl = all_pieces_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (all_pieces_done) {
            this.seeding_mode = true;
            this.nbBytesRemaining = 0L;
            this.prefer_udp_bloom = null;
            this.piecePicker.clearEndGameChunks();
            if (!start_of_day) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished_mono = SystemTime.getMonotonousTime();
            for (PEPeerTransport pc : this.peer_transports_cow) {
                pc.setSnubbed(false);
            }
            this.setNbPeersSnubbed(0);
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            this._timeStartedSeeding_mono = SystemTime.getMonotonousTime();
            try {
                this.disk_mgr.saveResumeData(false);
            }
            catch (Throwable e) {
                Debug.out("Failed to save resume data", e);
            }
            this.adapter.setStateSeeding(start_of_day);
            boolean checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion");
            boolean checkBeforeMove = COConfigurationManager.getBooleanParameter("Check Pieces on Completion Before Move");
            if (!checkBeforeMove) {
                this.finish_in_progress = this.disk_mgr.downloadEnded(start_of_day);
            }
            if (checkPieces && !start_of_day) {
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest(req, this);
            }
            if (checkBeforeMove) {
                this.finish_in_progress = this.disk_mgr.downloadEnded(start_of_day);
            }
        } else {
            this.seeding_mode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletionState() {
        boolean dm_done;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        boolean bl = dm_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (this.seeding_mode) {
            if (!dm_done) {
                this.seeding_mode = false;
                this._timeStartedSeeding = -1L;
                this._timeStartedSeeding_mono = -1L;
                this._timeFinished_mono = 0L;
                Map<PeerCacheKey, Integer> map = this.outbound_ignore_addresses;
                synchronized (map) {
                    Iterator<Integer> it = this.outbound_ignore_addresses.values().iterator();
                    while (it.hasNext()) {
                        int rc = it.next();
                        if (rc != 7 && rc != 6) continue;
                        it.remove();
                    }
                }
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning off seeding mode for PEPeerManager"));
            }
        } else if (dm_done) {
            this.checkFinished(false);
            if (this.seeding_mode) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning on seeding mode for PEPeerManager"));
            }
        }
    }

    private void checkRequests() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        this.hash_handler.update();
        long mono_now = SystemTime.getMonotonousTime();
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = peer_transports.size() - 1;
        while (i >= 0) {
            List expired;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() == 30 && (expired = pc.getExpiredRequests()) != null && expired.size() > 0) {
                boolean isSeed = pc.isSeed();
                this.checkSnubbing(pc);
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(0);
                long timeSinceData = pc.getTimeSinceLastDataMessageReceived();
                long dataTimeout = isSeed ? 120000L : 60000L;
                long requestTimeout = 120000L;
                if (pc.getNetwork() != "Public") {
                    dataTimeout *= 2L;
                    requestTimeout *= 2L;
                }
                boolean noData = timeSinceData < 0L || timeSinceData > dataTimeout;
                long timeSinceOldestRequest = mono_now - request2.getTimeCreatedMono();
                int j = timeSinceOldestRequest > requestTimeout && noData ? 0 : 1;
                while (j < expired.size()) {
                    request2 = (DiskManagerReadRequest)expired.get(j);
                    pc.sendCancel(request2);
                    int pieceNumber = request2.getPieceNumber();
                    PEPieceImpl pe_piece = this.pePieces[pieceNumber];
                    if (pe_piece != null) {
                        pe_piece.clearRequested(request2.getOffset() / 16384);
                    }
                    if (!this.piecePicker.isInEndGameMode()) {
                        this.checkEmptyPiece(pieceNumber);
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    @Override
    public void checkSnubbing(PEPeerTransport peer) {
        boolean pub;
        long timeSinceGoodData = peer.getTimeSinceGoodDataReceived();
        boolean bl = pub = peer.getNetwork() == "Public";
        if (pub) {
            if (timeSinceGoodData < 0L || timeSinceGoodData > 60000L) {
                peer.setSnubbed(true);
            }
        } else {
            int connected = this._seeds + this._peers;
            if (connected < 8) {
                return;
            }
            if (timeSinceGoodData < 0L || timeSinceGoodData > 120000L) {
                peer.setSnubbed(true);
            }
        }
    }

    private void updateTrackerAnnounceInterval() {
        int num_wanted;
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int WANT_LIMIT = 100;
        int[] _num_wanted = this.getMaxNewConnectionsAllowed();
        if (_num_wanted[0] < 0) {
            num_wanted = 100;
        } else {
            num_wanted = _num_wanted[0] + _num_wanted[1];
            if (num_wanted > 100) {
                num_wanted = 100;
            }
        }
        boolean has_remote = this.adapter.isNATHealthy();
        if (has_remote) {
            num_wanted = (int)((double)num_wanted / 1.5);
        }
        int current_connection_count = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tsr = this.adapter.getTrackerScrapeResponse();
        if (tsr != null && tsr.isValid()) {
            int swarm_size;
            int num_seeds = tsr.getSeeds();
            int num_peers = tsr.getPeers();
            if (this.seeding_mode) {
                float ratio = (float)num_peers / (float)(num_seeds + num_peers);
                swarm_size = (int)((float)num_peers * ratio);
            } else {
                swarm_size = num_peers + num_seeds;
            }
            if (swarm_size < num_wanted) {
                num_wanted = swarm_size;
            }
        }
        if (num_wanted < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (current_connection_count == 0) {
            current_connection_count = 1;
        }
        int current_percent = current_connection_count * 100 / (current_connection_count + num_wanted);
        this.adapter.setTrackerRefreshDelayOverrides(current_percent);
    }

    @Override
    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    @Override
    public int getBytesQueuedForUpload() {
        return this.bytes_queued_for_upload;
    }

    @Override
    public int getNbPeersWithUploadQueued() {
        return this.connections_with_queued_data;
    }

    @Override
    public int getNbPeersWithUploadBlocked() {
        return this.connections_with_queued_data_blocked;
    }

    @Override
    public int getNbPeersUnchoked() {
        return this.connections_unchoked;
    }

    @Override
    public int getNbPeersUnchoking() {
        return this.connections_unchoking;
    }

    @Override
    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    @Override
    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    @Override
    public float getMinAvailability(int file_index) {
        return this.piecePicker.getMinAvailability(file_index);
    }

    @Override
    public long getBytesUnavailable() {
        return this.piecePicker.getBytesUnavailable();
    }

    @Override
    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    @Override
    public long getAvailWentBadTime() {
        long went_bad = this.piecePicker.getAvailWentBadTime();
        if ((double)this.piecePicker.getMinAvailability() < 1.0 && this.last_seed_disconnect_time > went_bad - 5000L) {
            went_bad = this.last_seed_disconnect_time;
        }
        return went_bad;
    }

    @Override
    public void addPeerTransport(PEPeerTransport transport) {
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected", 1);
            }
        } else {
            transport.closeConnection("IP address blocked by filters", 5);
        }
    }

    private void doUnchokes() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        int max_to_unchoke = this.adapter.getMaxUploads();
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        if (this.seeding_mode) {
            if (this.unchoker == null || !this.unchoker.isSeedingUnchoker()) {
                this.unchoker = UnchokerFactory.getSingleton().getUnchoker(true);
            }
        } else if (this.unchoker == null || this.unchoker.isSeedingUnchoker()) {
            this.unchoker = UnchokerFactory.getSingleton().getUnchoker(false);
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L) {
            boolean do_high_latency_peers;
            boolean refresh = this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L;
            boolean bl = do_high_latency_peers = this.mainloop_loop_count % (long)MAINLOOP_TWENTY_SECOND_INTERVAL == 0L;
            if (do_high_latency_peers) {
                boolean ok = false;
                String[] stringArray = AENetworkClassifier.AT_NON_PUBLIC;
                int n = AENetworkClassifier.AT_NON_PUBLIC.length;
                int n2 = 0;
                while (n2 < n) {
                    String net = stringArray[n2];
                    if (this.adapter.isNetworkEnabled(net)) {
                        ok = true;
                        break;
                    }
                    ++n2;
                }
                if (!ok) {
                    do_high_latency_peers = false;
                }
            }
            this.unchoker.calculateUnchokes(max_to_unchoke, peer_transports, refresh, this.adapter.hasPriorityConnection(), do_high_latency_peers);
            ArrayList<PEPeer> chokes = this.unchoker.getChokes();
            ArrayList<PEPeer> unchokes = this.unchoker.getUnchokes();
            this.addFastUnchokes(unchokes);
            UnchokerUtil.performChokes(chokes, unchokes);
        } else if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            ArrayList<PEPeer> unchokes = this.unchoker.getImmediateUnchokes(max_to_unchoke, peer_transports);
            this.addFastUnchokes(unchokes);
            UnchokerUtil.performChokes(null, unchokes);
        }
    }

    private void addFastUnchokes(ArrayList peers_to_unchoke) {
        for (PEPeerTransport peer : this.peer_transports_cow) {
            if (peer.getConnectionState() != 4 || !UnchokerUtil.isUnchokable(peer, true) || peers_to_unchoke.contains(peer)) continue;
            if (peer.isLANLocal()) {
                peers_to_unchoke.add(peer);
                continue;
            }
            if (!fast_unchoke_new_peers || peer.getData("fast_unchoke_done") != null) continue;
            peer.setData("fast_unchoke_done", "");
            peers_to_unchoke.add(peer);
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
            ++i;
        }
    }

    private void checkSeeds() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (!this.disconnectSeedsWhenSeeding()) {
            return;
        }
        ArrayList<PEPeerTransport> to_close = null;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc != null && pc.getPeerState() == 30 && (this.isSeeding() && pc.isSeed() || pc.isRelativeSeed())) {
                if (to_close == null) {
                    to_close = new ArrayList<PEPeerTransport>();
                }
                to_close.add(pc);
            }
            ++i;
        }
        if (to_close != null) {
            i = 0;
            while (i < to_close.size()) {
                this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "disconnect other seed when seeding", 6, false);
                ++i;
            }
        }
    }

    private void updateStats() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        ++this.stats_tick_count;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int new_pending_tcp_connections = 0;
        int new_connecting_tcp_connections = 0;
        int new_seeds = 0;
        int new_peers = 0;
        int new_tcp_peers_transfering = 0;
        int new_tcp_incoming = 0;
        int new_udp_incoming = 0;
        int new_utp_incoming = 0;
        int bytes_queued = 0;
        int con_queued = 0;
        int con_blocked = 0;
        int con_unchoked = 0;
        int con_unchoking = 0;
        int out_messages = 0;
        for (PEPeerTransport pc : peer_transports) {
            if (pc.getPeerState() == 30) {
                Connection connection;
                if (pc.isTCP()) {
                    ++new_tcp_peers_transfering;
                }
                if (!pc.isChokedByMe()) {
                    ++con_unchoked;
                    out_messages += pc.getIncomingRequestedPieceNumberCount();
                }
                if (!pc.isChokingMe()) {
                    ++con_unchoking;
                }
                if ((connection = pc.getPluginConnection()) != null) {
                    OutgoingMessageQueue mq = connection.getOutgoingMessageQueue();
                    int q = mq.getDataQueuedBytes() + mq.getProtocolQueuedBytes();
                    bytes_queued += q;
                    if (q > 0) {
                        ++con_queued;
                        if (mq.isBlocked()) {
                            ++con_blocked;
                        }
                    }
                }
                if (pc.isSeed()) {
                    ++new_seeds;
                } else {
                    ++new_peers;
                }
                if (!pc.isIncoming() || pc.isLANLocal()) continue;
                if (pc.isTCP()) {
                    if (pc.getNetwork() != "Public") continue;
                    ++new_tcp_incoming;
                    continue;
                }
                String protocol = pc.getProtocol();
                if (protocol.equals("UDP")) {
                    ++new_udp_incoming;
                    continue;
                }
                ++new_utp_incoming;
                continue;
            }
            if (!pc.isTCP()) continue;
            int c_state = pc.getConnectionState();
            if (c_state == 0) {
                ++new_pending_tcp_connections;
                continue;
            }
            if (c_state != 1) continue;
            ++new_connecting_tcp_connections;
        }
        this._seeds = new_seeds;
        this._peers = new_peers;
        this._tcp_peers_transfering = new_tcp_peers_transfering;
        this._remotesTCPNoLan = new_tcp_incoming;
        this._remotesUDPNoLan = new_udp_incoming;
        this._remotesUTPNoLan = new_utp_incoming;
        this._tcpPendingConnections = new_pending_tcp_connections;
        this._tcpConnectingConnections = new_connecting_tcp_connections;
        this.bytes_queued_for_upload = bytes_queued;
        this.connections_with_queued_data = con_queued;
        this.connections_with_queued_data_blocked = con_blocked;
        this.connections_unchoked = con_unchoked;
        this.connections_unchoking = con_unchoking;
        this.outbound_message_count = out_messages;
        this._stats.update(this.stats_tick_count);
        if (this.global_hide_a_piece_cached != global_hide_a_piece) {
            this.initHiddenPiece();
        }
    }

    @Override
    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.clearRequested(request2.getOffset() / 16384);
        }
    }

    @Override
    public void requestAdded(PEPiece piece, PEPeerTransport peer, DiskManagerReadRequest request2) {
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (PEPeerManagerListener listener : peer_manager_listeners) {
            try {
                listener.requestAdded(this, piece, peer, request2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public PEPeerControl getControl() {
        return this;
    }

    @Override
    public byte[][] getSecrets(int crypto_level) {
        return this.adapter.getSecrets(crypto_level);
    }

    @Override
    public byte[] getHash() {
        return this._hash.getDataID();
    }

    @Override
    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    @Override
    public byte[] getPeerId() {
        return this._myPeerId;
    }

    @Override
    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    @Override
    public void discarded(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.discarded(peer, length);
            if (ban_peer_discard_ratio > 0.0f && !this.piecePicker.isInEndGameMode() && !this.piecePicker.hasEndGameModeBeenAbandoned()) {
                long discarded;
                long received = peer.getStats().getTotalDataBytesReceived();
                long non_discarded = received - (discarded = peer.getStats().getTotalBytesDiscarded());
                if (non_discarded < 0L) {
                    non_discarded = 0L;
                }
                if (discarded >= (long)ban_peer_discard_min_kb * 1024L && (non_discarded == 0L || (float)discarded / (float)non_discarded >= ban_peer_discard_ratio)) {
                    this.badPeerDetected(peer.getIp(), -1, "Discard ratio exceeded (slow peer?)");
                }
            }
        }
    }

    @Override
    public void dataBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesReceived(peer, length);
            this._averageReceptionSpeed.addValue(length);
        }
    }

    @Override
    public void protocolBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesReceived(peer, length);
        }
    }

    @Override
    public void dataBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesSent(peer, length);
        }
    }

    @Override
    public void protocolBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesSent(peer, length);
        }
    }

    @Override
    public void writeCompleted(DiskManagerWriteRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        DiskManagerPiece dm_piece = this.dm_pieces[pieceNumber];
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        if (pePiece == null) {
            pePiece = new PEPieceImpl(this.piecePicker, dm_piece, 0);
        }
        if (!dm_piece.isDone()) {
            Object user_data = request2.getUserData();
            String key = user_data instanceof String ? (String)user_data : (user_data instanceof PEPeer ? ((PEPeer)user_data).getIp() : "<none>");
            pePiece.setWritten(key, request2.getOffset() / 16384);
        }
    }

    @Override
    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
    }

    @Override
    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, Object sender, boolean cancel) {
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (dmPiece.isWritten(blockNumber)) {
            data.returnToPool();
            return;
        }
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.setDownloaded(offset);
        }
        DiskManagerWriteRequest request2 = this.disk_mgr.createWriteRequest(pieceNumber, offset, data, sender);
        this.disk_mgr.enqueueWriteRequest(request2, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(pieceNumber, offset);
        }
        if (cancel || this.piecePicker.isInEndGameMode()) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this.disk_mgr.createReadRequest(pieceNumber, offset, dmPiece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
                ++i;
            }
        }
    }

    @Override
    public boolean isWritten(int piece_number, int offset) {
        return this.dm_pieces[piece_number].isWritten(offset / 16384);
    }

    @Override
    public boolean validateReadRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        if (this.disk_mgr.checkBlockConsistencyForRead(String.valueOf(originator.getClient()) + ": " + originator.getIp(), true, pieceNumber, offset, length)) {
            DiskManagerPiece dm_piece;
            int read_count;
            if (enable_seeding_piece_rechecks && this.isSeeding() && (read_count = (dm_piece = this.dm_pieces[pieceNumber]).getReadCount() & 0xFFFF) < 65525) {
                dm_piece.setReadCount((short)(++read_count));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateHintRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        return this.disk_mgr.checkBlockConsistencyForHint(String.valueOf(originator.getClient()) + ": " + originator.getIp(), pieceNumber, offset, length);
    }

    @Override
    public boolean validatePieceReply(PEPeerTransport originator, int pieceNumber, int offset, DirectByteBuffer data) {
        return this.disk_mgr.checkBlockConsistencyForWrite(String.valueOf(originator.getClient()) + ": " + originator.getIp(), pieceNumber, offset, data);
    }

    @Override
    public int getAvailability(int pieceNumber) {
        return this.piecePicker.getAvailability(pieceNumber);
    }

    @Override
    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this.piecePicker.addHavePiece(pcOrigin, pieceNumber);
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.piecePicker.getAvailability(pieceNumber) - 1) < 4) {
            if (this.dm_pieces[pieceNumber].isDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = peer_transports.size() - 1;
            while (i >= 0) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc != pcOrigin && pc.getPeerState() == 30 && pc.isPieceAvailable(pieceNumber)) {
                    ((PEPeerStatsImpl)pc.getStats()).statisticalSentPiece(pieceLength / availability);
                }
                --i;
            }
        }
    }

    @Override
    public int getPieceLength(int pieceNumber) {
        return this.disk_mgr.getPieceLength(pieceNumber);
    }

    @Override
    public int getNbPeers() {
        return this._peers;
    }

    @Override
    public int getNbSeeds() {
        return this._seeds;
    }

    @Override
    public int getNbRemoteTCPConnections() {
        return this._remotesTCPNoLan;
    }

    @Override
    public int getNbRemoteUDPConnections() {
        return this._remotesUDPNoLan;
    }

    @Override
    public int getNbRemoteUTPConnections() {
        return this._remotesUTPNoLan;
    }

    @Override
    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    @Override
    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    @Override
    public int getNbPeersStalledPendingLoad() {
        int res = 0;
        for (PEPeerTransport transport : this.peer_transports_cow) {
            if (!transport.isStalledPendingLoad()) continue;
            ++res;
        }
        return res;
    }

    @Override
    public long getETA(boolean smoothed) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_eta_calculation || now - this.last_eta_calculation > 900L) {
            long smooth_result;
            long jagged_result;
            long dataRemaining = Math.max(this.nbBytesRemaining, this.disk_mgr.getRemainingExcludingDND());
            if (dataRemaining == 0L) {
                long timeElapsed = (this._timeFinished_mono - this._timeStarted_mono) / 1000L;
                jagged_result = timeElapsed > 1L ? timeElapsed * -1L : 0L;
                smooth_result = jagged_result;
            } else {
                long lETA;
                long averageSpeed = this._averageReceptionSpeed.getAverage();
                long l = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                jagged_result = lETA;
                averageSpeed = this._stats.getSmoothedDataReceiveRate();
                long l2 = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                smooth_result = lETA;
            }
            this.last_eta = jagged_result;
            this.last_eta_smoothed = smooth_result;
            this.last_eta_calculation = now;
        }
        return smoothed ? this.last_eta_smoothed : this.last_eta;
    }

    @Override
    public boolean isRTA() {
        return this.piecePicker.getRTAProviders().size() > 0;
    }

    private void addToPeerTransports(PEPeerTransport peer) {
        List<Object[]> limiters;
        boolean added = false;
        try {
            this.peer_transports_mon.enter();
            if (peer.getPeerState() == 50) {
                return;
            }
            if (this.peer_transports_cow.contains(peer)) {
                Debug.out("Transport added twice");
                return;
            }
            if (this.is_running) {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size() + 1);
                new_peer_transports.addAll(this.peer_transports_cow);
                new_peer_transports.add(peer);
                this.peer_transports_cow = new_peer_transports;
                if (this.upload_diabled) {
                    peer.setUploadDisabled(this.upload_limited_rate_group, true);
                }
                if (this.download_diabled) {
                    peer.setDownloadDisabled(this.download_limited_rate_group, true);
                }
                added = true;
            }
            limiters = this.external_rate_limiters_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (added) {
            long connect_time;
            boolean incoming = peer.isIncoming();
            this._stats.haveNewConnection(incoming);
            if (incoming && (connect_time = SystemTime.getCurrentTime()) > this.last_remote_time) {
                this.last_remote_time = connect_time;
            }
            if (limiters != null) {
                int i = 0;
                while (i < limiters.size()) {
                    Object[] entry = limiters.get(i);
                    peer.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
                    ++i;
                }
            }
            this.peerAdded(peer);
        } else {
            peer.closeConnection("PeerTransport added when manager not running", 2);
        }
    }

    @Override
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList<PEPeerTransport> transports;
        try {
            this.peer_transports_mon.enter();
            ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                new_limiters.addAll(this.external_rate_limiters_cow);
            }
            new_limiters.add(new Object[]{group, upload});
            this.external_rate_limiters_cow = new_limiters;
            transports = this.peer_transports_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        int i = 0;
        while (i < transports.size()) {
            ((PEPeerTransport)transports.get(i)).addRateLimiter(group, upload);
            ++i;
        }
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList<PEPeerTransport> transports;
        try {
            this.peer_transports_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                int i = 0;
                while (i < this.external_rate_limiters_cow.size()) {
                    Object[] entry = this.external_rate_limiters_cow.get(i);
                    if (entry[0] != group) {
                        new_limiters.add(entry);
                    }
                    ++i;
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            transports = this.peer_transports_cow;
        }
        finally {
            this.peer_transports_mon.exit();
        }
        int i = 0;
        while (i < transports.size()) {
            ((PEPeerTransport)transports.get(i)).removeRateLimiter(group, upload);
            ++i;
        }
    }

    @Override
    public int getEffectiveUploadRateLimitBytesPerSecond() {
        return this.adapter.getEffectiveUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.adapter.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.adapter.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed, boolean network_failed) {
        boolean ipv6reconnect;
        boolean tcpReconnect;
        boolean connection_found;
        block30: {
            connection_found = false;
            tcpReconnect = false;
            ipv6reconnect = false;
            try {
                try {
                    String net = peer.getNetwork();
                    String ip = peer.getIp();
                    int tcpPort = peer.getTCPListenPort();
                    int udpPort = peer.getUDPListenPort();
                    this.peer_transports_mon.enter();
                    if (this.is_running) {
                        boolean canTryHolePunch;
                        boolean canTryIpv6;
                        boolean canTryUDP;
                        boolean both_seeds;
                        boolean bl = both_seeds = this.seeding_mode && (peer.isSeed() || peer.isRelativeSeed());
                        if (net == "Public") {
                            canTryUDP = UDPNetworkManager.UDP_OUTGOING_ENABLED && udpPort > 0;
                            canTryIpv6 = network_admin.hasIPV6Potential(true) && peer.getAlternativeIPv6() != null;
                            canTryHolePunch = peer.isTCP() && !both_seeds;
                        } else {
                            canTryUDP = false;
                            canTryIpv6 = false;
                            canTryHolePunch = false;
                        }
                        PeerItem peer_item = peer.getPeerItemIdentity();
                        PeerItem self_item = this.peer_database.getSelfPeer();
                        if (self_item == null || !self_item.equals(peer_item)) {
                            boolean wasIPv6;
                            if (net == "Public") {
                                try {
                                    wasIPv6 = AddressUtils.getByName(ip) instanceof Inet6Address;
                                }
                                catch (UnknownHostException e) {
                                    wasIPv6 = false;
                                    canTryIpv6 = false;
                                }
                            } else {
                                wasIPv6 = false;
                                canTryIpv6 = false;
                            }
                            String keyUDP = String.valueOf(ip) + ":" + udpPort;
                            if (peer.isTCP()) {
                                if (connect_failed) {
                                    if (canTryHolePunch) {
                                        if (canTryUDP && udp_fallback_for_failed_connection) {
                                            this.pending_nat_traversals.put(keyUDP, peer);
                                        } else if (canTryIpv6 && !wasIPv6) {
                                            tcpReconnect = true;
                                            ipv6reconnect = true;
                                        }
                                        if (this._tcp_peers_transfering > 0 && this.isPeerSourceEnabled("HolePunch") && tcpPort > 0) {
                                            String keyTCP = String.valueOf(ip) + ":" + tcpPort;
                                            this.pending_hole_punches.put(keyTCP, new Object[]{ip, tcpPort});
                                        }
                                    }
                                } else if (canTryUDP && udp_fallback_for_dropped_connection && network_failed && this.seeding_mode && peer.isInterested() && !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() > 60L && FeatureAvailability.isUDPPeerReconnectEnabled()) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent((Object)peer, LOGID, 1, "Unexpected stream closure detected, attempting recovery"));
                                    }
                                    this.udp_reconnects.put(keyUDP, peer);
                                } else if (network_failed && peer.isSafeForReconnect() && (!this.seeding_mode || !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() >= 60L) && this.getMaxConnections(net) > 0 && (this.getMaxNewConnectionsAllowed(net) < 0 || this.getMaxNewConnectionsAllowed(net) > this.getMaxConnections(net) / 3) && FeatureAvailability.isGeneralPeerReconnectEnabled()) {
                                    tcpReconnect = true;
                                }
                            } else if (connect_failed && udp_fallback_for_failed_connection && canTryHolePunch && peer.getData(PEER_NAT_TRAVERSE_DONE_KEY) == null) {
                                this.pending_nat_traversals.put(keyUDP, peer);
                            }
                        }
                    }
                    if (this.peer_transports_cow.contains(peer)) {
                        ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow);
                        new_peer_transports.remove(peer);
                        this.peer_transports_cow = new_peer_transports;
                        connection_found = true;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    this.peer_transports_mon.exit();
                    break block30;
                }
            }
            catch (Throwable throwable) {
                this.peer_transports_mon.exit();
                throw throwable;
            }
            this.peer_transports_mon.exit();
        }
        if (connection_found) {
            this.peerRemoved(peer);
        }
        if (tcpReconnect) {
            peer.reconnect(false, ipv6reconnect, null);
        }
    }

    @Override
    public void informFullyConnected(PEPeer peer) {
        this.updateConnectHealth((PEPeerTransport)peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateConnectHealth(PEPeerTransport pc) {
        int state;
        if (pc.isIncoming() || (state = pc.getOutboundConnectionProgress()) == 0) return;
        boolean ok = state == 4;
        String ps = pc.getPeerSource();
        int[] nArray = this.ob_ps_stats;
        synchronized (this.ob_ps_stats) {
            boolean[] stats_history;
            int stats_index;
            if (pc.getUserData(CON_HEALTH_DONE_KEY) != null) return;
            pc.setUserData(CON_HEALTH_DONE_KEY, "");
            if (ps == "Tracker") {
                stats_index = 0;
                stats_history = this.ob_ps_stats_history[0];
            } else if (ps == "DHT") {
                stats_index = 1;
                stats_history = this.ob_ps_stats_history[1];
            } else if (ps == "PeerExchange") {
                stats_index = 2;
                stats_history = this.ob_ps_stats_history[2];
            } else if (ps == "Plugin") {
                stats_index = 3;
                stats_history = this.ob_ps_stats_history[3];
            } else if (ps == "Incoming") {
                stats_index = 4;
                stats_history = this.ob_ps_stats_history[4];
            } else {
                stats_index = 5;
                stats_history = this.ob_ps_stats_history[5];
            }
            int n = stats_index;
            int n2 = this.ob_ps_stats_pos[n];
            this.ob_ps_stats_pos[n] = n2 + 1;
            int pos = n2;
            if (pos < 100) {
                if (ok) {
                    int n3 = stats_index;
                    this.ob_ps_stats[n3] = this.ob_ps_stats[n3] + 1;
                }
                stats_history[pos] = ok;
            } else {
                if (stats_history[pos %= 100]) {
                    if (!ok) {
                        int n4 = stats_index;
                        this.ob_ps_stats[n4] = this.ob_ps_stats[n4] - 1;
                    }
                } else if (ok) {
                    int n5 = stats_index;
                    this.ob_ps_stats[n5] = this.ob_ps_stats[n5] + 1;
                }
                stats_history[pos] = ok;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getConnectHealth(boolean verbose) {
        String str = "";
        int i = 0;
        while (i < this.ob_ps_stats.length) {
            int events;
            String ps = PEPeerSource.PS_SOURCES[i];
            if (ps != "Incoming" && (events = Math.min(this.ob_ps_stats_pos[i], 100)) > 0) {
                str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + ps + "=" + this.ob_ps_stats[i] * 100 / events + "%";
                if (verbose) {
                    str = String.valueOf(str) + " (" + this.ob_ps_stats[i] + "/" + events + ")";
                }
            }
            ++i;
        }
        if (verbose) {
            str = String.valueOf(str) + (str.isEmpty() ? "" : ": ") + "Fail history=" + this.connect_fail_history.size() + ", blocked=" + this.outbound_ignore_addresses.size();
        }
        return str;
    }

    private void peerAdded(PEPeerTransport pc) {
        this.adapter.addPeer(pc);
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (PEPeerManagerListener peer : peer_manager_listeners) {
            peer.peerAdded(this, pc);
        }
    }

    private void peerRemoved(PEPeerTransport pc) {
        int[] reserved_pieces;
        int piece;
        int udp;
        if (this.is_running) {
            this.updateConnectHealth(pc);
        }
        if (this.is_running && !this.seeding_mode && (this.prefer_udp || prefer_udp_default) && (udp = pc.getUDPListenPort()) != 0 && udp == pc.getTCPListenPort()) {
            BloomFilter filter2 = this.prefer_udp_bloom;
            if (filter2 == null) {
                filter2 = this.prefer_udp_bloom = BloomFilterFactory.createAddOnly(10000);
            }
            if (filter2.getEntryCount() < 1000) {
                filter2.add(pc.getIp().getBytes());
            }
        }
        if ((piece = pc.getUniqueAnnounce()) != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        if ((reserved_pieces = pc.getReservedPieceNumbers()) != null) {
            int[] nArray = reserved_pieces;
            int n = reserved_pieces.length;
            int n2 = 0;
            while (n2 < n) {
                String reserved_by;
                int reserved_piece = nArray[n2];
                PEPieceImpl pe_piece = this.pePieces[reserved_piece];
                if (pe_piece != null && (reserved_by = pe_piece.getReservedBy()) != null && reserved_by.equals(pc.getIp())) {
                    pe_piece.setReservedBy(null);
                }
                ++n2;
            }
        }
        if (pc.isSeed()) {
            this.last_seed_disconnect_time = SystemTime.getCurrentTime();
        }
        this.adapter.removePeer(pc);
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (PEPeerManagerListener peer : peer_manager_listeners) {
            peer.peerRemoved(this, pc);
        }
    }

    @Override
    public void addPiece(PEPiece piece, int pieceNumber, PEPeer for_peer) {
        this.addPiece(piece, pieceNumber, false, for_peer);
    }

    protected void addPiece(PEPiece piece, int pieceNumber, boolean force_add, PEPeer for_peer) {
        if (piece == null || this.pePieces[pieceNumber] != null) {
            Debug.out("piece state inconsistent");
        }
        this.pePieces[pieceNumber] = (PEPieceImpl)piece;
        ++this.nbPiecesActive;
        if (this.is_running || force_add) {
            this.adapter.addPiece(piece);
        }
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            try {
                peer_manager_listeners.get(i).pieceAdded(this, piece, for_peer);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void removePiece(PEPiece pePiece, int pieceNumber) {
        if (pePiece != null) {
            this.adapter.removePiece(pePiece);
        } else {
            pePiece = this.pePieces[pieceNumber];
        }
        if (this.pePieces[pieceNumber] != null) {
            this.pePieces[pieceNumber] = null;
            --this.nbPiecesActive;
        }
        if (pePiece == null) {
            return;
        }
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            try {
                peer_manager_listeners.get(i).pieceRemoved(this, pePiece);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public int getNbActivePieces() {
        return this.nbPiecesActive;
    }

    @Override
    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    @Override
    public long getTimeStarted(boolean mono) {
        return mono ? this._timeStarted_mono : this._timeStarted;
    }

    @Override
    public long getTimeStartedSeeding(boolean mono) {
        return mono ? this._timeStartedSeeding_mono : this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        BrokenMd5Hasher md5 = new BrokenMd5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        int i = 0;
        while (i < result.length) {
            result[i] = md5Result.get();
            ++i;
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        String[] writers = piece.getWriters();
        int offset = 0;
        int i = 0;
        while (i < writers.length) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            String peer = writers[i];
            if (peer != null && (buffer = this.disk_mgr.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
            ++i;
        }
    }

    @Override
    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(passed ? 1 : 0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    @Override
    public void checkCancelled(DiskManagerCheckRequest request2) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(2)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    @Override
    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(0)});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    @Override
    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this.pePieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    private void processPieceCheckResult(DiskManagerCheckRequest request2, int outcome) {
        block48: {
            int check_type = (Integer)request2.getUserData();
            try {
                int pieceNumber = request2.getPieceNumber();
                if (check_type == 2) {
                    if (outcome == 0) {
                        Debug.out(String.valueOf(this.getDisplayName()) + ": Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                        if (!this.restart_initiated) {
                            this.restart_initiated = true;
                            this.adapter.restartDownload(true);
                        }
                    }
                    return;
                }
                if (check_type == 4 || check_type == 5) {
                    if (outcome == 0) {
                        if (check_type == 4) {
                            Debug.out(String.valueOf(this.getDisplayName()) + "Piece #" + pieceNumber + " failed recheck while seeding. Re-downloading...");
                        } else {
                            Debug.out(String.valueOf(this.getDisplayName()) + "Piece #" + pieceNumber + " failed recheck after being reported as bad. Re-downloading...");
                        }
                        Logger.log(new LogAlert((Object)this, true, 3, "Download '" + this.getDisplayName() + "': piece " + pieceNumber + " has been corrupted, re-downloading"));
                        if (!this.restart_initiated) {
                            this.restart_initiated = true;
                            this.adapter.restartDownload(true);
                        }
                    }
                    return;
                }
                PEPieceImpl pePiece = this.pePieces[pieceNumber];
                if (outcome == 1 || this.is_metadata_download) {
                    try {
                        if (pePiece != null) {
                            List list;
                            if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                                this.MD5CheckPiece(pePiece, true);
                            }
                            if ((list = pePiece.getPieceWrites()).size() > 0) {
                                int i = 0;
                                while (i < pePiece.getNbBlocks()) {
                                    List listPerBlock = pePiece.getPieceWrites(i);
                                    byte[] correctHash = null;
                                    for (PEPieceWriteImpl write : listPerBlock) {
                                        if (!write.isCorrect()) continue;
                                        correctHash = write.getHash();
                                    }
                                    if (correctHash != null) {
                                        for (PEPieceWriteImpl write : listPerBlock) {
                                            if (Arrays.equals(write.getHash(), correctHash)) continue;
                                            this.badPeerDetected(write.getSender(), pieceNumber, "Hash check failed (block)");
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }
                        break block48;
                    }
                    finally {
                        this.removePiece(pePiece, pieceNumber);
                        this.sendHave(pieceNumber);
                    }
                }
                if (outcome == 0) {
                    Iterator<PEPeerManagerListener> it = this.peer_manager_listeners_cow.iterator();
                    while (it.hasNext()) {
                        try {
                            it.next().pieceCorrupted(this, pieceNumber);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (pePiece != null) {
                        try {
                            this.MD5CheckPiece(pePiece, false);
                            String[] writers = pePiece.getWriters();
                            ArrayList<String> uniqueWriters = new ArrayList<String>();
                            int[] writesPerWriter = new int[writers.length];
                            int i = 0;
                            while (i < writers.length) {
                                String writer = writers[i];
                                if (writer != null) {
                                    int writerId = uniqueWriters.indexOf(writer);
                                    if (writerId == -1) {
                                        uniqueWriters.add(writer);
                                        writerId = uniqueWriters.size() - 1;
                                    }
                                    int n = writerId;
                                    writesPerWriter[n] = writesPerWriter[n] + 1;
                                }
                                ++i;
                            }
                            int nbWriters = uniqueWriters.size();
                            if (nbWriters == 1) {
                                String bad_ip = (String)uniqueWriters.get(0);
                                PEPeerTransport bad_peer = this.getTransportFromAddress(bad_ip);
                                if (bad_peer != null) {
                                    bad_peer.sendBadPiece(pieceNumber);
                                }
                                this.badPeerDetected(bad_ip, pieceNumber, "Hash fail (piece)");
                                pePiece.reset();
                            } else if (nbWriters > 1) {
                                int maxWrites = 0;
                                String bestWriter = null;
                                PEPeer bestWriter_transport = null;
                                int i2 = 0;
                                while (i2 < uniqueWriters.size()) {
                                    String writer;
                                    PEPeerTransport pt;
                                    int writes = writesPerWriter[i2];
                                    if (writes > maxWrites && (pt = this.getTransportFromAddress(writer = (String)uniqueWriters.get(i2))) != null && pt.getReservedPieceNumbers() == null && !ip_filter.isInRange(writer, this.getDisplayName(), this.getTorrentHash())) {
                                        bestWriter = writer;
                                        maxWrites = writes;
                                        bestWriter_transport = pt;
                                    }
                                    ++i2;
                                }
                                if (bestWriter != null) {
                                    pePiece.setReservedBy(bestWriter);
                                    bestWriter_transport.addReservedPieceNumber(pePiece.getPieceNumber());
                                    pePiece.setRequestable();
                                    i2 = 0;
                                    while (i2 < pePiece.getNbBlocks()) {
                                        if (writers[i2] == null || !writers[i2].equals(bestWriter)) {
                                            pePiece.reDownloadBlock(i2);
                                        }
                                        ++i2;
                                    }
                                } else {
                                    pePiece.reset();
                                }
                            } else {
                                pePiece.reset();
                            }
                            this.piecePicker.addEndGameChunks(pePiece);
                            this._stats.hashFailed(pePiece.getLength());
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            pePiece.reset();
                        }
                    } else {
                        this.dm_pieces[pieceNumber].reset();
                    }
                }
            }
            finally {
                if (check_type == 3) {
                    this.rescan_piece_time = SystemTime.getCurrentTime();
                }
                if (!this.seeding_mode) {
                    this.checkFinished(false);
                }
            }
        }
    }

    private void badPeerDetected(String ip, int piece_number, String reason) {
        int ps;
        boolean hash_fail = piece_number >= 0;
        PEPeerTransport peer = this.getTransportFromAddress(ip);
        if (hash_fail && peer != null) {
            Iterator<PEPeerManagerListener> it = this.peer_manager_listeners_cow.iterator();
            while (it.hasNext()) {
                try {
                    it.next().peerSentBadData(this, peer, piece_number);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        IpFilterManager filter_manager = IpFilterManagerFactory.getSingleton();
        int nbWarnings = filter_manager.getBadIps().addWarningForIp(ip);
        boolean disconnect_peer = false;
        if (nbWarnings > 2) {
            if (COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
                if (ip_filter.ban(ip, String.valueOf(this.getDisplayName()) + ": " + reason, false)) {
                    this.checkForBannedConnections();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)peer, LOGID, 3, String.valueOf(ip) + " : has been banned and won't be able " + "to connect until you restart"));
                }
                disconnect_peer = true;
            }
        } else if (!hash_fail) {
            disconnect_peer = true;
        }
        if (disconnect_peer && peer != null && (ps = peer.getPeerState()) != 40 && ps != 50) {
            this.closeAndRemovePeer(peer, "has sent too many " + (hash_fail ? "bad pieces" : "discarded blocks") + ", " + 2 + " max.", 286, true);
        }
    }

    @Override
    public int getNbPieces() {
        return this._nbPieces;
    }

    @Override
    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    @Override
    public PEPiece getPiece(int pieceNumber) {
        return this.pePieces[pieceNumber];
    }

    @Override
    public PEPeerStats createPeerStats(PEPeer owner) {
        return new PEPeerStatsImpl(owner);
    }

    @Override
    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this.disk_mgr.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public boolean requestExists(String peer_ip, int piece_number, int offset, int length) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        DiskManagerReadRequest request2 = null;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (conn.getIp().equals(peer_ip)) {
                if (request2 == null) {
                    request2 = this.createDiskManagerRequest(piece_number, offset, length);
                }
                if (conn.getRequestIndex(request2) != -1) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean seedPieceRecheck() {
        DiskManagerPiece dm_piece;
        if (!enable_seeding_piece_rechecks && !this.isSeeding()) {
            return false;
        }
        int max_reads = 0;
        int max_reads_index = 0;
        int i = 0;
        while (i < this.dm_pieces.length) {
            DiskManagerPiece dm_piece2 = this.dm_pieces[i];
            if (dm_piece2.isDone()) {
                int num = dm_piece2.getReadCount() & 0xFFFF;
                if (num > 65526) {
                    if (--num == 65526) {
                        num = 0;
                    }
                    dm_piece2.setReadCount((short)num);
                } else if (num > max_reads) {
                    max_reads = num;
                    max_reads_index = i;
                }
            }
            ++i;
        }
        if (max_reads > 0 && max_reads >= (dm_piece = this.dm_pieces[max_reads_index]).getNbBlocks() * 3) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(max_reads_index, new Integer(4));
            req.setAdHoc(true);
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rechecking piece " + max_reads_index + " while seeding as most active"));
            }
            this.disk_mgr.enqueueCheckRequest(req, this);
            dm_piece.setReadCount((short)-1);
            int i2 = 0;
            while (i2 < this.dm_pieces.length) {
                int num;
                if (i2 != max_reads_index && (num = this.dm_pieces[i2].getReadCount() & 0xFFFF) < 65526) {
                    this.dm_pieces[i2].setReadCount((short)0);
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            peer_manager_listeners.addAll(this.peer_manager_listeners_cow);
            peer_manager_listeners.add(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow);
            peer_manager_listeners.remove(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            ArrayList<PEPeerTransport> to_close = null;
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            String name = this.getDisplayName();
            byte[] hash = this.getTorrentHash();
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (ip_filter.isInRange(conn.getIp(), name, hash)) {
                    if (to_close == null) {
                        to_close = new ArrayList<PEPeerTransport>();
                    }
                    to_close.add(conn);
                }
                ++i;
            }
            if (to_close != null) {
                i = 0;
                while (i < to_close.size()) {
                    this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "IPFilter banned IP address", 5, true);
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean isSeeding() {
        return this.seeding_mode;
    }

    @Override
    public boolean isMetadataDownload() {
        return this.is_metadata_download;
    }

    @Override
    public int getTorrentInfoDictSize() {
        return this.metadata_infodict_size;
    }

    @Override
    public void setTorrentInfoDictSize(int size) {
        this.metadata_infodict_size = size;
    }

    @Override
    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    @Override
    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    @Override
    public boolean canToggleSuperSeedMode() {
        if (this.superSeedMode) {
            return true;
        }
        return this.superSeedPieces == null && this.getRemaining() == 0L;
    }

    @Override
    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode == this.superSeedMode) {
            return;
        }
        boolean kick_peers = false;
        if (_superSeedMode) {
            if (this.superSeedPieces == null && this.getRemaining() == 0L) {
                this.superSeedMode = true;
                this.initialiseSuperSeedMode();
                kick_peers = true;
            }
        } else {
            this.superSeedMode = false;
            kick_peers = true;
        }
        if (kick_peers) {
            ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                this.closeAndRemovePeer(conn, "Turning on super-seeding", 0, false);
                ++i;
            }
        }
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        int i = 0;
        while (i < this._nbPieces) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
            ++i;
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        int i = 0;
        while (i < this.superSeedPieces.length) {
            this.superSeedPieces[i].updateTime();
            ++i;
        }
        int nbUnchoke = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator iter1 = peer_transports.iterator();
        while (iter1.hasNext()) {
            sortedPeers.add(new SuperSeedPeer((PEPeerTransport)iter1.next()));
        }
        Collections.sort(sortedPeers);
        Iterator iter2 = sortedPeers.iterator();
        while (iter2.hasNext()) {
            PEPeerTransport peer = ((SuperSeedPeer)iter2.next()).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getPeerState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null || selectedPeer.getPeerState() >= 40) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        SuperSeedPiece piece = null;
        boolean loopdone = false;
        while ((piece = this.superSeedPieces[this.superSeedModeCurrentPiece]).getLevel() > 0 || this.superSeedModeCurrentPiece == this.hidden_piece) {
            piece = null;
            ++this.superSeedModeCurrentPiece;
            if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
            this.superSeedModeCurrentPiece = 0;
            if (loopdone) {
                this.superSeedMode = false;
                this.closeAndRemoveAllPeers("quiting SuperSeed mode", 0, true);
                return;
            }
            loopdone = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.isPieceAvailable(piece.getPieceNumber())) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        selectedPeer.sendHave(piece.getPieceNumber());
    }

    @Override
    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[pieceNumber].peerHasPiece(null);
        if (peer.getUniqueAnnounce() == pieceNumber) {
            peer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    @Override
    public boolean isPrivateTorrent() {
        return this.is_private_torrent;
    }

    @Override
    public int getExtendedMessagingMode() {
        return this.adapter.getExtendedMessagingMode();
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    @Override
    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    @Override
    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    @Override
    public Object getData(String key) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                return null;
            }
            Object object = this.user_data.get(key);
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap<Object, Object>();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getConnectTimeout(int ct_def) {
        int max;
        int lower_limit;
        if (ct_def <= 0) {
            return ct_def;
        }
        if (this.seeding_mode) {
            return ct_def;
        }
        int max_sim_con = TCPConnectionManager.MAX_SIMULTANEOUS_CONNECT_ATTEMPTS;
        if (max_sim_con >= 50) {
            return ct_def;
        }
        int connected = this._seeds + this._peers;
        int connecting = this._tcpConnectingConnections;
        int queued = this._tcpPendingConnections;
        int not_yet_connected = this.peer_database.getDiscoveredPeerCount();
        int potential = connecting + queued + not_yet_connected;
        if (potential <= (lower_limit = (max = this.getMaxConnections("")) / 4) || max == lower_limit) {
            return ct_def;
        }
        int MIN_CT = 7500;
        if (potential >= max) {
            return 7500;
        }
        int pos = potential - lower_limit;
        int scale = max - lower_limit;
        int res = 7500 + (ct_def - 7500) * (scale - pos) / scale;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectionChecks() {
        long last_update;
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        boolean has_ipv6 = false;
        boolean has_ipv4 = false;
        boolean can_ipv6 = network_admin.hasIPV6Potential(true);
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int[] allowed_info;
            int allowed_base;
            this.upload_limited_rate_group.getRateLimitBytesPerSecond();
            this.download_limited_rate_group.getRateLimitBytesPerSecond();
            int num_waiting_establishments = 0;
            int udp_connections = 0;
            for (PEPeerTransport transport : peer_transports) {
                int state = transport.getConnectionState();
                if (state == 0 || state == 1) {
                    ++num_waiting_establishments;
                } else if (can_ipv6 && transport.getNetwork() == "Public") {
                    boolean is_ipv6 = transport.getIp().contains(":");
                    if (is_ipv6) {
                        has_ipv6 = true;
                    } else {
                        has_ipv4 = true;
                    }
                }
                if (transport.isTCP()) continue;
                ++udp_connections;
            }
            int[] allowed_seeds_info = this.getMaxSeedConnections();
            int base_allowed_seeds = allowed_seeds_info[0];
            if (base_allowed_seeds > 0) {
                int extra_seeds = allowed_seeds_info[1];
                int to_disconnect = this._seeds - base_allowed_seeds;
                if (to_disconnect > 0) {
                    HashSet<PEPeerTransport> to_retain = new HashSet<PEPeerTransport>();
                    if (extra_seeds > 0) {
                        for (PEPeerTransport transport : peer_transports) {
                            if (!transport.isSeed() || transport.getNetwork() == "Public") continue;
                            to_retain.add(transport);
                            if (to_retain.size() == extra_seeds) break;
                        }
                        to_disconnect -= to_retain.size();
                    }
                    int i = peer_transports.size() - 1;
                    while (i >= 0 && to_disconnect > 0) {
                        PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                        if (transport.isSeed() && !to_retain.contains(transport)) {
                            this.closeAndRemovePeer(transport, "Too many seeds", 15, false);
                            --to_disconnect;
                        }
                        --i;
                    }
                }
            }
            if ((allowed_base = (allowed_info = this.getMaxNewConnectionsAllowed())[0]) < 0 || allowed_base > 1000) {
                allowed_info[0] = allowed_base = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                int free = this.getMaxConnections()[0] / 20;
                allowed_info[0] = allowed_base -= free;
            }
            int i = 0;
            while (i < allowed_info.length) {
                int allowed = allowed_info[i];
                if (allowed > 0) {
                    int wanted = TCPConnectionManager.MAX_SIMULTANEOUS_CONNECT_ATTEMPTS - num_waiting_establishments;
                    if (wanted > allowed) {
                        num_waiting_establishments += wanted - allowed;
                    }
                    int remaining = allowed;
                    int tcp_remaining = TCPNetworkManager.getSingleton().getConnectDisconnectManager().getMaxOutboundPermitted();
                    int udp_remaining = UDPNetworkManager.getSingleton().getConnectionManager().getMaxOutboundPermitted();
                    while (num_waiting_establishments < TCPConnectionManager.MAX_SIMULTANEOUS_CONNECT_ATTEMPTS && (tcp_remaining > 0 || udp_remaining > 0)) {
                        boolean udp_ok;
                        boolean prefer_udp_overall;
                        PeerItem item;
                        if (!this.is_running || (item = this.peer_database.getNextOptimisticConnectPeer(i == 1)) == null || !this.is_running) break;
                        PeerItem self = this.peer_database.getSelfPeer();
                        if (self != null && self.equals(item) || this.isAlreadyConnected(item)) continue;
                        String source = PeerItem.convertSourceString(item.getSource());
                        boolean use_crypto = item.getHandshakeType() == 1;
                        int tcp_port = item.getTCPPort();
                        int udp_port = item.getUDPPort();
                        if (udp_port == 0 && udp_probe_enabled) {
                            udp_port = tcp_port;
                        }
                        boolean bl = prefer_udp_overall = this.prefer_udp || prefer_udp_default;
                        if (prefer_udp_overall && udp_port == 0) {
                            byte[] address = item.getIP().getBytes();
                            BloomFilter bloom = this.prefer_udp_bloom;
                            if (bloom != null && bloom.contains(address)) {
                                udp_port = tcp_port;
                            }
                        }
                        boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0 && tcp_remaining > 0;
                        boolean bl2 = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0 && udp_remaining > 0;
                        if (!(!tcp_ok || prefer_udp_overall && udp_ok)) {
                            if (this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, true, use_crypto, item.getCryptoLevel(), null) != null) continue;
                            --tcp_remaining;
                            ++num_waiting_establishments;
                            --remaining;
                            continue;
                        }
                        if (!udp_ok || this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, false, use_crypto, item.getCryptoLevel(), null) != null) continue;
                        --udp_remaining;
                        ++num_waiting_establishments;
                        --remaining;
                    }
                    if (i == 0) {
                        if (UDPNetworkManager.UDP_OUTGOING_ENABLED && remaining > 0 && udp_remaining > 0 && udp_connections < 16) {
                            this.doUDPConnectionChecks(remaining);
                        }
                        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L && TCPNetworkManager.TCP_OUTGOING_ENABLED && remaining > 0 && tcp_remaining > 0) {
                            this.doTCPConnectionChecks(remaining);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
            boolean do_dup_con_checks = dual_ipv4_ipv6_connection_action != 0 && this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && this.seeding_mode && has_ipv4 && has_ipv6 && !this.superSeedMode;
            long piece_length = this.disk_mgr.getPieceLength();
            int DUP_CHECK_MIN_PIECES = 10;
            int min_done = Math.max(1, (int)(piece_length * 10L * 1000L / this.disk_mgr.getTotalLength()));
            ArrayList<PEPeerTransport> interesting_peers = new ArrayList<PEPeerTransport>(peer_transports.size());
            for (PEPeerTransport transport : peer_transports) {
                int done;
                if (transport.doTimeoutChecks()) continue;
                transport.doKeepAliveCheck();
                transport.doPerformanceTuningCheck();
                if (!do_dup_con_checks || transport.getNetwork() != "Public" || (done = transport.getPercentDoneInThousandNotation()) >= 1000 || done <= min_done) continue;
                interesting_peers.add(transport);
            }
            if (interesting_peers.size() > 1) {
                Collections.sort(interesting_peers, new Comparator<PEPeerTransport>(){

                    @Override
                    public int compare(PEPeerTransport p1, PEPeerTransport p2) {
                        return p1.getPercentDoneInThousandNotation() - p2.getPercentDoneInThousandNotation();
                    }
                });
                int DUP_CHECK_TOLERANCE = Math.max(1, min_done / 2);
                ArrayList<PEPeerTransport> to_ban = new ArrayList<PEPeerTransport>();
                int i = 0;
                while (i < interesting_peers.size()) {
                    PEPeerTransport peer1 = (PEPeerTransport)interesting_peers.get(i);
                    int p1_done = peer1.getPercentDoneInThousandNotation();
                    boolean p1_ipv6 = peer1.getIp().contains(":");
                    int j = i + 1;
                    while (j < interesting_peers.size()) {
                        boolean p2_ipv6;
                        PEPeerTransport peer2 = (PEPeerTransport)interesting_peers.get(j);
                        int p2_done = peer2.getPercentDoneInThousandNotation();
                        if (Math.abs(p2_done - p1_done) > DUP_CHECK_TOLERANCE) break;
                        BitFlags f1 = peer1.getAvailable();
                        BitFlags f2 = peer2.getAvailable();
                        if (f1 != null && f2 != null && p1_ipv6 != (p2_ipv6 = peer2.getIp().contains(":"))) {
                            PEPeerTransport[] peers;
                            String cc_match = null;
                            PEPeerTransport[] pEPeerTransportArray = peers = new PEPeerTransport[]{peer1, peer2};
                            int n = peers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PEPeerTransport peer = pEPeerTransportArray[n2];
                                String[] details = (String[])peer.getUserData(DUP_PEER_CC_KEY);
                                if (details == null) {
                                    try {
                                        details = PeerUtils.getCountryDetails(peer);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    if (details == null) {
                                        details = new String[]{};
                                    }
                                    peer.setUserData(DUP_PEER_CC_KEY, details);
                                }
                                if (details.length <= 0) {
                                    cc_match = null;
                                    break;
                                }
                                String cc = details[0];
                                if (cc_match == null) {
                                    cc_match = cc;
                                } else if (!cc.equals(cc_match)) {
                                    cc_match = null;
                                }
                                ++n2;
                            }
                            if (cc_match != null) {
                                boolean[] b1 = f1.flags;
                                boolean[] b2 = f2.flags;
                                int same_pieces = 0;
                                int k = 0;
                                while (k < b1.length) {
                                    if (b1[k] && b2[k]) {
                                        ++same_pieces;
                                    }
                                    ++k;
                                }
                                int max_pieces = Math.max(f1.nbSet, f2.nbSet);
                                if (same_pieces >= 10 && max_pieces >= same_pieces && same_pieces * 100 / max_pieces >= 95) {
                                    String[] ass = new String[2];
                                    int hits = 0;
                                    PEPeerTransport[] pEPeerTransportArray2 = peers;
                                    int n3 = peers.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        final PEPeerTransport peer = pEPeerTransportArray2[n4];
                                        String as = (String)peer.getUserData(DUP_PEER_AS_KEY);
                                        if (as == null) {
                                            peer.setUserData(DUP_PEER_AS_KEY, "");
                                            try {
                                                network_admin.lookupASN(HostNameToIPResolver.syncResolve(peer.getIp()), new NetworkAdminASNListener(){

                                                    @Override
                                                    public void success(NetworkAdminASN asn) {
                                                        peer.setUserData(DUP_PEER_AS_KEY, asn.getAS());
                                                    }

                                                    @Override
                                                    public void failed(NetworkAdminException error) {
                                                    }
                                                });
                                            }
                                            catch (Throwable throwable) {}
                                        } else if (!as.isEmpty()) {
                                            ass[hits++] = as;
                                        }
                                        ++n4;
                                    }
                                    if (hits == 2 && ass[0].equals(ass[1])) {
                                        PEPeerTransport peer_to_ban = dual_ipv4_ipv6_connection_action == 1 ? (p1_ipv6 ? peer2 : peer1) : (p1_ipv6 ? peer1 : peer2);
                                        to_ban.add(peer_to_ban);
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                for (PEPeerTransport peer : to_ban) {
                    String msg = "Duplicate IPv4 and IPv6 connection detected";
                    ip_filter.ban(peer.getIp(), String.valueOf(this.getDisplayName()) + ": " + msg, false);
                    this.closeAndRemovePeer(peer, msg, 1, true);
                }
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L) {
            this.optimisticDisconnectCount = 0;
            int[] allowed = this.getMaxNewConnectionsAllowed();
            if (allowed[0] + allowed[1] == 0) {
                this.doOptimisticDisconnect(false, false, "");
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int goal;
            float percentage = ((float)(this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL) + 1.0f) / (1.0f * (float)MAINLOOP_SIXTY_SECOND_INTERVAL);
            if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
                goal = 0;
                ArrayList<PEPeerTransport> transferring = new ArrayList<PEPeerTransport>(peer_transports.size());
                for (PEPeerTransport transport : peer_transports) {
                    if (transport.getPeerState() != 30) continue;
                    transferring.add(transport);
                }
                this.sweepList = transferring;
            } else {
                goal = (int)Math.floor(percentage * (float)this.sweepList.size());
            }
            int i = this.nextPEXSweepIndex;
            while (i < goal && i < this.sweepList.size()) {
                PEPeerTransport peer = this.sweepList.get(i);
                peer.updatePeerExchange();
                ++i;
            }
            this.nextPEXSweepIndex = goal;
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            this.hp_bloom = null;
            long now = SystemTime.getMonotonousTime();
            Map<PeerCacheKey, Integer> i = this.outbound_ignore_addresses;
            synchronized (i) {
                Iterator<Long> it = this.connect_fail_history.values().iterator();
                while (it.hasNext()) {
                    long t = it.next();
                    if (now - t <= 180000L) continue;
                    it.remove();
                }
            }
            if (peer_transports.size() > 1) {
                HashMap<String, ArrayList<PEPeerTransport>> peer_map = new HashMap<String, ArrayList<PEPeerTransport>>();
                for (PEPeerTransport peer : peer_transports) {
                    if (peer.isIncoming() || peer.getPeerState() != 10 || peer.getConnectionState() != 1 || peer.getLastMessageSentTimeMono() < 0L) continue;
                    String key = String.valueOf(peer.getIp()) + ":" + peer.getPort();
                    ArrayList<PEPeerTransport> list = (ArrayList<PEPeerTransport>)peer_map.get(key);
                    if (list == null) {
                        list = new ArrayList<PEPeerTransport>(1);
                        peer_map.put(key, list);
                    }
                    list.add(peer);
                }
                for (List list : peer_map.values()) {
                    if (list.size() < 2) continue;
                    long newest_time_mono = Long.MIN_VALUE;
                    PEPeerTransport newest_peer = null;
                    for (PEPeerTransport peer : list) {
                        long last_sent_mono = peer.getLastMessageSentTimeMono();
                        if (last_sent_mono <= newest_time_mono) continue;
                        newest_time_mono = last_sent_mono;
                        newest_peer = peer;
                    }
                    for (PEPeerTransport peer : list) {
                        if (peer == newest_peer || peer.getPeerState() != 10 || peer.getConnectionState() != 1) continue;
                        this.closeAndRemovePeer(peer, "Removing old duplicate connection", 1, false);
                    }
                }
            }
        }
    }

    @Override
    public boolean isHolePunchOperationOK(PEPeerTransport peer, boolean is_connect) {
        BloomFilter bf = this.hp_bloom;
        if (bf == null) {
            bf = this.hp_bloom = BloomFilterFactory.createAddRemove4Bit(512);
        }
        return bf.add(peer.getIp().getBytes()) <= (is_connect ? 3 : 5);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTCPConnectionChecks(int number) {
        try {
            block13: {
                Iterator<Object[]> it;
                int to_do;
                int a_pos;
                ArrayList<PEPeerTransport> available;
                block12: {
                    this.peer_transports_mon.enter();
                    if (this.pending_hole_punches.size() == 0) {
                        return;
                    }
                    available = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size());
                    for (PEPeerTransport peer : this.peer_transports_cow) {
                        if (!peer.canSendHolePunch()) continue;
                        available.add(peer);
                    }
                    if (available.isEmpty()) {
                        return;
                    }
                    Collections.shuffle(available);
                    a_pos = 0;
                    to_do = Math.min(number, this.seeding_mode ? 2 : 5);
                    it = this.pending_hole_punches.values().iterator();
                    if (!true) break block12;
                    if (!it.hasNext()) return;
                    if (a_pos >= available.size()) return;
                    if (to_do <= 0) break block13;
                }
                do {
                    Object[] entry = it.next();
                    it.remove();
                    String ip = (String)entry[0];
                    int port = (Integer)entry[1];
                    PEPeerTransport peer = (PEPeerTransport)available.get(a_pos++);
                    try {
                        peer.sendHolePunch(InetAddress.getByName(ip), port);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    --to_do;
                    if (!it.hasNext()) return;
                    if (a_pos >= available.size()) return;
                } while (to_do > 0);
            }
            return;
        }
        finally {
            this.peer_transports_mon.exit();
        }
    }

    /*
     * Exception decompiling
     */
    private void doUDPConnectionChecks(int number) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean doOptimisticDisconnect(boolean pending_lan_local_peer, boolean force, String network) {
        int maxOptimistics;
        long medianConnectionTime;
        int non_pub_extra;
        if (network != "I2P") {
            int[] max_con = this.getMaxConnections();
            non_pub_extra = max_con[1];
        } else {
            non_pub_extra = 0;
        }
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        PEPeerTransport max_transport = null;
        PEPeerTransport max_seed_transport = null;
        PEPeerTransport max_non_lan_transport = null;
        PEPeerTransport max_pub_transport = null;
        PEPeerTransport max_pub_seed_transport = null;
        PEPeerTransport max_pub_non_lan_transport = null;
        long max_time = 0L;
        long max_seed_time = 0L;
        long max_non_lan_time = 0L;
        long max_pub_time = 0L;
        long max_pub_seed_time = 0L;
        long max_pub_non_lan_time = 0L;
        int non_pub_found = 0;
        ArrayList<Long> activeConnectionTimes = new ArrayList<Long>(peer_transports.size());
        int lan_peer_count = 0;
        long mono_now = SystemTime.getMonotonousTime();
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getConnectionState() == 4) {
                boolean count_pubs;
                long timeConnected = peer.getConnectionEstablishedMonoTime();
                long timeSinceConnection = timeConnected < 0L ? 0L : mono_now - timeConnected;
                long timeSinceSentData = peer.getTimeSinceLastDataMessageSent();
                activeConnectionTimes.add(timeSinceConnection);
                long peerTestTime = 0L;
                if (this.seeding_mode) {
                    if (timeSinceSentData != -1L) {
                        peerTestTime = timeSinceSentData;
                    }
                } else {
                    long timeSinceGoodData = peer.getTimeSinceGoodDataReceived();
                    peerTestTime = timeSinceGoodData == -1L ? (peerTestTime += timeSinceConnection) : (peerTestTime += timeSinceGoodData);
                    if (!peer.isInteresting()) {
                        peerTestTime = !peer.isInterested() ? (peerTestTime += timeSinceConnection + timeSinceSentData) : (peerTestTime += timeSinceConnection - timeSinceSentData);
                        peerTestTime *= 2L;
                    }
                    peerTestTime += peer.getSnubbedTime();
                }
                if (!peer.isIncoming()) {
                    peerTestTime *= 2L;
                }
                boolean bl = count_pubs = non_pub_extra > 0 && peer.getNetwork() == "Public";
                if (peer.isLANLocal()) {
                    ++lan_peer_count;
                } else {
                    if (peerTestTime > max_non_lan_time) {
                        max_non_lan_time = peerTestTime;
                        max_non_lan_transport = peer;
                    }
                    if (count_pubs && peerTestTime > max_pub_non_lan_time) {
                        max_pub_non_lan_time = peerTestTime;
                        max_pub_non_lan_transport = peer;
                    }
                }
                if (!this.seeding_mode) {
                    PEPeerStats pestats;
                    peerTestTime += peer.getSnubbedTime();
                    if (peer.getSnubbedTime() > 120L) {
                        peerTestTime = (long)((double)peerTestTime * 1.5);
                    }
                    if ((pestats = peer.getStats()).getTotalDataBytesReceived() + pestats.getTotalDataBytesSent() > 524288L) {
                        boolean goodPeer = true;
                        if (peer.isSnubbed() && pestats.getTotalDataBytesReceived() < pestats.getTotalDataBytesSent()) {
                            peerTestTime = (long)((double)peerTestTime * 1.5);
                            goodPeer = false;
                        }
                        if (pestats.getTotalDataBytesSent() > pestats.getTotalDataBytesReceived() * 10L) {
                            peerTestTime *= 2L;
                            goodPeer = false;
                        }
                        if (pestats.getTotalDataBytesReceived() > 0L && pestats.getTotalBytesDiscarded() > 0L) {
                            peerTestTime = (long)((double)peerTestTime * (1.0 + (double)pestats.getTotalBytesDiscarded() / (double)pestats.getTotalDataBytesReceived()));
                        }
                        if (goodPeer) {
                            peerTestTime = (long)((double)peerTestTime * 0.7);
                        }
                    }
                }
                if (peerTestTime > max_time) {
                    max_time = peerTestTime;
                    max_transport = peer;
                }
                if (count_pubs) {
                    if (peerTestTime > max_pub_time) {
                        max_pub_time = peerTestTime;
                        max_pub_transport = peer;
                    }
                } else {
                    ++non_pub_found;
                }
                if (peer.isSeed() || peer.isRelativeSeed()) {
                    if (peerTestTime > max_seed_time) {
                        max_seed_time = peerTestTime;
                        max_seed_transport = peer;
                    }
                    if (count_pubs && peerTestTime > max_pub_seed_time) {
                        max_pub_seed_time = peerTestTime;
                        max_pub_seed_transport = peer;
                    }
                }
            }
            ++i;
        }
        if (non_pub_extra > 0 && non_pub_found <= non_pub_extra) {
            if (max_transport != null && max_transport.getNetwork() != "Public") {
                max_time = max_pub_time;
                max_transport = max_pub_transport;
            }
            if (max_seed_transport != null && max_seed_transport.getNetwork() != "Public") {
                max_seed_time = max_pub_seed_time;
                max_seed_transport = max_pub_seed_transport;
            }
            if (max_non_lan_transport != null && max_non_lan_transport.getNetwork() != "Public") {
                max_non_lan_time = max_pub_non_lan_time;
                max_non_lan_transport = max_pub_non_lan_transport;
            }
        }
        if (activeConnectionTimes.size() > 0) {
            Collections.sort(activeConnectionTimes);
            medianConnectionTime = (Long)activeConnectionTimes.get(activeConnectionTimes.size() / 2);
        } else {
            medianConnectionTime = 0L;
        }
        int max_con = this.getMaxConnections(network);
        int n = maxOptimistics = max_con == 0 ? 8 : Math.max(max_con / 30, 2);
        if (!pending_lan_local_peer && !force && this.optimisticDisconnectCount >= maxOptimistics && medianConnectionTime < 300000L) {
            return false;
        }
        if (max_transport != null) {
            int LAN_PEER_MAX = 4;
            if (max_transport.isLANLocal() && lan_peer_count < 4 && max_non_lan_transport != null) {
                max_transport = max_non_lan_transport;
                max_time = max_non_lan_time;
            }
            if (this.getMaxSeedConnections(network) > 0 && max_seed_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_seed_transport, "timed out by doOptimisticDisconnect()", 14, true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (max_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_transport, "timed out by doOptimisticDisconnect()", 14, true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (pending_lan_local_peer && lan_peer_count < 4) {
                this.closeAndRemovePeer(max_transport, "making space for LAN peer in doOptimisticDisconnect()", 14, true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (force) {
                this.closeAndRemovePeer(max_transport, "force removal of worst peer in doOptimisticDisconnect()", 14, true);
                return true;
            }
        } else if (force && peer_transports.size() > 0) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(new Random().nextInt(peer_transports.size()));
            this.closeAndRemovePeer(pt, "force removal of random peer in doOptimisticDisconnect()", 14, true);
            return true;
        }
        return false;
    }

    @Override
    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport base_peer) {
        if (base_peer.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(base_peer.getIp(), base_peer.getTCPListenPort(), (byte)2, base_peer.getPeerItemIdentity().getHandshakeType(), base_peer.getUDPListenPort(), (byte)1, 0);
            return this.peer_database.registerPeerConnection(peer, new PeerExchangerItem.Helper(){

                @Override
                public boolean isSeed() {
                    return base_peer.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peer_id) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getPeerItemIdentity().equals(peer_id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void peerVerifiedAsSelf(PEPeerTransport self) {
        if (self.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(self.getIp(), self.getTCPListenPort(), PeerItem.convertSourceID(self.getPeerSource()), self.getPeerItemIdentity().getHandshakeType(), self.getUDPListenPort(), (byte)2, 0);
            this.peer_database.setSelfPeer(peer);
        }
    }

    @Override
    public void IPFilterEnabledChanged(boolean is_enabled) {
        if (is_enabled) {
            this.checkForBannedConnections();
        }
    }

    @Override
    public boolean canIPBeBanned(String ip) {
        return true;
    }

    @Override
    public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
        return true;
    }

    @Override
    public void IPBlockedListChanged(IpFilter filter2) {
        Iterator<PEPeerTransport> it = this.peer_transports_cow.iterator();
        String name = this.getDisplayName();
        byte[] hash = this.getTorrentHash();
        while (it.hasNext()) {
            try {
                PEPeerTransport peer = it.next();
                if (!filter2.isInRange(peer.getIp(), name, hash)) continue;
                peer.closeConnection("IP address blocked by filters", 5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void IPBanned(BannedIp ip) {
        int i = 0;
        while (i < this._nbPieces) {
            if (this.pePieces[i] != null) {
                this.pePieces[i].reDownloadBlocks(ip.getIp());
            }
            ++i;
        }
    }

    private boolean disconnectSeedsWhenSeeding() {
        if (this.hidden_piece < 0) {
            return global_disconnect_seeds_when_seeding;
        }
        return global_hide_a_piece_ds;
    }

    private void initHiddenPiece() {
        this.global_hide_a_piece_cached = global_hide_a_piece;
        int new_hp = (this.local_hide_a_piece_opt == null ? this.global_hide_a_piece_cached : this.local_hide_a_piece_opt != false) ? (this.hidden_piece == -1 ? (int)(Math.abs(this.adapter.getRandomSeed()) % (long)this._nbPieces) : this.hidden_piece) : -1;
        if (new_hp != this.hidden_piece) {
            this.hidden_piece = new_hp;
            this.removeAllPeers("Hidden piece changed", 0);
        }
    }

    @Override
    public void setMaskDownloadCompletion(Boolean mask) {
        if (mask == null && this.local_hide_a_piece_opt == null) {
            return;
        }
        if (mask != null && this.local_hide_a_piece_opt != null && mask == this.local_hide_a_piece_opt) {
            return;
        }
        this.local_hide_a_piece_opt = mask;
        this.initHiddenPiece();
    }

    @Override
    public long getHiddenBytes() {
        if (this.hidden_piece < 0) {
            return 0L;
        }
        return this.dm_pieces[this.hidden_piece].getLength();
    }

    @Override
    public int getHiddenPiece() {
        return this.hidden_piece;
    }

    @Override
    public int getUploadPriority() {
        return this.adapter.getUploadPriority();
    }

    @Override
    public int getAverageCompletionInThousandNotation() {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        long total = this.disk_mgr.getTotalLength();
        int my_completion = total == 0L ? 1000 : (int)(1000L * (total - this.disk_mgr.getRemainingExcludingDND()) / total);
        int sum = my_completion == 1000 ? 0 : my_completion;
        int num = my_completion == 1000 ? 0 : 1;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeer peer = peer_transports.get(i);
            if (peer.getPeerState() == 30 && !peer.isSeed()) {
                ++num;
                sum += peer.getPercentDoneInThousandNotation();
            }
            ++i;
        }
        return num > 0 ? sum / num : 0;
    }

    @Override
    public int getMaxCompletionInThousandNotation(boolean never_include_seeds) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int max = 0;
        boolean ignore_seeds = this.isSeeding() || never_include_seeds;
        int i = 0;
        while (i < peer_transports.size()) {
            int done;
            PEPeer peer = peer_transports.get(i);
            if (!(peer.getPeerState() != 30 || (done = peer.getPercentDoneInThousandNotation()) == 1000 && ignore_seeds || done <= max)) {
                max = done;
            }
            ++i;
        }
        return max;
    }

    @Override
    public int[] getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    private int getMaxConnections(String net) {
        int[] data = this.getMaxConnections();
        int result = data[0];
        if (result > 0 && net != "Public") {
            result += data[1];
        }
        return result;
    }

    public int[] getMaxSeedConnections() {
        return this.adapter.getMaxSeedConnections();
    }

    private int getMaxSeedConnections(String net) {
        int[] data = this.getMaxSeedConnections();
        int result = data[0];
        if (result > 0 && net != "Public") {
            result += data[1];
        }
        return result;
    }

    @Override
    public int getMaxNewConnectionsAllowed(String network) {
        int[] max_con = this.getMaxConnections();
        int dl_max = max_con[0];
        if (network != "Public") {
            dl_max += max_con[1];
        }
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max);
        return allowed_peers;
    }

    private int[] getMaxNewConnectionsAllowed() {
        int[] max_con = this.getMaxConnections();
        int dl_max = max_con[0];
        int extra = max_con[1];
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max + extra);
        if (allowed_peers >= 0 && (allowed_peers -= extra) < 0) {
            if ((extra += allowed_peers) < 0) {
                extra = 0;
            }
            allowed_peers = 0;
        }
        return new int[]{allowed_peers, extra};
    }

    @Override
    public int[] getPeerCount() {
        return new int[]{this._peers + this._seeds, this.peer_transports_cow.size()};
    }

    @Override
    public int[] getPieceCount() {
        return new int[]{this.nbPiecesActive, this.outbound_message_count};
    }

    @Override
    public int getSchedulePriority() {
        return this.isSeeding() ? Integer.MAX_VALUE : this.adapter.getPosition();
    }

    @Override
    public boolean hasPotentialConnections() {
        return this.pending_nat_traversals.size() + this.pending_hole_punches.size() + this.peer_database.getDiscoveredPeerCount() > 0;
    }

    @Override
    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    @Override
    public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (Arrays.equals(peer_id, conn.getId())) {
                return conn;
            }
            ++i;
        }
        return null;
    }

    @Override
    public PEPeerTransport getTransportFromAddress(String peer) {
        ArrayList<PEPeerTransport> peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(i);
            if (peer.equals(pt.getIp())) {
                return pt;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void incNbPeersSnubbed() {
        ++this.nbPeersSnubbed;
    }

    @Override
    public void decNbPeersSnubbed() {
        --this.nbPeersSnubbed;
    }

    @Override
    public void setNbPeersSnubbed(int n) {
        this.nbPeersSnubbed = n;
    }

    @Override
    public int getNbPeersSnubbed() {
        return this.nbPeersSnubbed;
    }

    @Override
    public boolean getPreferUDP() {
        return this.prefer_udp;
    }

    @Override
    public void setPreferUDP(boolean prefer) {
        this.prefer_udp = prefer;
    }

    @Override
    public boolean isPeerSourceEnabled(String peer_source) {
        return this.adapter.isPeerSourceEnabled(peer_source);
    }

    @Override
    public boolean isNetworkEnabled(String net) {
        return this.adapter.isNetworkEnabled(net);
    }

    @Override
    public void peerDiscovered(PEPeerTransport finder, PeerItem pi) {
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        int i = 0;
        while (i < peer_manager_listeners.size()) {
            try {
                peer_manager_listeners.get(i).peerDiscovered(this, pi, finder);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            @Override
            public int getType() {
                return 5;
            }

            @Override
            public int getStatus() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? 5 : 1;
            }

            @Override
            public String getName() {
                return MessageText.getString("tps.pex.details", new String[]{String.valueOf(PEPeerControlImpl.this.peer_transports_cow.size()), String.valueOf(PEPeerControlImpl.this.peer_database.getExchangedPeerCount()), String.valueOf(PEPeerControlImpl.this.peer_database.getDiscoveredPeerCount())});
            }

            @Override
            public int getPeers() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? PEPeerControlImpl.this.peer_database.getExchangedPeersUsed() : -1;
            }
        };
    }

    private void checkAutoSequentialFiles(DiskManagerFileInfo done_file) {
        int seq_info;
        boolean was_active = false;
        if (this.asfe_activated && done_file != null && (seq_info = this.piecePicker.getSequentialInfo()) > 0 && done_file.getFirstPieceNumber() == seq_info - 1) {
            was_active = true;
        }
        Set<String> asfe = auto_sequential_file_exts;
        boolean set_seq = false;
        if (!asfe.isEmpty()) {
            DiskManagerFileInfo[] files;
            DiskManagerFileInfo[] diskManagerFileInfoArray = files = this.disk_mgr.getFileSet().getFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                if (!file.isSkipped() && file.getDownloaded() != file.getLength()) {
                    String e = file.getExtension();
                    if (asfe.contains(e = e.toLowerCase(Locale.US))) {
                        this.piecePicker.setSequentialAscendingFrom(file.getFirstPieceNumber());
                        set_seq = true;
                        this.asfe_activated = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        if (was_active && !set_seq) {
            this.piecePicker.clearSequential();
            this.asfe_activated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFilePriorityChanged() {
        Map<PeerCacheKey, Integer> map = this.outbound_ignore_addresses;
        synchronized (map) {
            Iterator<Integer> it = this.outbound_ignore_addresses.values().iterator();
            while (it.hasNext()) {
                int rc = it.next();
                if (rc != 7 && rc != 6) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCloseReason(PEPeerTransport peer, boolean reason_outgoing, int reason) {
        NetworkConnectionBase connection;
        if ((reason == 6 || reason == 7 || !reason_outgoing && reason == 5 || !reason_outgoing && reason == 4 || reason_outgoing && reason == 258 || reason == 1000000) && (connection = peer.getNetworkConnection()) != null) {
            InetSocketAddress address = connection.getEndpoint().getNotionalAddress();
            PeerCacheKey key = address.isUnresolved() ? new PeerNonPublicCacheKey(address.getHostName()) : new PeerResolvedCacheKey(address.getAddress().getAddress(), peer.getTCPListenPort());
            if (reason == 1000000) {
                Map<PeerCacheKey, Integer> map = this.outbound_ignore_addresses;
                synchronized (map) {
                    this.connect_fail_history.put(key, SystemTime.getMonotonousTime());
                }
            }
            InetAddress ipv6 = peer.getAlternativeIPv6();
            Map<PeerCacheKey, Integer> map = this.outbound_ignore_addresses;
            synchronized (map) {
                Integer i_rc = reason;
                this.outbound_ignore_addresses.put(key, i_rc);
                if (ipv6 != null) {
                    key = new PeerResolvedCacheKey(ipv6.getAddress(), peer.getTCPListenPort());
                    PeerResolvedCacheKey keyv6 = key;
                    this.outbound_ignore_addresses.put(keyv6, i_rc);
                }
            }
        }
    }

    @Override
    public PEPeerControlHashHandler getHashHandler() {
        return this.hash_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateEvidence(IndentWriter writer) {
        Map<PeerCacheKey, Integer> ad2;
        writer.println("PeerManager: seeding=" + this.seeding_mode);
        writer.println("    udp_fb=" + this.pending_nat_traversals.size() + ",udp_tc=" + this.udp_traversal_count + ",pd=[" + this.peer_database.getString() + "]");
        String pending_udp = "";
        try {
            this.peer_transports_mon.enter();
            for (PEPeerTransport peer : this.pending_nat_traversals.values()) {
                pending_udp = String.valueOf(pending_udp) + (pending_udp.length() == 0 ? "" : ",") + peer.getPeerItemIdentity().getAddressString() + ":" + peer.getPeerItemIdentity().getUDPPort();
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (pending_udp.length() > 0) {
            writer.println("    pending_udp=" + pending_udp);
        }
        List traversals = PeerNATTraverser.getSingleton().getTraversals(this);
        String active_udp = "";
        for (Map<PeerCacheKey, Integer> ad2 : traversals) {
            active_udp = String.valueOf(active_udp) + (active_udp.length() == 0 ? "" : ",") + AddressUtils.getHostAddress((InetSocketAddress)((Object)ad2)) + ":" + ((InetSocketAddress)((Object)ad2)).getPort();
        }
        if (active_udp.length() > 0) {
            writer.println("    active_udp=" + active_udp);
        }
        writer.println("    tcp_hp=" + this.pending_hole_punches.size());
        ad2 = this.outbound_ignore_addresses;
        synchronized (ad2) {
            writer.println("  Outbound Ignores: " + this.outbound_ignore_addresses.size());
            try {
                writer.indent();
                for (Map.Entry<PeerCacheKey, Integer> entry : this.outbound_ignore_addresses.entrySet()) {
                    writer.println(String.valueOf(entry.getKey().getString()) + " - " + entry.getValue());
                }
            }
            finally {
                writer.exdent();
            }
        }
        ad2 = this.outbound_ignore_addresses;
        synchronized (ad2) {
            writer.println("  Connect Fails: " + this.connect_fail_history.size());
            long now = SystemTime.getMonotonousTime();
            try {
                writer.indent();
                for (Map.Entry<PeerCacheKey, Long> entry : this.connect_fail_history.entrySet()) {
                    writer.println(String.valueOf(entry.getKey().getString()) + " - " + (now - entry.getValue()));
                }
            }
            finally {
                writer.exdent();
            }
        }
        if (!this.seeding_mode) {
            int i;
            int num;
            String str;
            writer.println("  Active Pieces");
            int num_active = 0;
            try {
                writer.indent();
                str = "";
                num = 0;
                i = 0;
                while (i < this.pePieces.length) {
                    PEPieceImpl piece = this.pePieces[i];
                    if (piece != null) {
                        ++num_active;
                        str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString() + ": " + piece.getString();
                        if (++num == 20) {
                            writer.println(str);
                            str = "";
                            num = 0;
                        }
                    }
                    ++i;
                }
                if (num > 0) {
                    writer.println(str);
                }
            }
            finally {
                writer.exdent();
            }
            if (num_active == 0) {
                writer.println("  Inactive Pieces (excluding done/skipped)");
                try {
                    writer.indent();
                    str = "";
                    num = 0;
                    i = 0;
                    while (i < this.dm_pieces.length) {
                        DiskManagerPiece dm_piece = this.dm_pieces[i];
                        if (dm_piece.isInteresting()) {
                            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString();
                            if (++num == 20) {
                                writer.println(str);
                                str = "";
                                num = 0;
                            }
                        }
                        ++i;
                    }
                    if (num > 0) {
                        writer.println(str);
                    }
                }
                finally {
                    writer.exdent();
                }
            }
            this.piecePicker.generateEvidence(writer);
        }
        try {
            this.peer_transports_mon.enter();
            writer.println("Peers: total = " + this.peer_transports_cow.size());
            writer.indent();
            try {
                writer.indent();
                for (PEPeerTransport peer : this.peer_transports_cow) {
                    peer.generateEvidence(writer);
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            this.peer_transports_mon.exit();
            writer.exdent();
        }
        this.disk_mgr.generateEvidence(writer);
    }

    private class MyPeer
    implements PEPeer {
        private final Map<Object, Object> user_data = new HashMap<Object, Object>();
        private final PEPeerStats stats;
        private volatile long last_active;
        private volatile int incoming_request_count;
        private volatile int outgoing_request_count;
        private volatile int[] incoming_requested_pieces;
        private volatile int[] outgoing_requested_pieces;

        private MyPeer() {
            this.stats = new MyPeerStats(this);
            this.incoming_requested_pieces = new int[0];
            this.outgoing_requested_pieces = new int[0];
        }

        private void update() {
            if (this.last_active == 0L) {
                return;
            }
            long now = SystemTime.getMonotonousTime();
            if (now - this.last_active > 10000L) {
                this.last_active = 0L;
                return;
            }
            int in_req = 0;
            int out_req = 0;
            HashSet<Integer> in_pieces = new HashSet<Integer>();
            HashSet<Integer> out_pieces = new HashSet<Integer>();
            for (PEPeerTransport peer : PEPeerControlImpl.this.peer_transports_cow) {
                int p;
                int[] pieces;
                in_req += peer.getIncomingRequestCount();
                out_req += peer.getOutgoingRequestCount();
                int[] nArray = pieces = peer.getIncomingRequestedPieceNumbers();
                int n = pieces.length;
                int n2 = 0;
                while (n2 < n) {
                    p = nArray[n2];
                    in_pieces.add(p);
                    ++n2;
                }
                nArray = pieces = peer.getOutgoingRequestedPieceNumbers();
                n = pieces.length;
                n2 = 0;
                while (n2 < n) {
                    p = nArray[n2];
                    out_pieces.add(p);
                    ++n2;
                }
            }
            int[] temp = new int[in_pieces.size()];
            int pos = 0;
            for (Integer i : in_pieces) {
                temp[pos++] = i;
            }
            this.incoming_requested_pieces = temp;
            temp = new int[out_pieces.size()];
            pos = 0;
            for (Integer i : out_pieces) {
                temp[pos++] = i;
            }
            this.outgoing_requested_pieces = temp;
            this.incoming_request_count = in_req;
            this.outgoing_request_count = out_req;
        }

        private void setActive() {
            long now = SystemTime.getMonotonousTime();
            if (this.last_active == 0L) {
                this.last_active = now;
                this.update();
            } else {
                this.last_active = now;
            }
        }

        @Override
        public boolean isMyPeer() {
            return true;
        }

        @Override
        public void addListener(PEPeerListener listener) {
        }

        @Override
        public void removeListener(PEPeerListener listener) {
        }

        @Override
        public int getPeerState() {
            return 30;
        }

        @Override
        public PEPeerManager getManager() {
            return PEPeerControlImpl.this;
        }

        @Override
        public String getPeerSource() {
            return "local";
        }

        @Override
        public byte[] getId() {
            return PEPeerControlImpl.this._myPeerId;
        }

        @Override
        public String getIp() {
            String[] nets = PEPeerControlImpl.this.adapter.getEnabledNetworks();
            String result = "";
            String[] stringArray = nets;
            int n = nets.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress ia;
                String net = stringArray[n2];
                String str = "";
                str = net == "Public" ? ((ia = NetworkAdmin.getSingleton().getDefaultPublicAddress()) == null ? "127.0.0.1" : ia.getHostAddress()) : (net == "I2P" ? "i2p" : "tor");
                result = result.isEmpty() ? str : String.valueOf(result) + "; " + str;
                ++n2;
            }
            return result;
        }

        @Override
        public InetAddress getAlternativeIPv6() {
            return null;
        }

        @Override
        public int getPort() {
            return PEPeerControlImpl.this.getTCPListeningPortNumber();
        }

        @Override
        public String getIPHostName() {
            return "";
        }

        @Override
        public int getTCPListenPort() {
            return PEPeerControlImpl.this.getTCPListeningPortNumber();
        }

        @Override
        public int getUDPListenPort() {
            return UDPNetworkManager.getSingleton().getUDPListeningPortNumber();
        }

        @Override
        public int getUDPNonDataListenPort() {
            return UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        }

        @Override
        public BitFlags getAvailable() {
            return PEPeerControlImpl.this.disk_mgr.getAvailability();
        }

        @Override
        public boolean isPieceAvailable(int pieceNumber) {
            return PEPeerControlImpl.this.disk_mgr.isDone(pieceNumber);
        }

        @Override
        public boolean transferAvailable() {
            return true;
        }

        @Override
        public void setSnubbed(boolean b) {
        }

        @Override
        public boolean isChokingMe() {
            return false;
        }

        @Override
        public boolean isUnchokeOverride() {
            return false;
        }

        @Override
        public boolean isChokedByMe() {
            return false;
        }

        @Override
        public void sendChoke() {
        }

        @Override
        public void sendUnChoke() {
        }

        @Override
        public boolean isInteresting() {
            return false;
        }

        @Override
        public boolean isInterested() {
            return false;
        }

        @Override
        public boolean isDownloadPossible() {
            return true;
        }

        @Override
        public boolean isSeed() {
            return PEPeerControlImpl.this.isSeeding();
        }

        @Override
        public boolean isRelativeSeed() {
            return this.isSeed();
        }

        @Override
        public boolean isSnubbed() {
            return false;
        }

        @Override
        public long getSnubbedTime() {
            return 0L;
        }

        @Override
        public PEPeerStats getStats() {
            return this.stats;
        }

        @Override
        public boolean isIncoming() {
            return false;
        }

        @Override
        public boolean hasReceivedBitField() {
            return true;
        }

        @Override
        public int getPercentDoneInThousandNotation() {
            long total = PEPeerControlImpl.this.disk_mgr.getTotalLength();
            long rem = PEPeerControlImpl.this.disk_mgr.getRemaining();
            return (int)((total - rem) * 1000L / total);
        }

        @Override
        public String getClient() {
            return String.valueOf(MessageText.getString("label.local.peer")) + " - " + Constants.APP_NAME;
        }

        @Override
        public boolean isOptimisticUnchoke() {
            return false;
        }

        @Override
        public void setOptimisticUnchoke(boolean is_optimistic) {
        }

        @Override
        public void setUploadHint(int timeToSpread) {
        }

        @Override
        public int getUploadHint() {
            return -1;
        }

        @Override
        public void setUniqueAnnounce(int uniquePieceNumber) {
        }

        @Override
        public int getUniqueAnnounce() {
            return -1;
        }

        @Override
        public int getConsecutiveNoRequestCount() {
            return 0;
        }

        @Override
        public void setConsecutiveNoRequestCount(int num) {
        }

        @Override
        public void setUploadRateLimitBytesPerSecond(int bytes) {
            PEPeerControlImpl.this.adapter.setUploadRateLimitBytesPerSecond(bytes);
        }

        @Override
        public void setDownloadRateLimitBytesPerSecond(int bytes) {
            PEPeerControlImpl.this.adapter.setDownloadRateLimitBytesPerSecond(bytes);
        }

        @Override
        public int getUploadRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }

        @Override
        public int getDownloadRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }

        @Override
        public void addRateLimiter(LimitedRateGroup limiter, boolean upload) {
        }

        @Override
        public LimitedRateGroup[] getRateLimiters(boolean upload) {
            return new LimitedRateGroup[0];
        }

        @Override
        public void removeRateLimiter(LimitedRateGroup limiter, boolean upload) {
        }

        @Override
        public void setUploadDisabled(Object key, boolean disabled) {
        }

        @Override
        public void setDownloadDisabled(Object key, boolean disabled) {
        }

        @Override
        public boolean isUploadDisabled() {
            return false;
        }

        @Override
        public boolean isDownloadDisabled() {
            return false;
        }

        @Override
        public void updateAutoUploadPriority(Object key, boolean inc) {
        }

        @Override
        public Object getData(String key) {
            return this.getUserData(key);
        }

        @Override
        public void setData(String key, Object value) {
            this.setUserData(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getUserData(Object key) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                return this.user_data.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUserData(Object key, Object value) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                this.user_data.put(key, value);
            }
        }

        @Override
        public NetworkConnectionBase getNetworkConnection() {
            return null;
        }

        @Override
        public Connection getPluginConnection() {
            return null;
        }

        @Override
        public boolean supportsMessaging() {
            return true;
        }

        @Override
        public int getMessagingMode() {
            return 2;
        }

        @Override
        public String getEncryption() {
            return "";
        }

        @Override
        public String getProtocol() {
            return "";
        }

        @Override
        public String getProtocolQualifier() {
            return null;
        }

        @Override
        public Message[] getSupportedMessages() {
            return null;
        }

        @Override
        public void addReservedPieceNumber(int pieceNumber) {
        }

        @Override
        public void removeReservedPieceNumber(int pieceNumber) {
        }

        @Override
        public int[] getReservedPieceNumbers() {
            return new int[0];
        }

        @Override
        public int getIncomingRequestCount() {
            this.setActive();
            return this.incoming_request_count;
        }

        @Override
        public int getOutgoingRequestCount() {
            this.setActive();
            return this.outgoing_request_count;
        }

        @Override
        public int[] getIncomingRequestedPieceNumbers() {
            this.setActive();
            return this.incoming_requested_pieces;
        }

        @Override
        public int[] getOutgoingRequestedPieceNumbers() {
            this.setActive();
            return this.outgoing_requested_pieces;
        }

        @Override
        public int[] getCurrentIncomingRequestProgress() {
            return null;
        }

        @Override
        public int[] getCurrentOutgoingRequestProgress() {
            return null;
        }

        @Override
        public long getBytesRemaining() {
            return PEPeerControlImpl.this.disk_mgr.getRemaining();
        }

        @Override
        public void setSuspendedLazyBitFieldEnabled(boolean enable) {
        }

        @Override
        public long getConnectionEstablishedMonoTime() {
            return PEPeerControlImpl.this._timeStarted_mono;
        }

        @Override
        public void setLastPiece(int i) {
        }

        @Override
        public int getLastPiece() {
            return -1;
        }

        @Override
        public boolean isLANLocal() {
            return true;
        }

        @Override
        public void resetLANLocalStatus() {
        }

        @Override
        public boolean sendRequestHint(int piece_number, int offset, int length, int life) {
            return false;
        }

        @Override
        public int[] getRequestHint() {
            return null;
        }

        @Override
        public void clearRequestHint() {
        }

        @Override
        public void sendStatsRequest(Map request2) {
        }

        @Override
        public void sendRejectRequest(DiskManagerReadRequest request2) {
        }

        @Override
        public void setHaveAggregationEnabled(boolean enabled) {
        }

        @Override
        public byte[] getHandshakeReservedBytes() {
            return BTHandshake.AZ_RESERVED;
        }

        @Override
        public String getClientNameFromPeerID() {
            return this.getClient();
        }

        @Override
        public String getClientNameFromExtensionHandshake() {
            return this.getClient();
        }

        @Override
        public boolean isPriorityConnection() {
            return false;
        }

        @Override
        public void setPriorityConnection(boolean is_priority) {
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public int getTaggableType() {
            return 4;
        }

        @Override
        public String getTaggableID() {
            return null;
        }

        @Override
        public String getTaggableName() {
            return this.getIp();
        }

        @Override
        public TaggableResolver getTaggableResolver() {
            return null;
        }

        @Override
        public Object getTaggableTransientProperty(String key) {
            return null;
        }

        @Override
        public void setTaggableTransientProperty(String key, Object value) {
        }
    }

    private class MyPeerStats
    implements PEPeerStats {
        private final PEPeer peer;

        private MyPeerStats(PEPeer _peer) {
            this.peer = _peer;
        }

        @Override
        public PEPeer getPeer() {
            return this.peer;
        }

        @Override
        public void setPeer(PEPeer p) {
        }

        @Override
        public void dataBytesSent(int num_bytes) {
        }

        @Override
        public void protocolBytesSent(int num_bytes) {
        }

        @Override
        public void dataBytesReceived(int num_bytes) {
        }

        @Override
        public void protocolBytesReceived(int num_bytes) {
        }

        @Override
        public void bytesDiscarded(int num_bytes) {
        }

        @Override
        public void hasNewPiece(int piece_size) {
        }

        @Override
        public void statisticalSentPiece(int piece_size) {
        }

        @Override
        public long getDataReceiveRate() {
            return PEPeerControlImpl.this._stats.getDataReceiveRate();
        }

        @Override
        public long getProtocolReceiveRate() {
            return PEPeerControlImpl.this._stats.getProtocolReceiveRate();
        }

        @Override
        public long getTotalDataBytesReceived() {
            return PEPeerControlImpl.this._stats.getTotalDataBytesReceived();
        }

        @Override
        public long getTotalProtocolBytesReceived() {
            return PEPeerControlImpl.this._stats.getTotalProtocolBytesReceived();
        }

        @Override
        public long getDataSendRate() {
            return PEPeerControlImpl.this._stats.getDataSendRate();
        }

        @Override
        public long getProtocolSendRate() {
            return PEPeerControlImpl.this._stats.getProtocolSendRate();
        }

        @Override
        public long getTotalDataBytesSent() {
            return PEPeerControlImpl.this._stats.getTotalDataBytesSent();
        }

        @Override
        public long getTotalProtocolBytesSent() {
            return PEPeerControlImpl.this._stats.getTotalProtocolBytesSent();
        }

        @Override
        public long getSmoothDataReceiveRate() {
            return PEPeerControlImpl.this._stats.getSmoothedDataReceiveRate();
        }

        @Override
        public long getTotalBytesDiscarded() {
            return PEPeerControlImpl.this._stats.getTotalDiscarded();
        }

        @Override
        public long getEstimatedDownloadRateOfPeer() {
            return this.getDataReceiveRate() + this.getProtocolReceiveRate();
        }

        @Override
        public long getEstimatedUploadRateOfPeer() {
            return this.getDataSendRate() + this.getProtocolSendRate();
        }

        @Override
        public long getEstimatedSecondsToCompletion() {
            return PEPeerControlImpl.this.getETA(true);
        }

        @Override
        public long getTotalBytesDownloadedByPeer() {
            return PEPeerControlImpl.this._stats.getTotalDataBytesReceived() + PEPeerControlImpl.this._stats.getTotalProtocolBytesReceived();
        }

        @Override
        public void diskReadComplete(long bytes) {
        }

        @Override
        public int getTotalDiskReadCount() {
            return 0;
        }

        @Override
        public int getAggregatedDiskReadCount() {
            return 0;
        }

        @Override
        public long getTotalDiskReadBytes() {
            return 0L;
        }

        @Override
        public void setUploadRateLimitBytesPerSecond(int bytes) {
            this.peer.setUploadRateLimitBytesPerSecond(bytes);
        }

        @Override
        public void setDownloadRateLimitBytesPerSecond(int bytes) {
            this.peer.setDownloadRateLimitBytesPerSecond(bytes);
        }

        @Override
        public int getUploadRateLimitBytesPerSecond() {
            return this.peer.getUploadRateLimitBytesPerSecond();
        }

        @Override
        public int getDownloadRateLimitBytesPerSecond() {
            return this.peer.getDownloadRateLimitBytesPerSecond();
        }

        @Override
        public int getPermittedBytesToSend() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void permittedSendBytesUsed(int num) {
        }

        @Override
        public int getPermittedBytesToReceive() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void permittedReceiveBytesUsed(int num) {
        }
    }

    static interface PeerCacheKey {
        public String getString();
    }

    static class PeerNonPublicCacheKey
    implements PeerCacheKey {
        final String key;

        PeerNonPublicCacheKey(String address) {
            this.key = address.length() > 16 ? new String(address.substring(0, 16)) : address;
        }

        @Override
        public String getString() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PeerNonPublicCacheKey) {
                return this.key.equals(((PeerNonPublicCacheKey)obj).key);
            }
            return false;
        }
    }

    static class PeerResolvedCacheKey
    extends HashWrapper
    implements PeerCacheKey {
        PeerResolvedCacheKey(byte[] bytes, int port) {
            super(PeerResolvedCacheKey.addPort(bytes, port));
        }

        @Override
        public String getString() {
            byte[] bytes = this.getBytes();
            int len = bytes.length;
            byte[] address = new byte[len - 2];
            System.arraycopy(bytes, 0, address, 0, address.length);
            try {
                InetAddress ia = InetAddress.getByAddress(address);
                int port = bytes[len - 2] << 8 & 0xFF00 | bytes[len - 1] & 0xFF;
                return String.valueOf(ia.getHostAddress()) + ":" + port;
            }
            catch (Throwable e) {
                return ByteFormatter.encodeString(bytes);
            }
        }

        static byte[] addPort(byte[] address, int port) {
            int len = address.length;
            byte[] temp = new byte[len + 2];
            System.arraycopy(address, 0, temp, 0, len);
            temp[len] = (byte)(port >> 8);
            temp[len + 1] = (byte)port;
            return temp;
        }
    }

    static class PeerUnresolvedCacheKey
    implements PeerCacheKey {
        final String key;

        PeerUnresolvedCacheKey(String address, int port) {
            this.key = String.valueOf(address) + ":" + port;
        }

        @Override
        public String getString() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PeerUnresolvedCacheKey) {
                return this.key.equals(((PeerUnresolvedCacheKey)obj).key);
            }
            return false;
        }
    }
}

