/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.pairing.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.pairing.PairedNode;
import com.biglybt.core.pairing.PairedService;
import com.biglybt.core.pairing.PairedServiceRequestHandler;
import com.biglybt.core.pairing.PairingConnectionData;
import com.biglybt.core.pairing.PairingException;
import com.biglybt.core.pairing.PairingManager;
import com.biglybt.core.pairing.PairingManagerListener;
import com.biglybt.core.pairing.PairingTest;
import com.biglybt.core.pairing.PairingTestListener;
import com.biglybt.core.pairing.impl.PairingManagerTunnelHandler;
import com.biglybt.core.security.CryptoManager;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AEVerifier;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.core.versioncheck.VersionCheckClientListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.clientid.ClientIDException;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.InfoParameter;
import com.biglybt.pif.ui.config.LabelParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterGroup;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import com.biglybt.util.JSONUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class PairingManagerImpl
implements PairingManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean DEBUG = false;
    private final String DEFAULT_SERVICE_URL;
    private final URL DEFAULT_WEB_REMOTE_URL;
    private final String DEFAULT_TUNNEL_SERVER;
    private String _SERVICE_URL;
    private URL _WEB_REMOTE_URL;
    private String _TUNNEL_SERVER;
    private static final PairingManagerImpl singleton = new PairingManagerImpl();
    private static final int GLOBAL_UPDATE_PERIOD = 60000;
    private static final int CD_REFRESH_PERIOD = 82800000;
    private static final int CD_REFRESH_TICKS = 1380;
    private static final int CONNECT_TEST_PERIOD_MILLIS = 1800000;
    private Core core;
    final BooleanParameter param_enable;
    private final InfoParameter param_ac_info;
    private final InfoParameter param_status_info;
    private final InfoParameter param_last_error;
    private final HyperlinkParameter param_view;
    final BooleanParameter param_srp_enable;
    private final LabelParameter param_srp_state;
    private final BooleanParameter param_e_enable;
    private final StringParameter param_public_ipv4;
    private final StringParameter param_public_ipv6;
    private final StringParameter param_host;
    private final BooleanParameter param_net_enable;
    private final StringParameter param_local_ipv4;
    private final StringParameter param_local_ipv6;
    private final BooleanParameter param_icon_enable;
    private final Map<String, PairedServiceImpl> services;
    private final AESemaphore init_sem;
    private TimerEventPeriodic global_update_event;
    private InetAddress current_v4;
    private InetAddress current_v6;
    private String local_v4;
    private String local_v6;
    private Set<InetAddress> ignored_v4;
    private Set<InetAddress> ignored_v6;
    private PairingManagerTunnelHandler tunnel_handler;
    private boolean update_outstanding;
    private boolean updates_enabled;
    private static final int MIN_UPDATE_PERIOD_DEFAULT = 10000;
    private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
    private int min_update_period;
    private int max_update_period;
    private final AsyncDispatcher dispatcher;
    private boolean must_update_once;
    private boolean update_in_progress;
    private TimerEvent deferred_update_event;
    private long last_update_time;
    private int consec_update_fails;
    private long qr_version;
    private String last_message;
    final Map<String, Object[]> local_address_checks;
    private final CopyOnWriteList<PairingManagerListener> listeners;
    private UIAdapter ui;
    private int tests_in_progress;

    public static PairingManager getSingleton() {
        return singleton;
    }

    protected PairingManagerImpl() {
        String pairing_host22 = "pair.biglybt.com";
        this._SERVICE_URL = "https://" + pairing_host22 + "/pairing";
        String wr_host = "remote.biglybt.com";
        URL wr_url = null;
        try {
            wr_url = new URL("http://" + wr_host + "/");
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        this._WEB_REMOTE_URL = wr_url;
        this._TUNNEL_SERVER = "https://" + pairing_host22 + "/";
        this.DEFAULT_SERVICE_URL = this._SERVICE_URL;
        this.DEFAULT_WEB_REMOTE_URL = this._WEB_REMOTE_URL;
        this.DEFAULT_TUNNEL_SERVER = this._TUNNEL_SERVER;
        this.services = new HashMap<String, PairedServiceImpl>();
        this.init_sem = new AESemaphore("PM:init");
        this.local_v4 = "";
        this.local_v6 = "";
        this.ignored_v4 = new HashSet<InetAddress>();
        this.ignored_v6 = new HashSet<InetAddress>();
        this.min_update_period = 10000;
        this.max_update_period = 3600000;
        this.dispatcher = new AsyncDispatcher();
        this.last_update_time = -1L;
        this.qr_version = COConfigurationManager.getLongParameter("pairing.qr.ver", 0L);
        this.local_address_checks = new HashMap<String, Object[]>();
        this.listeners = new CopyOnWriteList();
        this.tests_in_progress = 0;
        AEDiagnostics.addWeakEvidenceGenerator(this);
        try {
            this.ui = (UIAdapter)Class.forName("com.biglybt.ui.swt.core.pairing.PMSWTImpl").newInstance();
        }
        catch (Throwable pairing_host22) {
            // empty catch block
        }
        this.getServices();
        VersionCheckClient.getSingleton().addVersionCheckClientListener(new VersionCheckClientListener(){

            @Override
            public void versionCheckStarted(String reason) {
            }

            @Override
            public void versionCheckCompleted(String reason, boolean changed) {
                if (changed) {
                    PairingManagerImpl.this.getServices();
                }
            }
        });
        this.must_update_once = COConfigurationManager.getBooleanParameter("pairing.updateoutstanding");
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        final UIManager ui_manager = default_pi.getUIManager();
        BasicPluginConfigModel configModel = ui_manager.createBasicPluginConfigModel("server", "Pairing");
        configModel.addHyperlinkParameter2("ConfigView.label.please.visit.here", "https://wiki.biglybt.com/w/UG_Options#Pairing");
        this.param_enable = configModel.addBooleanParameter2("pairing.enable", "pairing.enable", false);
        String access_code = this.readAccessCode();
        this.param_ac_info = configModel.addInfoParameter2("pairing.accesscode", access_code);
        this.param_status_info = configModel.addInfoParameter2("pairing.status.info", "");
        this.param_last_error = configModel.addInfoParameter2("pairing.last.error", "");
        this.param_view = configModel.addHyperlinkParameter2("pairing.view.registered", String.valueOf(this.getServiceURL().toExternalForm()) + "/web/view?ac=" + access_code);
        if (access_code.length() == 0) {
            this.param_view.setEnabled(false);
        }
        COConfigurationManager.registerExportedParameter("pairing.enable", this.param_enable.getConfigKeyName());
        COConfigurationManager.registerExportedParameter("pairing.access_code", this.param_ac_info.getConfigKeyName());
        final ActionParameter ap = configModel.addActionParameter2("pairing.ac.getnew", "pairing.ac.getnew.create");
        ap.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                try {
                    ap.setEnabled(false);
                    PairingManagerImpl.this.allocateAccessCode(false);
                    SimpleTimer.addEvent("PM:enabler", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            ap.setEnabled(true);
                        }
                    });
                }
                catch (Throwable e) {
                    ap.setEnabled(true);
                    String details = MessageText.getString("pairing.alloc.fail", new String[]{Debug.getNestedExceptionMessage(e)});
                    ui_manager.showMessageBox("pairing.op.fail", "!" + details + "!", 1L);
                }
            }
        });
        LabelParameter param_srp_info = configModel.addLabelParameter2("pairing.srp.info");
        HyperlinkParameter param_srp_link = configModel.addHyperlinkParameter2("label.more.info.here", "https://wiki.biglybt.com/w/Secure_Remote_Password");
        this.param_srp_enable = configModel.addBooleanParameter2("pairing.srp.enable", "pairing.srp.enable", false);
        COConfigurationManager.registerExportedParameter("pairing.srp_enable", this.param_srp_enable.getConfigKeyName());
        this.param_srp_state = configModel.addLabelParameter2("");
        this.updateSRPState();
        final ActionParameter param_srp_set = configModel.addActionParameter2("pairing.srp.setpw", "pairing.srp.setpw.doit");
        param_srp_set.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                param_srp_set.setEnabled(false);
                new AEThread2("getpw"){

                    @Override
                    public void run() {
                        try {
                            if (PairingManagerImpl.this.ui != null) {
                                char[] password = PairingManagerImpl.this.ui.getSRPPassword();
                                if (password != null) {
                                    PairingManagerImpl.this.tunnel_handler.setSRPPassword(password);
                                }
                            } else {
                                Debug.out("No UI available");
                            }
                        }
                        finally {
                            param_srp_set.setEnabled(true);
                        }
                    }
                }.start();
            }
        });
        this.param_srp_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                boolean active = PairingManagerImpl.this.param_srp_enable.getValue();
                PairingManagerImpl.this.tunnel_handler.setActive(active);
                PairingManagerImpl.this.updateSRPState();
            }
        });
        this.param_srp_enable.addEnabledOnSelection((Parameter)this.param_srp_state);
        this.param_srp_enable.addEnabledOnSelection((Parameter)param_srp_set);
        configModel.createGroup("pairing.group.srp", param_srp_info, param_srp_link, this.param_srp_enable, this.param_srp_state, param_srp_set);
        this.param_net_enable = configModel.addBooleanParameter2("pairing.nets.enable", "pairing.nets.enable", false);
        configModel.createGroup("pairing.group.optional", this.param_net_enable);
        LabelParameter param_e_info = configModel.addLabelParameter2("pairing.explicit.info");
        this.param_e_enable = configModel.addBooleanParameter2("pairing.explicit.enable", "pairing.explicit.enable", false);
        this.param_public_ipv4 = configModel.addStringParameter2("pairing.ipv4", "pairing.ipv4", "");
        this.param_public_ipv6 = configModel.addStringParameter2("pairing.ipv6", "pairing.ipv6", "");
        this.param_host = configModel.addStringParameter2("pairing.host", "pairing.host", "");
        LabelParameter spacer = configModel.addLabelParameter2("blank.resource");
        this.param_local_ipv4 = configModel.addStringParameter2("pairing.local.ipv4", "pairing.local.ipv4", "");
        this.param_local_ipv6 = configModel.addStringParameter2("pairing.local.ipv6", "pairing.local.ipv6", "");
        this.param_public_ipv4.setGenerateIntermediateEvents(false);
        this.param_public_ipv6.setGenerateIntermediateEvents(false);
        this.param_host.setGenerateIntermediateEvents(false);
        ParameterListener change_listener = new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                PairingManagerImpl.this.updateNeeded();
                if (param == PairingManagerImpl.this.param_enable) {
                    PairingManagerImpl.this.fireChanged();
                }
            }
        };
        this.param_enable.addListener(change_listener);
        this.param_e_enable.addListener(change_listener);
        this.param_public_ipv4.addListener(change_listener);
        this.param_public_ipv6.addListener(change_listener);
        this.param_local_ipv4.addListener(change_listener);
        this.param_local_ipv6.addListener(change_listener);
        this.param_host.addListener(change_listener);
        this.param_net_enable.addListener(change_listener);
        this.param_e_enable.addEnabledOnSelection((Parameter)this.param_public_ipv4);
        this.param_e_enable.addEnabledOnSelection((Parameter)this.param_public_ipv6);
        this.param_e_enable.addEnabledOnSelection((Parameter)this.param_local_ipv4);
        this.param_e_enable.addEnabledOnSelection((Parameter)this.param_local_ipv6);
        this.param_e_enable.addEnabledOnSelection((Parameter)this.param_host);
        ParameterGroup groupExplicit = configModel.createGroup("pairing.group.explicit", param_e_info, this.param_e_enable, this.param_public_ipv4, this.param_public_ipv6, this.param_host, spacer, this.param_local_ipv4, this.param_local_ipv6);
        groupExplicit.setMinimumRequiredUserMode(1);
        this.param_icon_enable = configModel.addBooleanParameter2("pairing.config.icon.show", "pairing.config.icon.show", true);
        this.param_icon_enable.setAllowedUiTypes("swt");
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                PairingManagerImpl.this.initialise(core);
            }
        });
    }

    private void getServices() {
        Map vc_data = VersionCheckClient.getSingleton().getMostRecentVersionCheckData();
        if (vc_data != null) {
            byte[] b_wr;
            byte[] b_ts;
            byte[] b_ps = (byte[])vc_data.get("pairing_server");
            if (b_ps != null) {
                try {
                    String ps;
                    this._SERVICE_URL = ps = new String(b_ps, "UTF-8");
                }
                catch (Throwable ps) {}
            } else {
                this._SERVICE_URL = this.DEFAULT_SERVICE_URL;
            }
            if ((b_ts = (byte[])vc_data.get("tunnel_server")) != null) {
                try {
                    String ts;
                    this._TUNNEL_SERVER = ts = new String(b_ts, "UTF-8");
                }
                catch (Throwable ts) {}
            } else {
                this._TUNNEL_SERVER = this.DEFAULT_TUNNEL_SERVER;
            }
            if ((b_wr = (byte[])vc_data.get("web_remote_server")) != null) {
                try {
                    String wr = new String(b_wr, "UTF-8");
                    this._WEB_REMOTE_URL = new URL(wr);
                }
                catch (Throwable throwable) {}
            } else {
                this._WEB_REMOTE_URL = this.DEFAULT_WEB_REMOTE_URL;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(Core _core) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.core = _core;
        }
        try {
            this.tunnel_handler = new PairingManagerTunnelHandler(this, this.core);
            PluginInterface default_pi = PluginInitializer.getDefaultInterface();
            DelayedTask dt = default_pi.getUtilities().createDelayedTask(new Runnable(){

                @Override
                public void run() {
                    new DelayedEvent("PM:delayinit", 10000L, new AERunnable(){

                        @Override
                        public void runSupport() {
                            PairingManagerImpl.this.enableUpdates();
                        }
                    });
                }
            });
            dt.queue();
            if (this.ui != null) {
                try {
                    this.ui.initialise(default_pi, this.param_icon_enable);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.init_sem.releaseForever();
            this.updateSRPState();
        }
    }

    protected void waitForInitialisation() throws PairingException {
        if (!this.init_sem.reserve(30000L)) {
            throw new PairingException("Timeout waiting for initialisation");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.param_enable.getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.param_enable.setValue(enabled);
    }

    @Override
    public boolean isSRPEnabled() {
        return this.param_srp_enable.getValue();
    }

    @Override
    public void setSRPEnabled(boolean enabled) {
        this.param_srp_enable.setValue(enabled);
    }

    @Override
    public URL getServiceURL() {
        try {
            return new URL(this._SERVICE_URL);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public URL getWebRemoteURL() {
        return this._WEB_REMOTE_URL;
    }

    @Override
    public String getTunnelServer() {
        return this._TUNNEL_SERVER;
    }

    @Override
    public void setGroup(String group) {
        COConfigurationManager.setParameter("pairing.groupcode", group);
        this.updateNeeded();
    }

    @Override
    public String getGroup() {
        return COConfigurationManager.getStringParameter("pairing.groupcode", null);
    }

    @Override
    public List<PairedNode> listGroup() throws PairingException {
        try {
            URL url = new URL(String.valueOf(this.getServiceURL().toExternalForm()) + "/remote/listGroup?gc=" + this.getGroup());
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            Map json = JSONUtils.decodeJSON(new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8"));
            List list = (List)json.get("result");
            ArrayList<PairedNode> result = new ArrayList<PairedNode>();
            String my_ac = this.peekAccessCode();
            if (list != null) {
                for (Map m : list) {
                    PairedNodeImpl node = new PairedNodeImpl(m);
                    if (my_ac != null && my_ac.equals(node.getAccessCode())) continue;
                    result.add(node);
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to list group", e);
        }
    }

    @Override
    public List<PairedService> lookupServices(String access_code) throws PairingException {
        try {
            URL url = new URL(String.valueOf(this.getServiceURL().toExternalForm()) + "/remote/listBindings?ac=" + access_code + "&jsoncallback=");
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            String reply = new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8");
            reply = reply.substring(1, reply.length() - 1);
            Map json = JSONUtils.decodeJSON(reply);
            Map error = (Map)json.get("error");
            if (error != null) {
                throw new PairingException((String)error.get("msg"));
            }
            List list = (List)json.get("result");
            ArrayList<PairedService> result = new ArrayList<PairedService>();
            if (list != null) {
                for (Map m : list) {
                    result.add(new PairedService2Impl((String)m.get("sid"), m));
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to lookup services", e);
        }
    }

    protected void setStatus(String str) {
        String last_status = this.param_status_info.getValue();
        if (!last_status.equals(str)) {
            this.param_status_info.setValue(str);
            this.fireChanged();
        }
    }

    @Override
    public String getStatus() {
        return this.param_status_info.getValue();
    }

    @Override
    public String getSRPStatus() {
        if (!this.isSRPEnabled()) {
            return "Not enabled";
        }
        if (this.tunnel_handler == null) {
            return "Initialising";
        }
        return this.tunnel_handler.getStatus();
    }

    protected void setLastServerError(String error, Map<String, Object> payload) {
        String last_error = this.param_last_error.getValue();
        if (error == null) {
            error = "";
        }
        try {
            COConfigurationManager.setParameter("Plugin.default.pairing.last.error.payload", error.isEmpty() ? "" : Base32.encode(BEncoder.encode(payload)));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        if (!last_error.equals(error)) {
            this.param_last_error.setValue(error);
            if (error.contains("generate a new one")) {
                Logger.log(new LogAlert(true, 1, "The pairing access code is invalid.\n\nCreate a new one via Tools->Options->Connection->Pairing or disable the pairing feature."));
            }
            this.fireChanged();
        }
    }

    @Override
    public String getLastServerError() {
        String last_error = this.param_last_error.getValue();
        if (last_error.length() == 0) {
            last_error = null;
        }
        return last_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActionOutstanding() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            block4: {
                if (this.isEnabled()) break block4;
                return false;
            }
            return !this.updates_enabled || this.update_outstanding || this.deferred_update_event != null || this.update_in_progress;
        }
    }

    protected String readAccessCode() {
        return COConfigurationManager.getStringParameter("pairing.accesscode", "");
    }

    protected void writeAccessCode(String ac) {
        COConfigurationManager.setParameter("pairing.accesscode", ac);
        COConfigurationManager.save();
        this.param_ac_info.setValue(ac);
        this.param_view.setHyperlink(String.valueOf(this.getServiceURL().toExternalForm()) + "/web/view?ac=" + ac);
        this.param_view.setEnabled(ac.length() > 0);
    }

    private File receiveQR(String ac, Map<String, Object> response) {
        byte[] bytes;
        block4: {
            try {
                bytes = (byte[])response.get("qr_b");
                if (bytes != null) break block4;
                return null;
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        long ver = (Long)response.get("qr_v");
        File cache_dir = FileUtil.newFile(SystemProperties.getUserPath(), "cache");
        File qr_file = FileUtil.newFile(cache_dir, "qr_" + ac + "_" + ver + ".png");
        if (FileUtil.writeBytesAsFile2(qr_file.getAbsolutePath(), bytes)) {
            return qr_file;
        }
        return null;
    }

    @Override
    public File getQRCode() {
        String existing = this.readAccessCode();
        if (existing == null) {
            return null;
        }
        if (this.qr_version > 0L) {
            File cache_dir = FileUtil.newFile(SystemProperties.getUserPath(), "cache");
            File qr_file = FileUtil.newFile(cache_dir, "qr_" + existing + "_" + this.qr_version + ".png");
            if (qr_file.exists()) {
                return qr_file;
            }
        }
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        request2.put("ac", existing);
        try {
            Map<String, Object> response = this.sendRequest("get_qr", request2);
            return this.receiveQR(existing, response);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected String allocateAccessCode(boolean updating) throws PairingException {
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        String existing = this.readAccessCode();
        request2.put("ac", existing);
        request2.put("qr", 1L);
        Map<String, Object> response = this.sendRequest("allocate", request2);
        try {
            String code = this.getString(response, "ac");
            this.receiveQR(code, response);
            this.writeAccessCode(code);
            if (!updating) {
                this.updateNeeded();
            }
            this.fireChanged();
            return code;
        }
        catch (Throwable e) {
            throw new PairingException("allocation failed", e);
        }
    }

    @Override
    public String peekAccessCode() {
        return this.readAccessCode();
    }

    @Override
    public String getAccessCode() throws PairingException {
        this.waitForInitialisation();
        String ac = this.readAccessCode();
        if (ac == null || ac.length() == 0) {
            ac = this.allocateAccessCode(false);
        }
        return ac;
    }

    public void getAccessCode(final PairingManagerListener listener) throws PairingException {
        new AEThread2("PM:gac", true){

            @Override
            public void run() {
                try {
                    try {
                        PairingManagerImpl.this.getAccessCode();
                    }
                    catch (Throwable throwable) {
                        listener.somethingChanged(PairingManagerImpl.this);
                    }
                }
                finally {
                    listener.somethingChanged(PairingManagerImpl.this);
                }
            }
        }.start();
    }

    @Override
    public String getReplacementAccessCode() throws PairingException {
        this.waitForInitialisation();
        String new_code = this.allocateAccessCode(false);
        return new_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService addService(String sid, PairedServiceRequestHandler handler) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            if (result == null) {
                result = new PairedServiceImpl(sid, handler);
                this.services.put(sid, result);
            } else {
                result.setHandler(handler);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedServiceImpl getService(String sid) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(PairedServiceImpl service) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            String sid = service.getSID();
            if (this.services.remove(sid) != null) {
                // empty if block
            }
        }
        this.updateNeeded();
    }

    protected void sync(PairedServiceImpl service) {
        this.updateNeeded();
    }

    protected InetAddress updateAddress(InetAddress current, InetAddress latest, boolean v6) {
        if (v6 ? latest instanceof Inet4Address : latest instanceof Inet6Address) {
            return current;
        }
        if (current == latest) {
            return current;
        }
        if (current == null || latest == null) {
            return latest;
        }
        if (!current.equals(latest)) {
            return latest;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void updateGlobals(boolean is_updating) {
        now = SystemTime.getMonotonousTime();
        network_admin = NetworkAdmin.getSingleton();
        latest_v4 = this.core.getInstanceManager().getMyInstance().getExternalAddress();
        var6_5 = this;
        synchronized (var6_5) {
            temp_v4 = this.updateAddress(this.current_v4, latest_v4, false);
            latest_v6 = network_admin.getDefaultPublicAddressV6();
            temp_v6 = this.updateAddress(this.current_v6, latest_v6, true);
            latest_v4_locals = new TreeSet<String>();
            latest_v6_locals = new TreeSet<String>();
            interfaces = network_admin.getInterfaces();
            to_do = new ArrayList<9>();
            var15_13 = this.local_address_checks;
            synchronized (var15_13) {
                existing_checked = new HashSet<String>(this.local_address_checks.keySet());
            }
            num_v4_accepted = 0;
            num_v6_accepted = 0;
            var20_17 = interfaces;
            var19_18 = interfaces.length;
            var18_21 = 0;
            while (var18_21 < var19_18) {
                intf = var20_17[var18_21];
                addresses = intf.getAddresses();
                num_v4_from_this_intf = 0;
                num_v6_from_this_intf = 0;
                var27_32 = addresses;
                var26_31 = addresses.length;
                var25_30 = 0;
                while (var25_30 < var26_31) {
                    block28: {
                        block29: {
                            block30: {
                                address = var27_32[var25_30];
                                ia = address.getAddress();
                                if (ia.isLoopbackAddress() || !ia.isLinkLocalAddress() && !ia.isSiteLocalAddress()) break block28;
                                is_v4 = ia instanceof Inet4Address;
                                if (!is_v4) break block29;
                                if (this.ignored_v4.contains(ia)) break block28;
                                if (num_v4_from_this_intf != 3 && num_v4_accepted != 10) break block30;
                                this.ignored_v4.add(ia);
                                break block28;
                            }
                            ++num_v4_from_this_intf;
                            ++num_v4_accepted;
                            ** GOTO lbl57
                        }
                        if (this.ignored_v6.contains(ia)) break block28;
                        if (num_v6_from_this_intf == 3 || num_v6_accepted == 10) {
                            this.ignored_v6.add(ia);
                        } else {
                            ++num_v6_from_this_intf;
                            ++num_v6_accepted;
lbl57:
                            // 2 sources

                            a_str = ia.getHostAddress();
                            existing_checked.remove(a_str);
                            var32_38 = this.local_address_checks;
                            synchronized (var32_38) {
                                check = this.local_address_checks.get(a_str);
                            }
                            v2 = run_check = check == null || now - (Long)check[0] > 1800000L;
                            if (run_check) {
                                to_do.add(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        String result;
                                        block16: {
                                            Socket socket = new Socket();
                                            result = a_str;
                                            try {
                                                try {
                                                    socket.bind(new InetSocketAddress(ia, 0));
                                                    socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                                                    result = String.valueOf(result) + "*";
                                                }
                                                catch (Throwable throwable) {
                                                    try {
                                                        socket.close();
                                                    }
                                                    catch (Throwable throwable2) {}
                                                    break block16;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Throwable throwable3) {
                                                    // empty catch block
                                                }
                                                throw throwable;
                                            }
                                            try {
                                                socket.close();
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        Map<String, Object[]> map = PairingManagerImpl.this.local_address_checks;
                                        synchronized (map) {
                                            PairingManagerImpl.this.local_address_checks.put(a_str, new Object[]{new Long(now), result});
                                            if (is_v4) {
                                                latest_v4_locals.add(result);
                                            } else {
                                                latest_v6_locals.add(result);
                                            }
                                        }
                                    }
                                });
                            } else if (is_v4) {
                                latest_v4_locals.add((String)check[1]);
                            } else {
                                latest_v6_locals.add((String)check[1]);
                            }
                        }
                    }
                    ++var25_30;
                }
                ++var18_21;
            }
            if (to_do.size() > 0) {
                sem = new AESemaphore("PM:check");
                for (Runnable r : to_do) {
                    new AEThread2("PM:check:", true, (AESemaphore)sem, r){
                        private final /* synthetic */ AESemaphore val$sem;
                        private final /* synthetic */ Runnable val$r;
                        {
                            this.val$sem = aESemaphore;
                            this.val$r = runnable;
                            super($anonymous0, $anonymous1);
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$r.run();
                            }
                            finally {
                                this.val$sem.release();
                            }
                        }
                    }.start();
                }
                i = 0;
                while (i < to_do.size()) {
                    sem.reserve();
                    ++i;
                }
            }
            sem = this.local_address_checks;
            synchronized (sem) {
                for (String excess : existing_checked) {
                    this.local_address_checks.remove(excess);
                }
            }
            v4_locals_str = this.getString(latest_v4_locals);
            v6_locals_str = this.getString(latest_v6_locals);
            if (temp_v4 != this.current_v4 || temp_v6 != this.current_v6 || !v4_locals_str.equals(this.local_v4) || !v6_locals_str.equals(this.local_v6)) {
                this.current_v4 = temp_v4;
                this.current_v6 = temp_v6;
                this.local_v4 = v4_locals_str;
                this.local_v6 = v6_locals_str;
                if (!is_updating) {
                    this.updateNeeded();
                }
            }
        }
    }

    protected String getString(Set<String> set) {
        String str = "";
        for (String s : set) {
            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + s;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdates() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.updates_enabled = true;
            if (this.update_outstanding) {
                this.update_outstanding = false;
                this.updateNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNeeded() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.updates_enabled) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        PairingManagerImpl.this.doUpdate();
                    }
                });
            } else {
                this.setStatus(MessageText.getString("pairing.status.initialising"));
                this.update_outstanding = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doUpdate() {
        block68: {
            now = SystemTime.getMonotonousTime();
            var3_2 = this;
            synchronized (var3_2) {
                if (this.deferred_update_event != null) {
                    return;
                }
                time_since_last_update = now - this.last_update_time;
                if (this.last_update_time > 0L && time_since_last_update < (long)this.min_update_period) {
                    this.deferUpdate((long)this.min_update_period - time_since_last_update);
                    return;
                }
                this.update_in_progress = true;
            }
            payload = new HashMap<String, Object>();
            is_enabled = this.param_enable.getValue();
            has_services = false;
            var6_9 = this;
            synchronized (var6_9) {
                block70: {
                    list = new ArrayList<Map<String, String>>();
                    payload.put("s", list);
                    if (this.services.size() <= 0 || !is_enabled) break block70;
                    if (this.global_update_event == null) {
                        this.global_update_event = SimpleTimer.addPeriodicEvent("PM:updater", 60000L, new TimerEventPerformer(){
                            private int tick_count;

                            @Override
                            public void perform(TimerEvent event2) {
                                AEThread2.createAndStartDaemon("PM:updater", () -> {
                                    ++this.tick_count;
                                    PairingManagerImpl.this.updateGlobals(false);
                                    if (this.tick_count % 1380 == 0) {
                                        PairingManagerImpl.this.updateNeeded();
                                    }
                                });
                            }
                        });
                        this.updateGlobals(true);
                    }
                    enable_nets = this.param_net_enable.getValue();
                    for (PairedServiceImpl service : this.services.values()) {
                        list.add(service.toMap(enable_nets));
                    }
                    has_services = list.size() > 0;
                    ** GOTO lbl58
                }
                if (this.global_update_event != null) ** break block67
                if (this.consec_update_fails != 0 || this.must_update_once) ** GOTO lbl58
                this.update_in_progress = false;
                this.setStatus(MessageText.getString(is_enabled != false ? "pairing.status.noservices" : "label.disabled"));
                // MONITOREXIT @DISABLED, blocks:[1, 2, 18] lbl46 : MonitorExitStatement: MONITOREXIT : var6_9
                var15_18 = this;
            }
            synchronized (var15_18) {
                if (this.update_in_progress) {
                    Debug.out("Something didn't clear update_in_progress!!!!");
                    this.update_in_progress = false;
                }
            }
            return;
            {
                try {
                    try {
                        this.global_update_event.cancel();
                        this.global_update_event = null;
lbl58:
                        // 3 sources

                        this.last_update_time = now;
                        // MONITOREXIT @DISABLED, blocks:[18, 4, 5, 6] lbl65 : MonitorExitStatement: MONITOREXIT : var6_9
                        {
                            catch (Throwable v2) {
                                throw v2;
                            }
                        }
                        ac = this.readAccessCode();
                        if (ac.length() == 0) {
                            ac = this.allocateAccessCode(true);
                        }
                        payload.put("ac", ac);
                        gc = this.getGroup();
                        if (gc != null && gc.length() > 0) {
                            payload.put("gc", gc);
                        }
                        if (is_enabled && has_services && this.param_srp_enable.getValue()) {
                            this.tunnel_handler.setActive(true);
                            this.tunnel_handler.updateRegistrationData(payload);
                        } else {
                            this.tunnel_handler.setActive(false);
                        }
                        var8_13 = this;
                        synchronized (var8_13) {
                            if (this.current_v4 != null) {
                                payload.put("c_v4", this.current_v4.getHostAddress());
                            }
                            if (this.current_v6 != null) {
                                payload.put("c_v6", this.current_v6.getHostAddress());
                            }
                            if (this.local_v4.length() > 0) {
                                payload.put("l_v4", this.local_v4);
                            }
                            if (this.local_v6.length() > 0) {
                                payload.put("l_v6", this.local_v6);
                            }
                            if (this.param_e_enable.getValue()) {
                                host = this.param_host.getValue().trim();
                                if (host.length() > 0) {
                                    payload.put("e_h", host);
                                }
                                if ((v4 = this.param_public_ipv4.getValue().trim()).length() > 0) {
                                    payload.put("e_v4", v4);
                                }
                                if ((v6 = this.param_public_ipv6.getValue().trim()).length() > 0) {
                                    payload.put("e_v6", v6);
                                }
                                if ((l_v4 = this.param_local_ipv4.getValue().trim()).length() > 0) {
                                    payload.put("e_l_v4", l_v4);
                                }
                                if ((l_v6 = this.param_local_ipv6.getValue().trim()).length() > 0) {
                                    payload.put("e_l_v6", l_v6);
                                }
                            }
                            try {
                                admin = NetworkAdmin.getSingleton();
                                http_proxy = admin.getHTTPProxy();
                                if (http_proxy != null) {
                                    payload.put("hp", http_proxy.getName());
                                }
                                if ((socks_proxies = admin.getSocksProxies()).length > 0) {
                                    payload.put("sp", socks_proxies[0].getName());
                                }
                            }
                            catch (Throwable var9_17) {
                                // empty catch block
                            }
                            payload.put("_enabled", is_enabled != false ? 1L : 0L);
                        }
                        this.sendRequest("update", payload);
                        var8_13 = this;
                        synchronized (var8_13) {
                            this.consec_update_fails = 0;
                            this.must_update_once = false;
                            if (this.deferred_update_event == null) {
                                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                            }
                            this.update_in_progress = false;
                            if (this.global_update_event == null) {
                                this.setStatus(MessageText.getString(is_enabled != false ? "pairing.status.noservices" : "label.disabled"));
                            } else {
                                this.setStatus(MessageText.getString("pairing.status.registered", new String[]{new SimpleDateFormat().format(new Date(SystemTime.getCurrentTime()))}));
                            }
                            break block68;
                        }
                    }
                    catch (Throwable e) {
                        var4_6 = this;
                        synchronized (var4_6) {
                            try {
                                ++this.consec_update_fails;
                                back_off = this.min_update_period;
                                i = 0;
                                while (i < this.consec_update_fails) {
                                    if ((back_off *= 2L) > (long)this.max_update_period) {
                                        back_off = this.max_update_period;
                                        break;
                                    }
                                    ++i;
                                }
                                this.deferUpdate(back_off);
                            }
                            finally {
                                this.update_in_progress = false;
                            }
                        }
                    }
                    var15_19 = this;
                }
                catch (Throwable var14_25) {
                    var15_20 = this;
                    synchronized (var15_20) {
                        if (this.update_in_progress) {
                            Debug.out("Something didn't clear update_in_progress!!!!");
                            this.update_in_progress = false;
                        }
                    }
                    throw var14_25;
                }
                synchronized (var15_19) {
                    if (this.update_in_progress) {
                        Debug.out("Something didn't clear update_in_progress!!!!");
                        this.update_in_progress = false;
                    }
                }
            }
        }
        var15_21 = this;
        synchronized (var15_21) {
            if (this.update_in_progress) {
                Debug.out("Something didn't clear update_in_progress!!!!");
                this.update_in_progress = false;
            }
        }
    }

    protected void deferUpdate(long millis) {
        long target = SystemTime.getOffsetTime(millis += 5000L);
        this.deferred_update_event = SimpleTimer.addEvent("PM:defer", target, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                synchronized (pairingManagerImpl) {
                    PairingManagerImpl.this.deferred_update_event = null;
                }
                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                PairingManagerImpl.this.updateNeeded();
            }
        });
        this.setStatus(MessageText.getString("pairing.status.pending", new String[]{new SimpleDateFormat().format(new Date(target))}));
        COConfigurationManager.setParameter("pairing.updateoutstanding", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sendRequest(String command, Map<String, Object> payload) throws PairingException {
        try {
            String error;
            HashMap<String, Map<String, Object>> request2 = new HashMap<String, Map<String, Object>>();
            CryptoManager cman = CryptoManagerFactory.getSingleton();
            String azid = Base32.encode(cman.getSecureID());
            payload.put("_azid", azid);
            try {
                String pk = Base32.encode(cman.getECCHandler().getPublicKey("pairing"));
                payload.put("_pk", pk);
            }
            catch (Throwable pk) {
                // empty catch block
            }
            request2.put("req", payload);
            String request_str = Base32.encode(BEncoder.encode(request2));
            String sig = null;
            try {
                sig = Base32.encode(cman.getECCHandler().sign(request_str.getBytes("UTF-8"), "pairing"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String other_params = "&ver=" + UrlUtils.encode("3.4.0.0") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
            if (sig != null) {
                other_params = String.valueOf(other_params) + "&sig=" + sig;
            }
            URL target = new URL(String.valueOf(this.getServiceURL().toExternalForm()) + "/client/" + command + "?request=" + request_str + other_params);
            Properties http_properties = new Properties();
            http_properties.put("URL", target);
            try {
                ClientIDManagerImpl.getSingleton().generateHTTPProperties(null, http_properties);
            }
            catch (ClientIDException e) {
                throw new IOException(e.getMessage());
            }
            target = (URL)http_properties.get("URL");
            HttpURLConnection connection = (HttpURLConnection)target.openConnection();
            connection.setConnectTimeout(30000);
            InputStream is = connection.getInputStream();
            Map<String, Object> response = BDecoder.decode(new BufferedInputStream(is));
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                Long max_retry;
                Long min_retry = (Long)response.get("min_secs");
                if (min_retry != null) {
                    this.min_update_period = min_retry.intValue() * 1000;
                }
                if ((max_retry = (Long)response.get("max_secs")) != null) {
                    this.max_update_period = max_retry.intValue() * 1000;
                }
            }
            final String message = this.getString(response, "message");
            if (!(message == null || this.last_message != null && this.last_message.equals(message))) {
                this.last_message = message;
                try {
                    byte[] message_sig = (byte[])response.get("message_sig");
                    AEVerifier.verifyData(message, message_sig);
                    new AEThread2("PairMsg", true){

                        @Override
                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            if (ui_manager != null) {
                                ui_manager.showMessageBox("pairing.server.warning.title", "!" + message + "!", 1L);
                            }
                        }
                    }.start();
                }
                catch (Throwable message_sig) {
                    // empty catch block
                }
            }
            if ((error = this.getString(response, "error")) != null) {
                throw new PairingException(error);
            }
            this.setLastServerError(null, payload);
            Map reply = (Map)response.get("rep");
            Long qr_v = (Long)reply.get("qr_v");
            if (qr_v != null && this.qr_version != qr_v) {
                this.qr_version = qr_v;
                COConfigurationManager.setParameter("pairing.qr.ver", this.qr_version);
            }
            return reply;
        }
        catch (Throwable e) {
            this.setLastServerError(Debug.getNestedExceptionMessage(e), payload);
            if (e instanceof PairingException) {
                throw (PairingException)e;
            }
            throw new PairingException("invocation failed", e);
        }
    }

    @Override
    public PairingTest testService(String sid, PairingTestListener listener) throws PairingException {
        return new TestServiceImpl(sid, listener);
    }

    protected void updateSRPState() {
        String text = this.param_srp_enable.getValue() ? (this.tunnel_handler == null ? String.valueOf(MessageText.getString("pairing.status.initialising")) + "..." : this.tunnel_handler.getStatus()) : MessageText.getString("label.disabled");
        this.param_srp_state.setLabelText(MessageText.getString("pairing.srp.state", new String[]{text}));
    }

    @Override
    public void setSRPPassword(char[] password) {
        this.init_sem.reserve();
        this.tunnel_handler.setSRPPassword(password);
    }

    @Override
    public boolean handleLocalTunnel(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        this.init_sem.reserve();
        return this.tunnel_handler.handleLocalTunnel(request2, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordRequest(String name, String ip, boolean good) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.tests_in_progress > 0) {
                return;
            }
        }
        if (this.ui != null) {
            try {
                this.ui.recordRequest(name, ip, good);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void fireChanged() {
        for (PairingManagerListener l : this.listeners) {
            try {
                l.somethingChanged(this);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addListener(PairingManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PairingManagerListener l) {
        this.listeners.remove(l);
    }

    protected String getString(Map<String, Object> map, String name) throws IOException {
        byte[] bytes = (byte[])map.get(name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Pairing Manager");
        try {
            writer.indent();
            if (this.tunnel_handler != null) {
                this.tunnel_handler.generateEvidence(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    private class PairedNodeImpl
    implements PairedNode {
        private final Map map;

        protected PairedNodeImpl(Map _map) {
            this.map = _map;
        }

        @Override
        public String getAccessCode() {
            return (String)this.map.get("ac");
        }

        @Override
        public List<InetAddress> getAddresses() {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            this.addAddress(addresses, "c_v4");
            this.addAddress(addresses, "c_v6");
            this.addAddress(addresses, "l_v4");
            this.addAddress(addresses, "l_v6");
            this.addAddress(addresses, "e_v4");
            this.addAddress(addresses, "e_v6");
            this.addAddress(addresses, "e_l_v4");
            this.addAddress(addresses, "e_l_v6");
            this.addAddress(addresses, "e_h");
            return new ArrayList<InetAddress>(addresses);
        }

        private void addAddress(Set<InetAddress> addresses, String key) {
            String str = (String)this.map.get(key);
            if (str != null) {
                String[] bits;
                String[] stringArray = bits = str.split(",");
                int n = bits.length;
                int n2 = 0;
                while (n2 < n) {
                    String bit = stringArray[n2];
                    if ((bit = bit.trim()).length() != 0) {
                        if (bit.endsWith("*")) {
                            bit = bit.substring(0, bit.length() - 1);
                        }
                        try {
                            addresses.add(InetAddress.getByName(bit));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
        }

        @Override
        public List<PairedService> getServices() {
            Map smap = (Map)this.map.get("services");
            ArrayList<PairedService> services = new ArrayList<PairedService>();
            for (Map.Entry entry : smap.entrySet()) {
                services.add(new PairedService2Impl((String)entry.getKey(), (Map)entry.getValue()));
            }
            return services;
        }
    }

    private static class PairedService2Impl
    implements PairedService {
        private final String sid;
        private final Map map;

        protected PairedService2Impl(String _sid, Map _map) {
            this.sid = _sid;
            this.map = _map;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return new PairingConnectionData2(this.map);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported");
        }
    }

    protected class PairedServiceImpl
    implements PairedService,
    PairingConnectionData {
        private final String sid;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private PairedServiceRequestHandler request_handler;

        protected PairedServiceImpl(String _sid, PairedServiceRequestHandler _request_handler) {
            this.sid = _sid;
            this.request_handler = _request_handler;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        protected void setHandler(PairedServiceRequestHandler _h) {
            this.request_handler = _h;
        }

        protected PairedServiceRequestHandler getHandler() {
            return this.request_handler;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return this;
        }

        @Override
        public void remove() {
            PairingManagerImpl.this.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String name, String value) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                if (value == null) {
                    this.attributes.remove(name);
                } else {
                    this.attributes.put(name, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAttribute(String name) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                return this.attributes.get(name);
            }
        }

        @Override
        public void sync() {
            PairingManagerImpl.this.sync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> toMap(boolean enable_nets) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("sid", this.sid);
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                result.putAll(this.attributes);
            }
            if (!enable_nets) {
                result.remove("I2P");
                result.remove("Tor");
            }
            return result;
        }
    }

    private static class PairingConnectionData2
    implements PairingConnectionData {
        private final Map map;

        protected PairingConnectionData2(Map _map) {
            this.map = _map;
        }

        @Override
        public void setAttribute(String name, String value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public String getAttribute(String name) {
            return (String)this.map.get(name);
        }

        @Override
        public void sync() {
            throw new RuntimeException("Not supported");
        }
    }

    protected class TestServiceImpl
    implements PairingTest {
        private final String sid;
        private final PairingTestListener listener;
        private volatile int outcome = 0;
        private volatile String error_message;
        private volatile boolean cancelled;

        protected TestServiceImpl(String _sid, PairingTestListener _listener) {
            this.sid = _sid;
            this.listener = _listener;
            new AEThread2("PM:test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block56: {
                        block55: {
                            String access_code;
                            block54: {
                                access_code = null;
                                long sid_wait_start = -1L;
                                do {
                                    if (!PairingManagerImpl.this.isEnabled()) {
                                        throw new Exception("Pairing is disabled");
                                    }
                                    access_code = PairingManagerImpl.this.peekAccessCode();
                                    if (access_code != null && !PairingManagerImpl.this.hasActionOutstanding()) {
                                        if (PairingManagerImpl.this.getService(TestServiceImpl.this.sid) != null) break block54;
                                        long now = SystemTime.getMonotonousTime();
                                        if (sid_wait_start == -1L) {
                                            sid_wait_start = now;
                                        } else if (now - sid_wait_start > 5000L) break block54;
                                    }
                                    Thread.sleep(500L);
                                } while (!TestServiceImpl.this.cancelled);
                                TestServiceImpl.this.outcome = 6;
                                try {
                                    TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                }
                                catch (Throwable throwable) {
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    synchronized (pairingManagerImpl) {
                                        PairingManagerImpl pairingManagerImpl2 = PairingManagerImpl.this;
                                        pairingManagerImpl2.tests_in_progress = pairingManagerImpl2.tests_in_progress - 1;
                                    }
                                    throw throwable;
                                }
                                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                synchronized (pairingManagerImpl) {
                                    PairingManagerImpl pairingManagerImpl3 = PairingManagerImpl.this;
                                    pairingManagerImpl3.tests_in_progress = pairingManagerImpl3.tests_in_progress - 1;
                                }
                                return;
                            }
                            try {
                                try {
                                    PairedServiceImpl service = PairingManagerImpl.this.getService(TestServiceImpl.this.sid);
                                    if (service == null) {
                                        throw new Exception("Service not found");
                                    }
                                    TestServiceImpl.this.listener.testStarted(TestServiceImpl.this);
                                    String other_params = "&ver=" + UrlUtils.encode("3.4.0.0") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
                                    URL target = new URL(String.valueOf(PairingManagerImpl.this.getServiceURL().toExternalForm()) + "/web/test?sid=" + TestServiceImpl.this.sid + "&ac=" + access_code + "&format=bencode" + other_params);
                                    HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                                    connection.setConnectTimeout(10000);
                                    try {
                                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                        synchronized (pairingManagerImpl) {
                                            PairingManagerImpl pairingManagerImpl4 = PairingManagerImpl.this;
                                            pairingManagerImpl4.tests_in_progress = pairingManagerImpl4.tests_in_progress + 1;
                                        }
                                        InputStream is = connection.getInputStream();
                                        Map response = BDecoder.decode(new BufferedInputStream(is));
                                        response = BDecoder.decodeStrings(response);
                                        Long code = (Long)response.get("code");
                                        if (code == null) {
                                            throw new Exception("Code missing from reply");
                                        }
                                        TestServiceImpl.this.error_message = (String)response.get("msg");
                                        if (code == 1L) {
                                            TestServiceImpl.this.outcome = 1;
                                            break block55;
                                        }
                                        if (code == 2L) {
                                            TestServiceImpl.this.outcome = 4;
                                            break block55;
                                        }
                                        if (code == 3L) {
                                            TestServiceImpl.this.outcome = 5;
                                            break block55;
                                        }
                                        if (code == 4L) {
                                            TestServiceImpl.this.outcome = 2;
                                            TestServiceImpl.this.error_message = "Connect timeout";
                                            break block55;
                                        }
                                        if (code == 5L) {
                                            TestServiceImpl.this.outcome = 2;
                                            break block55;
                                        }
                                        TestServiceImpl.this.outcome = 5;
                                        TestServiceImpl.this.error_message = "Unknown response code " + code;
                                    }
                                    catch (SocketTimeoutException e) {
                                        TestServiceImpl.this.outcome = 3;
                                        TestServiceImpl.this.error_message = "Connect timeout";
                                    }
                                }
                                catch (Throwable e) {
                                    TestServiceImpl.this.outcome = 3;
                                    TestServiceImpl.this.error_message = Debug.getNestedExceptionMessage(e);
                                    try {
                                        TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                    }
                                    catch (Throwable throwable) {
                                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                        synchronized (pairingManagerImpl) {
                                            PairingManagerImpl pairingManagerImpl5 = PairingManagerImpl.this;
                                            pairingManagerImpl5.tests_in_progress = pairingManagerImpl5.tests_in_progress - 1;
                                        }
                                        throw throwable;
                                    }
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    synchronized (pairingManagerImpl) {
                                        PairingManagerImpl pairingManagerImpl6 = PairingManagerImpl.this;
                                        pairingManagerImpl6.tests_in_progress = pairingManagerImpl6.tests_in_progress - 1;
                                        break block56;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                }
                                catch (Throwable throwable2) {
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    synchronized (pairingManagerImpl) {
                                        PairingManagerImpl pairingManagerImpl7 = PairingManagerImpl.this;
                                        pairingManagerImpl7.tests_in_progress = pairingManagerImpl7.tests_in_progress - 1;
                                    }
                                    throw throwable2;
                                }
                                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                synchronized (pairingManagerImpl) {
                                    PairingManagerImpl pairingManagerImpl8 = PairingManagerImpl.this;
                                    pairingManagerImpl8.tests_in_progress = pairingManagerImpl8.tests_in_progress - 1;
                                }
                                throw throwable;
                            }
                        }
                        try {
                            TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                        }
                        catch (Throwable throwable) {
                            PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                            synchronized (pairingManagerImpl) {
                                PairingManagerImpl pairingManagerImpl9 = PairingManagerImpl.this;
                                pairingManagerImpl9.tests_in_progress = pairingManagerImpl9.tests_in_progress - 1;
                            }
                            throw throwable;
                        }
                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                        synchronized (pairingManagerImpl) {
                            PairingManagerImpl pairingManagerImpl10 = PairingManagerImpl.this;
                            pairingManagerImpl10.tests_in_progress = pairingManagerImpl10.tests_in_progress - 1;
                        }
                    }
                }
            }.start();
        }

        @Override
        public int getOutcome() {
            return this.outcome;
        }

        @Override
        public String getErrorMessage() {
            return this.error_message;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }

    public static interface UIAdapter {
        public void initialise(PluginInterface var1, BooleanParameter var2);

        public void recordRequest(String var1, String var2, boolean var3);

        public char[] getSRPPassword();
    }
}

