/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.tcp;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;

public class SelectorGuard {
    private static final int SELECTOR_SPIN_THRESHOLD = 200;
    private static final int MAX_IGNORES = 5;
    private boolean marked = false;
    private int consecutiveZeroSelects = 0;
    private long beforeSelectTime;
    private long select_op_time;
    private final String type;
    private int ignores = 0;

    public SelectorGuard(String _type) {
        this.type = _type;
    }

    public String getType() {
        return this.type;
    }

    public void markPreSelectTime() {
        this.beforeSelectTime = SystemTime.getMonotonousTime();
        this.marked = true;
    }

    public void verifySelectorIntegrity(int num_keys_ready, long time_threshold) {
        if (num_keys_ready > 0) {
            ++this.ignores;
            if (this.ignores > 5) {
                this.ignores = 0;
                this.consecutiveZeroSelects = 0;
            }
            return;
        }
        if (this.marked) {
            this.marked = false;
        } else {
            Debug.out("Error: You must run markPreSelectTime() before calling isSelectorOK");
        }
        this.select_op_time = SystemTime.getMonotonousTime() - this.beforeSelectTime;
        if (this.select_op_time > time_threshold) {
            this.consecutiveZeroSelects = 0;
            return;
        }
        ++this.consecutiveZeroSelects;
        if (this.consecutiveZeroSelects % 20 == 0 && Constants.isWindows && this.consecutiveZeroSelects > 40) {
            Debug.out("consecutiveZeroSelects=" + this.consecutiveZeroSelects);
        }
        if (this.consecutiveZeroSelects > 200) {
            this.consecutiveZeroSelects = 0;
            try {
                Thread.sleep(50L);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
    }
}

