/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.OutgoingMessageQueue;
import com.biglybt.core.networkmanager.RawMessage;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageStreamEncoder;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.TimeFormatter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class OutgoingMessageQueueImpl
implements OutgoingMessageQueue {
    private final LinkedList<RawMessage> queue = new LinkedList();
    private final AEMonitor queue_mon = new AEMonitor("OutgoingMessageQueue:queue");
    private final ArrayList delayed_notifications = new ArrayList();
    private final AEMonitor delayed_notifications_mon = new AEMonitor("OutgoingMessageQueue:DN");
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("OutgoingMessageQueue:L");
    private int total_size = 0;
    private int total_data_size = 0;
    private boolean priority_boost = false;
    private RawMessage urgent_message = null;
    private boolean destroyed = false;
    private MessageStreamEncoder stream_encoder;
    private Transport transport;
    private int progress_id;
    private int[] progress;
    private static final boolean TRACE_HISTORY = false;
    private static final int MAX_HISTORY_TRACES = 30;
    private final LinkedList<RawMessage> prev_sent = new LinkedList();
    private boolean trace;
    private WeakReference rawBufferCache = new WeakReference<Object>(null);
    private WeakReference origPositionsCache = new WeakReference<Object>(null);

    public OutgoingMessageQueueImpl(MessageStreamEncoder stream_encoder) {
        this.stream_encoder = stream_encoder;
    }

    @Override
    public void setTransport(Transport _transport) {
        this.transport = _transport;
    }

    @Override
    public int getMssSize() {
        return this.transport == null ? NetworkManager.getMinMssSize() : this.transport.getMssSize();
    }

    @Override
    public void setEncoder(MessageStreamEncoder stream_encoder) {
        this.stream_encoder = stream_encoder;
    }

    @Override
    public MessageStreamEncoder getEncoder() {
        return this.stream_encoder;
    }

    @Override
    public int[] getCurrentMessageProgress() {
        return this.progress;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        try {
            this.queue_mon.enter();
            while (!this.queue.isEmpty()) {
                this.queue.remove(0).destroy();
            }
        }
        finally {
            this.queue_mon.exit();
        }
        this.total_size = 0;
        this.total_data_size = 0;
        this.prev_sent.clear();
        this.listeners = new ArrayList();
        this.progress = null;
        ++this.progress_id;
        this.urgent_message = null;
    }

    @Override
    public int getTotalSize() {
        return this.total_size;
    }

    @Override
    public int getDataQueuedBytes() {
        return this.total_data_size;
    }

    @Override
    public int getProtocolQueuedBytes() {
        return this.total_size - this.total_data_size;
    }

    @Override
    public boolean getPriorityBoost() {
        return this.priority_boost;
    }

    @Override
    public void setPriorityBoost(boolean boost) {
        this.priority_boost = boost;
    }

    @Override
    public boolean isBlocked() {
        if (this.transport == null) {
            return false;
        }
        return !this.transport.isReadyForWrite(null);
    }

    @Override
    public boolean hasUrgentMessage() {
        return this.urgent_message != null;
    }

    @Override
    public Message peekFirstMessage() {
        try {
            this.queue_mon.enter();
            Message message = this.queue.peek();
            return message;
        }
        finally {
            this.queue_mon.exit();
        }
    }

    @Override
    public void addMessage(Message message, boolean manual_listener_notify) {
        boolean allowed = true;
        ArrayList list_ref = this.listeners;
        int i = 0;
        while (i < list_ref.size()) {
            OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)list_ref.get(i);
            allowed = allowed && listener.messageAdded(message);
            ++i;
        }
        if (!allowed) {
            return;
        }
        RawMessage[] rmesgs = this.stream_encoder.encodeMessage(message);
        if (this.destroyed) {
            int i2 = 0;
            while (i2 < rmesgs.length) {
                rmesgs[i2].destroy();
                ++i2;
            }
            return;
        }
        int i3 = 0;
        while (i3 < rmesgs.length) {
            RawMessage rmesg = rmesgs[i3];
            this.removeMessagesOfType(rmesg.messagesToRemove(), manual_listener_notify);
            try {
                this.queue_mon.enter();
                int pos = 0;
                for (RawMessage msg : this.queue) {
                    if (rmesg.getPriority() > msg.getPriority() && msg.getRawData()[0].position((byte)5) == 0) break;
                    ++pos;
                }
                if (rmesg.isNoDelay()) {
                    this.urgent_message = rmesg;
                }
                this.queue.add(pos, rmesg);
                DirectByteBuffer[] payload = rmesg.getRawData();
                int remaining = 0;
                int j = 0;
                while (j < payload.length) {
                    remaining += payload[j].remaining((byte)5);
                    ++j;
                }
                this.total_size += remaining;
                if (rmesg.getType() == 1) {
                    this.total_data_size += remaining;
                }
            }
            finally {
                this.queue_mon.exit();
            }
            if (manual_listener_notify) {
                NotificationItem item = new NotificationItem(0);
                item.message = rmesg;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                }
                finally {
                    this.delayed_notifications_mon.exit();
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                int j = 0;
                while (j < listeners_ref.size()) {
                    OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(j);
                    listener.messageQueued(rmesg.getBaseMessage());
                    ++j;
                }
            }
            ++i3;
        }
    }

    @Override
    public void removeMessagesOfType(Message[] message_types, boolean manual_listener_notify) {
        if (message_types == null) {
            return;
        }
        ArrayList<RawMessage> messages_removed = null;
        try {
            this.queue_mon.enter();
            Iterator i = this.queue.iterator();
            block6: while (i.hasNext()) {
                RawMessage msg = (RawMessage)i.next();
                int t = 0;
                while (t < message_types.length) {
                    boolean same_type = message_types[t].getID().equals(msg.getID());
                    if (same_type && msg.getRawData()[0].position((byte)5) == 0) {
                        if (msg == this.urgent_message) {
                            this.urgent_message = null;
                        }
                        DirectByteBuffer[] payload = msg.getRawData();
                        int remaining = 0;
                        int x = 0;
                        while (x < payload.length) {
                            remaining += payload[x].remaining((byte)5);
                            ++x;
                        }
                        this.total_size -= remaining;
                        if (msg.getType() == 1) {
                            this.total_data_size -= remaining;
                        }
                        if (manual_listener_notify) {
                            NotificationItem item = new NotificationItem(1);
                            item.message = msg;
                            try {
                                this.delayed_notifications_mon.enter();
                                this.delayed_notifications.add(item);
                            }
                            finally {
                                this.delayed_notifications_mon.exit();
                            }
                        } else {
                            if (messages_removed == null) {
                                messages_removed = new ArrayList<RawMessage>();
                            }
                            messages_removed.add(msg);
                        }
                        i.remove();
                        continue block6;
                    }
                    ++t;
                }
            }
            if (this.queue.isEmpty()) {
                this.progress = null;
                ++this.progress_id;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (!manual_listener_notify && messages_removed != null) {
            ArrayList listeners_ref = this.listeners;
            int x = 0;
            while (x < messages_removed.size()) {
                RawMessage msg = (RawMessage)messages_removed.get(x);
                int i = 0;
                while (i < listeners_ref.size()) {
                    OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg.getBaseMessage());
                    ++i;
                }
                msg.destroy();
                ++x;
            }
        }
    }

    @Override
    public boolean removeMessage(Message message, boolean manual_listener_notify) {
        Message msg_removed = null;
        try {
            this.queue_mon.enter();
            for (RawMessage raw : this.queue) {
                if (!message.equals(raw.getBaseMessage())) continue;
                if (raw.getRawData()[0].position((byte)5) != 0) break;
                if (raw == this.urgent_message) {
                    this.urgent_message = null;
                }
                DirectByteBuffer[] payload = raw.getRawData();
                int remaining = 0;
                int x = 0;
                while (x < payload.length) {
                    remaining += payload[x].remaining((byte)5);
                    ++x;
                }
                this.total_size -= remaining;
                if (raw.getType() == 1) {
                    this.total_data_size -= remaining;
                }
                this.queue.remove(raw);
                msg_removed = raw;
                break;
            }
            if (this.queue.isEmpty()) {
                this.progress = null;
                ++this.progress_id;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (msg_removed != null) {
            if (manual_listener_notify) {
                NotificationItem item = new NotificationItem(1);
                item.message = msg_removed;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                }
                finally {
                    this.delayed_notifications_mon.exit();
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                int i = 0;
                while (i < listeners_ref.size()) {
                    OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg_removed.getBaseMessage());
                    ++i;
                }
                msg_removed.destroy();
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] deliverToTransport(int max_bytes, boolean protocol_is_free, boolean manual_listener_notify) throws IOException {
        block54: {
            block51: {
                if (max_bytes < 1) {
                    if (!protocol_is_free) {
                        Debug.out("max_bytes < 1: " + max_bytes);
                        return new int[2];
                    }
                    max_bytes = 0;
                }
                if (this.transport == null) {
                    throw new IOException("not ready to deliver data");
                }
                data_written = 0;
                protocol_written = 0;
                messages_sent = null;
                try {
                    this.queue_mon.enter();
                    if (this.queue.isEmpty()) break block51;
                    buffer_limit = 64;
                    raw_buffers = (ByteBuffer[])this.rawBufferCache.get();
                    if (raw_buffers == null) {
                        raw_buffers = new ByteBuffer[buffer_limit];
                        this.rawBufferCache = new WeakReference<Object[]>(raw_buffers);
                    } else {
                        Arrays.fill(raw_buffers, null);
                    }
                    orig_positions = (int[])this.origPositionsCache.get();
                    if (orig_positions == null) {
                        orig_positions = new int[buffer_limit];
                        this.origPositionsCache = new WeakReference<int[]>(orig_positions);
                    } else {
                        Arrays.fill(orig_positions, 0);
                    }
                    buffer_count = 0;
                    total_sofar_excluding_free = 0;
                    total_to_write = 0;
                    block13: for (RawMessage message : this.queue) {
                        msg_is_free = message.getType() == 0 && protocol_is_free != false;
                        payloads = message.getRawData();
                        x = 0;
                        while (x < payloads.length) {
                            buff = payloads[x].getBuffer((byte)5);
                            raw_buffers[buffer_count] = buff;
                            orig_positions[buffer_count] = buff.position();
                            ++buffer_count;
                            rem = buff.remaining();
                            total_to_write += rem;
                            if (!msg_is_free && (total_sofar_excluding_free += rem) >= max_bytes) break block13;
                            if (buffer_count == buffer_limit) {
                                new_buffer_limit = buffer_limit * 2;
                                new_raw_buffers = new ByteBuffer[new_buffer_limit];
                                new_orig_positions = new int[new_buffer_limit];
                                System.arraycopy(raw_buffers, 0, new_raw_buffers, 0, buffer_limit);
                                System.arraycopy(orig_positions, 0, new_orig_positions, 0, buffer_limit);
                                raw_buffers = new_raw_buffers;
                                orig_positions = new_orig_positions;
                                buffer_limit = new_buffer_limit;
                            }
                            ++x;
                        }
                    }
                    last_buff = raw_buffers[buffer_count - 1];
                    orig_last_limit = last_buff.limit();
                    if (total_sofar_excluding_free > max_bytes) {
                        reduce_by = total_sofar_excluding_free - max_bytes;
                        last_buff.limit(orig_last_limit - reduce_by);
                        total_to_write -= reduce_by;
                    }
                    if (total_to_write <= 0) {
                        last_buff.limit(orig_last_limit);
                        var27_40 = new int[2];
                        return var27_40;
                    }
                    this.transport.write((ByteBuffer[])raw_buffers, 0, buffer_count);
                    last_buff.limit(orig_last_limit);
                    pos = 0;
                    stop = false;
                    block15: while (!this.queue.isEmpty() && !stop) {
                        msg = this.queue.get(0);
                        payloads = msg.getRawData();
                        x = 0;
                        while (x < payloads.length) {
                            block53: {
                                bb = payloads[x].getBuffer((byte)5);
                                bytes_written = bb.limit() - bb.remaining() - orig_positions[pos];
                                this.total_size -= bytes_written;
                                if (msg.getType() == 1) {
                                    this.total_data_size -= bytes_written;
                                }
                                if (x > 0 && msg.getType() == 1) {
                                    data_written += bytes_written;
                                } else {
                                    protocol_written += bytes_written;
                                }
                                if (!bb.hasRemaining()) break block53;
                                stop = true;
                                message_size = 0;
                                written = 0;
                                i = 0;
                                if (true) ** GOTO lbl129
                            }
                            if (x == payloads.length - 1) {
                                if (msg == this.urgent_message) {
                                    this.urgent_message = null;
                                }
                                this.queue.remove(0);
                                this.progress = null;
                                ++this.progress_id;
                                if (manual_listener_notify) {
                                    item = new NotificationItem(2);
                                    item.message = msg;
                                    try {
                                        this.delayed_notifications_mon.enter();
                                        this.delayed_notifications.add(item);
                                    }
                                    finally {
                                        this.delayed_notifications_mon.exit();
                                    }
                                } else {
                                    if (messages_sent == null) {
                                        messages_sent = new ArrayList<RawMessage>();
                                    }
                                    messages_sent.add(msg);
                                }
                            }
                            if (++pos >= buffer_count) {
                                stop = true;
                                continue block15;
                            }
                            ++x;
                            continue;
                            do {
                                buff = payloads[i].getBuffer((byte)5);
                                message_size += buff.limit();
                                if (i < x) {
                                    written += buff.limit();
                                } else if (i == x) {
                                    written += buff.position();
                                }
                                ++i;
lbl129:
                                // 2 sources

                            } while (i < payloads.length);
                            this.progress = new int[]{message_size, written, this.progress_id};
                            continue block15;
                        }
                    }
                }
                finally {
                    this.queue_mon.exit();
                }
            }
            if (data_written + protocol_written <= 0 && messages_sent == null) break block54;
            if (this.trace) {
                TimeFormatter.milliTrace("omq:deliver: " + (data_written + protocol_written) + ", q=" + this.queue.size() + "/" + this.total_size);
            }
            if (manual_listener_notify) {
                if (data_written > 0) {
                    item = new NotificationItem(3);
                    item.byte_count = data_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                    }
                    finally {
                        this.delayed_notifications_mon.exit();
                    }
                }
                if (protocol_written <= 0) return new int[]{data_written, protocol_written};
                item = new NotificationItem(4);
                item.byte_count = protocol_written;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                    return new int[]{data_written, protocol_written};
                }
                finally {
                    this.delayed_notifications_mon.exit();
                }
            }
            listeners_ref = this.listeners;
            num_listeners = listeners_ref.size();
            i = 0;
            if (true) ** GOTO lbl189
        }
        if (!this.trace) return new int[]{data_written, protocol_written};
        TimeFormatter.milliTrace("omq:deliver: 0, q=" + this.queue.size() + "/" + this.total_size);
        return new int[]{data_written, protocol_written};
        do {
            listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
            if (data_written > 0) {
                listener.dataBytesSent(data_written);
            }
            if (protocol_written > 0) {
                listener.protocolBytesSent(protocol_written);
            }
            if (messages_sent != null) {
                x = 0;
                while (x < messages_sent.size()) {
                    msg = (RawMessage)messages_sent.get(x);
                    listener.messageSent(msg.getBaseMessage());
                    if (i == num_listeners - 1) {
                        msg.destroy();
                    }
                    ++x;
                }
            }
            ++i;
lbl189:
            // 2 sources

        } while (i < num_listeners);
        return new int[]{data_written, protocol_written};
    }

    @Override
    public void flush() {
        try {
            this.queue_mon.enter();
            if (this.queue.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < this.queue.size()) {
                RawMessage msg = this.queue.get(i);
                msg.setNoDelay();
                if (i == 0) {
                    this.urgent_message = msg;
                }
                ++i;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        ArrayList list_ref = this.listeners;
        int i = 0;
        while (i < list_ref.size()) {
            OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)list_ref.get(i);
            listener.flush();
            ++i;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void doListenerNotifications() {
        ArrayList notifications_copy;
        try {
            this.delayed_notifications_mon.enter();
            if (this.delayed_notifications.size() == 0) {
                return;
            }
            notifications_copy = new ArrayList(this.delayed_notifications);
            this.delayed_notifications.clear();
        }
        finally {
            this.delayed_notifications_mon.exit();
        }
        ArrayList listeners_ref = this.listeners;
        int j = 0;
        while (j < notifications_copy.size()) {
            NotificationItem item = (NotificationItem)notifications_copy.get(j);
            switch (item.type) {
                case 0: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.messageQueued(item.message.getBaseMessage());
                        ++i;
                    }
                    break;
                }
                case 1: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.messageRemoved(item.message.getBaseMessage());
                        ++i;
                    }
                    item.message.destroy();
                    break;
                }
                case 2: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.messageSent(item.message.getBaseMessage());
                        ++i;
                    }
                    item.message.destroy();
                    break;
                }
                case 4: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.protocolBytesSent(item.byte_count);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.dataBytesSent(item.byte_count);
                        ++i;
                    }
                    break;
                }
                default: {
                    Debug.out("NotificationItem.type unknown :" + item.type);
                }
            }
            ++j;
        }
    }

    @Override
    public void setTrace(boolean on) {
        this.trace = on;
        this.transport.setTrace(on);
    }

    @Override
    public String getQueueTrace() {
        StringBuilder trace = new StringBuilder();
        trace.append("**** OUTGOING QUEUE TRACE ****\n");
        try {
            this.queue_mon.enter();
            int i = 0;
            for (RawMessage raw : this.prev_sent) {
                trace.append("[#h").append(i).append("]: ").append(raw.getID()).append(" [").append(raw.getDescription()).append("]").append("\n");
                ++i;
            }
            int position = this.queue.size() - 1;
            for (RawMessage raw : this.queue) {
                int pos = raw.getRawData()[0].position((byte)5);
                int length = raw.getRawData()[0].limit((byte)5);
                trace.append("[#").append(position).append(" ").append(pos).append(":").append(length).append("]: ").append(raw.getID()).append(" [").append(raw.getDescription()).append("]").append("\n");
                --position;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        return trace.toString();
    }

    @Override
    public void registerQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<OutgoingMessageQueue.MessageQueueListener> new_list = new ArrayList<OutgoingMessageQueue.MessageQueueListener>(this.listeners.size() + 1);
            new_list.addAll(this.listeners);
            new_list.add(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void cancelQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList new_list = new ArrayList(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void notifyOfExternallySentMessage(Message message) {
        ArrayList listeners_ref = this.listeners;
        DirectByteBuffer[] buffs = message.getData();
        int size = 0;
        int i = 0;
        while (i < buffs.length) {
            size += buffs[i].remaining((byte)5);
            ++i;
        }
        i = 0;
        while (i < listeners_ref.size()) {
            OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
            listener.messageSent(message);
            if (message.getType() == 1) {
                listener.dataBytesSent(size);
            } else {
                listener.protocolBytesSent(size);
            }
            ++i;
        }
    }

    private static class NotificationItem {
        private static final int MESSAGE_ADDED = 0;
        private static final int MESSAGE_REMOVED = 1;
        private static final int MESSAGE_SENT = 2;
        private static final int DATA_BYTES_SENT = 3;
        private static final int PROTOCOL_BYTES_SENT = 4;
        final int type;
        RawMessage message;
        int byte_count = 0;

        NotificationItem(int notification_type) {
            this.type = notification_type;
        }
    }
}

