/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.RateHandler;
import com.biglybt.core.networkmanager.impl.MultiPeerDownloader2;
import com.biglybt.core.networkmanager.impl.MultiPeerUploader;
import com.biglybt.core.networkmanager.impl.SinglePeerDownloader;
import com.biglybt.core.networkmanager.impl.SinglePeerUploader;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import java.util.HashMap;

public class EntityHandler {
    private final HashMap upgraded_connections = new HashMap();
    private final AEMonitor lock = new AEMonitor("EntityHandler");
    private final MultiPeerUploader global_uploader;
    private final MultiPeerDownloader2 global_downloader;
    private boolean global_registered = false;
    private final int handler_type;
    private final NetworkManager net_man;

    public EntityHandler(NetworkManager _net_man, int type, RateHandler rate_handler) {
        this.net_man = _net_man;
        this.handler_type = type;
        if (this.handler_type == 0) {
            this.global_uploader = new MultiPeerUploader(rate_handler);
            this.global_downloader = null;
        } else {
            this.global_downloader = new MultiPeerDownloader2(rate_handler);
            this.global_uploader = null;
        }
    }

    public void registerPeerConnection(NetworkConnectionBase connection) {
        try {
            this.lock.enter();
            if (!this.global_registered) {
                if (this.handler_type == 0) {
                    this.net_man.addWriteEntity(this.global_uploader, -1);
                } else {
                    this.net_man.addReadEntity(this.global_downloader, -1);
                }
                this.global_registered = true;
            }
            if (this.handler_type == 0) {
                this.global_uploader.addPeerConnection(connection);
            } else {
                this.global_downloader.addPeerConnection(connection);
            }
        }
        finally {
            this.lock.exit();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelPeerConnection(NetworkConnectionBase connection) {
        try {
            this.lock.enter();
            if (connection == null) {
                Debug.out("connection is null");
                return false;
            }
            if (this.handler_type == 0) {
                if (this.global_uploader.removePeerConnection(connection)) return true;
                SinglePeerUploader upload_entity = (SinglePeerUploader)this.upgraded_connections.remove(connection);
                if (upload_entity == null) return false;
                boolean bl = this.net_man.removeWriteEntity(upload_entity);
                return bl;
            }
            if (this.global_downloader.removePeerConnection(connection)) return true;
            SinglePeerDownloader download_entity = (SinglePeerDownloader)this.upgraded_connections.remove(connection);
            if (download_entity == null) return false;
            boolean bl = this.net_man.removeReadEntity(download_entity);
            return bl;
        }
        finally {
            this.lock.exit();
        }
    }

    public void upgradePeerConnection(NetworkConnectionBase connection, RateHandler handler, int partition_id) {
        try {
            this.lock.enter();
            if (connection == null) {
                Debug.out("connection is null");
                return;
            }
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = new SinglePeerUploader(connection, handler);
                if (!this.global_uploader.removePeerConnection(connection)) {
                    Debug.out("upgradePeerConnection:: upload entity not found/removed !");
                }
                this.net_man.addWriteEntity(upload_entity, partition_id);
                this.upgraded_connections.put(connection, upload_entity);
            } else {
                SinglePeerDownloader download_entity = new SinglePeerDownloader(connection, handler);
                if (!this.global_downloader.removePeerConnection(connection)) {
                    Debug.out("upgradePeerConnection:: download entity not found/removed !");
                }
                this.net_man.addReadEntity(download_entity, partition_id);
                this.upgraded_connections.put(connection, download_entity);
            }
        }
        finally {
            this.lock.exit();
        }
    }

    public void downgradePeerConnection(NetworkConnectionBase connection) {
        try {
            this.lock.enter();
            if (connection == null) {
                Debug.out("connection is null");
                return;
            }
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = (SinglePeerUploader)this.upgraded_connections.remove(connection);
                if (upload_entity != null) {
                    this.net_man.removeWriteEntity(upload_entity);
                } else {
                    Debug.out("upload_entity == null");
                }
                this.global_uploader.addPeerConnection(connection);
            } else {
                SinglePeerDownloader download_entity = (SinglePeerDownloader)this.upgraded_connections.remove(connection);
                if (download_entity != null) {
                    this.net_man.removeReadEntity(download_entity);
                } else {
                    Debug.out("download_entity == null");
                }
                this.global_downloader.addPeerConnection(connection);
            }
        }
        finally {
            this.lock.exit();
        }
    }

    public RateHandler getRateHandler(NetworkConnectionBase connection) {
        try {
            this.lock.enter();
            if (connection == null) {
                Debug.out("connection is null");
                return null;
            }
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = (SinglePeerUploader)this.upgraded_connections.get(connection);
                if (upload_entity != null) {
                    RateHandler rateHandler = upload_entity.getRateHandler();
                    return rateHandler;
                }
                RateHandler rateHandler = this.global_uploader.getRateHandler();
                return rateHandler;
            }
            SinglePeerDownloader download_entity = (SinglePeerDownloader)this.upgraded_connections.get(connection);
            if (download_entity != null) {
                RateHandler rateHandler = download_entity.getRateHandler();
                return rateHandler;
            }
            RateHandler rateHandler = this.global_downloader.getRateHandler();
            return rateHandler;
        }
        finally {
            this.lock.exit();
        }
    }
}

