/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.transport.DHTTransport;
import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminImpl;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.ddb.DistributedDatabaseContact;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.net.netstatus.NetStatusPlugin;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTester;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTesterBT;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTesterListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkAdminDistributedNATTester {
    private static final boolean DEBUG = false;
    private static final int CONTACTS_TO_TEST = 8;
    private static final long CHECK_PERIOD = 300000L;
    private static final long NOBIND_CHECK_PERIOD = 3600000L;
    private static final long BIND_CHECK_PERIOD = 10800000L;
    private NetworkAdminImpl admin;
    private DistributedDatabase ddb;
    private DHTPlugin dht_plugin;
    private NetStatusPlugin net_status_plugin;
    private boolean enabled;
    private boolean check_running = false;
    private volatile long last_nobind_check;
    private volatile long last_bind_check;
    private volatile String last_alert = "";

    protected NetworkAdminDistributedNATTester(NetworkAdminImpl _admin, Core _core) {
        this.admin = _admin;
        PluginInterface dht_pi = _core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        PluginInterface net_status_pi = _core.getPluginManager().getPluginInterfaceByClass(NetStatusPlugin.class);
        if (dht_pi != null && net_status_pi != null) {
            AEThread2.createAndStartDaemon("NetworkAdminDistributedNATTester", () -> {
                this.dht_plugin = (DHTPlugin)dht_pi.getPlugin();
                this.net_status_plugin = (NetStatusPlugin)net_status_pi.getPlugin();
                this.ddb = dht_pi.getDistributedDatabase();
                COConfigurationManager.addAndFireParameterListener("IPV6 Enable Multiple Address Checks", name -> {
                    this.enabled = COConfigurationManager.getBooleanParameter(name);
                });
                SimpleTimer.addPeriodicEvent("NetworkAdminDistributedNATTester", 300000L, this::runChecks);
                this.admin.addPropertyChangeListener(property -> {
                    if (property == "Default Bind IP") {
                        this.last_nobind_check = 0L;
                        this.last_bind_check = 0L;
                    }
                });
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runChecks(TimerEvent ev) {
        if (!this.enabled) {
            return;
        }
        NetworkAdminDistributedNATTester networkAdminDistributedNATTester = this;
        synchronized (networkAdminDistributedNATTester) {
            if (this.check_running) {
                return;
            }
            this.check_running = true;
        }
        boolean async = false;
        this.logMessage("Running checks");
        try {
            NetworkAdminNetworkInterface[] interfaces = this.admin.getInterfaces();
            ArrayList<InetAddress> global_ipv6 = new ArrayList<InetAddress>();
            NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                NetworkAdminNetworkInterfaceAddress[] addresses;
                NetworkAdminNetworkInterface intf = networkAdminNetworkInterfaceArray[n2];
                NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = addresses = intf.getAddresses();
                int n3 = addresses.length;
                int n4 = 0;
                while (n4 < n3) {
                    NetworkAdminNetworkInterfaceAddress address = networkAdminNetworkInterfaceAddressArray[n4];
                    InetAddress a = address.getAddress();
                    if (AddressUtils.isGlobalAddressV6(a)) {
                        global_ipv6.add(a);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (global_ipv6.size() > 1) {
                DHT[] dhts = this.dht_plugin.getDHTs();
                DHT target_dht = null;
                int i = 0;
                while (i < dhts.length) {
                    if (dhts[i].getTransport().getNetwork() == 3) {
                        target_dht = dhts[i];
                        break;
                    }
                    ++i;
                }
                if (target_dht != null) {
                    DHTTransport transport = target_dht.getTransport();
                    InetAddress bind_address = transport.getCurrentBindAddress();
                    if (bind_address == null) {
                        this.logMessage("DHT bind address invalid, not testing");
                    } else if (!bind_address.isAnyLocalAddress()) {
                        this.logMessage("DHT already bound, not testing");
                    } else {
                        DHT f_target_dht = target_dht;
                        AEThread2.createAndStartDaemon("DistributedNATCheck", () -> {
                            try {
                                this.test(f_target_dht, global_ipv6);
                            }
                            catch (Throwable throwable) {
                                NetworkAdminDistributedNATTester networkAdminDistributedNATTester = this;
                                synchronized (networkAdminDistributedNATTester) {
                                    this.check_running = false;
                                }
                                throw throwable;
                            }
                            NetworkAdminDistributedNATTester networkAdminDistributedNATTester = this;
                            synchronized (networkAdminDistributedNATTester) {
                                this.check_running = false;
                            }
                        });
                        async = true;
                    }
                } else {
                    this.logMessage("No DHT");
                }
            } else {
                this.logMessage("Insufficient V6 addresses");
            }
        }
        catch (Throwable throwable) {
            if (!async) {
                NetworkAdminDistributedNATTester networkAdminDistributedNATTester2 = this;
                synchronized (networkAdminDistributedNATTester2) {
                    this.check_running = false;
                }
            }
            throw throwable;
        }
        if (!async) {
            NetworkAdminDistributedNATTester networkAdminDistributedNATTester3 = this;
            synchronized (networkAdminDistributedNATTester3) {
                this.check_running = false;
            }
        }
    }

    private void test(DHT dht, List<InetAddress> addresses) {
        long now = SystemTime.getMonotonousTime();
        if (this.last_nobind_check > 0L && now - this.last_nobind_check < 3600000L) {
            return;
        }
        int result = this.testSupport(dht, null);
        this.logMessage("No bind result: " + result);
        if (result != 0) {
            this.last_nobind_check = now;
            if (result != 1) {
                if (this.last_bind_check > 0L && now - this.last_bind_check < 10800000L) {
                    return;
                }
                this.last_bind_check = now;
                ArrayList<InetAddress> working = new ArrayList<InetAddress>();
                ArrayList<InetAddress> not_working = new ArrayList<InetAddress>();
                for (InetAddress a : addresses) {
                    result = this.testSupport(dht, a);
                    this.logMessage("Bind to " + a + " result " + result);
                    if (result == 1) {
                        working.add(a);
                        continue;
                    }
                    if (result != 2) continue;
                    not_working.add(a);
                }
                InetAddress dht_address = dht.getTransport().getLocalContact().getAddress().getAddress();
                if (not_working.contains(dht_address) && !working.isEmpty()) {
                    String dht_str = dht_address.getHostAddress();
                    String ok_str = "";
                    for (InetAddress a : working) {
                        ok_str = String.valueOf(ok_str) + (ok_str.isEmpty() ? "" : ", ") + a.getHostAddress();
                    }
                    String alert = String.valueOf(dht_str) + ok_str;
                    if (!this.last_alert.equals(alert)) {
                        this.last_alert = alert;
                        LogAlert la = new LogAlert(true, 1, MessageText.getString("network.admin.multiple.global.ipv6.issue", new String[]{dht_str, ok_str}));
                        la.forceNotify = true;
                        Logger.log(la);
                    }
                }
            }
        }
    }

    private int testSupport(DHT dht, InetAddress bind_address) {
        AtomicBoolean got_incoming;
        AtomicBoolean got_outgoing;
        block15: {
            DHTTransport transport = dht.getTransport();
            DHTTransportContact[] contacts = dht.getTransport().getReachableContacts();
            if (contacts.length < 8) {
                return 0;
            }
            this.logMessage("Testing " + dht + " against " + bind_address);
            NetStatusProtocolTester pt = this.net_status_plugin.getProtocolTester();
            got_outgoing = new AtomicBoolean();
            got_incoming = new AtomicBoolean();
            NetStatusProtocolTesterBT tester = pt.createTester(new NetStatusProtocolTesterListener(){

                @Override
                public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                    boolean outgoing = session.isInitiator();
                    NetworkAdminDistributedNATTester.this.logMessage("Added, initiator=" + outgoing);
                    if (outgoing) {
                        got_outgoing.set(true);
                    } else {
                        got_incoming.set(true);
                    }
                }

                @Override
                public void complete(NetStatusProtocolTesterBT tester) {
                    NetworkAdminDistributedNATTester.this.logMessage("Complete");
                }

                @Override
                public void log(String str, boolean is_detailed) {
                    NetworkAdminDistributedNATTester.this.logMessage(str);
                }

                @Override
                public void logError(String str) {
                    NetworkAdminDistributedNATTester.this.logMessage(str);
                }

                @Override
                public void logError(String str, Throwable e) {
                    NetworkAdminDistributedNATTester.this.logMessage(str);
                }
            });
            if (bind_address != null) {
                tester.setBindIP(bind_address);
                transport.setExplicitBindAddress(bind_address, true);
            }
            try {
                try {
                    int tried = 0;
                    DHTTransportContact[] dHTTransportContactArray = contacts;
                    int n = contacts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DHTTransportContact contact = dHTTransportContactArray[n2];
                        if (!got_incoming.get() && ++tried <= 8) {
                            DistributedDatabaseContact ddb_contact = this.ddb.importContact(contact.getAddress());
                            if (pt.tryTest(tester, ddb_contact)) {
                                Thread.sleep(5000L);
                            }
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    tester.destroy();
                    if (bind_address != null) {
                        transport.setExplicitBindAddress(null, true);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                tester.destroy();
                if (bind_address != null) {
                    transport.setExplicitBindAddress(null, true);
                }
                throw throwable;
            }
            tester.destroy();
            if (bind_address != null) {
                transport.setExplicitBindAddress(null, true);
            }
        }
        if (got_incoming.get()) {
            return 1;
        }
        if (got_outgoing.get()) {
            return 2;
        }
        return 3;
    }

    private void logMessage(String str) {
    }
}

