/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class NetworkAdminASNLookupImpl {
    private static final String WHOIS_ADDRESS = "whois.cymru.com";
    private static final int WHOIS_PORT = 43;
    private static final int TIMEOUT = 30000;
    private final InetAddress address;

    protected NetworkAdminASNLookupImpl(InetAddress _address) {
        this.address = _address;
    }

    protected NetworkAdminASNImpl lookup() throws NetworkAdminException {
        return this.lookupDNS(this.address);
    }

    protected NetworkAdminASNImpl lookupTCP(InetAddress address) throws NetworkAdminException {
        NetworkAdminASNImpl networkAdminASNImpl;
        Socket socket = new Socket();
        int timeout = 30000;
        long start = SystemTime.getCurrentTime();
        socket.connect(new InetSocketAddress(WHOIS_ADDRESS, 43), timeout);
        long end = SystemTime.getCurrentTime();
        timeout = (int)((long)timeout - (end - start));
        if (timeout <= 0) {
            throw new NetworkAdminException("Timeout on connect");
        }
        if (timeout > 30000) {
            timeout = 30000;
        }
        socket.setSoTimeout(timeout);
        try {
            int len;
            OutputStream os = socket.getOutputStream();
            String command = "-u -p " + address.getHostAddress() + "\r\n";
            os.write(command.getBytes());
            os.flush();
            InputStream is = socket.getInputStream();
            byte[] buffer = new byte[1024];
            String result = "";
            while ((len = is.read(buffer)) > 0) {
                result = String.valueOf(result) + new String(buffer, 0, len);
            }
            networkAdminASNImpl = this.processResult(address instanceof Inet4Address, result);
        }
        catch (Throwable throwable) {
            try {
                socket.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new NetworkAdminException("whois connection failed", e);
            }
        }
        socket.close();
        return networkAdminASNImpl;
    }

    protected NetworkAdminASNImpl lookupDNS(InetAddress address) throws NetworkAdminException {
        int i;
        byte[] bytes = address.getAddress();
        StringBuilder ip_query = new StringBuilder(64);
        if (address instanceof Inet4Address) {
            i = 3;
            while (i >= 0) {
                ip_query.append(String.valueOf(bytes[i] & 0xFF));
                ip_query.append(".");
                --i;
            }
            ip_query.append("origin.asn.cymru.com");
        } else {
            i = 15;
            while (i >= 0) {
                byte b = bytes[i];
                ip_query.append(Integer.toHexString(b & 0xF));
                ip_query.append(".");
                ip_query.append(Integer.toHexString(b >> 4 & 0xF));
                ip_query.append(".");
                --i;
            }
            ip_query.append("origin6.asn.cymru.com");
        }
        String ip_result = this.lookupDNS(ip_query.toString());
        NetworkAdminASNImpl result = this.processResult(address instanceof Inet4Address, "AS | BGP Prefix | CC | Reg | Date | AS Name\n" + ip_result + " | n/a");
        String as = result.getAS();
        if (as.length() > 0) {
            String asn_query = "AS" + as + ".asn.cymru.com";
            try {
                int pos;
                String asn_result = this.lookupDNS(asn_query);
                if (asn_result != null && (pos = asn_result.lastIndexOf(124)) != -1) {
                    String asn = asn_result.substring(pos + 1).trim();
                    result.setASName(asn);
                }
            }
            catch (Throwable e) {
                Debug.outNoStack("ASN lookup " + address + " (" + ip_result + ") for '" + asn_query + "' failed: " + e.getMessage());
            }
        }
        return result;
    }

    protected String lookupDNS(String query) throws NetworkAdminException {
        DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
        if (dns_utils == null) {
            throw new NetworkAdminException("DNS lookup unavailable");
        }
        try {
            return dns_utils.getTXTRecord(query);
        }
        catch (UnknownHostException e) {
            throw new NetworkAdminException("Query failed for '" + query + "'", e);
        }
    }

    protected NetworkAdminASNImpl processResult(boolean ipv4, String result) {
        int pos;
        StringTokenizer lines = new StringTokenizer(result, "\n");
        int line_number = 0;
        ArrayList<String> keywords = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        block0: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (++line_number > 2) break;
            StringTokenizer tok = new StringTokenizer(line, "|");
            int token_number = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                if (line_number == 1) {
                    keywords.add(token.toLowerCase(MessageText.LOCALE_ENGLISH));
                } else {
                    if (token_number >= keywords.size()) continue block0;
                    String kw = (String)keywords.get(token_number);
                    map.put(kw, token);
                }
                ++token_number;
            }
        }
        String as = (String)map.get("as");
        if (as != null && (pos = as.indexOf(" ")) > 0) {
            as = as.substring(0, pos).trim();
        }
        String asn = (String)map.get("as name");
        String bgp_prefix = (String)map.get("bgp prefix");
        if (bgp_prefix != null) {
            int pos2 = bgp_prefix.indexOf(32);
            if (pos2 != -1) {
                bgp_prefix = bgp_prefix.substring(pos2 + 1).trim();
            }
            if (bgp_prefix.indexOf(47) == -1) {
                bgp_prefix = null;
            }
        }
        return new NetworkAdminASNImpl(ipv4, as, asn, bgp_prefix);
    }

    public static void main(String[] args) {
        try {
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(InetAddress.getByName("2a00:23c4:aeac:400:8d1d:ec9d:6107:5520"));
            NetworkAdminASNImpl asn = lookup.lookup();
            System.out.println(asn.getString());
            System.out.println(asn.matchesCIDR(InetAddress.getByName("2a00:2404:aeac:400:8d1d:ec9d:6107:5520")));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

