/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.networkmanager.VirtualServerChannelSelector;
import com.biglybt.core.networkmanager.impl.tcp.VirtualBlockingServerChannelSelector;
import com.biglybt.core.networkmanager.impl.tcp.VirtualNonBlockingServerChannelSelector;
import java.net.InetSocketAddress;

public class VirtualServerChannelSelectorFactory {
    public static VirtualServerChannelSelector createBlocking(InetSocketAddress bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        return new VirtualBlockingServerChannelSelector(bind_address, so_rcvbuf_size, listener);
    }

    public static VirtualServerChannelSelector createNonBlocking(InetSocketAddress bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        return new VirtualNonBlockingServerChannelSelector(bind_address, so_rcvbuf_size, listener);
    }

    public static VirtualServerChannelSelector createTest(InetSocketAddress bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        int range = COConfigurationManager.getIntParameter("TCP.Listen.Port.Range", -1);
        if (range == -1) {
            return VirtualServerChannelSelectorFactory.createBlocking(bind_address, so_rcvbuf_size, listener);
        }
        return new VirtualNonBlockingServerChannelSelector(bind_address.getAddress(), bind_address.getPort(), range, so_rcvbuf_size, listener);
    }
}

