/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.metasearch.impl.web.rss;

import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.metasearch.ResultListener;
import com.biglybt.core.metasearch.SearchException;
import com.biglybt.core.metasearch.SearchParameter;
import com.biglybt.core.metasearch.impl.EngineImpl;
import com.biglybt.core.metasearch.impl.MetaSearchImpl;
import com.biglybt.core.metasearch.impl.web.FieldMapping;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.metasearch.impl.web.WebResult;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.xml.rss.RSSChannel;
import com.biglybt.pif.utils.xml.rss.RSSFeed;
import com.biglybt.pif.utils.xml.rss.RSSItem;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;

public class RSSEngine
extends WebEngine {
    private Pattern seed_leecher_pat = Pattern.compile("([0-9]+)\\s+(seed|leecher)s", 2);
    private Pattern size_pat = Pattern.compile("([0-9\\.]+)\\s+(B|KB|KiB|MB|MiB|GB|GiB|TB|TiB)", 2);

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new RSSEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new RSSEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public RSSEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 4, id, last_updated, rank_bias, name, searchURLFormat, "GMT", false, "EEE, d MMM yyyy HH:mm:ss Z", new FieldMapping[0], needs_auth, auth_method, login_url, required_cookies);
    }

    protected RSSEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
    }

    protected RSSEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 1, id, last_updated, rank_bias, name, map);
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        super.exportToBencodedMap(res, generic);
        return res;
    }

    @Override
    public boolean supportsField(int field_id) {
        switch (field_id) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 102: 
            case 103: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getAutoDownloadSupported() {
        return (int)this.getLocalLong("auto_dl_supported", 0L);
    }

    @Override
    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        boolean only_if_mod = !searchContext.containsKey("force_full");
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, only_if_mod, new WebEngine.pageDetailsVerifier(){

            @Override
            public void verify(WebEngine.pageDetails details) throws SearchException {
                try {
                    String page = details.getContent();
                    if (page != null && page.length() > 0) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(page.getBytes("UTF-8"));
                        RSSFeed rssFeed = StaticUtilities.getRSSFeed(details.getInitialURL(), bais);
                        details.setVerifiedState(rssFeed);
                    }
                }
                catch (Throwable e) {
                    RSSEngine.this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
                    if (e instanceof SearchException) {
                        throw (SearchException)e;
                    }
                    throw new SearchException("RSS matching failed", e);
                }
            }
        });
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        if (page == null || page.length() == 0) {
            return new Result[0];
        }
        try {
            RSSFeed rssFeed = (RSSFeed)page_details.getVerifiedState();
            RSSChannel[] channels = rssFeed.getChannels();
            ArrayList<WebResult> results = new ArrayList<WebResult>();
            int i = 0;
            while (i < channels.length) {
                RSSChannel channel2 = channels[i];
                SimpleXMLParserDocumentNode[] channel_kids = channel2.getNode().getChildren();
                int auto_dl_state = 1;
                int j = 0;
                while (j < channel_kids.length) {
                    SimpleXMLParserDocumentNode child = channel_kids[j];
                    String lc_full_child_name = child.getFullName().toLowerCase();
                    if (lc_full_child_name.equals("vuze:auto_dl_enabled") && !child.getValue().equalsIgnoreCase("true")) {
                        auto_dl_state = 2;
                    }
                    ++j;
                }
                this.setLocalLong("auto_dl_supported", auto_dl_state);
                RSSItem[] items = channel2.getItems();
                int j2 = 0;
                while (j2 < items.length) {
                    String magnet;
                    String name;
                    String dlink;
                    String existing;
                    SimpleXMLParserDocumentNode n;
                    String lc_child_name;
                    SimpleXMLParserDocumentNode child;
                    SimpleXMLParserDocumentNode[] children;
                    SimpleXMLParserDocumentNode node;
                    String potential_cdp_link;
                    String desc_size;
                    String item_magnet;
                    String item_hash;
                    boolean got_seeds_peers;
                    String uid;
                    WebResult result;
                    block129: {
                        String link_url;
                        String lc_url;
                        RSSItem item = items[j2];
                        result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), "");
                        result.setPublishedDate(item.getPublicationDate());
                        result.setNameFromHTML(item.getTitle());
                        URL cdp_link = item.getLink();
                        boolean cdp_set = false;
                        if (cdp_link != null && ((lc_url = (link_url = cdp_link.toExternalForm()).toLowerCase(Locale.US)).startsWith("http") || lc_url.startsWith("tor:http") || lc_url.startsWith("i2p:http"))) {
                            result.setCDPLink(link_url);
                            cdp_set = true;
                        }
                        if ((uid = item.getUID()) != null) {
                            result.setUID(uid);
                            if (!cdp_set) {
                                try {
                                    String test_url = new URL(uid).toExternalForm();
                                    if (test_url.toLowerCase().startsWith("http")) {
                                        result.setCDPLink(test_url);
                                    }
                                }
                                catch (Throwable test_url) {
                                    // empty catch block
                                }
                            }
                        }
                        got_seeds_peers = false;
                        int item_seeds = -1;
                        int item_peers = -1;
                        item_hash = null;
                        item_magnet = null;
                        desc_size = null;
                        potential_cdp_link = null;
                        node = item.getNode();
                        children = node.getChildren();
                        boolean vuze_feed = false;
                        int k = 0;
                        while (k < children.length) {
                            child = children[k];
                            String lc_full_child_name = child.getFullName().toLowerCase();
                            if (lc_full_child_name.startsWith("vuze:")) {
                                vuze_feed = true;
                                break;
                            }
                            ++k;
                        }
                        k = 0;
                        while (k < children.length) {
                            block128: {
                                String value;
                                String lc_full_child_name;
                                block134: {
                                    block133: {
                                        block132: {
                                            block131: {
                                                block130: {
                                                    child = children[k];
                                                    lc_child_name = child.getName().toLowerCase();
                                                    lc_full_child_name = child.getFullName().toLowerCase();
                                                    value = child.getValue().trim();
                                                    if (!lc_child_name.equals("enclosure")) break block130;
                                                    SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                                    if (typeAtt != null && typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent")) {
                                                        SimpleXMLParserDocumentAttribute lengthAtt;
                                                        SimpleXMLParserDocumentAttribute urlAtt = child.getAttribute("url");
                                                        if (urlAtt != null) {
                                                            result.setTorrentLink(urlAtt.getValue());
                                                        }
                                                        if ((lengthAtt = child.getAttribute("length")) != null) {
                                                            result.setSizeFromHTML(lengthAtt.getValue());
                                                        }
                                                    }
                                                    break block128;
                                                }
                                                if (!lc_child_name.equals("category")) break block131;
                                                result.setCategoryFromHTML(value);
                                                break block128;
                                            }
                                            if (!lc_child_name.equals("tag")) break block132;
                                            result.addTagFromHTML(value);
                                            break block128;
                                        }
                                        if (!lc_child_name.equals("comments")) break block133;
                                        if (value.startsWith("http")) {
                                            try {
                                                String test_url = new URL(value).toExternalForm();
                                                if (test_url.toLowerCase().startsWith("http")) {
                                                    potential_cdp_link = test_url;
                                                }
                                            }
                                            catch (Throwable test_url) {
                                                // empty catch block
                                            }
                                        }
                                        result.setCommentsFromHTML(value);
                                        break block128;
                                    }
                                    if (!lc_child_name.equals("link") && !lc_child_name.equals("guid")) break block134;
                                    String lc_value = value.toLowerCase();
                                    try {
                                        URL url = new URL(value);
                                        if (lc_value.endsWith(".torrent") || lc_value.startsWith("magnet:") || lc_value.startsWith("bc:") || lc_value.startsWith("bctp:") || lc_value.startsWith("dht:")) {
                                            result.setTorrentLink(value);
                                            break block128;
                                        }
                                        if (!lc_child_name.equals("link") || vuze_feed) break block128;
                                        long test = this.getLocalLong("link_is_torrent", 0L);
                                        if (test == 1L) {
                                            result.setTorrentLink(value);
                                            break block128;
                                        }
                                        if (test != 0L && SystemTime.getCurrentTime() - test <= 60000L) break block128;
                                        if (this.linkIsToTorrent(url)) {
                                            result.setTorrentLink(value);
                                            this.setLocalLong("link_is_torrent", 1L);
                                            break block128;
                                        }
                                        this.setLocalLong("link_is_torrent", SystemTime.getCurrentTime());
                                    }
                                    catch (Throwable e) {
                                        SimpleXMLParserDocumentAttribute hrefAtt;
                                        SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                        if (typeAtt == null || !typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent") || (hrefAtt = child.getAttribute("href")) == null) break block128;
                                        String href = hrefAtt.getValue().trim();
                                        try {
                                            result.setTorrentLink(new URL(href).toExternalForm());
                                            break block128;
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    break block128;
                                }
                                if (lc_child_name.equals("content") && rssFeed.isAtomFeed()) {
                                    String src;
                                    SimpleXMLParserDocumentAttribute srcAtt = child.getAttribute("src");
                                    String string = src = srcAtt == null ? null : srcAtt.getValue();
                                    if (src != null) {
                                        boolean is_dl_link = false;
                                        SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                        if (typeAtt != null && typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent")) {
                                            is_dl_link = true;
                                        }
                                        if (!is_dl_link) {
                                            is_dl_link = src.toLowerCase().contains(".torrent");
                                        }
                                        if (is_dl_link) {
                                            try {
                                                new URL(src);
                                                result.setTorrentLink(src);
                                            }
                                            catch (Throwable throwable) {}
                                        }
                                    }
                                } else if (lc_full_child_name.equals("vuze:size")) {
                                    result.setSizeFromHTML(value);
                                } else if (lc_full_child_name.equals("vuze:seeds")) {
                                    got_seeds_peers = true;
                                    result.setNbSeedsFromHTML(value);
                                } else if (lc_full_child_name.equals("vuze:superseeds")) {
                                    got_seeds_peers = true;
                                    result.setNbSuperSeedsFromHTML(value);
                                } else if (lc_full_child_name.equals("vuze:peers")) {
                                    got_seeds_peers = true;
                                    result.setNbPeersFromHTML(value);
                                } else if (lc_full_child_name.equals("vuze:rank")) {
                                    result.setRankFromHTML(value);
                                } else if (lc_full_child_name.equals("vuze:contenttype")) {
                                    String type = value.toLowerCase();
                                    if (type.startsWith("video")) {
                                        type = "video";
                                    } else if (type.startsWith("audio")) {
                                        type = "audio";
                                    } else if (type.startsWith("games")) {
                                        type = "game";
                                    }
                                    result.setContentType(type);
                                } else if (lc_full_child_name.equals("vuze:downloadurl")) {
                                    result.setTorrentLink(value);
                                } else if (lc_full_child_name.equals("vuze:playurl")) {
                                    result.setPlayLink(value);
                                } else if (lc_full_child_name.equals("vuze:drmkey")) {
                                    result.setDrmKey(value);
                                } else if (lc_full_child_name.equals("vuze:assethash")) {
                                    result.setHash(value);
                                } else if (lc_full_child_name.equals("vuze:assetdate")) {
                                    result.setAssetDate(value);
                                } else if (lc_child_name.equals("seeds") || lc_child_name.equals("seeders")) {
                                    try {
                                        item_seeds = Integer.parseInt(value);
                                    }
                                    catch (Throwable type) {}
                                } else if (lc_child_name.equals("peers") || lc_child_name.equals("leechers")) {
                                    try {
                                        item_peers = Integer.parseInt(value);
                                    }
                                    catch (Throwable type) {}
                                } else if (lc_child_name.equals("infohash") || lc_child_name.equals("info_hash")) {
                                    item_hash = value;
                                } else if (lc_child_name.equals("magneturi")) {
                                    item_magnet = value;
                                }
                            }
                            ++k;
                        }
                        if (!got_seeds_peers && item_peers >= 0 && item_seeds >= 0) {
                            result.setNbSeedsFromHTML(String.valueOf(item_seeds));
                            result.setNbPeersFromHTML(String.valueOf(item_peers));
                            got_seeds_peers = true;
                        }
                        if (!got_seeds_peers) {
                            try {
                                SimpleXMLParserDocumentNode desc_node = node.getChild("description");
                                if (desc_node != null) {
                                    String desc = desc_node.getValue().trim();
                                    desc = desc.replaceAll("\\(s\\)", "s");
                                    desc = desc.replaceAll("seeders", "seeds");
                                    Matcher m = this.seed_leecher_pat.matcher(desc);
                                    while (m.find()) {
                                        String num = m.group(1);
                                        String type = m.group(2);
                                        if (type.toLowerCase().charAt(0) == 's') {
                                            result.setNbSeedsFromHTML(num);
                                            continue;
                                        }
                                        result.setNbPeersFromHTML(num);
                                    }
                                    m = this.size_pat.matcher(desc);
                                    if (m.find()) {
                                        desc_size = String.valueOf(m.group(1)) + " " + m.group(2);
                                    }
                                }
                            }
                            catch (Throwable desc_node) {
                                // empty catch block
                            }
                        }
                        try {
                            SimpleXMLParserDocumentNode trackers_node;
                            SimpleXMLParserDocumentNode n2;
                            String hash;
                            SimpleXMLParserDocumentNode n3;
                            String dlink2;
                            SimpleXMLParserDocumentNode n4;
                            SimpleXMLParserDocumentNode torrent_node = node.getChild("torrent");
                            if (torrent_node == null) break block129;
                            if (result.getSize() <= 0L && (n4 = torrent_node.getChild("contentLength")) != null) {
                                try {
                                    long l = Long.parseLong(n4.getValue().trim());
                                    result.setSizeFromHTML(String.valueOf(l) + " B");
                                }
                                catch (Throwable l) {
                                    // empty catch block
                                }
                            }
                            if (((dlink2 = result.getDownloadLink()) == null || dlink2.length() == 0) && (n3 = torrent_node.getChild("magnetURI")) != null) {
                                dlink2 = n3.getValue().trim();
                                result.setTorrentLink(dlink2);
                            }
                            if (((hash = result.getHash()) == null || hash.length() == 0) && (n2 = torrent_node.getChild("infoHash")) != null) {
                                String uri;
                                String h = n2.getValue().trim();
                                result.setHash(h);
                                if ((dlink2 == null || dlink2.length() == 0) && (uri = UrlUtils.normaliseMagnetURI(h)) != null) {
                                    result.setTorrentLink(uri);
                                }
                            }
                            if ((trackers_node = torrent_node.getChild("trackers")) != null && !got_seeds_peers) {
                                SimpleXMLParserDocumentNode[] groups = trackers_node.getChildren();
                                int max_total = -1;
                                int best_seeds = 0;
                                int best_leechers = 0;
                                SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = groups;
                                int n5 = groups.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    SimpleXMLParserDocumentNode[] g_kids;
                                    SimpleXMLParserDocumentNode group = simpleXMLParserDocumentNodeArray[n6];
                                    SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray2 = g_kids = group.getChildren();
                                    int n7 = g_kids.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        SimpleXMLParserDocumentAttribute a_leechers;
                                        int leechers;
                                        SimpleXMLParserDocumentAttribute a_seeds;
                                        int seeds;
                                        int total;
                                        SimpleXMLParserDocumentNode t = simpleXMLParserDocumentNodeArray2[n8];
                                        if (t.getName().equalsIgnoreCase("tracker") && (total = (seeds = (a_seeds = t.getAttribute("seeds")) == null ? -1 : Integer.parseInt(a_seeds.getValue().trim())) + (leechers = (a_leechers = t.getAttribute("peers")) == null ? -1 : Integer.parseInt(a_leechers.getValue().trim()))) > max_total) {
                                            max_total = total;
                                            best_seeds = seeds;
                                            best_leechers = leechers;
                                        }
                                        ++n8;
                                    }
                                    ++n6;
                                }
                                if (max_total >= 0) {
                                    result.setNbSeedsFromHTML(String.valueOf(Math.max(0, best_seeds)));
                                    result.setNbPeersFromHTML(String.valueOf(Math.max(0, best_leechers)));
                                    got_seeds_peers = true;
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        int k = 0;
                        while (k < children.length) {
                            child = children[k];
                            lc_child_name = child.getName().toLowerCase();
                            if (lc_child_name.equals("attr")) {
                                SimpleXMLParserDocumentAttribute attr_name = child.getAttribute("name");
                                SimpleXMLParserDocumentAttribute attr_value = child.getAttribute("value");
                                if (attr_name != null && attr_value != null) {
                                    String name2 = attr_name.getValue();
                                    String value = attr_value.getValue();
                                    if (name2.equals("seeders")) {
                                        if (!got_seeds_peers) {
                                            result.setNbSeedsFromHTML(value);
                                        }
                                    } else if (name2.equals("peers")) {
                                        if (!got_seeds_peers) {
                                            result.setNbPeersFromHTML(value);
                                        }
                                    } else if (name2.equals("infohash")) {
                                        if (item_hash == null) {
                                            item_hash = value;
                                        }
                                    } else if (name2.equals("magneturl") && item_magnet == null) {
                                        item_magnet = value;
                                    }
                                }
                            }
                            ++k;
                        }
                    }
                    catch (Throwable k) {
                        // empty catch block
                    }
                    if (result.getSize() <= 0L && (n = node.getChild("size")) != null) {
                        result.setSizeFromHTML(n.getValue().trim());
                    }
                    if (item_hash != null && result.getHash() == null) {
                        result.setHash(item_hash);
                    }
                    if (item_magnet != null && ((existing = result.getTorrentLinkRaw()) == null || existing.length() == 0)) {
                        result.setTorrentLink(item_magnet);
                    }
                    if (((dlink = result.getDownloadLink()) == null || dlink.length() == 0) && (name = result.getName()) != null && (magnet = UrlUtils.parseTextForMagnets(name)) != null) {
                        result.setTorrentLink(magnet);
                    }
                    if ((dlink = result.getDownloadLink()) == null || dlink.length() == 0) {
                        result.setTorrentLink(result.getCDPLink());
                    }
                    String latest_cdp_link = result.getCDPLink();
                    String latest_torrent_link = result.getTorrentLink();
                    if (latest_cdp_link == null || latest_cdp_link.isEmpty() || latest_cdp_link.length() > 0 && latest_cdp_link.equals(latest_torrent_link)) {
                        try {
                            String test_url = new URL(uid).toExternalForm();
                            if (test_url.toLowerCase().startsWith("http")) {
                                result.setCDPLink(test_url);
                                potential_cdp_link = null;
                            }
                        }
                        catch (Throwable test_url) {
                            // empty catch block
                        }
                        if (potential_cdp_link != null) {
                            result.setCDPLink(potential_cdp_link);
                        }
                    }
                    if (result.getSize() <= 0L && desc_size != null) {
                        result.setSizeFromHTML(desc_size);
                    }
                    if (result.getHash() == null && dlink != null) {
                        byte[] hash;
                        String tlink;
                        String mag = UrlUtils.parseTextForMagnets(dlink);
                        if (mag == null && (tlink = result.getTorrentLinkRaw()) != null) {
                            mag = UrlUtils.parseTextForMagnets(tlink);
                        }
                        if (mag != null && (hash = UrlUtils.getTruncatedHashFromMagnetURI(mag)) != null) {
                            result.setHash(ByteFormatter.encodeString(hash));
                        }
                    }
                    results.add(result);
                    if (absolute_max_matches >= 0 && results.size() == absolute_max_matches) break;
                    ++j2;
                }
                ++i;
            }
            Result[] res = results.toArray(new Result[results.size()]);
            this.debugLog("success: found " + res.length + " results");
            return res;
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException("RSS matching failed", e);
        }
    }

    protected boolean linkIsToTorrent(URL url) {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            String content_type = con.getContentType();
            if (content_type != null) {
                this.log("Testing link " + url + " to see if torrent link -> content type=" + content_type);
                if (content_type.equalsIgnoreCase("application/x-bittorrent")) {
                    return true;
                }
            }
        }
        finally {
            return false;
        }
    }
}

