/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.metasearch.impl.web;

import java.util.regex.Pattern;

public class FieldMapping {
    private final String postFilter;
    private final boolean postFilterRequiresSearchQuery;
    private String name;
    private int field;
    private Pattern postFilterPattern;

    public FieldMapping(String name, int field, String postFilter) {
        this.name = name;
        this.field = field;
        this.postFilter = postFilter;
        this.postFilterRequiresSearchQuery = postFilter != null && postFilter.contains("%s");
    }

    public String getName() {
        return this.name;
    }

    public int getField() {
        return this.field;
    }

    public Pattern getPostFilterPattern(String searchQuery) {
        if (this.postFilter == null) {
            return null;
        }
        if (this.postFilterPattern == null || this.postFilterRequiresSearchQuery && !this.postFilterPattern.pattern().contains("\\\\Q" + searchQuery + "\\\\E")) {
            this.postFilterPattern = Pattern.compile(this.postFilterRequiresSearchQuery ? this.postFilter.replaceAll("%s", Pattern.quote(searchQuery)) : this.postFilter, 66);
        }
        return this.postFilterPattern;
    }

    public String getPostFilter() {
        return this.postFilter;
    }
}

