/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.metasearch.impl;

import com.biglybt.core.metasearch.impl.DateParser;
import com.biglybt.core.metasearch.impl.DateParserClassic;
import com.biglybt.core.util.SystemTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateParserRegex
extends DateParser {
    static boolean DEBUG = false;
    TimeZone timeZone;
    DateFormat userDateFormat;
    boolean auto;
    private static final Pattern hasLettersPattern = Pattern.compile("(?i).*[a-z]");
    private static final Pattern isAgeBasedPattern = Pattern.compile("(?i)(ago)|(min)|(hour)|(day)|(week)|(month)|(year)|([0-9](h|d|w|m|y))");
    private static final Map<String, Pattern> isAgeBasedPatternCN = new HashMap<String, Pattern>();
    private static final Pattern getTimeComponent = Pattern.compile("(?i)([0-9]{2}):([0-9]{2})(:([0-9]{2}))?( ?(a|p)m)?");
    private static final Pattern timeBasedDateWithLettersPattern = Pattern.compile("(?i)([0-9]{1,2})[^ ]{0,2}(?: |-)([a-z]{3,10})\\.?(?: |-)?([0-9]{2,4})?");
    private static final Pattern timeBasedDateWithLettersPatternMonthFirst = Pattern.compile("(?i)([a-z]{3,10})\\.?(?: |-)?([0-9]{1,2})[^ ]{0,2}(?: |-)([0-9]{2,4})?");
    private static final Pattern todayPattern = Pattern.compile("(?i)(t.?day)");
    private static final Pattern yesterdayPattern = Pattern.compile("(?i)(y[a-z\\-]+day)");
    private static final Pattern agoSpacerPattern = Pattern.compile("(?i)([0-9])([a-z])");
    private static final Pattern agoTimeRangePattern = Pattern.compile("(?i)([0-9.]+) ([a-z\\(\\)]+)");
    private static final Pattern numbersOnlyDatePattern = Pattern.compile("([0-9]{2,4})[ \\-\\./]([0-9]{2,4})[ \\-\\./]?([0-9]{2,4})?");
    private static final String[] MONTHS_LIST = new String[]{" january janvier enero januar", " february fevrier f\u00e9vrier febrero februar", " march mars marzo marz marz m\u00e4rz", " april avril abril april ", " may mai mayo mai", " june juin junio juni", " july juillet julio juli", " august aout ao\u00fbt agosto august", " september septembre septiembre september", " october octobre octubre oktober", " november novembre noviembre november", " december decembre d\u00e9cembre diciembre dezember"};

    static {
        isAgeBasedPatternCN.put("min", Pattern.compile("([0-9]+)\\s*\u5206\u949f\u524d"));
        isAgeBasedPatternCN.put("hour", Pattern.compile("([0-9]+)\\s*\u5c0f\u65f6\u524d"));
        isAgeBasedPatternCN.put("day", Pattern.compile("([0-9]+)\\s*\u5929\u524d"));
        isAgeBasedPatternCN.put("week", Pattern.compile("([0-9]+)\\s*\u5468\u524d"));
        isAgeBasedPatternCN.put("month", Pattern.compile("([0-9]+)\\s*\u4e2a\u6708\u524d"));
        isAgeBasedPatternCN.put("year", Pattern.compile("([0-9]+)\\s*\u5e74\u524d"));
    }

    public DateParserRegex() {
        this("GMT-7", true, null);
    }

    public DateParserRegex(String timeZone, boolean auto, String dateFormat) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
        this.auto = auto;
        if (!auto && dateFormat != null) {
            this.userDateFormat = new SimpleDateFormat(dateFormat);
            this.userDateFormat.setTimeZone(this.timeZone);
        }
    }

    @Override
    public Date parseDate(String date) {
        Date result = null;
        if (this.auto) {
            result = this.parseDateInternal(date);
        } else if (this.userDateFormat != null) {
            try {
                result = this.userDateFormat.parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DEBUG && result != null) {
            System.out.println(String.valueOf(date) + " > " + result.toString());
        }
        return result;
    }

    private Date parseDateInternal(String input) {
        if (input == null) {
            return null;
        }
        String s = input;
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone);
        Matcher matcher = getTimeComponent.matcher(s);
        if ((s = matcher.replaceFirst("").trim()).endsWith(" at")) {
            s = s.substring(0, s.length() - 3).trim();
        }
        if ((matcher = hasLettersPattern.matcher(s)).find()) {
            matcher = isAgeBasedPattern.matcher(s);
            if (matcher.find()) {
                matcher = todayPattern.matcher(s);
                if (!matcher.find()) {
                    matcher = yesterdayPattern.matcher(s);
                    if (matcher.find()) {
                        ((Calendar)calendar).add(5, -1);
                    } else {
                        s = s.replaceAll("ago", "").trim();
                        matcher = agoSpacerPattern.matcher(s);
                        s = matcher.replaceAll("$1 $2");
                        matcher = agoTimeRangePattern.matcher(s);
                        boolean seenHoursAsLowerCaseH = false;
                        while (matcher.find()) {
                            String unit = matcher.group(2);
                            if (unit.equals("h")) {
                                seenHoursAsLowerCaseH = true;
                            }
                            float value = Float.parseFloat(matcher.group(1));
                            int intValue = (int)value;
                            this.adjustDate(calendar, unit, value, intValue, seenHoursAsLowerCaseH);
                        }
                    }
                }
            } else {
                int year;
                Object monthStr;
                matcher = timeBasedDateWithLettersPattern.matcher(s);
                if (matcher.find()) {
                    boolean hasYear;
                    int day = Integer.parseInt(matcher.group(1));
                    calendar.set(5, day);
                    monthStr = " " + matcher.group(2).toLowerCase();
                    int month = -1;
                    int i = 0;
                    while (i < MONTHS_LIST.length) {
                        if (MONTHS_LIST[i].contains((CharSequence)monthStr)) {
                            month = i;
                        }
                        ++i;
                    }
                    if (month > -1) {
                        calendar.set(2, month);
                    }
                    boolean bl = hasYear = matcher.group(3) != null;
                    if (hasYear) {
                        year = Integer.parseInt(matcher.group(3));
                        if (year < 100) {
                            year += 2000;
                        }
                        calendar.set(1, year);
                    }
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                } else {
                    matcher = timeBasedDateWithLettersPatternMonthFirst.matcher(s);
                    if (matcher.find()) {
                        boolean hasYear;
                        int day = Integer.parseInt(matcher.group(2));
                        calendar.set(5, day);
                        monthStr = " " + matcher.group(1).toLowerCase();
                        int month = -1;
                        int i = 0;
                        while (i < MONTHS_LIST.length) {
                            if (MONTHS_LIST[i].contains((CharSequence)monthStr)) {
                                month = i;
                            }
                            ++i;
                        }
                        if (month > -1) {
                            calendar.set(2, month);
                        }
                        boolean bl = hasYear = matcher.group(3) != null;
                        if (hasYear) {
                            year = Integer.parseInt(matcher.group(3));
                            if (year < 100) {
                                year += 2000;
                            }
                            calendar.set(1, year);
                        }
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    } else {
                        Date d = new DateParserClassic().parseDate(input);
                        if (d != null) {
                            return d;
                        }
                        System.err.println("DateParserRegex: Unparseable date : " + input);
                    }
                }
            }
        } else {
            for (String unit : isAgeBasedPatternCN.keySet()) {
                Pattern p = isAgeBasedPatternCN.get(unit);
                matcher = p.matcher(s);
                if (!matcher.find()) continue;
                try {
                    int intValue = Integer.parseInt(matcher.group(1));
                    this.adjustDate(calendar, unit, intValue, intValue, false);
                    return calendar.getTime();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            matcher = numbersOnlyDatePattern.matcher(s);
            if (matcher.find()) {
                try {
                    int day;
                    String g1 = matcher.group(1);
                    String g2 = matcher.group(2);
                    String g3 = matcher.group(3);
                    int i1 = Integer.parseInt(g1);
                    int i2 = Integer.parseInt(g2);
                    if (g3 != null) {
                        int i3 = Integer.parseInt(g3);
                        day = i1;
                        int month = i2;
                        int year = i3;
                        if (month > 12) {
                            day = i2;
                            month = i1;
                        }
                        if (year < 100) {
                            year += 2000;
                        }
                        if (g1.length() == 4) {
                            year = i1;
                            day = i3;
                        }
                        calendar.set(1, year);
                        calendar.set(2, month - 1);
                        calendar.set(5, day);
                    } else {
                        int month = i1;
                        day = i2;
                        if (month > 12) {
                            day = i1;
                            month = i2;
                        }
                        if (month > 12) {
                            System.err.println("DateParserRegex: Unparseable date : " + input);
                        } else {
                            calendar.set(2, month - 1);
                            calendar.set(5, day);
                        }
                    }
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    long parseLong = Long.parseLong(s);
                    if (parseLong < SystemTime.getCurrentTime() / 1000L) {
                        parseLong *= 1000L;
                    }
                    calendar.setTimeInMillis(parseLong);
                }
                catch (Throwable parseLong) {
                    // empty catch block
                }
            }
        }
        if ((matcher = getTimeComponent.matcher(input)).find()) {
            try {
                boolean hasSeconds;
                int hours = Integer.parseInt(matcher.group(1));
                int minutes = Integer.parseInt(matcher.group(2));
                calendar.set(12, minutes);
                boolean amPMModifier = matcher.group(5) != null;
                boolean bl = hasSeconds = matcher.group(4) != null;
                if (hasSeconds) {
                    int seconds = Integer.parseInt(matcher.group(4));
                    calendar.set(13, seconds);
                }
                if (amPMModifier) {
                    String amPm = matcher.group(5).trim().toLowerCase();
                    if (amPm.equals("am")) {
                        calendar.set(9, 0);
                    } else {
                        calendar.set(9, 1);
                    }
                    calendar.set(10, hours);
                } else {
                    calendar.set(11, hours);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int nbBack = 0;
        GregorianCalendar calendarCompare = new GregorianCalendar();
        while (calendar.after(calendarCompare) && nbBack++ < 50) {
            ((Calendar)calendar).add(1, -1);
        }
        return calendar.getTime();
    }

    private void adjustDate(Calendar calendar, String unit, float value, int intValue, boolean seenHoursAsLowerCaseH) {
        String lUnit = unit.toLowerCase();
        if (lUnit.startsWith("sec")) {
            calendar.add(13, -intValue);
        } else if (lUnit.startsWith("min") || unit.equals("m") && seenHoursAsLowerCaseH) {
            calendar.add(12, -intValue);
            int seconds = (int)((value - (float)intValue) * 60.0f);
            calendar.add(13, -seconds);
        } else if (lUnit.startsWith("h")) {
            calendar.add(11, -intValue);
            int seconds = (int)((value - (float)intValue) * 3600.0f);
            calendar.add(13, -seconds);
        } else if (lUnit.startsWith("d")) {
            calendar.add(5, -intValue);
            int seconds = (int)((value - (float)intValue) * 86400.0f);
            calendar.add(13, -seconds);
        } else if (lUnit.startsWith("w")) {
            calendar.add(3, -intValue);
            int seconds = (int)((value - (float)intValue) * 640800.0f);
            calendar.add(13, -seconds);
        } else if (lUnit.startsWith("m")) {
            calendar.add(2, -intValue);
            int hours = (int)((value - (float)intValue) * 720.0f);
            calendar.add(11, -hours);
        } else if (lUnit.startsWith("y")) {
            calendar.add(1, -intValue);
            int hours = (int)((value - (float)intValue) * 8760.0f);
            calendar.add(11, -hours);
        }
    }

    public static void main(String[] args) {
        DEBUG = true;
        DateParserRegex dateParser = new DateParserRegex();
        dateParser.parseDate("Today 05:34");
        dateParser.parseDate("Y-Day 21:55");
        dateParser.parseDate("07-25 2006");
        dateParser.parseDate("02-01 02:53");
        dateParser.parseDate("02-01 02:53 am");
        dateParser.parseDate("02-01 02:53 pm");
        dateParser.parseDate("03 Mar 2006");
        dateParser.parseDate("0 minute ago");
        dateParser.parseDate("3 hours ago");
        dateParser.parseDate("2 days ago");
        dateParser.parseDate("10 months ago");
        dateParser.parseDate("45 mins ago");
        dateParser.parseDate("Today");
        dateParser.parseDate("Yesterday");
        dateParser.parseDate("16.9w");
        dateParser.parseDate("22.6h");
        dateParser.parseDate("1.7d");
        dateParser.parseDate("2d 7h");
        dateParser.parseDate("1w");
        dateParser.parseDate("1w 4d");
        dateParser.parseDate("1mon 1w");
        dateParser.parseDate("22.11.");
        dateParser.parseDate("22 Apr 08");
        dateParser.parseDate("3 months");
        dateParser.parseDate("1 day");
        dateParser.parseDate("3 weeks");
        dateParser.parseDate("1 year");
        dateParser.parseDate("4 hours ago");
        dateParser.parseDate("yesterday");
        dateParser.parseDate("2 days ago");
        dateParser.parseDate("1 month ago");
        dateParser.parseDate("2 months ago");
        dateParser.parseDate("06/18");
        dateParser.parseDate("02:10");
        dateParser.parseDate("2005-02-26 20:55:10");
        dateParser.parseDate("2005-02-26 10:55:10 PM");
        dateParser.parseDate("2005-02-26 10:55:10 AM");
        dateParser.parseDate("25-04-08");
        dateParser.parseDate("142 Day(s) ago");
        dateParser.parseDate("6 Minute(s) ago");
        dateParser.parseDate("1 Hour(s) ago");
        dateParser.parseDate("1.4h");
        dateParser.parseDate("3.5d");
        dateParser.parseDate("392w");
        dateParser.parseDate("01st Mar");
        dateParser.parseDate("19th Apr");
        dateParser.parseDate("03rd Apr");
        dateParser.parseDate("2nd Apr");
        dateParser.parseDate("3rd Nov");
        dateParser.parseDate("04-28");
        dateParser.parseDate("2007-07-14");
        dateParser.parseDate("2008.04.28");
        dateParser.parseDate("16/04/08");
        dateParser.parseDate("20-Dec-07");
        dateParser.parseDate("2009-01-12 at 03:36:38");
        dateParser.parseDate("2013-08-11T18:30:00.000Z");
        dateParser.parseDate("12\u5c0f\u65f6\u524d");
        dateParser.parseDate("12 \u5c0f\u65f6\u524d");
    }
}

