/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.messenger.config;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.activities.ActivitiesManager;
import com.biglybt.core.messenger.PlatformMessage;
import com.biglybt.core.messenger.PlatformMessenger;
import com.biglybt.core.messenger.PlatformMessengerListener;
import com.biglybt.util.MapUtils;
import java.util.List;
import java.util.Map;

public class PlatformVuzeActivitiesMessenger {
    public static final String LISTENER_ID = "vuzenews";
    public static final String OP_GET = "get-entries";
    public static final long DEFAULT_RETRY_MS = 86400000L;

    public static void getEntries(long agoMS, long maxDelayMS, String reason, final GetEntriesReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", reason.equals("shown") ? "vznews" : LISTENER_ID, OP_GET, new Object[]{"ago-ms", new Long(agoMS), "reason", reason}, maxDelayMS);
        PlatformMessengerListener listener = null;
        if (replyListener != null) {
            listener = new PlatformMessengerListener(){

                @Override
                public void messageSent(PlatformMessage message) {
                }

                @Override
                public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                    ActivitiesEntry[] entries = new ActivitiesEntry[]{};
                    List entriesList = (List)MapUtils.getMapObject(reply, "entries", null, List.class);
                    if (entriesList != null && entriesList.size() > 0) {
                        entries = new ActivitiesEntry[entriesList.size()];
                        int i = 0;
                        for (Object obj : entriesList) {
                            if (!(obj instanceof Map)) continue;
                            Map platformEntry = (Map)obj;
                            entries[i] = ActivitiesManager.createEntryFromMap(platformEntry, false);
                            if (entries[i] == null) continue;
                            ++i;
                        }
                    }
                    long refreshInMS = MapUtils.getMapLong(reply, "refresh-in-ms", 86400000L);
                    replyListener.gotVuzeNewsEntries(entries, refreshInMS);
                }
            };
        }
        PlatformMessenger.queueMessage(message, listener);
    }

    public static interface GetEntriesReplyListener {
        public void gotVuzeNewsEntries(ActivitiesEntry[] var1, long var2);
    }
}

