/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.messenger.config;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.messenger.PlatformMessengerException;
import com.biglybt.core.messenger.config.PlatformMessengerConfig;
import com.biglybt.core.security.CryptoECCUtils;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import java.security.Signature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;

public class PlatformSubscriptionsMessenger {
    private static final boolean MESSAGING_ENABLED = true;
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("subscription", false);
    private static final String OP_CREATE_SUBS = "create-subscription";
    private static final String OP_UPDATE_SUBS = "update-subscription";
    private static final String OP_GET_SUBS_BY_SID = "get-subscriptions";
    private static final String OP_GET_POP_BY_SID = "get-subscription-infos";
    private static final String OP_SET_SELECTED = "set-selected";

    public static void updateSubscription(boolean create, String name, byte[] public_key, byte[] private_key, byte[] sid, int version, boolean is_anon, String content) throws PlatformMessengerException {
        String operation = create ? OP_CREATE_SUBS : OP_UPDATE_SUBS;
        PlatformSubscriptionsMessenger.checkEnabled(operation);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String sid_str = Base32.encode(sid);
        String pk_str = Base32.encode(public_key);
        parameters.put("name", name);
        parameters.put("subscription_id", sid_str);
        parameters.put("version_number", new Long(version));
        parameters.put("content", content);
        if (create) {
            parameters.put("public_key", pk_str);
        }
        try {
            Signature sig = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPrivkey(private_key));
            sig.update((String.valueOf(name) + pk_str + sid_str + version + content).getBytes("UTF-8"));
            byte[] sig_bytes = sig.sign();
            parameters.put("signature", Base32.encode(sig_bytes));
            dispatcher.syncInvoke(operation, parameters, is_anon);
        }
        catch (Throwable e) {
            throw new PlatformMessengerException("Failed to create/update subscription", e);
        }
    }

    public static subscriptionDetails getSubscriptionBySID(byte[] sid, boolean is_anon) throws PlatformMessengerException {
        PlatformSubscriptionsMessenger.checkEnabled(OP_GET_SUBS_BY_SID);
        HashMap<String, JSONArray> parameters = new HashMap<String, JSONArray>();
        JSONArray sid_list = new JSONArray();
        sid_list.add(Base32.encode(sid));
        parameters.put("subscription_ids", sid_list);
        Map reply = dispatcher.syncInvoke(OP_GET_SUBS_BY_SID, parameters, is_anon);
        int i = 0;
        while (i < sid_list.size()) {
            Map map = (Map)reply.get((String)sid_list.get(i));
            if (map != null) {
                subscriptionDetails details = new subscriptionDetails(map);
                return details;
            }
            ++i;
        }
        throw new PlatformMessengerException("Unknown sid '" + ByteFormatter.encodeString(sid) + "'");
    }

    public static long getPopularityBySID(byte[] sid) throws PlatformMessengerException {
        PlatformSubscriptionsMessenger.checkEnabled(OP_GET_POP_BY_SID);
        HashMap<String, JSONArray> parameters = new HashMap<String, JSONArray>();
        JSONArray sid_list = new JSONArray();
        sid_list.add(Base32.encode(sid));
        parameters.put("subscription_ids", sid_list);
        Map reply = dispatcher.syncInvoke(OP_GET_POP_BY_SID, parameters);
        int i = 0;
        while (i < sid_list.size()) {
            Map map = (Map)reply.get((String)sid_list.get(i));
            if (map != null) {
                subscriptionInfo info = new subscriptionInfo(map);
                return info.getPopularity();
            }
            ++i;
        }
        return -1L;
    }

    public static List[] setSelected(List sids) throws PlatformMessengerException {
        ArrayList<Long> popularities;
        PlatformSubscriptionsMessenger.checkEnabled(OP_SET_SELECTED);
        HashMap<String, JSONArray> parameters = new HashMap<String, JSONArray>();
        JSONArray sid_list = new JSONArray();
        int i = 0;
        while (i < sids.size()) {
            sid_list.add(Base32.encode((byte[])sids.get(i)));
            ++i;
        }
        parameters.put("subscription_ids", sid_list);
        Map reply = dispatcher.syncInvoke(OP_SET_SELECTED, parameters);
        ArrayList<Long> versions = (ArrayList<Long>)reply.get("version_numbers");
        if (versions == null) {
            versions = new ArrayList<Long>();
            int i2 = 0;
            while (i2 < sids.size()) {
                versions.add(new Long(1L));
                ++i2;
            }
        }
        if ((popularities = (ArrayList<Long>)reply.get("popularities")) == null) {
            popularities = new ArrayList<Long>();
            int i3 = 0;
            while (i3 < sids.size()) {
                popularities.add(new Long(-1L));
                ++i3;
            }
        }
        return new List[]{versions, popularities};
    }

    protected static void checkEnabled(String method) throws PlatformMessengerException {
    }

    public static void main(String[] args) {
        try {
            CoreFactory.create();
            String short_id = "";
            long res = PlatformSubscriptionsMessenger.getPopularityBySID(Base32.decode(short_id));
            System.out.println(res);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class subscriptionDetails {
        private Map details;

        protected subscriptionDetails(Map _details) {
            this.details = _details;
        }

        public String getName() {
            return this.getString("name");
        }

        public String getContent() {
            return this.getString("content");
        }

        public int getPopularity() {
            Long l_pop = (Long)this.details.get("popularity");
            if (l_pop != null) {
                return l_pop.intValue();
            }
            return -1;
        }

        protected String getString(String key) {
            Object obj = this.details.get(key);
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof byte[]) {
                byte[] bytes = (byte[])obj;
                try {
                    return new String(bytes, "UTF-8");
                }
                catch (Throwable e) {
                    return new String(bytes);
                }
            }
            return null;
        }
    }

    public static class subscriptionInfo {
        private Map info;

        protected subscriptionInfo(Map _info) {
            this.info = _info;
        }

        public long getPopularity() {
            return ((Long)this.info.get("popularity")).intValue();
        }
    }
}

