/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.messenger.config;

import com.biglybt.core.messenger.PlatformMessage;
import com.biglybt.core.messenger.PlatformMessenger;
import com.biglybt.core.messenger.PlatformMessengerException;
import com.biglybt.core.messenger.PlatformMessengerListener;
import com.biglybt.core.util.AESemaphore;
import java.util.Map;

public class PlatformMessengerConfig {
    private String listener_id;
    private boolean send_azid;

    protected PlatformMessengerConfig(String _listener_id, boolean _send_azid) {
        this.listener_id = _listener_id;
        this.send_azid = _send_azid;
    }

    protected Map syncInvoke(String operationID, Map parameters) throws PlatformMessengerException {
        return this.syncInvoke(operationID, parameters, false);
    }

    protected Map syncInvoke(String operationID, Map parameters, boolean forceProxy) throws PlatformMessengerException {
        PlatformMessage message = new PlatformMessage("AZMSG", this.listener_id, operationID, parameters, 0L);
        if (!this.send_azid) {
            message.setSendAZID(false);
        }
        message.setForceProxy(forceProxy);
        final AESemaphore sem = new AESemaphore("PlatformMessengerConfig:syncInvoke");
        final Object[] result = new Object[1];
        PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

            @Override
            public void messageSent(PlatformMessage message) {
            }

            @Override
            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                try {
                    if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
                        String e_message = (String)reply.get("message");
                        if (e_message != null) {
                            result[0] = new PlatformMessengerException(e_message);
                        } else {
                            String text = (String)reply.get("text");
                            Throwable e = (Throwable)reply.get("Throwable");
                            result[0] = text == null && e == null ? new PlatformMessengerException("Unknown error") : (text == null ? new PlatformMessengerException("Failed to send RPC", e) : (e == null ? new PlatformMessengerException(text) : new PlatformMessengerException(text, e)));
                        }
                    } else {
                        result[0] = reply;
                    }
                }
                finally {
                    sem.release();
                }
            }
        });
        sem.reserve();
        if (result[0] instanceof PlatformMessengerException) {
            throw (PlatformMessengerException)result[0];
        }
        return (Map)result[0];
    }
}

