/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.core.ipfilter.impl.IpRangeImpl;
import com.biglybt.core.tracker.protocol.PRHelpers;
import java.net.UnknownHostException;

public class IpRangeV4Impl
extends IpRangeImpl {
    private int ipStart;
    private int ipEnd;
    private static final byte FLAG_MERGED = 4;
    private int merged_end;
    private IpRangeV4Impl[] my_merged_entries;

    public IpRangeV4Impl(String _description, String _startIp, String _endIp, boolean _sessionOnly) {
        if (_sessionOnly) {
            this.flags = 1;
        }
        if (_startIp == null || _endIp == null) {
            throw new RuntimeException("Invalid start/end values - null not supported");
        }
        try {
            if (_startIp.contains(":")) {
                this.flags = (byte)(this.flags | 8);
            } else {
                this.ipStart = PRHelpers.addressToInt(_startIp);
            }
        }
        catch (UnknownHostException e) {
            this.flags = (byte)(this.flags | 8);
        }
        try {
            if (_endIp.contains(":")) {
                this.flags = (byte)(this.flags | 0x10);
            } else {
                this.ipEnd = PRHelpers.addressToInt(_endIp);
            }
        }
        catch (UnknownHostException e) {
            this.flags = (byte)(this.flags | 0x10);
        }
        if (_description.length() > 0) {
            this.setDescription(_description);
        }
        this.checkValid();
    }

    public IpRangeV4Impl(String _description, int _startIp, int _endIp, boolean _sessionOnly) {
        if (_sessionOnly) {
            this.flags = 1;
        }
        this.ipStart = _startIp;
        this.ipEnd = _endIp;
        if (_description.length() > 0) {
            this.setDescription(_description);
        }
        this.checkValid();
    }

    @Override
    protected final boolean isV4() {
        return true;
    }

    @Override
    public boolean isValid() {
        if ((this.flags & 0x18) > 0) {
            return false;
        }
        long start_address = this.ipStart;
        long end_address = this.ipEnd;
        if (start_address < 0L) {
            start_address += 0x100000000L;
        }
        if (end_address < 0L) {
            end_address += 0x100000000L;
        }
        return end_address >= start_address;
    }

    @Override
    public boolean isInRange(String ipAddress) {
        if (!this.isValid()) {
            return false;
        }
        try {
            long int_address = PRHelpers.addressToInt(ipAddress);
            if (int_address < 0L) {
                int_address += 0x100000000L;
            }
            long start_address = this.ipStart;
            long end_address = this.ipEnd;
            if (start_address < 0L) {
                start_address += 0x100000000L;
            }
            if (end_address < 0L) {
                end_address += 0x100000000L;
            }
            return int_address >= start_address && int_address <= end_address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    @Override
    public String getStartIp() {
        return (this.flags & 8) > 0 ? "" : PRHelpers.intToAddress(this.ipStart);
    }

    protected long getStartIpLong() {
        if ((this.flags & 8) > 0) {
            return -1L;
        }
        long val = this.ipStart;
        if (val < 0L) {
            val += 0x100000000L;
        }
        return val;
    }

    @Override
    public void setStartIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid start value - null not supported");
        }
        if (str.equals(this.getStartIp())) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFF7);
        try {
            if (str.contains(":")) {
                this.flags = (byte)(this.flags | 8);
            } else {
                this.ipStart = PRHelpers.addressToInt(str);
            }
        }
        catch (UnknownHostException e) {
            this.flags = (byte)(this.flags | 8);
        }
        if ((this.flags & 0x18) == 0) {
            this.checkValid();
        }
    }

    @Override
    public String getEndIp() {
        return (this.flags & 0x10) > 0 ? "" : PRHelpers.intToAddress(this.ipEnd);
    }

    protected long getEndIpLong() {
        if ((this.flags & 0x10) > 0) {
            return -1L;
        }
        long val = this.ipEnd;
        if (val < 0L) {
            val += 0x100000000L;
        }
        return val;
    }

    @Override
    public void setEndIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid end value - null not supported");
        }
        if (str.equals(this.getEndIp())) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        try {
            if (str.contains(":")) {
                this.flags = (byte)(this.flags | 0x10);
            } else {
                this.ipEnd = PRHelpers.addressToInt(str);
            }
        }
        catch (UnknownHostException e) {
            this.flags = (byte)(this.flags | 0x10);
        }
        if ((this.flags & 0x18) == 0) {
            this.checkValid();
        }
    }

    @Override
    public int compareStartIpTo(IpRange other) {
        if (other instanceof IpRangeV4Impl) {
            long l = this.getStartIpLong() - ((IpRangeV4Impl)other).getStartIpLong();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int compareEndIpTo(IpRange other) {
        if (other instanceof IpRangeV4Impl) {
            long l = this.getEndIpLong() - ((IpRangeV4Impl)other).getEndIpLong();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    protected long getMergedEndLong() {
        return this.merged_end < 0 ? (long)this.merged_end + 0x100000000L : (long)this.merged_end;
    }

    protected IpRangeV4Impl[] getMergedEntries() {
        return this.my_merged_entries;
    }

    protected void resetMergeInfo() {
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        if ((this.flags & 0x10) == 0) {
            this.merged_end = this.ipEnd;
        }
    }

    protected boolean getMerged() {
        return (this.flags & 4) != 0;
    }

    protected void setMerged() {
        this.flags = (byte)(this.flags | 4);
    }

    protected void setMergedEnd(long endIpLong) {
        this.merged_end = (int)(endIpLong >= 0x100000000L ? endIpLong - 0x100000000L : endIpLong);
    }

    protected void addMergedEntry(IpRangeV4Impl e2) {
        if (this.my_merged_entries == null) {
            this.my_merged_entries = new IpRangeV4Impl[]{e2};
        } else {
            IpRangeV4Impl[] x = new IpRangeV4Impl[this.my_merged_entries.length + 1];
            System.arraycopy(this.my_merged_entries, 0, x, 0, this.my_merged_entries.length);
            x[x.length - 1] = e2;
            this.my_merged_entries = x;
        }
    }

    @Override
    public String getStringSlow() {
        return this.toString();
    }
}

