/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipchecker.natchecker;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.impl.TransportHelper;
import com.biglybt.core.networkmanager.impl.http.HTTPNetworkManager;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.peermanager.messaging.MessageStreamDecoder;
import com.biglybt.core.peermanager.messaging.MessageStreamEncoder;
import com.biglybt.core.peermanager.messaging.MessageStreamFactory;
import com.biglybt.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.biglybt.core.peermanager.messaging.azureus.AZMessageEncoder;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class NatCheckerServer
extends AEThread {
    static final LogIDs LOGID = LogIDs.NET;
    private static final String incoming_handshake = "NATCHECK_HANDSHAKE";
    private final InetAddress bind_ip;
    private boolean bind_ip_set;
    private final String check;
    private final boolean http_test;
    private ServerSocket server;
    private volatile boolean bContinue = true;
    private final boolean use_incoming_router;
    private NetworkManager.ByteMatcher matcher;

    public NatCheckerServer(InetAddress _bind_ip, int _port, String _check, boolean _http_test) throws Exception {
        super("Nat Checker Server");
        Object net_man;
        this.bind_ip = _bind_ip;
        this.check = _check;
        this.http_test = _http_test;
        if (this.http_test) {
            net_man = HTTPNetworkManager.getSingleton();
            this.use_incoming_router = ((HTTPNetworkManager)net_man).isHTTPListenerEnabled() ? _port == ((HTTPNetworkManager)net_man).getHTTPListeningPortNumber() : false;
            if (this.use_incoming_router && !((HTTPNetworkManager)net_man).isEffectiveBindAddress(this.bind_ip)) {
                ((HTTPNetworkManager)net_man).setExplicitBindAddress(this.bind_ip);
                this.bind_ip_set = true;
            }
        } else {
            net_man = TCPNetworkManager.getSingleton();
            this.use_incoming_router = ((TCPNetworkManager)net_man).isDefaultTCPListenerEnabled() ? _port == ((TCPNetworkManager)net_man).getDefaultTCPListeningPortNumber() : false;
            if (this.use_incoming_router) {
                if (!((TCPNetworkManager)net_man).getDefaultIncomingSocketManager().isEffectiveBindAddress(this.bind_ip)) {
                    ((TCPNetworkManager)net_man).getDefaultIncomingSocketManager().setExplicitBindAddress(this.bind_ip);
                    this.bind_ip_set = true;
                }
                this.matcher = new NetworkManager.ByteMatcher(){

                    @Override
                    public int matchThisSizeOrBigger() {
                        return this.maxSize();
                    }

                    @Override
                    public int maxSize() {
                        return NatCheckerServer.incoming_handshake.getBytes().length;
                    }

                    @Override
                    public int minSize() {
                        return this.maxSize();
                    }

                    @Override
                    public Object matches(TransportHelper transport, ByteBuffer to_compare, int port) {
                        int old_limit = to_compare.limit();
                        to_compare.limit(to_compare.position() + this.maxSize());
                        boolean matches = to_compare.equals(ByteBuffer.wrap(NatCheckerServer.incoming_handshake.getBytes()));
                        to_compare.limit(old_limit);
                        return matches ? "" : null;
                    }

                    @Override
                    public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                        return this.matches(transport, to_compare, port);
                    }

                    @Override
                    public byte[][] getSharedSecrets() {
                        return null;
                    }

                    @Override
                    public int getSpecificPort() {
                        return -1;
                    }

                    @Override
                    public String getDescription() {
                        return "NatChecker";
                    }
                };
                NetworkManager.getSingleton().requestIncomingConnectionRouting(this.matcher, new NetworkManager.RoutingListener(){

                    @Override
                    public void connectionRouted(NetworkConnection connection, Object routing_data) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Incoming connection from [" + connection + "] successfully routed to NAT CHECKER"));
                        }
                        try {
                            ByteBuffer msg = NatCheckerServer.this.getMessage();
                            Transport transport = connection.getTransport();
                            long start = SystemTime.getCurrentTime();
                            while (msg.hasRemaining()) {
                                transport.write(new ByteBuffer[]{msg}, 0, 1);
                                if (!msg.hasRemaining()) continue;
                                long now = SystemTime.getCurrentTime();
                                if (now < start) {
                                    start = now;
                                } else if (now - start > 30000L) {
                                    throw new Exception("Timeout");
                                }
                                Thread.sleep(50L);
                            }
                        }
                        catch (Throwable t) {
                            Debug.out("Nat check write failed", t);
                        }
                        connection.close(null);
                    }

                    @Override
                    public boolean autoCryptoFallback() {
                        return true;
                    }
                }, new MessageStreamFactory(){

                    @Override
                    public MessageStreamEncoder createEncoder() {
                        return new AZMessageEncoder(0);
                    }

                    @Override
                    public MessageStreamDecoder createDecoder() {
                        return new AZMessageDecoder();
                    }
                });
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT tester using central routing for server socket"));
            }
        }
        if (!this.use_incoming_router) {
            try {
                this.server = new ServerSocket();
                this.server.setReuseAddress(true);
                InetSocketAddress address = this.bind_ip != null ? new InetSocketAddress(this.bind_ip, _port) : new InetSocketAddress(_port);
                this.server.bind(address);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "NAT tester server socket bound to " + address));
                }
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "NAT tester failed to setup listener socket", e));
                throw e;
            }
        }
    }

    protected ByteBuffer getMessage() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("check", this.check);
        byte[] map_bytes = BEncoder.encode(map);
        ByteBuffer msg = ByteBuffer.allocate(4 + map_bytes.length);
        msg.putInt(map_bytes.length);
        msg.put(map_bytes);
        msg.flip();
        return msg;
    }

    @Override
    public void runSupport() {
        while (this.bContinue) {
            try {
                if (this.use_incoming_router) {
                    Thread.sleep(20L);
                    continue;
                }
                Socket sck = this.server.accept();
                try {
                    sck.getOutputStream().write(this.getMessage().array());
                    sck.close();
                    sck = null;
                }
                finally {
                    if (sck != null) {
                        try {
                            sck.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Exception e) {
                this.bContinue = false;
            }
        }
    }

    public void stopIt() {
        this.bContinue = false;
        if (this.use_incoming_router) {
            if (this.http_test) {
                if (this.bind_ip_set) {
                    HTTPNetworkManager.getSingleton().clearExplicitBindAddress();
                }
            } else {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(this.matcher);
                if (this.bind_ip_set) {
                    TCPNetworkManager.getSingleton().getDefaultIncomingSocketManager().clearExplicitBindAddress();
                }
            }
        } else if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

