/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.internat;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.internat.LocaleUtilDecoderCandidate;
import com.biglybt.core.internat.LocaleUtilDecoderFallback;
import com.biglybt.core.internat.LocaleUtilDecoderReal;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;

public class LocaleUtil {
    private static final Charset systemEncoding = Charset.defaultCharset();
    private static final String[] manual_charset = new String[]{Charset.defaultCharset().name(), "Big5", "EUC-JP", "EUC-KR", "GB18030", "GB2312", "GBK", "ISO-2022-JP", "ISO-2022-KR", "Shift_JIS", "KOI8-R", "TIS-620", Constants.DEFAULT_ENCODING_CHARSET.name(), "windows-1251", Constants.BYTE_ENCODING_CHARSET.name()};
    protected static final Charset[] generalCharsets = new Charset[]{Constants.BYTE_ENCODING_CHARSET, Constants.DEFAULT_ENCODING_CHARSET, Charset.defaultCharset()};
    private static final LocaleUtil singleton = new LocaleUtil();
    private final LocaleUtilDecoder[] all_decoders;
    private final LocaleUtilDecoder[] general_decoders;
    private LocaleUtilDecoder system_decoder;
    private final LocaleUtilDecoder fallback_decoder;

    public static LocaleUtil getSingleton() {
        return singleton;
    }

    private LocaleUtil() {
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        ArrayList<String> decoder_names = new ArrayList<String>();
        int i = 0;
        while (i < manual_charset.length) {
            try {
                String name = manual_charset[i];
                CharsetDecoder decoder = Charset.forName(name).newDecoder();
                if (decoder != null) {
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoder_names.add(lu_decoder.getName());
                    if (i == 0) {
                        this.system_decoder = lu_decoder;
                    }
                    decoders.add(lu_decoder);
                } else if (i == 0) {
                    Debug.out("System decoder failed to be found!!!!");
                }
            }
            catch (Exception name) {
                // empty catch block
            }
            ++i;
        }
        this.general_decoders = new LocaleUtilDecoder[generalCharsets.length];
        i = 0;
        while (i < this.general_decoders.length) {
            int gi = decoder_names.indexOf(generalCharsets[i]);
            if (gi != -1) {
                this.general_decoders[i] = (LocaleUtilDecoder)decoders.get(gi);
            }
            ++i;
        }
        boolean show_all = COConfigurationManager.getBooleanParameter("File.Decoder.ShowAll");
        if (show_all) {
            SortedMap<String, Charset> m = Charset.availableCharsets();
            for (String charset_name : m.keySet()) {
                if (decoder_names.contains(charset_name)) continue;
                try {
                    CharsetDecoder decoder = Charset.forName(charset_name).newDecoder();
                    if (decoder == null) continue;
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoders.add(lu_decoder);
                    decoder_names.add(lu_decoder.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.fallback_decoder = new LocaleUtilDecoderFallback(decoders.size());
        decoders.add(this.fallback_decoder);
        this.all_decoders = new LocaleUtilDecoder[decoders.size()];
        decoders.toArray(this.all_decoders);
    }

    public Charset getSystemEncoding() {
        return systemEncoding;
    }

    public LocaleUtilDecoder[] getDecoders() {
        return this.all_decoders;
    }

    public LocaleUtilDecoder[] getGeneralDecoders() {
        return this.general_decoders;
    }

    public LocaleUtilDecoder getFallBackDecoder() {
        return this.fallback_decoder;
    }

    public LocaleUtilDecoder getSystemDecoder() {
        return this.system_decoder;
    }

    protected List<LocaleUtilDecoderCandidate> getCandidates(byte[] array) {
        ArrayList<LocaleUtilDecoderCandidate> candidates = new ArrayList<LocaleUtilDecoderCandidate>();
        boolean show_less_likely_conversions = COConfigurationManager.getBooleanParameter("File.Decoder.ShowLax");
        int i = 0;
        while (i < this.all_decoders.length) {
            LocaleUtilDecoderCandidate candidate = new LocaleUtilDecoderCandidate(i);
            try {
                LocaleUtilDecoder decoder = this.all_decoders[i];
                String str = decoder.tryDecode(array, show_less_likely_conversions);
                if (str != null) {
                    candidate.setDetails(decoder, str);
                    candidates.add(candidate);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return candidates;
    }
}

