/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.instancemanager.impl;

import com.biglybt.core.instancemanager.impl.ClientInstanceImpl;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClientOtherInstanceImpl
extends ClientInstanceImpl {
    private final String id;
    private final String app_id;
    private final CopyOnWriteList<InetAddress> internal_addresses = new CopyOnWriteList();
    private InetAddress external_address;
    private int tcp_port;
    private int udp_port;
    private final int udp_non_data_port;
    private final Map<String, Object> props;
    private long alive_time;

    protected static ClientOtherInstanceImpl decode(InetAddress internal_address, Map map) {
        String id = new String((byte[])map.get("id"));
        String int_ip = new String((byte[])map.get("iip"));
        String ext_ip = new String((byte[])map.get("eip"));
        int tcp = ((Long)map.get("tp")).intValue();
        int udp = ((Long)map.get("dp")).intValue();
        Long l_udp_other = (Long)map.get("dp2");
        int udp_other = l_udp_other == null ? udp : l_udp_other.intValue();
        byte[] app_id_bytes = (byte[])map.get("ai");
        String app_id = app_id_bytes == null ? "az_4.2.0.2" : new String(app_id_bytes);
        Map props = (Map)map.get("pr");
        try {
            InetAddress external_address;
            ArrayList<InetAddress> internal_addresses = new ArrayList<InetAddress>(2);
            internal_addresses.add(internal_address);
            if (!int_ip.equals("0.0.0.0") && !internal_addresses.contains(internal_address = InetAddress.getByName(int_ip))) {
                internal_addresses.add(0, internal_address);
            }
            if (internal_address instanceof Inet4Address == (external_address = InetAddress.getByName(ext_ip)) instanceof Inet4Address) {
                return new ClientOtherInstanceImpl(id, app_id, internal_addresses, external_address, tcp, udp, udp_other, props);
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected ClientOtherInstanceImpl(String _id, String _app_id, List<InetAddress> _internal_addresses, InetAddress _external_address, int _tcp_port, int _udp_port, int _udp_non_data_port, Map<String, Object> _props) {
        this.id = _id;
        this.app_id = _app_id;
        this.internal_addresses.addAll(_internal_addresses);
        this.external_address = _external_address;
        this.tcp_port = _tcp_port;
        this.udp_port = _udp_port;
        this.udp_non_data_port = _udp_non_data_port;
        this.props = _props;
        this.alive_time = SystemTime.getCurrentTime();
    }

    protected boolean update(ClientOtherInstanceImpl new_inst) {
        this.alive_time = SystemTime.getCurrentTime();
        List<InetAddress> new_addresses = new_inst.getInternalAddresses();
        boolean same = true;
        int pos = 0;
        for (InetAddress new_address : new_addresses) {
            if (this.internal_addresses.contains(new_address)) continue;
            same = false;
            this.internal_addresses.add(pos++, new_address);
        }
        same = same && this.external_address.equals(new_inst.external_address) && this.tcp_port == new_inst.tcp_port && this.udp_port == new_inst.udp_port;
        this.external_address = new_inst.external_address;
        this.tcp_port = new_inst.tcp_port;
        this.udp_port = new_inst.udp_port;
        return !same;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getApplicationID() {
        return this.app_id;
    }

    @Override
    public InetAddress getInternalAddress() {
        return this.internal_addresses.get(0);
    }

    @Override
    public List<InetAddress> getInternalAddresses() {
        return this.internal_addresses.getList();
    }

    @Override
    public InetAddress getExternalAddress() {
        return this.external_address;
    }

    @Override
    public int getTCPListenPort() {
        return this.tcp_port;
    }

    @Override
    public int getUDPListenPort() {
        return this.udp_port;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.props;
    }

    protected long getAliveTime() {
        long now = SystemTime.getCurrentTime();
        if (now < this.alive_time) {
            this.alive_time = now;
        }
        return this.alive_time;
    }
}

