/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.instancemanager.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.instancemanager.ClientInstance;
import com.biglybt.core.instancemanager.ClientInstanceManager;
import com.biglybt.core.instancemanager.ClientInstanceManagerAdapter;
import com.biglybt.core.instancemanager.ClientInstanceManagerListener;
import com.biglybt.core.instancemanager.ClientInstanceTracked;
import com.biglybt.core.instancemanager.impl.ClientMyInstanceImpl;
import com.biglybt.core.instancemanager.impl.ClientOtherInstanceImpl;
import com.biglybt.core.instancemanager.impl.ClientPortClashHandler;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.IPFilterListener;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.NetUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.net.udp.mc.MCGroup;
import com.biglybt.net.udp.mc.MCGroupAdapter;
import com.biglybt.net.udp.mc.MCGroupException;
import com.biglybt.net.udp.mc.MCGroupFactory;
import com.biglybt.plugin.dht.DHTPlugin;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ClientInstanceManagerImpl
implements ClientInstanceManager,
MCGroupAdapter {
    private static final boolean DISABLE_LAN_LOCAL_STUFF = false;
    private static final LogIDs LOGID = LogIDs.NET;
    private static final String MC_GROUP_ADDRESS = "239.255.067.250";
    private static final int MC_GROUP_PORT = 16680;
    private static final int MC_CONTROL_PORT = 0;
    private static final int MT_VERSION = 1;
    private static final int MT_ALIVE = 1;
    private static final int MT_BYE = 2;
    private static final int MT_REQUEST = 3;
    private static final int MT_REPLY = 4;
    private static final int MT_REQUEST_SEARCH = 1;
    private static final int MT_REQUEST_TRACK = 2;
    private static final long ALIVE_PERIOD = 1800000L;
    private static ClientInstanceManagerImpl singleton;
    private final List listeners = new ArrayList();
    private static final AEMonitor class_mon;
    static Set<String> data_socks_proxies;
    private final ClientInstanceManagerAdapter adapter;
    private MCGroup mc_group;
    long search_id_next;
    final List<Request> requests = new ArrayList<Request>();
    final ClientMyInstanceImpl my_instance;
    private final Map<String, ClientOtherInstanceImpl> other_instances = new HashMap<String, ClientOtherInstanceImpl>();
    private volatile boolean initialised;
    private final IpFilter ip_filter;
    private volatile Map<InetSocketAddress, InetSocketAddress> tcp_lan_to_ext = new HashMap<InetSocketAddress, InetSocketAddress>();
    private volatile Map<InetSocketAddress, InetSocketAddress> udp_lan_to_ext = new HashMap<InetSocketAddress, InetSocketAddress>();
    private volatile Map<InetSocketAddress, InetSocketAddress> udp2_lan_to_ext = new HashMap<InetSocketAddress, InetSocketAddress>();
    private volatile Map<InetSocketAddress, InetSocketAddress> tcp_ext_to_lan = new HashMap<InetSocketAddress, InetSocketAddress>();
    private volatile Map<InetSocketAddress, InetSocketAddress> udp_ext_to_lan = new HashMap<InetSocketAddress, InetSocketAddress>();
    private volatile Map<InetSocketAddress, InetSocketAddress> udp2_ext_to_lan = new HashMap<InetSocketAddress, InetSocketAddress>();
    private volatile Set<InetAddress> lan_addresses = new HashSet<InetAddress>();
    private volatile List<Pattern> lan_subnets = new ArrayList<Pattern>();
    private volatile List<InetSocketAddress> explicit_peers = new ArrayList<InetSocketAddress>();
    private CopyOnWriteSet<InetSocketAddress> explicit_addresses = new CopyOnWriteSet(false);
    private volatile boolean include_well_known_lans = true;
    final AESemaphore initial_search_sem = new AESemaphore("ClientInstanceManager:initialSearch");
    private boolean init_wait_abandoned;
    final AEMonitor this_mon = new AEMonitor("ClientInstanceManager");
    boolean closing;

    static {
        class_mon = new AEMonitor("ClientInstanceManager:class");
        data_socks_proxies = null;
        ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                if (!COConfigurationManager.getBooleanParameter("Proxy.Data.Enable")) {
                    data_socks_proxies = null;
                    return;
                }
                ArrayList<String> hosts = new ArrayList<String>();
                if (COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
                    hosts.add(COConfigurationManager.getStringParameter("Proxy.Host"));
                } else {
                    hosts.add(COConfigurationManager.getStringParameter("Proxy.Data.Host"));
                    int i = 2;
                    while (i <= 3) {
                        hosts.add(COConfigurationManager.getStringParameter("Proxy.Data.Host." + i));
                        ++i;
                    }
                }
                HashSet<String> proxies = new HashSet<String>();
                for (String h : hosts) {
                    if (h == null || (h = h.trim()).isEmpty()) continue;
                    proxies.add(h);
                }
                data_socks_proxies = proxies.isEmpty() ? null : proxies;
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Data.Enable", "Proxy.Host", "Proxy.Data.Same", "Proxy.Data.Host"}, listener);
        int i = 2;
        while (i <= 3) {
            COConfigurationManager.addParameterListener("Proxy.Data.Host." + i, listener);
            ++i;
        }
    }

    public static ClientInstanceManager getSingleton(ClientInstanceManagerAdapter core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new ClientInstanceManagerImpl(core);
            }
        }
        finally {
            class_mon.exit();
        }
        return singleton;
    }

    protected ClientInstanceManagerImpl(ClientInstanceManagerAdapter _adapter) {
        this.adapter = _adapter;
        this.my_instance = new ClientMyInstanceImpl(this.adapter, this);
        this.ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        this.ip_filter.addListener(new IPFilterListener(){

            @Override
            public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
                return true;
            }

            @Override
            public boolean canIPBeBanned(String ip) {
                if (COConfigurationManager.getBooleanParameter("Ip Filter Dont Ban LAN")) {
                    try {
                        InetSocketAddress isa = AENetworkClassifier.categoriseAddress(ip) == "Public" ? new InetSocketAddress(InetAddress.getByName(ip), 0) : InetSocketAddress.createUnresolved(ip, 0);
                        return !ClientInstanceManagerImpl.this.isLANAddress(isa);
                    }
                    catch (Throwable e) {
                        return true;
                    }
                }
                return true;
            }

            @Override
            public void IPFilterEnabledChanged(boolean is_enabled) {
            }

            @Override
            public void IPBlockedListChanged(IpFilter filter2) {
            }

            @Override
            public void IPBanned(BannedIp ip) {
            }
        });
        new ClientPortClashHandler(this);
    }

    @Override
    public void initialize() {
        try {
            this.initialised = true;
            boolean enable = System.getProperty("az.instance.manager.enable", "1").equals("1");
            this.mc_group = enable ? MCGroupFactory.getSingleton(this, MC_GROUP_ADDRESS, 16680, 0, null) : this.getDummyMCGroup();
            this.adapter.addListener(new ClientInstanceManagerAdapter.StateListener(){

                @Override
                public void started() {
                }

                @Override
                public void stopped() {
                    ClientInstanceManagerImpl.this.closing = true;
                    ClientInstanceManagerImpl.this.sendByeBye();
                }
            });
            SimpleTimer.addPeriodicEvent("InstManager:timeouts", 1800000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    ClientInstanceManagerImpl.this.checkTimeouts();
                    ClientInstanceManagerImpl.this.sendAlive();
                }
            });
        }
        catch (Throwable e) {
            if (this.mc_group == null) {
                this.mc_group = this.getDummyMCGroup();
            }
            this.initial_search_sem.releaseForever();
            Debug.printStackTrace(e);
        }
        new AEThread2("ClientInstanceManager:initialSearch", true){

            @Override
            public void run() {
                try {
                    ClientInstanceManagerImpl.this.search();
                    ClientInstanceManagerImpl.this.addAddresses(ClientInstanceManagerImpl.this.my_instance);
                }
                finally {
                    ClientInstanceManagerImpl.this.initial_search_sem.releaseForever();
                }
            }
        }.start();
    }

    private MCGroup getDummyMCGroup() {
        return new MCGroup(){

            @Override
            public int getControlPort() {
                return 0;
            }

            @Override
            public void sendToGroup(byte[] data) {
            }

            @Override
            public void sendToGroup(String param_data) {
            }

            @Override
            public void sendToMember(InetSocketAddress address, byte[] data) throws MCGroupException {
            }
        };
    }

    @Override
    public long getClockSkew() {
        try {
            DHTPlugin dht = this.adapter.getDHTPlugin();
            if (dht != null) {
                return dht.getClockSkew();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return 0L;
    }

    @Override
    public void trace(String str) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, str));
        }
    }

    @Override
    public void log(Throwable e) {
        Debug.printStackTrace(e);
    }

    @Override
    public boolean isInitialized() {
        return this.initial_search_sem.isReleasedForever();
    }

    @Override
    public void updateNow() {
        this.sendAlive();
    }

    protected boolean isClosing() {
        return this.closing;
    }

    protected void sendAlive() {
        this.sendMessage(1);
    }

    protected void sendAlive(InetSocketAddress target) {
        this.sendMessage(1, target);
    }

    protected void sendByeBye() {
        this.sendMessage(2);
    }

    protected void sendByeBye(InetSocketAddress target) {
        this.sendMessage(2, target);
    }

    protected void sendMessage(int type) {
        this.sendMessage(type, (Map)null);
    }

    protected void sendMessage(int type, InetSocketAddress target) {
        this.sendMessage(type, null, target);
    }

    protected void sendMessage(int type, Map body) {
        this.sendMessage(type, body, null);
    }

    protected void sendMessage(int type, Map body, InetSocketAddress member) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ver", new Long(1L));
        map.put("type", new Long(type));
        HashMap<String, Object> originator = new HashMap<String, Object>();
        map.put("orig", originator);
        this.my_instance.encode(originator);
        if (body != null) {
            map.put("body", body);
        }
        try {
            if (member == null) {
                byte[] data = BEncoder.encode(map);
                this.mc_group.sendToGroup(data);
                if (this.explicit_peers.size() > 0) {
                    map.put("explicit", new Long(1L));
                    byte[] explicit_data = BEncoder.encode(map);
                    Iterator<InetSocketAddress> it = this.explicit_peers.iterator();
                    while (it.hasNext()) {
                        this.mc_group.sendToMember(it.next(), explicit_data);
                    }
                }
            } else {
                if (this.explicit_peers.contains(member)) {
                    map.put("explicit", new Long(1L));
                }
                byte[] explicit_data = BEncoder.encode(map);
                this.mc_group.sendToMember(member, explicit_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void received(NetworkInterface network_interface, InetAddress local_address, InetSocketAddress originator, byte[] data, int length) {
        block12: {
            try {
                String originator_id;
                ClientOtherInstanceImpl instance;
                Map<String, Object> map = BDecoder.decode(data, 0, length);
                long version = (Long)map.get("ver");
                long type = (Long)map.get("type");
                InetAddress originator_address = originator.getAddress();
                if (map.get("explicit") != null) {
                    this.addInstanceSupport(originator_address, false);
                }
                if ((instance = ClientOtherInstanceImpl.decode(originator_address, (Map)map.get("orig"))) == null) break block12;
                if (type == 1L) {
                    this.checkAdd(instance);
                    break block12;
                }
                if (type == 2L) {
                    this.checkRemove(instance);
                    break block12;
                }
                this.checkAdd(instance);
                Map body = (Map)map.get("body");
                if (type == 3L) {
                    Map reply;
                    String originator_id2 = instance.getID();
                    if (!originator_id2.equals(this.my_instance.getID()) && (reply = this.requestReceived(instance, body)) != null) {
                        reply.put("oid", originator_id2.getBytes());
                        reply.put("rid", body.get("rid"));
                        this.sendMessage(4, reply, originator);
                    }
                    break block12;
                }
                if (type != 4L || !(originator_id = new String((byte[])body.get("oid"))).equals(this.my_instance.getID())) break block12;
                long req_id = (Long)body.get("rid");
                try {
                    this.this_mon.enter();
                    int i = 0;
                    while (i < this.requests.size()) {
                        Request req = this.requests.get(i);
                        if (req.getID() == req_id) {
                            req.addReply(instance, body);
                        }
                        ++i;
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            catch (Throwable e) {
                Debug.out("Invalid packet received from " + originator, e);
            }
        }
    }

    protected Map requestReceived(ClientInstance instance, Map body) {
        long type = (Long)body.get("type");
        if (type == 1L) {
            return new HashMap();
        }
        if (type == 2L) {
            byte[] hash = (byte[])body.get("hash");
            boolean seed = ((Long)body.get("seed")).intValue() == 1;
            ClientInstanceTracked.TrackTarget target = this.adapter.track(hash);
            if (target != null) {
                try {
                    this.informTracked(new trackedInstance(instance, target, seed));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                HashMap<String, Long> reply = new HashMap<String, Long>();
                reply.put("seed", new Long(target.isSeed() ? 1 : 0));
                return reply;
            }
            return null;
        }
        return null;
    }

    @Override
    public void interfaceChanged(NetworkInterface network_interface) {
        this.sendAlive();
    }

    protected ClientOtherInstanceImpl checkAdd(ClientOtherInstanceImpl inst) {
        if (inst.getID().equals(this.my_instance.getID())) {
            return inst;
        }
        boolean added = false;
        boolean changed = false;
        try {
            this.this_mon.enter();
            ClientOtherInstanceImpl existing = this.other_instances.get(inst.getID());
            if (existing == null) {
                added = true;
                this.other_instances.put(inst.getID(), inst);
            } else {
                changed = existing.update(inst);
                inst = existing;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (added) {
            this.informAdded(inst);
        } else if (changed) {
            this.informChanged(inst);
        }
        return inst;
    }

    protected void checkRemove(ClientOtherInstanceImpl inst) {
        if (inst.getID().equals(this.my_instance.getID())) {
            return;
        }
        boolean removed = false;
        try {
            this.this_mon.enter();
            removed = this.other_instances.remove(inst.getID()) != null;
        }
        finally {
            this.this_mon.exit();
        }
        if (removed) {
            this.informRemoved(inst);
        }
    }

    @Override
    public ClientInstance getMyInstance() {
        return this.my_instance;
    }

    protected void search() {
        this.sendRequest(1);
    }

    @Override
    public int getOtherInstanceCount(boolean block_if_needed) {
        if (!block_if_needed && !this.initial_search_sem.isReleasedForever()) {
            return 0;
        }
        this.waitForInit();
        try {
            this.this_mon.enter();
            int n = this.other_instances.size();
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public ClientInstance[] getOtherInstances() {
        this.waitForInit();
        try {
            this.this_mon.enter();
            ClientInstance[] clientInstanceArray = this.other_instances.values().toArray(new ClientInstance[this.other_instances.size()]);
            return clientInstanceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void waitForInit() {
        if (this.init_wait_abandoned) {
            return;
        }
        if (!this.initial_search_sem.reserve(2500L)) {
            Debug.out("Instance manager - timeout waiting for initial search");
            this.init_wait_abandoned = true;
        }
    }

    protected void addAddresses(ClientInstance inst) {
        List<InetAddress> internal_addresses = inst.getInternalAddresses();
        InetAddress external_address = inst.getExternalAddress();
        int tcp = inst.getTCPListenPort();
        int udp = inst.getUDPListenPort();
        int udp2 = inst.getUDPNonDataListenPort();
        for (InetAddress internal_address : internal_addresses) {
            this.modifyAddresses(internal_address, external_address, tcp, udp, udp2, true);
        }
    }

    protected void removeAddresses(ClientInstance inst) {
        List<InetAddress> internal_addresses = inst.getInternalAddresses();
        InetAddress external_address = inst.getExternalAddress();
        int tcp = inst.getTCPListenPort();
        int udp = inst.getUDPListenPort();
        int udp2 = inst.getUDPNonDataListenPort();
        for (InetAddress internal_address : internal_addresses) {
            this.modifyAddresses(internal_address, external_address, tcp, udp, udp2, false);
        }
    }

    protected void modifyAddresses(InetAddress internal_address, InetAddress external_address, int tcp, int udp, int udp2, boolean add) {
        if (internal_address.isAnyLocalAddress()) {
            try {
                internal_address = NetUtils.getLocalHost();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        try {
            this.this_mon.enter();
            InetSocketAddress int_tcp = new InetSocketAddress(internal_address, tcp);
            InetSocketAddress ext_tcp = new InetSocketAddress(external_address, tcp);
            InetSocketAddress int_udp = new InetSocketAddress(internal_address, udp);
            InetSocketAddress ext_udp = new InetSocketAddress(external_address, udp);
            InetSocketAddress int_udp2 = new InetSocketAddress(internal_address, udp2);
            InetSocketAddress ext_udp2 = new InetSocketAddress(external_address, udp2);
            this.tcp_ext_to_lan = this.modifyAddress(this.tcp_ext_to_lan, ext_tcp, int_tcp, add);
            this.tcp_lan_to_ext = this.modifyAddress(this.tcp_lan_to_ext, int_tcp, ext_tcp, add);
            this.udp_ext_to_lan = this.modifyAddress(this.udp_ext_to_lan, ext_udp, int_udp, add);
            this.udp_lan_to_ext = this.modifyAddress(this.udp_lan_to_ext, int_udp, ext_udp, add);
            this.udp2_ext_to_lan = this.modifyAddress(this.udp2_ext_to_lan, ext_udp2, int_udp2, add);
            this.udp2_lan_to_ext = this.modifyAddress(this.udp2_lan_to_ext, int_udp2, ext_udp2, add);
            if (!this.lan_addresses.contains(internal_address)) {
                HashSet<InetAddress> new_lan_addresses = new HashSet<InetAddress>(this.lan_addresses);
                new_lan_addresses.add(internal_address);
                this.lan_addresses = new_lan_addresses;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected Map<InetSocketAddress, InetSocketAddress> modifyAddress(Map<InetSocketAddress, InetSocketAddress> map, InetSocketAddress key, InetSocketAddress value, boolean add) {
        InetSocketAddress old_value = map.get(key);
        boolean same = old_value != null && old_value.equals(value);
        Map<InetSocketAddress, InetSocketAddress> new_map = map;
        if (add) {
            if (!same) {
                new_map = new HashMap<InetSocketAddress, InetSocketAddress>(map);
                new_map.put(key, value);
            }
        } else if (same) {
            new_map = new HashMap<InetSocketAddress, InetSocketAddress>(map);
            new_map.remove(key);
        }
        return new_map;
    }

    @Override
    public InetSocketAddress getLANAddress(InetSocketAddress external_address, int address_type) {
        Map<InetSocketAddress, InetSocketAddress> map = address_type == 1 ? this.tcp_ext_to_lan : (address_type == 2 ? this.udp_ext_to_lan : this.udp2_ext_to_lan);
        if (map.size() == 0) {
            return null;
        }
        return map.get(external_address);
    }

    @Override
    public InetSocketAddress getExternalAddress(InetSocketAddress lan_address, int address_type) {
        Map<InetSocketAddress, InetSocketAddress> map = address_type == 1 ? this.tcp_lan_to_ext : (address_type == 2 ? this.udp_lan_to_ext : this.udp2_lan_to_ext);
        if (map.size() == 0) {
            return null;
        }
        return map.get(lan_address);
    }

    @Override
    public boolean isLANAddress(InetSocketAddress isa) {
        InetAddress address = isa.getAddress();
        if (address != null) {
            Set<String> sp = data_socks_proxies;
            if (sp != null && sp.contains(address.getHostAddress())) {
                return false;
            }
            if (this.include_well_known_lans && (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress())) {
                return true;
            }
            String host_address = address.getHostAddress();
            int i = 0;
            while (i < this.lan_subnets.size()) {
                Pattern p = this.lan_subnets.get(i);
                if (p.matcher(host_address).matches()) {
                    return true;
                }
                ++i;
            }
            if (this.lan_addresses.contains(address)) {
                return true;
            }
            if (this.explicit_peers.size() > 0) {
                Iterator<InetSocketAddress> it = this.explicit_peers.iterator();
                while (it.hasNext()) {
                    if (!it.next().getAddress().equals(address)) continue;
                    return true;
                }
            }
        }
        if (isa.getPort() != 0) {
            isa = this.setPort(isa, 0);
        }
        return this.explicit_addresses.contains(isa);
    }

    @Override
    public void addExplicitLANAddress(InetSocketAddress isa) {
        if (isa.getPort() != 0) {
            isa = this.setPort(isa, 0);
        }
        this.explicit_addresses.add(isa);
    }

    @Override
    public boolean isExplicitLANAddress(InetSocketAddress isa) {
        return this.explicit_addresses.contains(isa);
    }

    @Override
    public void removeExplicitLANAddress(InetSocketAddress isa) {
        if (isa.getPort() != 0) {
            isa = this.setPort(isa, 0);
        }
        this.explicit_addresses.remove(isa);
    }

    private InetSocketAddress setPort(InetSocketAddress isa, int port) {
        if (isa.isUnresolved()) {
            return InetSocketAddress.createUnresolved(isa.getHostName(), port);
        }
        return new InetSocketAddress(isa.getAddress(), port);
    }

    @Override
    public boolean addLANSubnet(String subnet) throws PatternSyntaxException {
        String str = "";
        int i = 0;
        while (i < subnet.length()) {
            char c = subnet.charAt(i);
            str = c == '*' ? String.valueOf(str) + ".*?" : (c == '.' ? String.valueOf(str) + "\\." : String.valueOf(str) + c);
            ++i;
        }
        Pattern pattern = Pattern.compile(str);
        int i2 = 0;
        while (i2 < this.lan_subnets.size()) {
            if (pattern.pattern().equals(this.lan_subnets.get(i2).pattern())) {
                return false;
            }
            ++i2;
        }
        try {
            this.this_mon.enter();
            ArrayList<Pattern> new_nets = new ArrayList<Pattern>(this.lan_subnets);
            new_nets.add(pattern);
            this.lan_subnets = new_nets;
        }
        finally {
            this.this_mon.exit();
        }
        return true;
    }

    @Override
    public void setIncludeWellKnownLANs(boolean include) {
        this.include_well_known_lans = include;
    }

    @Override
    public boolean getIncludeWellKnownLANs() {
        return this.include_well_known_lans;
    }

    @Override
    public boolean addInstance(InetAddress explicit_address) {
        return this.addInstanceSupport(explicit_address, true);
    }

    protected boolean addInstanceSupport(InetAddress explicit_address, boolean force_send_alive) {
        final InetSocketAddress sad = new InetSocketAddress(explicit_address, 16680);
        boolean new_peer = false;
        if (!this.explicit_peers.contains(sad)) {
            try {
                this.this_mon.enter();
                ArrayList<InetSocketAddress> new_peers = new ArrayList<InetSocketAddress>(this.explicit_peers);
                new_peers.add(sad);
                this.explicit_peers = new_peers;
            }
            finally {
                this.this_mon.exit();
            }
            new_peer = true;
        }
        if ((force_send_alive || new_peer) && this.initialised) {
            new DelayedEvent("ClientInstanceManagerImpl:delaySendAlive", 0L, new AERunnable(){

                @Override
                public void runSupport() {
                    ClientInstanceManagerImpl.this.sendAlive(sad);
                }
            });
        }
        return new_peer;
    }

    @Override
    public ClientInstanceTracked[] track(byte[] hash, ClientInstanceTracked.TrackTarget target) {
        if (this.mc_group == null || this.getOtherInstances().length == 0) {
            return new ClientInstanceTracked[0];
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("hash", hash);
        body.put("seed", new Long(target.isSeed() ? 1 : 0));
        Map replies = this.sendRequest(2, body);
        ClientInstanceTracked[] res = new ClientInstanceTracked[replies.size()];
        Iterator it = replies.entrySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ClientInstance inst = (ClientInstance)entry.getKey();
            Map reply = (Map)entry.getValue();
            boolean seed = ((Long)reply.get("seed")).intValue() == 1;
            res[pos++] = new trackedInstance(inst, target, seed);
        }
        return res;
    }

    protected void checkTimeouts() {
        ClientOtherInstanceImpl inst;
        long now = SystemTime.getCurrentTime();
        ArrayList<ClientOtherInstanceImpl> removed = new ArrayList<ClientOtherInstanceImpl>();
        try {
            this.this_mon.enter();
            Iterator<ClientOtherInstanceImpl> it = this.other_instances.values().iterator();
            while (it.hasNext()) {
                inst = it.next();
                if (!((double)(now - inst.getAliveTime()) > 4500000.0)) continue;
                removed.add(inst);
                it.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < removed.size()) {
            inst = (ClientOtherInstanceImpl)removed.get(i);
            this.informRemoved(inst);
            ++i;
        }
    }

    protected void informRemoved(ClientOtherInstanceImpl inst) {
        this.removeAddresses(inst);
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ClientInstanceManagerListener)this.listeners.get(i)).instanceLost(inst);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void informAdded(ClientInstance inst) {
        this.addAddresses(inst);
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ClientInstanceManagerListener)this.listeners.get(i)).instanceFound(inst);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void informChanged(ClientInstance inst) {
        this.addAddresses(inst);
        if (inst == this.my_instance) {
            this.sendAlive();
        }
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ClientInstanceManagerListener)this.listeners.get(i)).instanceChanged(inst);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void informTracked(ClientInstanceTracked inst) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ClientInstanceManagerListener)this.listeners.get(i)).instanceTracked(inst);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected Map sendRequest(int type) {
        return new Request(type, new HashMap()).getReplies();
    }

    protected Map sendRequest(int type, Map body) {
        return new Request(type, body).getReplies();
    }

    @Override
    public void addListener(ClientInstanceManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ClientInstanceManagerListener l) {
        this.listeners.remove(l);
    }

    protected class Request {
        private long id;
        private final Set reply_instances = new HashSet();
        private final Map replies = new HashMap();

        protected Request(int type, Map body) {
            try {
                ClientInstanceManagerImpl.this.this_mon.enter();
                this.id = ClientInstanceManagerImpl.this.search_id_next++;
                ClientInstanceManagerImpl.this.requests.add(this);
            }
            finally {
                ClientInstanceManagerImpl.this.this_mon.exit();
            }
            body.put("type", new Long(type));
            body.put("rid", new Long(this.id));
            ClientInstanceManagerImpl.this.sendMessage(3, body);
        }

        protected long getID() {
            return this.id;
        }

        protected void addReply(ClientInstance instance, Map body) {
            try {
                ClientInstanceManagerImpl.this.this_mon.enter();
                if (!this.reply_instances.contains(instance.getID())) {
                    this.reply_instances.add(instance.getID());
                    this.replies.put(instance, body);
                }
            }
            finally {
                ClientInstanceManagerImpl.this.this_mon.exit();
            }
        }

        protected Map getReplies() {
            try {
                Thread.sleep(2500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ClientInstanceManagerImpl.this.this_mon.enter();
                ClientInstanceManagerImpl.this.requests.remove(this);
                Map map = this.replies;
                return map;
            }
            finally {
                ClientInstanceManagerImpl.this.this_mon.exit();
            }
        }
    }

    protected static class trackedInstance
    implements ClientInstanceTracked {
        private final ClientInstance instance;
        private final ClientInstanceTracked.TrackTarget target;
        private final boolean seed;

        protected trackedInstance(ClientInstance _instance, ClientInstanceTracked.TrackTarget _target, boolean _seed) {
            this.instance = _instance;
            this.target = _target;
            this.seed = _seed;
        }

        @Override
        public ClientInstance getInstance() {
            return this.instance;
        }

        @Override
        public ClientInstanceTracked.TrackTarget getTarget() {
            return this.target;
        }

        @Override
        public boolean isSeed() {
            return this.seed;
        }
    }
}

