/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.helpers;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManagerInitialisationAdapter;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.protocol.magnet.MagnetConnection2;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class TorrentFolderWatcher {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String PARAMID_FOLDER = "Watch Torrent Folder";
    private volatile GlobalManager _global_manager;
    private final LoggerChannel log;
    volatile boolean running = false;
    private final ArrayList<TOTorrent> to_delete = new ArrayList();
    protected final AEMonitor this_mon = new AEMonitor("TorrentFolderWatcher");
    private final FilenameFilter filename_filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lc_name = name.toLowerCase();
            return lc_name.endsWith(".torrent") || lc_name.endsWith(".tor") || lc_name.endsWith(".magnet");
        }
    };
    private final ParameterListener param_listener = new ParameterListener(){

        @Override
        public void parameterChanged(String parameterName) {
            if (COConfigurationManager.getBooleanParameter(TorrentFolderWatcher.PARAMID_FOLDER)) {
                if (!TorrentFolderWatcher.this.running) {
                    TorrentFolderWatcher.this.running = true;
                    if (!TorrentFolderWatcher.this.watch_thread.isAlive()) {
                        TorrentFolderWatcher.this.watch_thread.setDaemon(true);
                        TorrentFolderWatcher.this.watch_thread.setPriority(1);
                        TorrentFolderWatcher.this.watch_thread.start();
                    }
                }
            } else {
                TorrentFolderWatcher.this.running = false;
            }
        }
    };
    final Thread watch_thread = new AEThread("FolderWatcher"){
        private long last_run;
        final AESemaphore wait_sem;
        {
            this.last_run = 0L;
            this.wait_sem = new AESemaphore("fw:wait");
            COConfigurationManager.addParameterListener(new String[]{TorrentFolderWatcher.PARAMID_FOLDER, "Watch Torrent Folder Interval Secs"}, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    wait_sem.release();
                }
            });
        }

        @Override
        public void runSupport() {
            while (true) {
                int sleep_ms;
                long remaining;
                long now = SystemTime.getMonotonousTime();
                int sleep_secs = COConfigurationManager.getIntParameter("Watch Torrent Folder Interval Secs");
                if (sleep_secs < 1) {
                    sleep_secs = 1;
                }
                if ((remaining = this.last_run + (long)(sleep_ms = sleep_secs * 1000) - now) >= 250L && this.last_run != 0L) {
                    this.wait_sem.reserve(remaining);
                    continue;
                }
                this.last_run = now;
                try {
                    if (TorrentFolderWatcher.this.running) {
                        TorrentFolderWatcher.this.importAddedFiles();
                        continue;
                    }
                    this.wait_sem.reserve(60000L);
                    continue;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    continue;
                }
                break;
            }
        }
    };
    private List<File> pending_magnets = new ArrayList<File>();
    private Set<File> active_magnets = new HashSet<File>();
    private Set<File> failed_magnets = new HashSet<File>();

    public TorrentFolderWatcher(GlobalManager global_manager) {
        this._global_manager = global_manager;
        Core core = CoreFactory.getSingleton();
        PluginInterface plugin_interface = core.getPluginManager().getDefaultPluginInterface();
        this.log = plugin_interface.getLogger().getTimeStampedChannel("Torrent Importer");
        UIManager ui_manager = plugin_interface.getUIManager();
        BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("log.torrent.importer");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.attachLoggerChannel(this.log);
    }

    public void start() {
        if (COConfigurationManager.getBooleanParameter(PARAMID_FOLDER)) {
            this.running = true;
            this.watch_thread.setDaemon(true);
            this.watch_thread.setPriority(1);
            this.watch_thread.start();
        }
        COConfigurationManager.addParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    public void destroy() {
        this.running = false;
        this._global_manager = null;
        COConfigurationManager.removeParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    private File renameToImported(File parent, File file) {
        File imported = FileUtil.newFile(parent, String.valueOf(file.getName()) + ".imported");
        if (imported.exists()) {
            imported.delete();
        }
        TorrentUtils.move(file, imported);
        return imported;
    }

    void importAddedFiles() {
        Core core = CoreFactory.getSingleton();
        try {
            this.this_mon.enter();
            if (!this.running) {
                return;
            }
            GlobalManager global_manager = this._global_manager;
            if (global_manager == null || !core.isStarted()) {
                return;
            }
            DownloadManager plugin_dm = core.getPluginManager().getDefaultPluginInterface().getDownloadManager();
            boolean save_torrents_default = COConfigurationManager.getBooleanParameter("Save Torrent Files");
            String torrent_save_path = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
            final int start_mode = COConfigurationManager.getIntParameter("Watch Torrents Add Mode");
            boolean always_rename = COConfigurationManager.getBooleanParameter("Watch Torrent Always Rename");
            int num_folders = COConfigurationManager.getIntParameter("Watch Torrent Folder Path Count", 1);
            ArrayList<File> folders = new ArrayList<File>();
            ArrayList<String> tags = new ArrayList<String>();
            int i = 0;
            while (i < num_folders) {
                String folder_path = COConfigurationManager.getStringParameter("Watch Torrent Folder Path" + (i == 0 ? "" : " " + i));
                File folder = null;
                if (folder_path != null && folder_path.length() > 0 && !(folder = FileUtil.newFile(folder_path, new String[0])).isDirectory()) {
                    if (!folder.exists()) {
                        FileUtil.mkdirs(folder);
                    }
                    if (!folder.isDirectory()) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] does not exist or is not a dir"));
                        }
                        folder = null;
                    }
                }
                if (folder != null) {
                    folders.add(folder);
                    String tag = COConfigurationManager.getStringParameter("Watch Torrent Folder Tag" + (i == 0 ? "" : " " + i), null);
                    if (tag != null && tag.trim().length() == 0) {
                        tag = null;
                    }
                    tags.add(tag);
                }
                ++i;
            }
            if (folders.isEmpty()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] not configured"));
                }
                return;
            }
            String default_data_save_path = COConfigurationManager.getStringParameter("Default save path");
            File f = null;
            if (default_data_save_path != null && default_data_save_path.length() > 0 && !(f = FileUtil.newFile(default_data_save_path, new String[0])).isDirectory()) {
                if (!f.exists()) {
                    FileUtil.mkdirs(f);
                }
                if (!f.isDirectory()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 3, "[Default save path] does not exist or is not a dir"));
                    }
                    Logger.log(new LogAlert(false, 3, "[Default save path] does not exist or is not a dir"));
                    return;
                }
            }
            if (f == null) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                }
                Logger.log(new LogAlert(false, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
            }
            int i2 = 0;
            while (i2 < this.to_delete.size()) {
                TOTorrent torrent = this.to_delete.get(i2);
                try {
                    this.log("Deleting processed torrent: " + TorrentUtils.getTorrentFileName(torrent));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                try {
                    TorrentUtils.delete(torrent);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i2;
            }
            this.to_delete.clear();
            int folder_index = 0;
            while (folder_index < folders.size()) {
                File folder = (File)folders.get(folder_index);
                this.log("Processing " + folder);
                final String tag_name = (String)tags.get(folder_index);
                boolean save_torrents = save_torrents_default;
                if (torrent_save_path.length() == 0 || FileUtil.newFile(torrent_save_path, new String[0]).getAbsolutePath().equals(folder.getAbsolutePath()) || !FileUtil.newFile(torrent_save_path, new String[0]).isDirectory()) {
                    save_torrents = false;
                }
                boolean rename_to_imported = always_rename || !save_torrents;
                String[] currentFileList = folder.list(this.filename_filter);
                if (currentFileList == null) {
                    Logger.log(new LogEvent(LOGID, 3, "There was a problem trying to get a listing of torrents from " + folder));
                } else {
                    int i3 = 0;
                    while (i3 < currentFileList.length) {
                        block57: {
                            if (!this.running) {
                                return;
                            }
                            File file = FileUtil.newFile(folder, currentFileList[i3]).getAbsoluteFile();
                            if (file.getName().toLowerCase(Locale.US).endsWith(".magnet")) {
                                this.handleMagnet(file);
                            } else {
                                this.log("Importing " + file.getName());
                                try {
                                    File move_loc;
                                    TagFeatureFileLocation tag_save_location;
                                    TagManager tm;
                                    TagType tt;
                                    Tag tag;
                                    TOTorrent torrent = TorrentUtils.readFromFile(file, false);
                                    com.biglybt.core.download.DownloadManager dm = global_manager.getDownloadManager(torrent);
                                    if (dm != null) {
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, String.valueOf(file.getAbsolutePath()) + " is already being downloaded"));
                                        }
                                        if (rename_to_imported && !file.equals(FileUtil.newFile(dm.getTorrentFileName(), new String[0]).getAbsoluteFile())) {
                                            this.renameToImported(folder, file);
                                        }
                                        this.applyTag(dm, tag_name);
                                        this.log("Import ignored, download already present: " + file.getName());
                                        break block57;
                                    }
                                    if (plugin_dm.lookupDownloadStub(torrent.getHash()) != null) {
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, String.valueOf(file.getAbsolutePath()) + " is an archived download"));
                                        }
                                        if (rename_to_imported) {
                                            this.renameToImported(folder, file);
                                        } else {
                                            this.to_delete.add(torrent);
                                        }
                                        this.log("Import ignored, download already archived: " + file.getName());
                                        break block57;
                                    }
                                    final boolean[] to_skip = TorrentUtils.getSkipFiles(torrent);
                                    DownloadManagerInitialisationAdapter dmia = new DownloadManagerInitialisationAdapter(){

                                        @Override
                                        public int getActions() {
                                            return 1;
                                        }

                                        @Override
                                        public void initialised(com.biglybt.core.download.DownloadManager dm, boolean for_seeding) {
                                            DiskManagerFileInfoSet file_info_set = dm.getDiskManagerFileInfoSet();
                                            DiskManagerFileInfo[] fileInfos = file_info_set.getFiles();
                                            DownloadManagerState dms = dm.getDownloadState();
                                            boolean reorder_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                                            int reorder_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
                                            if (to_skip != null) {
                                                boolean[] toCompact = new boolean[fileInfos.length];
                                                boolean[] toReorderCompact = new boolean[fileInfos.length];
                                                int comp_num = 0;
                                                int reorder_comp_num = 0;
                                                try {
                                                    dms.suppressStateSave(true);
                                                    int i = 0;
                                                    while (i < fileInfos.length) {
                                                        DiskManagerFileInfo fileInfo2;
                                                        File fDest;
                                                        if (to_skip[i] && !(fDest = (fileInfo2 = fileInfos[i]).getFile(true)).exists()) {
                                                            if (reorder_mode && fileInfo2.getLength() / 0x100000L >= (long)reorder_mode_min_mb) {
                                                                toReorderCompact[i] = true;
                                                                ++reorder_comp_num;
                                                            } else {
                                                                toCompact[i] = true;
                                                                ++comp_num;
                                                            }
                                                        }
                                                        ++i;
                                                    }
                                                    file_info_set.setSkipped(to_skip, true);
                                                    if (comp_num > 0) {
                                                        file_info_set.setStorageTypes(toCompact, 2);
                                                    }
                                                    if (reorder_comp_num > 0) {
                                                        file_info_set.setStorageTypes(toReorderCompact, 4);
                                                    }
                                                }
                                                finally {
                                                    dms.suppressStateSave(false);
                                                }
                                            }
                                            TorrentFolderWatcher.this.applyTag(dm, tag_name);
                                            TorrentFolderWatcher.this.applyAutoTagging(dm);
                                            TorrentOpenOptions.addModeDuringCreate(start_mode, dm);
                                        }
                                    };
                                    byte[] hash = null;
                                    try {
                                        hash = torrent.getHash();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    String data_save_path = default_data_save_path;
                                    boolean for_seeding = false;
                                    if (tag_name != null && (tag = (tt = (tm = TagManagerFactory.getTagManager()).getTagType(3)).getTag(tag_name, true)) instanceof TagFeatureFileLocation && (tag_save_location = (TagFeatureFileLocation)((Object)tag)).supportsTagMoveOnComplete() && (move_loc = tag_save_location.getTagMoveOnCompleteFolder()) != null && move_loc.exists()) {
                                        File root = torrent.isSimpleTorrent() ? move_loc : FileUtil.newFile(move_loc, FileUtil.convertOSSpecificChars(TorrentUtils.getLocalisedName(torrent), true));
                                        if ((tag_save_location.getTagMoveOnCompleteOptions() & 1L) != 0L) {
                                            TOTorrentFile[] files = torrent.getFiles();
                                            boolean all_exist = true;
                                            int j = 0;
                                            while (j < files.length) {
                                                File file_loc;
                                                if (!(to_skip != null && to_skip[j] || (file_loc = FileUtil.newFile(root, files[j].getRelativePath())).exists())) {
                                                    all_exist = false;
                                                    break;
                                                }
                                                ++j;
                                            }
                                            if (all_exist) {
                                                data_save_path = move_loc.getAbsolutePath();
                                                for_seeding = true;
                                            }
                                        }
                                    }
                                    int start_state = TorrentOpenOptions.addModePreCreate(start_mode);
                                    if (rename_to_imported) {
                                        File imported = this.renameToImported(folder, file);
                                        dm = global_manager.addDownloadManager(imported.getAbsolutePath(), hash, data_save_path, start_state, true, for_seeding, dmia);
                                    } else {
                                        dm = global_manager.addDownloadManager(file.getAbsolutePath(), hash, data_save_path, start_state, true, for_seeding, dmia);
                                        this.to_delete.add(torrent);
                                    }
                                    this.log("Imported " + file.getName());
                                    this.applyTag(dm, tag_name);
                                    TorrentOpenOptions.addModePostCreate(start_mode, dm);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Auto-imported " + file.getAbsolutePath()));
                                    }
                                }
                                catch (Throwable e) {
                                    this.log("Failed to import " + file.getName() + ": " + Debug.getNestedExceptionMessage(e));
                                    Debug.out("Failed to auto-import torrent file '" + file.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(e));
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                        ++i3;
                    }
                }
                ++folder_index;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void applyTag(com.biglybt.core.download.DownloadManager dm, String tag_name) {
        if (tag_name != null && dm != null) {
            TagManager tm = TagManagerFactory.getTagManager();
            TagType tt = tm.getTagType(3);
            Tag tag = tt.getTag(tag_name, true);
            try {
                if (tag == null) {
                    tag = tt.createTag(tag_name, true);
                }
                if (!tag.hasTaggable(dm)) {
                    tag.addTaggable(dm);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void applyAutoTagging(com.biglybt.core.download.DownloadManager dm) {
        DiskManagerFileInfo[] files;
        if (!COConfigurationManager.getBooleanParameter("Files Auto Tag Enable")) {
            return;
        }
        HashMap<String, long[]> ext_map = new HashMap<String, long[]>();
        DiskManagerFileInfoSet file_info_set = dm.getDiskManagerFileInfoSet();
        DiskManagerFileInfo[] diskManagerFileInfoArray = files = file_info_set.getFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String ext;
            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
            if (!file.isSkipped() && (ext = file.getExtension()) != null && ext.startsWith(".")) {
                ext = ext.substring(1);
                long file_size = file.getLength();
                long[] size = (long[])ext_map.get(ext);
                if (size == null) {
                    ext_map.put(ext, new long[]{file_size});
                } else {
                    size[0] = size[0] + file_size;
                }
            }
            ++n2;
        }
        int num = COConfigurationManager.getIntParameter("Files Auto Tag Count");
        TagManager tm = TagManagerFactory.getTagManager();
        TagType tag_type = tm.getTagType(3);
        ArrayList<Tag> matched_tags = new ArrayList<Tag>();
        Tag max_match_tag = null;
        long max_match_size = -1L;
        int i = 0;
        while (i < num) {
            String exts = COConfigurationManager.getStringParameter("File Auto Tag Exts " + (i == 0 ? "" : " " + i), "");
            if (!(exts = exts.trim().toLowerCase(Locale.US)).isEmpty()) {
                String tag_name = COConfigurationManager.getStringParameter("File Auto Tag Name " + (i == 0 ? "" : " " + i), "");
                if (!(tag_name = tag_name.trim()).isEmpty()) {
                    try {
                        Tag tag = tag_type.getTag(tag_name, true);
                        if (tag == null) {
                            tag = tag_type.createTag(tag_name, true);
                            tag.setPublic(false);
                        }
                        String[] bits = exts.replaceAll(",", ";").split(";");
                        boolean matched = false;
                        long max_match = 0L;
                        String[] stringArray = bits;
                        int n3 = bits.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            long[] size;
                            String bit = stringArray[n4];
                            if ((bit = bit.trim()).startsWith(".")) {
                                bit = bit.substring(1);
                            }
                            if ((size = (long[])ext_map.get(bit)) != null) {
                                matched = true;
                                if (size[0] > max_match) {
                                    max_match = size[0];
                                }
                            }
                            ++n4;
                        }
                        if (matched) {
                            matched_tags.add(tag);
                            if (max_match > max_match_size) {
                                max_match_size = max_match;
                                max_match_tag = tag;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            ++i;
        }
        ArrayList<Tag> selected_tags = new ArrayList<Tag>();
        if (matched_tags.isEmpty()) {
            String def_tag = COConfigurationManager.getStringParameter("File Auto Tag Name Default", "");
            if (!(def_tag = def_tag.trim()).isEmpty()) {
                try {
                    Tag tag = tag_type.getTag(def_tag, true);
                    if (tag == null) {
                        tag = tag_type.createTag(def_tag, true);
                        tag.setPublic(false);
                    }
                    selected_tags.add(tag);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        } else {
            boolean tag_best = COConfigurationManager.getBooleanParameter("Files Auto Tag Best Size");
            if (tag_best) {
                selected_tags.add(max_match_tag);
            } else {
                selected_tags.addAll(matched_tags);
            }
        }
        for (Tag t : selected_tags) {
            t.addTaggable(dm);
        }
    }

    private void handleMagnet(File file) {
        if (this.active_magnets.contains(file) || this.failed_magnets.contains(file) || this.pending_magnets.contains(file)) {
            return;
        }
        this.log("Adding magnet to queue: " + file.getName());
        this.pending_magnets.add(file);
        if (this.active_magnets.size() >= 5) {
            return;
        }
        final File to_do = this.pending_magnets.remove(0);
        this.active_magnets.add(to_do);
        new AEThread2("FolderWatcher:magnetdl"){

            @Override
            public void run() {
                File active = to_do;
                while (true) {
                    boolean ok = false;
                    boolean bad_magnet = true;
                    try {
                        try {
                            TorrentFolderWatcher.this.log("Processing magnet: " + active.getName());
                            String magnet_uri = FileUtil.readFileAsString(active, 32000, "UTF-8");
                            URL magnet_url = new URL(magnet_uri);
                            if (!magnet_url.getProtocol().toLowerCase(Locale.US).equals("magnet")) {
                                throw new Exception("URL '" + magnet_url + "' is not magnet protocol");
                            }
                            bad_magnet = false;
                            File output_file = FileUtil.newFile(String.valueOf(active.getAbsolutePath()) + ".torrent", new String[0]);
                            if (output_file.exists()) {
                                output_file.delete();
                            }
                            MagnetConnection2 con = (MagnetConnection2)magnet_url.openConnection();
                            try {
                                con.connect();
                                FileUtil.copyFile(con.getInputStream(), output_file);
                                if (output_file.length() == 0L) {
                                    output_file.delete();
                                    throw new Exception("Magnet download failed");
                                }
                                ok = true;
                            }
                            finally {
                                con.disconnect();
                            }
                        }
                        catch (Throwable e) {
                            Debug.out("Failed to auto-import magnet file '" + active.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(e));
                            Debug.printStackTrace(e);
                            try {
                                TorrentFolderWatcher.this.this_mon.enter();
                                TorrentFolderWatcher.this.active_magnets.remove(active);
                                if (ok) {
                                    TorrentFolderWatcher.this.log("Completed magnet: " + active.getName());
                                    active.delete();
                                } else {
                                    if (bad_magnet) {
                                        TorrentFolderWatcher.this.log("Bad magnet, failing: " + active.getName());
                                        active.renameTo(FileUtil.newFile(String.valueOf(active.getAbsolutePath()) + ".failed", new String[0]));
                                    } else {
                                        TorrentFolderWatcher.this.log("Magnet download failed, will retry later: " + active.getName());
                                    }
                                    TorrentFolderWatcher.this.failed_magnets.add(active);
                                }
                                if (TorrentFolderWatcher.this.pending_magnets.isEmpty()) {
                                    if (!TorrentFolderWatcher.this.active_magnets.isEmpty()) break;
                                    TorrentFolderWatcher.this.failed_magnets.clear();
                                    break;
                                }
                                active = (File)TorrentFolderWatcher.this.pending_magnets.remove(0);
                                TorrentFolderWatcher.this.active_magnets.add(active);
                                continue;
                            }
                            finally {
                                TorrentFolderWatcher.this.this_mon.exit();
                                continue;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            TorrentFolderWatcher.this.this_mon.enter();
                            TorrentFolderWatcher.this.active_magnets.remove(active);
                            if (ok) {
                                TorrentFolderWatcher.this.log("Completed magnet: " + active.getName());
                                active.delete();
                            } else {
                                if (bad_magnet) {
                                    TorrentFolderWatcher.this.log("Bad magnet, failing: " + active.getName());
                                    active.renameTo(FileUtil.newFile(String.valueOf(active.getAbsolutePath()) + ".failed", new String[0]));
                                } else {
                                    TorrentFolderWatcher.this.log("Magnet download failed, will retry later: " + active.getName());
                                }
                                TorrentFolderWatcher.this.failed_magnets.add(active);
                            }
                            if (TorrentFolderWatcher.this.pending_magnets.isEmpty()) {
                                if (!TorrentFolderWatcher.this.active_magnets.isEmpty()) break;
                                TorrentFolderWatcher.this.failed_magnets.clear();
                                break;
                            }
                            active = (File)TorrentFolderWatcher.this.pending_magnets.remove(0);
                            TorrentFolderWatcher.this.active_magnets.add(active);
                        }
                        finally {
                            TorrentFolderWatcher.this.this_mon.exit();
                        }
                        throw throwable;
                    }
                    try {
                        TorrentFolderWatcher.this.this_mon.enter();
                        TorrentFolderWatcher.this.active_magnets.remove(active);
                        if (ok) {
                            TorrentFolderWatcher.this.log("Completed magnet: " + active.getName());
                            active.delete();
                        } else {
                            if (bad_magnet) {
                                TorrentFolderWatcher.this.log("Bad magnet, failing: " + active.getName());
                                active.renameTo(FileUtil.newFile(String.valueOf(active.getAbsolutePath()) + ".failed", new String[0]));
                            } else {
                                TorrentFolderWatcher.this.log("Magnet download failed, will retry later: " + active.getName());
                            }
                            TorrentFolderWatcher.this.failed_magnets.add(active);
                        }
                        if (TorrentFolderWatcher.this.pending_magnets.isEmpty()) {
                            if (!TorrentFolderWatcher.this.active_magnets.isEmpty()) break;
                            TorrentFolderWatcher.this.failed_magnets.clear();
                            break;
                        }
                        active = (File)TorrentFolderWatcher.this.pending_magnets.remove(0);
                        TorrentFolderWatcher.this.active_magnets.add(active);
                        continue;
                    }
                    finally {
                        TorrentFolderWatcher.this.this_mon.exit();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private void log(String str) {
        this.log.log(str);
    }
}

