/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.global.impl;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostFactory;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.tracker.host.TRHostTorrentFinder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import java.io.File;

class GlobalManagerHostSupport
implements TRHostTorrentFinder {
    protected final GlobalManager gm;
    protected final TRHost host;

    protected GlobalManagerHostSupport(GlobalManager _gm) {
        this.gm = _gm;
        this.host = TRHostFactory.getSingleton();
        this.host.initialise(this);
    }

    @Override
    public TOTorrent lookupTorrent(byte[] hash) {
        TOTorrent torrent;
        DownloadManager dm = this.gm.getDownloadManager(new HashWrapper(hash));
        if (dm != null && (torrent = dm.getTorrent()) != null) {
            return torrent;
        }
        torrent = DownloadManagerImpl.getStubTorrent(hash);
        return torrent;
    }

    protected void torrentRemoved(DownloadManager download_manager, TOTorrent torrent) {
        File torrent_file;
        boolean is_magnet = download_manager.getDownloadState().getFlag(512L);
        if (is_magnet) {
            return;
        }
        String torrent_file_str = download_manager.getTorrentFileName();
        TRHostTorrent host_torrent = this.host.getHostTorrent(torrent);
        if (host_torrent != null && (torrent_file = FileUtil.newFile(torrent_file_str, new String[0])).exists()) {
            try {
                TorrentUtils.writeToFile(host_torrent.getTorrent(), torrent_file, false);
                host_torrent.setPassive(true);
            }
            catch (Throwable e) {
                Debug.out("Failed to make torrent '" + torrent_file_str + "' passive: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void torrentAdded(DownloadManager download_manager) {
        boolean is_magnet = download_manager.getDownloadState().getFlag(512L);
        if (is_magnet) {
            return;
        }
        TOTorrent torrent = download_manager.getTorrent();
        TRHostTorrent host_torrent = this.host.getHostTorrent(torrent);
        if (host_torrent != null && host_torrent.getTorrent() != torrent) {
            host_torrent.setTorrent(torrent);
        }
    }

    protected void destroy() {
        this.host.close();
    }
}

