/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManagerAvailability;
import com.biglybt.core.download.impl.DownloadManagerController;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.TrackerPeerSourceAdapter;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerDataProvider;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerFactory;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import com.biglybt.plugin.tracker.dht.DHTTrackerPlugin;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DownloadManagerAvailabilityImpl
implements DownloadManagerAvailability {
    private final List<TrackerPeerSource> peer_sources = new ArrayList<TrackerPeerSource>();
    TRTrackerAnnouncer tracker_client;

    public DownloadManagerAvailabilityImpl(TOTorrent to_torrent, List<List<String>> updated_trackers, String[] _enabled_peer_sources, final String[] _enabled_networks) {
        if (to_torrent == null) {
            return;
        }
        HashSet<String> enabled_peer_sources = new HashSet<String>(Arrays.asList(_enabled_peer_sources));
        HashSet<String> enabled_networks = new HashSet<String>(Arrays.asList(_enabled_networks));
        if (enabled_peer_sources.contains("Tracker")) {
            TOTorrentAnnounceURLSet[] sets;
            if (updated_trackers == null) {
                sets = to_torrent.getAnnounceURLGroup().getAnnounceURLSets();
            } else {
                sets = TorrentUtils.listToAnnounceSets(updated_trackers, to_torrent);
                try {
                    to_torrent = TorrentUtils.cloneTorrent(to_torrent);
                    TorrentUtils.setMemoryOnly(to_torrent, true);
                    to_torrent.getAnnounceURLGroup().setAnnounceURLSets(sets);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (sets.length == 0) {
                sets = new TOTorrentAnnounceURLSet[]{to_torrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{to_torrent.getAnnounceURL()})};
            }
            try {
                this.tracker_client = TRTrackerAnnouncerFactory.create(to_torrent, new TRTrackerAnnouncerFactory.DataProvider(){

                    @Override
                    public String[] getNetworks() {
                        return _enabled_networks;
                    }

                    @Override
                    public HashWrapper getTorrentHashOverride() {
                        return null;
                    }
                });
                final long torrent_size = to_torrent.getSize();
                this.tracker_client.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){

                    @Override
                    public String getName() {
                        return "Availability checker";
                    }

                    @Override
                    public long getTotalSent() {
                        return 0L;
                    }

                    @Override
                    public long getTotalReceived() {
                        return 0L;
                    }

                    @Override
                    public long getRemaining() {
                        return torrent_size;
                    }

                    @Override
                    public long getFailedHashCheck() {
                        return 0L;
                    }

                    @Override
                    public String getExtensions() {
                        return null;
                    }

                    @Override
                    public int getMaxNewConnectionsAllowed(String network) {
                        return 1;
                    }

                    @Override
                    public int getPendingConnectionCount() {
                        return 0;
                    }

                    @Override
                    public int getConnectedConnectionCount() {
                        return 0;
                    }

                    @Override
                    public int getUploadSpeedKBSec(boolean estimate) {
                        return 0;
                    }

                    @Override
                    public int getTCPListeningPortNumber() {
                        return TCPNetworkManager.getSingleton().getDefaultTCPListeningPortNumber();
                    }

                    @Override
                    public int getCryptoLevel() {
                        return 0;
                    }

                    @Override
                    public boolean isPeerSourceEnabled(String peer_source) {
                        return true;
                    }

                    @Override
                    public void setPeerSources(String[] allowed_sources) {
                    }
                });
                this.tracker_client.update(true);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                final TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                final URL[] urls = set.getAnnounceURLs();
                if (urls.length != 0 && !TorrentUtils.isDecentralised(urls[0])) {
                    this.peer_sources.add(new TrackerPeerSource(){
                        private TrackerPeerSource _delegate;
                        private TRTrackerAnnouncer ta;
                        private long ta_fixup;
                        private long last_scrape_fixup_time;
                        private Object[] last_scrape;

                        private TrackerPeerSource fixup() {
                            long now = SystemTime.getMonotonousTime();
                            if (now - this.ta_fixup > 1000L) {
                                TRTrackerAnnouncer current_ta = DownloadManagerAvailabilityImpl.this.tracker_client;
                                if (current_ta == this.ta) {
                                    if (current_ta != null && this._delegate == null) {
                                        this._delegate = current_ta.getTrackerPeerSource(set);
                                    }
                                } else {
                                    this._delegate = current_ta == null ? null : current_ta.getTrackerPeerSource(set);
                                    this.ta = current_ta;
                                }
                                this.ta_fixup = now;
                            }
                            return this._delegate;
                        }

                        protected Object[] getScrape() {
                            long now = SystemTime.getMonotonousTime();
                            if (now - this.last_scrape_fixup_time > 30000L || this.last_scrape == null) {
                                this.last_scrape = new Object[]{-1, -1, -1, -1, -1, ""};
                                this.last_scrape_fixup_time = now;
                            }
                            return this.last_scrape;
                        }

                        @Override
                        public int getType() {
                            return 1;
                        }

                        @Override
                        public String getName() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return urls[0].toExternalForm();
                            }
                            return delegate.getName();
                        }

                        @Override
                        public String getDetails() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return null;
                            }
                            return delegate.getDetails();
                        }

                        @Override
                        public URL getURL() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return urls[0];
                            }
                            return delegate.getURL();
                        }

                        @Override
                        public int getStatus() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return 2;
                            }
                            return delegate.getStatus();
                        }

                        @Override
                        public String getStatusString() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return (String)this.getScrape()[5];
                            }
                            return delegate.getStatusString();
                        }

                        @Override
                        public int getSeedCount() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return (Integer)this.getScrape()[0];
                            }
                            int seeds = delegate.getSeedCount();
                            if (seeds < 0) {
                                seeds = (Integer)this.getScrape()[0];
                            }
                            return seeds;
                        }

                        @Override
                        public int getLeecherCount() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return (Integer)this.getScrape()[1];
                            }
                            int leechers = delegate.getLeecherCount();
                            if (leechers < 0) {
                                leechers = (Integer)this.getScrape()[1];
                            }
                            return leechers;
                        }

                        @Override
                        public int getCompletedCount() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return (Integer)this.getScrape()[4];
                            }
                            int comp2 = delegate.getCompletedCount();
                            if (comp2 < 0) {
                                comp2 = (Integer)this.getScrape()[4];
                            }
                            return comp2;
                        }

                        @Override
                        public int getPeers() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return -1;
                            }
                            if (delegate.getSeedCount() > 0 || delegate.getLeecherCount() > 0) {
                                return -1;
                            }
                            return delegate.getPeers();
                        }

                        @Override
                        public int getInterval() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                Object[] si = this.getScrape();
                                int last = (Integer)si[2];
                                int next = (Integer)si[3];
                                if (last > 0 && next < Integer.MAX_VALUE && last < next) {
                                    return next - last;
                                }
                                return -1;
                            }
                            return delegate.getInterval();
                        }

                        @Override
                        public int getMinInterval() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return -1;
                            }
                            return delegate.getMinInterval();
                        }

                        @Override
                        public boolean isUpdating() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return false;
                            }
                            return delegate.isUpdating();
                        }

                        @Override
                        public int getLastUpdate() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return (Integer)this.getScrape()[2];
                            }
                            return delegate.getLastUpdate();
                        }

                        @Override
                        public int getSecondsToUpdate() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return Integer.MIN_VALUE;
                            }
                            return delegate.getSecondsToUpdate();
                        }

                        @Override
                        public boolean canManuallyUpdate() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return false;
                            }
                            return delegate.canManuallyUpdate();
                        }

                        @Override
                        public void manualUpdate() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate != null) {
                                delegate.manualUpdate();
                            }
                        }

                        @Override
                        public long[] getReportedStats() {
                            TrackerPeerSource delegate = this.fixup();
                            if (delegate == null) {
                                return null;
                            }
                            return delegate.getReportedStats();
                        }

                        @Override
                        public boolean canDelete() {
                            return false;
                        }

                        @Override
                        public void delete() {
                        }
                    });
                }
                ++n2;
            }
        }
        Torrent torrent = PluginCoreUtils.wrap(to_torrent);
        try {
            TrackerPeerSource ext_ps;
            ExternalSeedPlugin esp = DownloadManagerController.getExternalSeedPlugin();
            if (esp != null && (ext_ps = esp.getTrackerPeerSource(torrent)).getSeedCount() > 0) {
                this.peer_sources.add(ext_ps);
            }
        }
        catch (Throwable esp) {
            // empty catch block
        }
        if (enabled_peer_sources.contains("DHT") && enabled_networks.contains("Public") && !torrent.isPrivate()) {
            try {
                PluginInterface dht_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class);
                if (dht_pi != null) {
                    this.peer_sources.addAll(Arrays.asList(((DHTTrackerPlugin)dht_pi.getPlugin()).getTrackerPeerSources(torrent)));
                }
            }
            catch (Throwable dht_pi) {
                // empty catch block
            }
        }
        if (enabled_peer_sources.contains("DHT") && !torrent.isPrivate()) {
            try {
                PluginInterface i2p_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azneti2phelper", true);
                if (i2p_pi != null) {
                    IPCInterface ipc = i2p_pi.getIPC();
                    HashMap<String, String[]> options = new HashMap<String, String[]>();
                    options.put("peer_networks", _enabled_networks);
                    final int[] lookup_status = new int[]{9, -1, -1, -1};
                    IPCInterface callback = new IPCInterface(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public Object invoke(String methodName, Object[] params) throws IPCException {
                            if (!methodName.equals("statusUpdate")) return null;
                            int[] nArray = lookup_status;
                            synchronized (lookup_status) {
                                lookup_status[0] = (Integer)params[0];
                                if (params.length < 4) return null;
                                lookup_status[1] = (Integer)params[1];
                                lookup_status[2] = (Integer)params[2];
                                lookup_status[3] = (Integer)params[3];
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return null;
                            }
                        }

                        @Override
                        public boolean canInvoke(String methodName, Object[] params) {
                            return true;
                        }
                    };
                    TrackerPeerSourceAdapter ps = new TrackerPeerSourceAdapter(){

                        @Override
                        public int getType() {
                            return 3;
                        }

                        @Override
                        public String getName() {
                            return "I2P DHT";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public int getStatus() {
                            int[] nArray = lookup_status;
                            synchronized (lookup_status) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return lookup_status[0];
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public int getSeedCount() {
                            int[] nArray = lookup_status;
                            synchronized (lookup_status) {
                                int seeds;
                                block4: {
                                    seeds = lookup_status[1];
                                    int peers = lookup_status[3];
                                    if (seeds != 0 || peers <= 0) break block4;
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    return -1;
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return seeds;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public int getLeecherCount() {
                            int[] nArray = lookup_status;
                            synchronized (lookup_status) {
                                int leechers;
                                block4: {
                                    leechers = lookup_status[2];
                                    int peers = lookup_status[3];
                                    if (leechers != 0 || peers <= 0) break block4;
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    return -1;
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return leechers;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public int getPeers() {
                            int[] nArray = lookup_status;
                            synchronized (lookup_status) {
                                int peers = lookup_status[3];
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return peers == 0 ? -1 : peers;
                            }
                        }
                    };
                    ipc.invoke("lookupTorrent", new Object[]{"Availability lookup for '" + torrent.getName() + "'", torrent.getHash(), options, callback});
                    this.peer_sources.add(ps);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public List<TrackerPeerSource> getTrackerPeerSources() {
        return this.peer_sources;
    }

    @Override
    public void destroy() {
        if (this.tracker_client != null) {
            this.tracker_client.destroy();
        }
    }
}

