/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.impl.DownloadManagerStateImpl;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.util.SystemTime;
import java.io.File;

public class DownloadManagerStateFactory {
    public static int MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE;

    static {
        COConfigurationManager.addAndFireParameterListener("Max File Links Supported", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE = COConfigurationManager.getIntParameter(name);
            }
        });
    }

    public static DownloadManagerState getDownloadState(TOTorrent torrent) throws TOTorrentException {
        return DownloadManagerStateImpl.getDownloadState(torrent);
    }

    public static void loadGlobalStateCache() {
        DownloadManagerStateImpl.loadGlobalStateCache();
    }

    public static void saveGlobalStateCache() {
        DownloadManagerStateImpl.saveGlobalStateCache();
    }

    public static void discardGlobalStateCache() {
        DownloadManagerStateImpl.discardGlobalStateCache();
    }

    public static void importDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        DownloadManagerStateImpl.importDownloadState(source_dir, download_hash);
    }

    public static void deleteDownloadState(byte[] download_hash, boolean delete_cache) throws DownloadManagerException {
        DownloadManagerStateImpl.deleteDownloadState(download_hash, delete_cache);
    }

    public static void deleteDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        DownloadManagerStateImpl.deleteDownloadState(source_dir, download_hash);
    }

    public static void addGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        DownloadManagerStateImpl.addGlobalListener(l, attribute, event_type);
    }

    public void removeGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        DownloadManagerStateImpl.removeGlobalListener(l, attribute, event_type);
    }

    public static Integer getIntParameterDefault(String name) {
        return DownloadManagerStateImpl.getIntParameterDefault(name);
    }

    public static Boolean getBooleanParameterDefault(String name) {
        return DownloadManagerStateImpl.getBooleanParameterDefault(name);
    }

    public static int[] getCachedAggregateScrapeSeedsLeechers(DownloadManagerState state) {
        return DownloadManagerStateFactory.getCachedAggregateScrapeSeedsLeechers(state, 10080);
    }

    public static int[] getCachedAggregateScrapeSeedsLeechers(DownloadManagerState state, int max_age_mins) {
        String[] bits;
        String cache = state.getAttribute("agsc");
        int[] result = null;
        if (cache != null && (bits = cache.split(",")).length == 3) {
            try {
                long updated_mins = Long.parseLong(bits[0]);
                long mins = SystemTime.getCurrentTime() / 60000L;
                long age_mins = mins - updated_mins;
                if (age_mins <= (long)max_age_mins || max_age_mins == Integer.MAX_VALUE) {
                    int seeds = Integer.parseInt(bits[1]);
                    int peers = Integer.parseInt(bits[2]);
                    if (seeds >= 0 && peers >= 0) {
                        result = new int[]{seeds, peers};
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static void setDebugOn(boolean on) {
        DownloadManagerStateImpl.setDebugOn(on);
    }
}

