/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManager;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.FMFileOwner;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.diskmanager.file.impl.FMFileLimited;
import com.biglybt.core.diskmanager.file.impl.FMFilePadding;
import com.biglybt.core.diskmanager.file.impl.FMFileUnlimited;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LinkFileMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class FMFileManagerImpl
implements FMFileManager {
    public static final boolean DEBUG = false;
    protected static FMFileManagerImpl singleton;
    protected static final AEMonitor class_mon;
    protected final LinkedHashMap map;
    protected final AEMonitor map_mon = new AEMonitor("FMFileManager:Map");
    protected final HashMap<Object, LinkFileMap> links = new HashMap();
    protected final AEMonitor links_mon = new AEMonitor("FMFileManager:Links");
    protected final boolean limited;
    protected final int limit_size;
    protected AESemaphore close_queue_sem;
    protected List close_queue;
    protected final AEMonitor close_queue_mon = new AEMonitor("FMFileManager:CQ");
    protected List files;
    protected final AEMonitor files_mon = new AEMonitor("FMFileManager:File");

    static {
        class_mon = new AEMonitor("FMFileManager:class");
    }

    public static FMFileManager getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new FMFileManagerImpl();
            }
            FMFileManagerImpl fMFileManagerImpl = singleton;
            return fMFileManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected FMFileManagerImpl() {
        this.limit_size = COConfigurationManager.getIntParameter("File Max Open");
        this.limited = this.limit_size > 0;
        this.map = new LinkedHashMap(this.limit_size, 0.75f, true);
        if (this.limited) {
            this.close_queue_sem = new AESemaphore("FMFileManager::closeqsem");
            this.close_queue = new LinkedList();
            AEThread t = new AEThread("FMFileManager::closeQueueDispatcher"){

                @Override
                public void runSupport() {
                    FMFileManagerImpl.this.closeQueueDispatch();
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected LinkFileMap getLinksEntry(TOTorrent torrent) {
        Object links_key;
        try {
            links_key = torrent.getHashWrapper();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            links_key = "";
        }
        LinkFileMap links_entry = this.links.get(links_key);
        if (links_entry == null) {
            links_entry = new LinkFileMap();
            this.links.put(links_key, links_entry);
        }
        return links_entry;
    }

    @Override
    public void setFileLinks(TOTorrent torrent, LinkFileMap new_links) {
        try {
            this.links_mon.enter();
            LinkFileMap links_entry = this.getLinksEntry(torrent);
            Iterator<LinkFileMap.Entry> it = new_links.entryIterator();
            while (it.hasNext()) {
                LinkFileMap.Entry entry = it.next();
                int index = entry.getIndex();
                File source = entry.getFromFile();
                File target = entry.getToFile();
                if (target != null && !FileUtil.areFilePathsIdentical(source, target)) {
                    if (index >= 0) {
                        links_entry.put(index, source, target);
                        continue;
                    }
                    links_entry.putMigration(source, target);
                    continue;
                }
                links_entry.remove(index, source);
            }
        }
        finally {
            this.links_mon.exit();
        }
    }

    @Override
    public File getFileLink(TOTorrent torrent, int file_index, File file) {
        try {
            this.links_mon.enter();
            LinkFileMap links_entry = this.getLinksEntry(torrent);
            LinkFileMap.Entry entry = links_entry.getEntry(file_index, file);
            File res = null;
            res = entry == null ? file : (file.equals(entry.getFromFile()) ? entry.getToFile() : file);
            File file2 = res;
            return file2;
        }
        finally {
            this.links_mon.exit();
        }
    }

    @Override
    public boolean hasLinks(TOTorrent torrent) {
        return this.getLinksEntry(torrent).hasLinks();
    }

    @Override
    public FMFile createFile(FMFileOwner owner, File file, int type, boolean force) throws FMFileManagerException {
        if (owner.getTorrentFile().isPadFile()) {
            return new FMFilePadding(owner, file, false);
        }
        FMFileImpl res = this.limited ? new FMFileLimited(owner, this, file, type, force) : new FMFileUnlimited(owner, this, file, type, force);
        return res;
    }

    protected void getSlot(FMFileLimited file) {
        FMFileLimited oldest_file = null;
        try {
            this.map_mon.enter();
            if (this.map.size() >= this.limit_size) {
                Iterator it = this.map.keySet().iterator();
                oldest_file = (FMFileLimited)it.next();
                it.remove();
            }
            this.map.put(file, file);
        }
        finally {
            this.map_mon.exit();
        }
        if (oldest_file != null) {
            this.closeFile(oldest_file);
        }
    }

    protected void releaseSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            this.map.remove(file);
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void usedSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            if (this.map.containsKey(file)) {
                this.map.put(file, file);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void closeFile(FMFileLimited file) {
        try {
            this.close_queue_mon.enter();
            this.close_queue.add(file);
        }
        finally {
            this.close_queue_mon.exit();
        }
        this.close_queue_sem.release();
    }

    protected void closeQueueDispatch() {
        while (true) {
            this.close_queue_sem.reserve();
            FMFileLimited file = null;
            try {
                this.close_queue_mon.enter();
                if (this.close_queue.size() > 0) {
                    file = (FMFileLimited)this.close_queue.remove(0);
                }
            }
            finally {
                this.close_queue_mon.exit();
            }
            if (file == null) continue;
            try {
                file.close(false);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    protected void generate(IndentWriter writer) {
        writer.println("FMFileManager slots");
        try {
            writer.indent();
            try {
                this.map_mon.enter();
                for (FMFileLimited file : this.map.keySet()) {
                    writer.println(file.getString());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static void generateEvidence(IndentWriter writer) {
        FMFileManagerImpl.getSingleton();
        singleton.generate(writer);
    }
}

