/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.cache.impl;

import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import java.io.File;

public class CacheFileWithoutCache
implements CacheFile {
    protected final CacheFileManagerImpl manager;
    protected final FMFile file;
    protected final TOTorrentFile torrent_file;
    private long bytes_written;
    private long bytes_read;

    protected CacheFileWithoutCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        this.torrent_file = _torrent_file;
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void moveFile(File new_file, FileUtil.ProgressListener pl) throws CacheFileManagerException {
        try {
            this.file.moveFile(new_file, pl);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void renameFile(String new_file) throws CacheFileManagerException {
        try {
            this.file.renameFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            this.file.setAccessMode(mode == 1 ? 1 : 2);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public int getAccessMode() {
        return this.file.getAccessMode() == 1 ? 1 : 2;
    }

    @Override
    public void setStorageType(int type, boolean force) throws CacheFileManagerException {
        try {
            this.file.setStorageType(CacheFileManagerImpl.convertCacheToFileType(type), force);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.file.getStorageType());
    }

    @Override
    public long getLength() throws CacheFileManagerException {
        try {
            return this.file.exists() ? this.file.getLength() : 0L;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    @Override
    public long compareLength(long compare_to) throws CacheFileManagerException {
        return this.getLength() - compare_to;
    }

    @Override
    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws CacheFileManagerException {
        try {
            this.file.setPieceComplete(piece_number, piece_data);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int read_length = 0;
        int i = 0;
        while (i < buffers.length) {
            read_length += buffers[i].remaining((byte)3);
            ++i;
        }
        try {
            this.file.read(buffers, position);
            this.manager.fileBytesRead(read_length);
            this.bytes_read += (long)read_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        int read_length = buffer.remaining((byte)3);
        try {
            this.file.read(buffer, position);
            this.manager.fileBytesRead(read_length);
            this.bytes_read += (long)read_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        try {
            this.file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        int i = 0;
        while (i < buffers.length) {
            write_length += buffers[i].remaining((byte)3);
            ++i;
        }
        try {
            this.file.write(buffers, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        boolean write_ok = false;
        try {
            try {
                this.file.write(buffer, position);
                this.manager.fileBytesWritten(write_length);
                this.bytes_written += (long)write_length;
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                if (write_ok) {
                    buffer.returnToPool();
                }
            }
        }
        finally {
            if (write_ok) {
                buffer.returnToPool();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        block10: {
            block9: {
                block11: {
                    write_length = 0;
                    i = 0;
                    while (i < buffers.length) {
                        write_length += buffers[i].remaining((byte)3);
                        ++i;
                    }
                    write_ok = false;
                    try {
                        try {
                            this.file.write(buffers, position);
                            this.manager.fileBytesWritten(write_length);
                            this.bytes_written += (long)write_length;
                            write_ok = true;
                            break block9;
                        }
                        catch (FMFileManagerException e) {
                            this.manager.rethrow(this, e);
                            if (!write_ok) break block10;
                            i = 0;
                            ** while (i < buffers.length)
                        }
                    }
                    catch (Throwable var7_9) {
                        if (!write_ok) break block11;
                        i = 0;
                        ** while (i < buffers.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        buffers[i].returnToPool();
                        ++i;
                        continue;
lbl23:
                        // 1 sources

                        break block10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        buffers[i].returnToPool();
                        ++i;
                        continue;
                    }
                }
                throw var7_9;
            }
            if (write_ok) {
                i = 0;
                while (i < buffers.length) {
                    buffers[i].returnToPool();
                    ++i;
                }
            }
        }
    }

    @Override
    public void flushCache() throws CacheFileManagerException {
        try {
            this.file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void flushCache(long offset, int length) throws CacheFileManagerException {
        this.flushCache();
    }

    @Override
    public void clearCache() throws CacheFileManagerException {
    }

    @Override
    public void close() throws CacheFileManagerException {
        try {
            this.file.close();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.file.isOpen();
    }

    @Override
    public long getSessionBytesRead() {
        return this.bytes_read;
    }

    @Override
    public long getSessionBytesWritten() {
        return this.bytes_written;
    }

    @Override
    public long getLastModified() {
        return this.file.getLastModified();
    }

    @Override
    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

