/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.cache.impl;

import com.biglybt.core.diskmanager.cache.impl.CacheFileWithCache;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.SystemTime;

public class CacheEntry {
    protected static final int CT_DATA_WRITE = 0;
    protected static final int CT_READ_AHEAD = 1;
    private final CacheFileWithCache file;
    private final DirectByteBuffer buffer;
    private final long file_position;
    private final int size;
    private final int buffer_pos;
    private final int buffer_limit;
    protected boolean dirty;
    protected long last_used;
    protected int entry_type;
    protected int usage_count;

    CacheEntry(long _offset) {
        this.file = null;
        this.buffer = null;
        this.file_position = _offset;
        this.size = 0;
        this.buffer_pos = 0;
        this.buffer_limit = 0;
    }

    protected CacheEntry(int _entry_type, CacheFileWithCache _file, DirectByteBuffer _buffer, long _file_position, int _size) {
        this.entry_type = _entry_type;
        this.file = _file;
        this.buffer = _buffer;
        this.file_position = _file_position;
        this.size = _size;
        this.buffer_pos = this.buffer.position((byte)3);
        this.buffer_limit = this.buffer.limit((byte)3);
        if (this.size != this.buffer_limit - this.buffer_pos) {
            Debug.out("CacheEntry: initial size incorrect - size =" + this.size + ", pos = " + this.buffer_pos + ", lim = " + this.buffer_limit);
        }
        this.dirty = true;
        this.last_used = SystemTime.getCurrentTime();
    }

    public CacheFileWithCache getFile() {
        return this.file;
    }

    public long getFilePosition() {
        return this.file_position;
    }

    public int getLength() {
        return this.size;
    }

    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setClean() {
        this.dirty = false;
    }

    protected void resetBufferPosition() {
        this.buffer.position((byte)3, this.buffer_pos);
        this.buffer.limit((byte)3, this.buffer_limit);
    }

    protected void used() {
        this.last_used = SystemTime.getCurrentTime();
        ++this.usage_count;
    }

    protected long getLastUsed() {
        return this.last_used;
    }

    protected int getUsageCount() {
        return this.usage_count;
    }

    protected int getType() {
        return this.entry_type;
    }

    protected String getString() {
        return "[" + this.file_position + " - " + (this.file_position + (long)this.size - 1L) + ":" + this.buffer.position((byte)3) + "/" + this.buffer.limit((byte)3) + "]";
    }
}

