/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.access.impl;

import com.biglybt.core.diskmanager.access.DiskAccessRequest;
import com.biglybt.core.diskmanager.access.DiskAccessRequestListener;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.SystemTime;

public class DiskAccessRequestImpl
implements DiskAccessRequest {
    protected static final short OP_READ = 1;
    protected static final short OP_WRITE = 2;
    protected static final short OP_WRITE_AND_FREE = 3;
    private final long create_time = SystemTime.getMonotonousTime();
    private final CacheFile file;
    private final long offset;
    private final DirectByteBuffer buffer;
    private final DiskAccessRequestListener listener;
    private final short op;
    private final short cache_policy;
    private final int size;
    private volatile boolean cancelled;
    private int space_allowance;

    protected DiskAccessRequestImpl(CacheFile _file, long _offset, DirectByteBuffer _buffer, DiskAccessRequestListener _listener, short _op, short _cache_policy) {
        this.file = _file;
        this.offset = _offset;
        this.buffer = _buffer;
        this.listener = _listener;
        this.op = _op;
        this.cache_policy = _cache_policy;
        this.size = this.buffer.remaining((byte)4);
    }

    @Override
    public long getCreateMonoTime() {
        return this.create_time;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected void runRequest() {
        if (this.cancelled) {
            this.listener.requestCancelled(this);
            return;
        }
        try {
            if (this.op == 1) {
                this.file.read(this.buffer, this.offset, this.cache_policy);
            } else if (this.op == 2) {
                this.file.write(this.buffer, this.offset);
            } else {
                this.file.writeAndHandoverBuffer(this.buffer, this.offset);
            }
            this.listener.requestExecuted(this.size);
            this.listener.requestComplete(this);
        }
        catch (Throwable e) {
            this.listener.requestFailed(this, e);
        }
    }

    protected boolean canBeAggregatedWith(DiskAccessRequestImpl other) {
        return this.op == other.getOperation() && this.cache_policy == other.getCachePolicy();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void runAggregated(DiskAccessRequestImpl base_request, DiskAccessRequestImpl[] requests) {
        op = base_request.getOperation();
        file = base_request.getFile();
        offset = base_request.getOffset();
        cache_policy = base_request.getCachePolicy();
        buffers = new DirectByteBuffer[requests.length];
        current_offset = offset;
        total_size = 0L;
        i = 0;
        while (i < buffers.length) {
            request = requests[i];
            if (current_offset != request.getOffset()) {
                Debug.out("assert failed: requests not contiguous");
            }
            size = request.getSize();
            current_offset += (long)size;
            total_size += (long)size;
            buffers[i] = request.getBuffer();
            ++i;
        }
        try {
            if (op == 1) {
                file.read(buffers, offset, cache_policy);
            } else if (op == 2) {
                file.write(buffers, offset);
            } else {
                file.writeAndHandoverBuffers(buffers, offset);
            }
            base_request.getListener().requestExecuted(total_size);
            i = 0;
            while (true) {
                if (i >= requests.length) {
                    return;
                }
                request = requests[i];
                request.getListener().requestComplete(request);
                if (request != base_request) {
                    request.getListener().requestExecuted(0L);
                }
                ++i;
            }
        }
        catch (CacheFileManagerException e) {
            fail_index = e.getFailIndex();
        }
        finally {
            i = 0;
            ** while (i < fail_index)
        }
lbl-1000:
        // 1 sources

        {
            request = requests[i];
            request.getListener().requestComplete(request);
            ++i;
            continue;
        }
lbl47:
        // 1 sources

        i = fail_index;
        while (i < requests.length) {
            request = requests[i];
            request.getListener().requestFailed(request, e);
            ++i;
        }
    }

    @Override
    public CacheFile getFile() {
        return this.file;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public short getCachePolicy() {
        return this.cache_policy;
    }

    protected int getOperation() {
        return this.op;
    }

    @Override
    public int getPriority() {
        return this.listener.getPriority();
    }

    protected void setSpaceAllowance(int sa) {
        this.space_allowance = sa;
    }

    protected int getSpaceAllowance() {
        return this.space_allowance;
    }

    @Override
    public Object getUserData() {
        return this.listener.getUserData();
    }

    protected DiskAccessRequestListener getListener() {
        return this.listener;
    }
}

