/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.resume;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.disk.impl.DiskManagerRecheckScheduler;
import com.biglybt.core.disk.impl.access.DMChecker;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RDResumeHandler {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final boolean TEST_RECHECK_FAILURE_HANDLING = false;
    public static final byte PIECE_NOT_DONE = 0;
    public static final byte PIECE_DONE = 1;
    public static final byte PIECE_RECHECK_REQUIRED = 2;
    public static final byte PIECE_STARTED = 3;
    static boolean use_fast_resume_recheck_all;
    static boolean skip_comp_dl_file_checks;
    static boolean skip_incomp_dl_file_checks;
    final DiskManagerImpl disk_manager;
    final DMChecker checker;
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean stopped_for_close;
    private volatile boolean check_in_progress;
    private volatile boolean check_resume_was_valid;
    private volatile boolean check_is_full_check;
    private volatile boolean check_interrupted;
    private volatile boolean check_cancelled;
    private volatile int check_position;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"On Resume Recheck All", "Skip Complete Download File Checks", "Skip Incomplete Download File Checks"}, new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                use_fast_resume_recheck_all = COConfigurationManager.getBooleanParameter("On Resume Recheck All");
                skip_comp_dl_file_checks = COConfigurationManager.getBooleanParameter("Skip Complete Download File Checks");
                skip_incomp_dl_file_checks = COConfigurationManager.getBooleanParameter("Skip Incomplete Download File Checks");
            }
        });
    }

    public RDResumeHandler(DiskManagerImpl _disk_manager, DMChecker _writer_and_checker) {
        this.disk_manager = _disk_manager;
        this.checker = _writer_and_checker;
    }

    public void start() {
        if (this.started) {
            Debug.out("RDResumeHandler: reuse not supported");
        }
        this.started = true;
    }

    public void stop(boolean closing) {
        this.stopped_for_close |= closing;
        this.stopped = true;
    }

    public void checkAllPieces(boolean newfiles, final boolean forceRecheck, ProgressListener listener) {
        block63: {
            DiskManagerRecheckScheduler.DiskManagerRecheckInstance recheck_inst_maybe_null = null;
            final ArrayList failed_pieces = new ArrayList();
            final Consumer<Throwable> forceRecheckErrorReporter = new Consumer<Throwable>(){
                private boolean reported;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Throwable cause) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        if (this.reported) {
                            return;
                        }
                        this.reported = true;
                    }
                    String msg = String.valueOf(RDResumeHandler.this.disk_manager.getDisplayName()) + ": One or more piece checks failed: " + Debug.getNestedExceptionMessage(cause);
                    Logger.log(new LogAlert((Object)RDResumeHandler.this.disk_manager, true, 3, msg));
                }
            };
            listener.percentDone(0);
            try {
                try {
                    boolean resume_data_complete;
                    block62: {
                        resume_data_complete = false;
                        try {
                            this.check_in_progress = true;
                            final AESemaphore pending_checks_sem = new AESemaphore("RD:PendingChecks");
                            int pending_check_num = 0;
                            DiskManagerPiece[] pieces = this.disk_manager.getPieces();
                            boolean is_complete = this.disk_manager.getDownloadManager().isDownloadComplete(false);
                            HashMap<DiskManagerFileInfo, Long> file_sizes = skip_comp_dl_file_checks && is_complete || skip_incomp_dl_file_checks && !is_complete ? null : new HashMap<DiskManagerFileInfo, Long>();
                            boolean resumeValid = false;
                            byte[] resume_pieces = null;
                            Map partialPieces = null;
                            Map resume_data = newfiles ? null : this.getResumeData();
                            if (resume_data != null) {
                                try {
                                    resume_pieces = (byte[])resume_data.get("resume data");
                                    if (resume_pieces != null && resume_pieces.length != pieces.length) {
                                        Debug.out("Resume data array length mismatch: " + resume_pieces.length + "/" + pieces.length);
                                        resume_pieces = null;
                                    }
                                    partialPieces = (Map)resume_data.get("blocks");
                                    boolean bl = resumeValid = ((Long)resume_data.get("valid")).intValue() == 1;
                                    if (RDResumeHandler.isTorrentResumeDataComplete(pieces.length, resume_data)) {
                                        resume_data_complete = true;
                                    } else {
                                        resume_data = BEncoder.cloneMap(resume_data);
                                        resume_data.put("valid", new Long(0L));
                                        this.saveResumeData(resume_data);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (resume_pieces == null) {
                                this.check_is_full_check = true;
                                resumeValid = false;
                                resume_pieces = new byte[pieces.length];
                                Arrays.fill(resume_pieces, (byte)2);
                            }
                            this.check_resume_was_valid = resumeValid;
                            boolean recheck_all = use_fast_resume_recheck_all;
                            if (!recheck_all) {
                                long total_not_done = 0L;
                                int piece_size = this.disk_manager.getPieceLength();
                                int i = 0;
                                while (i < pieces.length) {
                                    if (resume_pieces[i] != 1) {
                                        total_not_done += (long)piece_size;
                                    }
                                    ++i;
                                }
                                if (total_not_done < 0x4000000L) {
                                    recheck_all = true;
                                }
                            }
                            if (Logger.isEnabled()) {
                                int total_not_done = 0;
                                int total_done = 0;
                                int total_started = 0;
                                int total_recheck = 0;
                                int i = 0;
                                while (i < pieces.length) {
                                    byte piece_state = resume_pieces[i];
                                    if (piece_state == 0) {
                                        ++total_not_done;
                                    } else if (piece_state == 1) {
                                        ++total_done;
                                    } else if (piece_state == 3) {
                                        ++total_started;
                                    } else {
                                        ++total_recheck;
                                    }
                                    ++i;
                                }
                                String str = "valid=" + resumeValid + ",not done=" + total_not_done + ",done=" + total_done + ",started=" + total_started + ",recheck=" + total_recheck + ",rc all=" + recheck_all + ",full=" + this.check_is_full_check;
                                Logger.log(new LogEvent(this.disk_manager, LOGID, str));
                            }
                            int i = 0;
                            while (i < pieces.length) {
                                if (this.stopped) {
                                    this.check_interrupted = true;
                                    break;
                                }
                                this.check_position = i;
                                DiskManagerPiece dm_piece = pieces[i];
                                listener.percentDone((i + 1) * 1000 / this.disk_manager.getNbPieces());
                                boolean pieceCannotExist = false;
                                byte piece_state = resume_pieces[i];
                                if ((piece_state == 1 || !resumeValid || recheck_all) && file_sizes != null) {
                                    DMPieceList list = this.disk_manager.getPieceList(i);
                                    int j = 0;
                                    while (j < list.size()) {
                                        DMPieceMapEntry entry = list.get(j);
                                        DiskManagerFileInfo file = entry.getFile();
                                        Long file_size = (Long)file_sizes.get(file);
                                        if (file_size == null) {
                                            try {
                                                file_size = new Long(((DiskManagerFileInfoImpl)file).getCacheFile().getLength());
                                            }
                                            catch (CacheFileManagerException e) {
                                                Debug.printStackTrace(e);
                                                file_size = -1L;
                                            }
                                            file_sizes.put(file, file_size);
                                        }
                                        if (file_size == -1L) {
                                            piece_state = 0;
                                            pieceCannotExist = true;
                                            if (!Logger.isEnabled()) break;
                                            Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is missing, " + "fails re-check."));
                                            break;
                                        }
                                        long expected_size = entry.getOffset() + (long)entry.getLength();
                                        if (file_size < expected_size) {
                                            piece_state = 0;
                                            pieceCannotExist = true;
                                            if (file_size <= 0L || !Logger.isEnabled()) break;
                                            Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is too small, fails re-check. File size = " + file_size + ", piece needs " + expected_size));
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                                if (piece_state == 1) {
                                    dm_piece.setDone(true);
                                } else if (piece_state != 0 || recheck_all) {
                                    if (pieceCannotExist) {
                                        dm_piece.setDone(false);
                                    } else if (piece_state == 2 || !resumeValid) {
                                        if (recheck_inst_maybe_null == null) {
                                            recheck_inst_maybe_null = this.disk_manager.getRecheckScheduler().register(this.disk_manager, false);
                                        }
                                        final DiskManagerRecheckScheduler.DiskManagerRecheckInstance recheck_inst = recheck_inst_maybe_null;
                                        recheck_inst.reserveSlot();
                                        while (!this.stopped) {
                                            if (recheck_inst.getPermission()) break;
                                        }
                                        if (this.stopped) {
                                            this.check_interrupted = true;
                                            break;
                                        }
                                        try {
                                            DiskManagerCheckRequest request2 = this.disk_manager.createCheckRequest(i, null);
                                            request2.setLowPriority(true);
                                            if (forceRecheck) {
                                                request2.setErrorIsFatal(false);
                                            }
                                            this.checker.enqueueCheckRequest(request2, new DiskManagerCheckRequestListener(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                                    if (!passed) {
                                                        List list = failed_pieces;
                                                        synchronized (list) {
                                                            failed_pieces.add(request2);
                                                        }
                                                    }
                                                    this.complete();
                                                }

                                                @Override
                                                public void checkCancelled(DiskManagerCheckRequest request2) {
                                                    this.complete();
                                                }

                                                @Override
                                                public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                                    if (forceRecheck) {
                                                        forceRecheckErrorReporter.accept(cause);
                                                    }
                                                    this.complete();
                                                }

                                                protected void complete() {
                                                    recheck_inst.releaseSlot();
                                                    pending_checks_sem.release();
                                                }

                                                @Override
                                                public boolean isFailureInteresting() {
                                                    return false;
                                                }
                                            });
                                            ++pending_check_num;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                }
                                ++i;
                            }
                            while (pending_check_num > 0) {
                                pending_checks_sem.reserve();
                                --pending_check_num;
                            }
                            if (partialPieces != null) {
                                for (Map.Entry key : partialPieces.entrySet()) {
                                    int pieceNumber = Integer.parseInt((String)key.getKey());
                                    DiskManagerPiece dm_piece = pieces[pieceNumber];
                                    if (dm_piece.isDone()) continue;
                                    List blocks = (List)partialPieces.get(key.getKey());
                                    Iterator iterBlock = blocks.iterator();
                                    while (iterBlock.hasNext()) {
                                        dm_piece.setWritten(((Long)iterBlock.next()).intValue());
                                    }
                                }
                            }
                            if (failed_pieces.size() <= 0) break block62;
                            byte[][] piece_hashes = this.disk_manager.getTorrent().getPieces();
                            ByteArrayHashMap<Integer> hash_map = new ByteArrayHashMap<Integer>();
                            int i2 = 0;
                            while (i2 < piece_hashes.length) {
                                byte[] hash = piece_hashes[i2];
                                if (hash != null) {
                                    hash_map.put(hash, i2);
                                }
                                ++i2;
                            }
                            if (recheck_inst_maybe_null == null) {
                                recheck_inst_maybe_null = this.disk_manager.getRecheckScheduler().register(this.disk_manager, false);
                            }
                            for (DiskManagerCheckRequest request3 : failed_pieces) {
                                while (!this.stopped) {
                                    if (recheck_inst_maybe_null.getPermission()) break;
                                }
                                if (this.stopped) {
                                    this.check_interrupted = true;
                                    break;
                                }
                                byte[] hash = request3.getHash();
                                if (hash == null) continue;
                                final Integer target_index = (Integer)hash_map.get(hash);
                                int current_index = request3.getPieceNumber();
                                int piece_size = this.disk_manager.getPieceLength(current_index);
                                if (target_index == null || target_index == current_index || this.disk_manager.getPieceLength(target_index) != piece_size || this.disk_manager.isDone(target_index)) continue;
                                final AESemaphore sem = new AESemaphore("PieceReorder");
                                this.disk_manager.enqueueReadRequest(this.disk_manager.createReadRequest(current_index, 0, piece_size), new DiskManagerReadRequestListener(){

                                    @Override
                                    public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                                        try {
                                            RDResumeHandler.this.disk_manager.enqueueWriteRequest(RDResumeHandler.this.disk_manager.createWriteRequest(target_index, 0, data, null), new DiskManagerWriteRequestListener(){

                                                @Override
                                                public void writeCompleted(DiskManagerWriteRequest request2) {
                                                    try {
                                                        DiskManagerCheckRequest check_request = (this).RDResumeHandler.this.disk_manager.createCheckRequest(target_index, null);
                                                        check_request.setLowPriority(true);
                                                        (this).RDResumeHandler.this.checker.enqueueCheckRequest(check_request, new DiskManagerCheckRequestListener(){

                                                            @Override
                                                            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                                                sem.release();
                                                            }

                                                            @Override
                                                            public void checkCancelled(DiskManagerCheckRequest request2) {
                                                                sem.release();
                                                            }

                                                            @Override
                                                            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                                                sem.release();
                                                            }

                                                            @Override
                                                            public boolean isFailureInteresting() {
                                                                return false;
                                                            }
                                                        });
                                                    }
                                                    catch (Throwable e) {
                                                        sem.release();
                                                    }
                                                }

                                                @Override
                                                public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
                                                    sem.release();
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            sem.release();
                                        }
                                    }

                                    @Override
                                    public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                                        sem.release();
                                    }

                                    @Override
                                    public int getPriority() {
                                        return -1;
                                    }

                                    @Override
                                    public void requestExecuted(long bytes) {
                                    }
                                });
                                sem.reserve();
                            }
                        }
                        finally {
                            this.check_in_progress = false;
                        }
                    }
                    if (this.stopped || resume_data_complete) break block63;
                    try {
                        this.saveResumeData(true);
                    }
                    catch (Exception e) {
                        Debug.out("Failed to dump initial resume data to disk");
                        Debug.printStackTrace(e);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    if (recheck_inst_maybe_null != null) {
                        this.check_cancelled = recheck_inst_maybe_null.isCancelled();
                        recheck_inst_maybe_null.unregister();
                    }
                }
            }
            finally {
                if (recheck_inst_maybe_null != null) {
                    this.check_cancelled = recheck_inst_maybe_null.isCancelled();
                    recheck_inst_maybe_null.unregister();
                }
            }
        }
    }

    public void saveResumeData(boolean interim_save) throws Exception {
        if (this.check_in_progress && interim_save) {
            return;
        }
        DiskManagerFileInfo[] files = this.disk_manager.getFiles();
        boolean was_complete = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState());
        if (was_complete && this.check_interrupted) {
            return;
        }
        DiskManagerPiece[] pieces = this.disk_manager.getPieces();
        byte[] resume_pieces = new byte[pieces.length];
        int i = 0;
        while (i < resume_pieces.length) {
            DiskManagerPiece piece = pieces[i];
            resume_pieces[i] = this.stopped_for_close && this.check_interrupted && this.check_is_full_check && i >= this.check_position ? 2 : (piece.isDone() ? 1 : (piece.getNbWritten() > 0 ? 3 : 0));
            ++i;
        }
        HashMap<String, Object> resume_data = new HashMap<String, Object>();
        resume_data.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        int i2 = 0;
        while (i2 < pieces.length) {
            DiskManagerPiece piece = pieces[i2];
            boolean[] written = piece.getWritten();
            if (!piece.isDone() && piece.getNbWritten() > 0 && written != null) {
                boolean all_written = true;
                int j = 0;
                while (j < written.length) {
                    if (!written[j]) {
                        all_written = false;
                        break;
                    }
                    ++j;
                }
                if (all_written) {
                    resume_pieces[i2] = 2;
                } else {
                    ArrayList<Long> blocks = new ArrayList<Long>();
                    int j2 = 0;
                    while (j2 < written.length) {
                        if (written[j2]) {
                            blocks.add(new Long(j2));
                        }
                        ++j2;
                    }
                    partialPieces.put("" + i2, blocks);
                }
            }
            ++i2;
        }
        resume_data.put("blocks", partialPieces);
        long lValid = this.check_interrupted ? (long)(this.check_resume_was_valid ? 1 : 0) : (interim_save ? 0L : 1L);
        resume_data.put("valid", new Long(lValid));
        int i3 = 0;
        while (i3 < files.length) {
            files[i3].flushCache();
            ++i3;
        }
        boolean is_complete = RDResumeHandler.isTorrentResumeDataComplete(pieces.length, resume_data);
        if (!was_complete || !is_complete) {
            this.saveResumeData(resume_data);
        }
    }

    private Map getResumeData() {
        return RDResumeHandler.getResumeData(this.disk_manager.getDownloadManager());
    }

    private void saveResumeData(Map resume_data) {
        RDResumeHandler.saveResumeData(this.disk_manager.getDownloadManager().getDownloadState(), resume_data);
    }

    public boolean isCancelled() {
        return this.check_cancelled;
    }

    protected static Map getResumeData(DownloadManager download_manager) {
        return RDResumeHandler.getResumeData(download_manager.getDownloadState());
    }

    protected static Map getResumeData(DownloadManagerState download_manager_state) {
        Map resume_map = download_manager_state.getResumeData();
        if (resume_map != null) {
            Map resume_data = (Map)resume_map.get("data");
            return resume_data;
        }
        return null;
    }

    private static void saveResumeData(DownloadManagerState download_manager_state, Map resume_data) {
        HashMap<String, Map> resume_map = new HashMap<String, Map>();
        resume_map.put("data", resume_data);
        download_manager_state.setResumeData(resume_map);
    }

    public static void setTorrentResumeDataComplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        int piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[piece_count];
        Arrays.fill(resume_pieces, (byte)1);
        HashMap<String, Object> resume_data = new HashMap<String, Object>();
        resume_data.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        resume_data.put("blocks", partialPieces);
        resume_data.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resume_data);
    }

    private static int clearResumeDataSupport(DownloadManager download_manager, DiskManagerFileInfo file, boolean recheck, boolean onlyClearUnsharedFirstLast) {
        Map partial_pieces;
        DownloadManagerState download_manager_state = download_manager.getDownloadState();
        Map resume_data = RDResumeHandler.getResumeData(download_manager);
        if (resume_data == null) {
            return 0;
        }
        resume_data = BEncoder.cloneMap(resume_data);
        int pieces_cleared = 0;
        byte[] resume_pieces = (byte[])resume_data.get("resume data");
        int firstPiece = file.getFirstPieceNumber();
        int lastPiece = file.getLastPieceNumber();
        if (onlyClearUnsharedFirstLast) {
            int firstFile;
            DiskManagerFileInfo[] files = download_manager.getDiskManagerFileInfo();
            boolean firstPieceShared = false;
            boolean lastPieceShared = false;
            int i = firstFile = RDResumeHandler.findFirstFileWithPieceN(firstPiece, files);
            while (i < files.length) {
                DiskManagerFileInfo currentFile = files[i];
                if (currentFile.getLastPieceNumber() >= firstPiece && currentFile.getIndex() != file.getIndex()) {
                    if (currentFile.getFirstPieceNumber() > lastPiece) break;
                    if (currentFile.getFirstPieceNumber() <= firstPiece && firstPiece <= currentFile.getLastPieceNumber()) {
                        firstPieceShared |= !currentFile.isSkipped();
                    }
                    if (currentFile.getFirstPieceNumber() <= lastPiece && lastPiece <= currentFile.getLastPieceNumber()) {
                        lastPieceShared |= !currentFile.isSkipped();
                    }
                }
                ++i;
            }
            if (firstPieceShared) {
                ++firstPiece;
            }
            if (lastPieceShared) {
                --lastPiece;
            }
        }
        if (resume_pieces != null) {
            int i = firstPiece;
            while (i <= lastPiece) {
                if (i >= resume_pieces.length) break;
                if (resume_pieces[i] == 1) {
                    ++pieces_cleared;
                }
                resume_pieces[i] = recheck ? 2 : 0;
                ++i;
            }
        }
        if ((partial_pieces = (Map)resume_data.get("blocks")) != null) {
            Iterator iter = partial_pieces.keySet().iterator();
            while (iter.hasNext()) {
                int piece_number = Integer.parseInt((String)iter.next());
                if (piece_number < firstPiece || piece_number > lastPiece) continue;
                iter.remove();
            }
        }
        resume_data.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resume_data);
        return pieces_cleared;
    }

    /*
     * Unable to fully structure code
     */
    private static int findFirstFileWithPieceN(int firstPiece, DiskManagerFileInfo[] files) {
        start = 0;
        end = files.length - 1;
        pivot = 0;
        while (start <= end) {
            pivot = start + end >>> 1;
            midVal = files[pivot].getLastPieceNumber();
            if (midVal < firstPiece) {
                start = pivot + 1;
                continue;
            }
            if (midVal <= firstPiece) ** GOTO lbl14
            end = pivot - 1;
            continue;
lbl-1000:
            // 1 sources

            {
                --pivot;
lbl14:
                // 2 sources

                ** while (pivot > 0 && files[pivot - 1].getLastPieceNumber() == firstPiece)
            }
lbl15:
            // 1 sources

            break;
        }
        return pivot;
    }

    public static boolean fileMustExist(DownloadManager download_manager, DiskManagerFileInfo file) {
        return RDResumeHandler.fileMustExist(download_manager, download_manager.getDiskManagerFileInfoSet(), file);
    }

    public static boolean fileMustExist(DownloadManager download_manager, DiskManagerFileInfoSet fileSet, DiskManagerFileInfo file) {
        int firstFile;
        Map resumeData = RDResumeHandler.getResumeData(download_manager);
        byte[] resumePieces = resumeData != null ? (byte[])resumeData.get("resume data") : null;
        boolean sharesAnyNeededPieces = false;
        DiskManagerFileInfo[] files = fileSet.getFiles();
        int firstPiece = file.getFirstPieceNumber();
        int lastPiece = file.getLastPieceNumber();
        int i = firstFile = RDResumeHandler.findFirstFileWithPieceN(firstPiece, files);
        while (i < files.length && !sharesAnyNeededPieces) {
            DiskManagerFileInfo currentFile = files[i];
            if (currentFile.getLastPieceNumber() >= firstPiece) {
                if (currentFile.getIndex() == file.getIndex() && resumePieces != null && file.getStorageType() != 2 && file.getStorageType() != 4) {
                    int j = firstPiece;
                    while (j <= lastPiece && !sharesAnyNeededPieces) {
                        sharesAnyNeededPieces |= resumePieces[j] != 0;
                        ++j;
                    }
                }
                if (currentFile.getFirstPieceNumber() > lastPiece) break;
                if (currentFile.getFirstPieceNumber() <= firstPiece && firstPiece <= currentFile.getLastPieceNumber()) {
                    sharesAnyNeededPieces |= !currentFile.isSkipped();
                }
                if (currentFile.getFirstPieceNumber() <= lastPiece && lastPiece <= currentFile.getLastPieceNumber()) {
                    sharesAnyNeededPieces |= !currentFile.isSkipped();
                }
            }
            ++i;
        }
        return sharesAnyNeededPieces;
    }

    public static int storageTypeChanged(DownloadManager download_manager, DiskManagerFileInfo file) {
        return RDResumeHandler.clearResumeDataSupport(download_manager, file, false, true);
    }

    public static void clearResumeData(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeDataSupport(download_manager, file, false, false);
    }

    public static void recheckFile(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeDataSupport(download_manager, file, true, false);
    }

    public static void setTorrentResumeTotallyIncomplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        long piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[(int)piece_count];
        Arrays.fill(resume_pieces, (byte)0);
        HashMap<String, Object> resumeMap = new HashMap<String, Object>();
        resumeMap.put("resume data", resume_pieces);
        resumeMap.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(download_manager_state, resumeMap);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState download_manager_state) {
        TOTorrent torrent = download_manager_state.getTorrent();
        long piece_count = torrent.getNumberOfPieces();
        byte[] resume_pieces = new byte[(int)piece_count];
        Arrays.fill(resume_pieces, (byte)1);
        int i = 0;
        while (i < 3) {
            int piece_num = (int)(Math.random() * (double)piece_count);
            resume_pieces[piece_num] = 2;
            ++i;
        }
        HashMap<String, Object> resumeMap = new HashMap<String, Object>();
        resumeMap.put("resume data", resume_pieces);
        HashMap partialPieces = new HashMap();
        resumeMap.put("blocks", partialPieces);
        resumeMap.put("valid", new Long(0L));
        RDResumeHandler.saveResumeData(download_manager_state, resumeMap);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState dms) {
        Map resume_data = RDResumeHandler.getResumeData(dms);
        return RDResumeHandler.isTorrentResumeDataComplete(dms.getTorrent().getNumberOfPieces(), resume_data);
    }

    public static boolean isTorrentResumeDataValid(DownloadManagerState dms) {
        Map resume_data = RDResumeHandler.getResumeData(dms);
        if (resume_data != null) {
            boolean valid = ((Long)resume_data.get("valid")).intValue() == 1;
            return valid;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTorrentResumeDataComplete(int piece_count, Map resume_data) {
        try {
            boolean valid;
            if (resume_data == null) return false;
            byte[] pieces = (byte[])resume_data.get("resume data");
            Map blocks = (Map)resume_data.get("blocks");
            boolean bl = valid = ((Long)resume_data.get("valid")).intValue() == 1;
            if (blocks == null || blocks.size() > 0) {
                return false;
            }
            if (!valid || pieces == null || pieces.length != piece_count) return false;
            int i = 0;
            while (true) {
                if (i >= pieces.length) {
                    return true;
                }
                if (pieces[i] != 1) {
                    return false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    public static void setupPieces(DownloadManagerState dms, DiskManagerPiece[] pieces) {
        Map resume_data = RDResumeHandler.getResumeData(dms);
        if (resume_data != null) {
            boolean valid;
            boolean bl = valid = ((Long)resume_data.get("valid")).intValue() == 1;
            if (valid) {
                Map partialPieces;
                byte[] rd_pieces = (byte[])resume_data.get("resume data");
                if (rd_pieces != null && rd_pieces.length == pieces.length) {
                    int i = 0;
                    while (i < pieces.length) {
                        if (rd_pieces[i] == 1) {
                            pieces[i].setDone(true);
                        }
                        ++i;
                    }
                }
                if ((partialPieces = (Map)resume_data.get("blocks")) != null) {
                    for (Map.Entry key : partialPieces.entrySet()) {
                        int pieceNumber = Integer.parseInt((String)key.getKey());
                        DiskManagerPiece dm_piece = pieces[pieceNumber];
                        if (dm_piece.isDone()) continue;
                        List blocks = (List)partialPieces.get(key.getKey());
                        Iterator iterBlock = blocks.iterator();
                        while (iterBlock.hasNext()) {
                            dm_piece.setWritten(((Long)iterBlock.next()).intValue());
                        }
                    }
                }
            }
        }
    }

    public static interface ProgressListener {
        public void percentDone(int var1);
    }
}

