/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.piecemapper.impl;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapper;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFile;
import com.biglybt.core.disk.impl.piecemapper.impl.DMPieceMapImpl;
import com.biglybt.core.disk.impl.piecemapper.impl.DMPieceMapSimple;
import com.biglybt.core.disk.impl.piecemapper.impl.PieceListImpl;
import com.biglybt.core.disk.impl.piecemapper.impl.PieceMapEntryImpl;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.StringInterner;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class PieceMapperImpl
implements DMPieceMapper {
    private final TOTorrent torrent;
    private final int last_piece_length;
    protected final ArrayList<fileInfo> btFileList = new ArrayList();

    public PieceMapperImpl(TOTorrent _torrent) {
        this.torrent = _torrent;
        int piece_length = (int)this.torrent.getPieceLength();
        int piece_count = this.torrent.getNumberOfPieces();
        long total_length = this.torrent.getSize();
        this.last_piece_length = (int)(total_length - (long)(piece_count - 1) * (long)piece_length);
    }

    @Override
    public void construct(LocaleUtilDecoder _locale_decoder, String _save_name) throws UnsupportedEncodingException {
        TOTorrentFile[] torrent_files = this.torrent.getFiles();
        if (this.torrent.isSimpleTorrent()) {
            this.buildFileLookupTables(torrent_files[0], _save_name);
        } else {
            this.buildFileLookupTables(torrent_files, _locale_decoder);
        }
    }

    private void buildFileLookupTables(TOTorrentFile torrent_file, String fileName) {
        this.btFileList.add(new fileInfo(torrent_file, "", fileName));
    }

    private void buildFileLookupTables(TOTorrentFile[] torrent_files, LocaleUtilDecoder locale_decoder) throws UnsupportedEncodingException {
        char separator = File.separatorChar;
        int i = 0;
        while (i < torrent_files.length) {
            this.buildFileLookupTable(torrent_files[i], locale_decoder, separator);
            ++i;
        }
    }

    private void buildFileLookupTable(TOTorrentFile torrent_file, LocaleUtilDecoder locale_decoder, char separator) throws UnsupportedEncodingException {
        byte[][] path_components = torrent_file.getPathComponents();
        StringBuilder pathBuffer = new StringBuilder(0);
        int lastIndex = path_components.length - 1;
        int j = 0;
        while (j < lastIndex) {
            String comp2 = locale_decoder.decodeString(path_components[j]);
            comp2 = FileUtil.convertOSSpecificChars(comp2, true);
            pathBuffer.append(comp2);
            pathBuffer.append(separator);
            ++j;
        }
        String last_comp = locale_decoder.decodeString(path_components[lastIndex]);
        last_comp = FileUtil.convertOSSpecificChars(last_comp, false);
        this.btFileList.add(new fileInfo(torrent_file, pathBuffer.toString(), last_comp));
    }

    @Override
    public DMPieceMap getPieceMap() {
        if (this.btFileList.size() == 1) {
            return new DMPieceMapSimple(this.torrent, this.btFileList.get(0).getFileInfo());
        }
        int piece_length = (int)this.torrent.getPieceLength();
        int piece_count = this.torrent.getNumberOfPieces();
        long total_length = this.torrent.getSize();
        DMPieceList[] pieceMap = new DMPieceList[piece_count];
        int modified_piece_length = piece_length;
        if (total_length < (long)modified_piece_length) {
            modified_piece_length = (int)total_length;
        }
        long fileOffset = 0L;
        int currentFile = 0;
        int i = 0;
        while (1 == piece_count && i < piece_count || i < piece_count - 1) {
            ArrayList<PieceMapEntryImpl> pieceToFileList = new ArrayList<PieceMapEntryImpl>();
            int usedSpace = 0;
            while (modified_piece_length > usedSpace) {
                fileInfo tempFile = this.btFileList.get(currentFile);
                long length = tempFile.getLength();
                long availableSpace = length - fileOffset;
                PieceMapEntryImpl tempPieceEntry = null;
                if (availableSpace <= (long)(modified_piece_length - usedSpace)) {
                    tempPieceEntry = new PieceMapEntryImpl(tempFile.getFileInfo(), fileOffset, (int)availableSpace);
                    usedSpace = (int)((long)usedSpace + availableSpace);
                    fileOffset = 0L;
                    ++currentFile;
                } else {
                    tempPieceEntry = new PieceMapEntryImpl(tempFile.getFileInfo(), fileOffset, modified_piece_length - usedSpace);
                    fileOffset += (long)(modified_piece_length - usedSpace);
                    usedSpace += modified_piece_length - usedSpace;
                }
                pieceToFileList.add(tempPieceEntry);
            }
            pieceMap[i] = PieceListImpl.convert(pieceToFileList);
            ++i;
        }
        if (piece_count > 1) {
            pieceMap[piece_count - 1] = PieceListImpl.convert(this.buildLastPieceToFileList(this.btFileList, currentFile, fileOffset));
        }
        return new DMPieceMapImpl(pieceMap);
    }

    private List<PieceMapEntryImpl> buildLastPieceToFileList(List<fileInfo> file_list, int current_file, long file_offset) {
        ArrayList<PieceMapEntryImpl> piece_to_file_list = new ArrayList<PieceMapEntryImpl>();
        int i = current_file;
        while (i < file_list.size()) {
            fileInfo file = file_list.get(i);
            long space_in_file = file.getLength() - file_offset;
            PieceMapEntryImpl piece_entry = new PieceMapEntryImpl(file.getFileInfo(), file_offset, (int)space_in_file);
            piece_to_file_list.add(piece_entry);
            file_offset = 0L;
            ++i;
        }
        return piece_to_file_list;
    }

    @Override
    public long getTotalLength() {
        return this.torrent.getSize();
    }

    @Override
    public int getPieceLength() {
        return (int)this.torrent.getPieceLength();
    }

    @Override
    public int getLastPieceLength() {
        return this.last_piece_length;
    }

    @Override
    public DMPieceMapperFile[] getFiles() {
        DMPieceMapperFile[] res = new DMPieceMapperFile[this.btFileList.size()];
        this.btFileList.toArray(res);
        return res;
    }

    protected static class fileInfo
    implements DMPieceMapperFile {
        private DiskManagerFileInfo file;
        private final TOTorrentFile torrent_file;
        private final String relative_path;
        private final String name;

        public fileInfo(TOTorrentFile _torrent_file, String _relative_path, String _name) {
            this.torrent_file = _torrent_file;
            this.relative_path = StringInterner.intern(_relative_path);
            this.name = _name;
        }

        @Override
        public long getLength() {
            return this.torrent_file.getLength();
        }

        @Override
        public String getRelativeDataPath() {
            return String.valueOf(this.relative_path) + this.name;
        }

        @Override
        public TOTorrentFile getTorrentFile() {
            return this.torrent_file;
        }

        @Override
        public DiskManagerFileInfo getFileInfo() {
            return this.file;
        }

        @Override
        public void setFileInfo(DiskManagerFileInfo _file) {
            this.file = _file;
        }
    }
}

