/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.access.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerRequest;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.SystemTime;

public abstract class DiskManagerRequestImpl
implements DiskManagerRequest {
    private static final LogIDs LOGID = LogIDs.DISK;
    static boolean DEBUG;
    private static int next_id;
    private long start_time;
    private String name;
    private boolean error_is_fatal = true;

    static {
        COConfigurationManager.addAndFireParameterListener("diskmanager.request.debug.enable", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                DEBUG = COConfigurationManager.getBooleanParameter(name, false);
            }
        });
    }

    protected abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStarts() {
        if (DEBUG) {
            try {
                Class<DiskManagerRequestImpl> clazz = DiskManagerRequestImpl.class;
                synchronized (DiskManagerRequestImpl.class) {
                    int id = next_id++;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    this.name = String.valueOf(this.getName()) + " [" + id + "]";
                    this.start_time = SystemTime.getCurrentTime();
                    Logger.log(new LogEvent(LOGID, "DMRequest start: " + this.name));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void requestEnds(boolean ok) {
        if (DEBUG) {
            try {
                Logger.log(new LogEvent(LOGID, "DMRequest end: " + this.name + ",ok=" + ok + ", time=" + (SystemTime.getCurrentTime() - this.start_time)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean getErrorIsFatal() {
        return this.error_is_fatal;
    }

    @Override
    public void setErrorIsFatal(boolean b) {
        this.error_is_fatal = b;
    }
}

