/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.access.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerRecheckScheduler;
import com.biglybt.core.disk.impl.access.DMChecker;
import com.biglybt.core.disk.impl.access.impl.DiskManagerCheckRequestImpl;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.List;

public class DMCheckerImpl
implements DMChecker {
    protected static final LogIDs LOGID = LogIDs.DISK;
    static boolean flush_pieces;
    static boolean checking_read_priority;
    static final AEMonitor class_mon;
    static final List async_check_queue;
    static final AESemaphore async_check_queue_sem;
    private static final boolean fully_async;
    protected final DiskManagerHelper disk_manager;
    protected int async_checks;
    protected final AESemaphore async_check_sem = new AESemaphore("DMChecker::asyncCheck");
    protected int async_reads;
    protected final AESemaphore async_read_sem = new AESemaphore("DMChecker::asyncRead");
    private boolean started;
    protected volatile boolean stopped;
    volatile boolean complete_recheck_in_progress;
    volatile int complete_recheck_progress;
    volatile boolean check_cancelled;
    private boolean checking_enabled = true;
    protected final AEMonitor this_mon = new AEMonitor("DMChecker");

    static {
        class_mon = new AEMonitor("DMChecker:class");
        async_check_queue = new ArrayList();
        async_check_queue_sem = new AESemaphore("DMChecker::asyncCheck");
        fully_async = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.fully.async");
        if (fully_async) {
            new AEThread2("DMCheckerImpl:asyncCheckScheduler", true){

                @Override
                public void run() {
                    while (true) {
                        Object[] entry;
                        async_check_queue_sem.reserve();
                        try {
                            class_mon.enter();
                            entry = (Object[])async_check_queue.remove(0);
                            int queue_size = async_check_queue.size();
                            if (queue_size % 100 == 0 && queue_size > 0) {
                                System.out.println("async check queue size=" + async_check_queue.size());
                            }
                        }
                        finally {
                            class_mon.exit();
                        }
                        ((DMCheckerImpl)entry[0]).enqueueCheckRequest((DiskManagerCheckRequest)entry[1], (DiskManagerCheckRequestListener)entry[2], flush_pieces);
                    }
                }
            }.start();
        }
        ParameterListener param_listener = new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                flush_pieces = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.flushpieces");
                checking_read_priority = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.read.priority");
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.perf.cache.flushpieces", "diskmanager.perf.checking.read.priority"}, param_listener);
    }

    public DMCheckerImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
    }

    @Override
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMChecker: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMChecker: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void stop() {
        long now;
        int check_wait;
        int read_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            read_wait = this.async_reads;
            check_wait = this.async_checks;
        }
        finally {
            this.this_mon.exit();
        }
        long log_time = SystemTime.getCurrentTime();
        int i = 0;
        while (i < read_wait) {
            now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for check-reads to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_read_sem.reserve();
            ++i;
        }
        log_time = SystemTime.getCurrentTime();
        i = 0;
        while (i < check_wait) {
            now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for checks to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_check_sem.reserve();
            ++i;
        }
    }

    @Override
    public int getCompleteRecheckStatus() {
        if (this.complete_recheck_in_progress) {
            return this.complete_recheck_progress;
        }
        return -1;
    }

    @Override
    public boolean getRecheckCancelled() {
        return this.check_cancelled;
    }

    @Override
    public void setCheckingEnabled(boolean enabled) {
        this.checking_enabled = enabled;
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return new DiskManagerCheckRequestImpl(pieceNumber, user_data);
    }

    @Override
    public void enqueueCompleteRecheckRequest(final DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener) {
        if (!this.checking_enabled) {
            listener.checkCompleted(request2, true);
            return;
        }
        this.complete_recheck_progress = 0;
        this.complete_recheck_in_progress = true;
        final DiskManagerRecheckScheduler.DiskManagerRecheckInstance recheck_inst = this.disk_manager.getRecheckScheduler().register(this.disk_manager, true);
        new AEThread2("DMChecker::completeRecheck", true){

            @Override
            public void run() {
                try {
                    final AESemaphore sem = new AESemaphore("DMChecker::completeRecheck");
                    int checks_submitted = 0;
                    final AESemaphore run_sem = new AESemaphore("DMChecker::completeRecheck:runsem", 2);
                    int nbPieces = DMCheckerImpl.this.disk_manager.getNbPieces();
                    int i = 0;
                    while (i < nbPieces) {
                        DMCheckerImpl.this.complete_recheck_progress = 1000 * i / nbPieces;
                        DiskManagerPiece dm_piece = DMCheckerImpl.this.disk_manager.getPiece(i);
                        if (dm_piece.isDone() || !dm_piece.isSkipped()) {
                            run_sem.reserve();
                            while (!DMCheckerImpl.this.stopped) {
                                if (recheck_inst.getPermission()) break;
                            }
                            if (DMCheckerImpl.this.stopped) break;
                            DiskManagerCheckRequest this_request = DMCheckerImpl.this.createCheckRequest(i, request2.getUserData());
                            DMCheckerImpl.this.enqueueCheckRequest(this_request, new DiskManagerCheckRequestListener(){

                                @Override
                                public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                    try {
                                        try {
                                            listener.checkCompleted(request2, passed);
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            this.complete();
                                        }
                                    }
                                    finally {
                                        this.complete();
                                    }
                                }

                                @Override
                                public void checkCancelled(DiskManagerCheckRequest request2) {
                                    try {
                                        try {
                                            listener.checkCancelled(request2);
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            this.complete();
                                        }
                                    }
                                    finally {
                                        this.complete();
                                    }
                                }

                                @Override
                                public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                    try {
                                        try {
                                            listener.checkFailed(request2, cause);
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            this.complete();
                                        }
                                    }
                                    finally {
                                        this.complete();
                                    }
                                }

                                @Override
                                public boolean isFailureInteresting() {
                                    return listener.isFailureInteresting();
                                }

                                protected void complete() {
                                    run_sem.release();
                                    sem.release();
                                }
                            }, false);
                            ++checks_submitted;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < checks_submitted) {
                        sem.reserve();
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    DMCheckerImpl.this.check_cancelled = recheck_inst.isCancelled();
                    DMCheckerImpl.this.complete_recheck_in_progress = false;
                    recheck_inst.unregister();
                    if (!DMCheckerImpl.this.stopped) {
                        DMCheckerImpl.this.disk_manager.getDownload().fireGlobalManagerEvent(2, new Object[]{request2.isExplicit(), DMCheckerImpl.this.check_cancelled});
                    }
                    throw throwable;
                }
                DMCheckerImpl.this.check_cancelled = recheck_inst.isCancelled();
                DMCheckerImpl.this.complete_recheck_in_progress = false;
                recheck_inst.unregister();
                if (!DMCheckerImpl.this.stopped) {
                    DMCheckerImpl.this.disk_manager.getDownload().fireGlobalManagerEvent(2, new Object[]{request2.isExplicit(), DMCheckerImpl.this.check_cancelled});
                }
            }
        }.start();
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        if (fully_async) {
            try {
                class_mon.enter();
                async_check_queue.add(new Object[]{this, request2, listener});
                if (async_check_queue.size() % 100 == 0) {
                    System.out.println("async check queue size=" + async_check_queue.size());
                }
            }
            finally {
                class_mon.exit();
            }
            async_check_queue_sem.release();
        } else {
            this.enqueueCheckRequest(request2, listener, flush_pieces);
        }
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        if (fully_async) {
            try {
                class_mon.enter();
                int i = 0;
                while (i < async_check_queue.size()) {
                    DiskManagerCheckRequest request2;
                    Object[] entry = (Object[])async_check_queue.get(i);
                    if (entry[0] == this && (request2 = (DiskManagerCheckRequest)entry[1]).getPieceNumber() == piece_number) {
                        return true;
                    }
                    ++i;
                }
            }
            finally {
                class_mon.exit();
            }
        }
        return false;
    }

    protected void enqueueCheckRequest(DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener, boolean read_flush) {
        request2.requestStarts();
        this.enqueueCheckRequestSupport(request2, new DiskManagerCheckRequestListener(){

            @Override
            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                request2.requestEnds(true);
                try {
                    int piece_number = request2.getPieceNumber();
                    DiskManagerPiece piece = DMCheckerImpl.this.disk_manager.getPiece(request2.getPieceNumber());
                    piece.setDone(passed);
                    if (passed) {
                        DMPieceList piece_list = DMCheckerImpl.this.disk_manager.getPieceList(piece_number);
                        int i = 0;
                        while (i < piece_list.size()) {
                            DMPieceMapEntry piece_entry = piece_list.get(i);
                            ((DiskManagerFileInfoImpl)piece_entry.getFile()).dataChecked(piece_entry.getOffset(), piece_entry.getLength());
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable) {
                    listener.checkCompleted(request2, passed);
                    if (Logger.isEnabled()) {
                        if (passed) {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 0, "Piece " + request2.getPieceNumber() + " passed hash check."));
                        } else {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, listener.isFailureInteresting() ? 1 : 0, "Piece " + request2.getPieceNumber() + " failed hash check."));
                        }
                    }
                    throw throwable;
                }
                listener.checkCompleted(request2, passed);
                if (Logger.isEnabled()) {
                    if (passed) {
                        Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 0, "Piece " + request2.getPieceNumber() + " passed hash check."));
                    } else {
                        Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, listener.isFailureInteresting() ? 1 : 0, "Piece " + request2.getPieceNumber() + " failed hash check."));
                    }
                }
            }

            @Override
            public void checkCancelled(DiskManagerCheckRequest request2) {
                request2.requestEnds(false);
                listener.checkCancelled(request2);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " hash check cancelled."));
                }
            }

            @Override
            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                request2.requestEnds(false);
                try {
                    DMCheckerImpl.this.disk_manager.getPiece(request2.getPieceNumber()).setDone(false);
                }
                finally {
                    listener.checkFailed(request2, cause);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " failed hash check - " + Debug.getNestedExceptionMessage(cause)));
                    }
                }
            }

            @Override
            public boolean isFailureInteresting() {
                return listener.isFailureInteresting();
            }

            @Override
            public boolean hashRequest(int piece_number, DiskManagerCheckRequestListener.HashListener hash_listener) {
                return listener.hashRequest(piece_number, hash_listener);
            }
        }, read_flush, false);
    }

    /*
     * Exception decompiling
     */
    protected void enqueueCheckRequestSupport(DiskManagerCheckRequest request, DiskManagerCheckRequestListener listener, boolean read_flush, boolean hash_requested) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

