/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.util.Debug;
import java.util.Arrays;

public class DiskManagerFileInfoSetImpl
implements DiskManagerFileInfoSet {
    final DiskManagerFileInfoImpl[] files;
    final DiskManagerHelper diskManager;

    public DiskManagerFileInfoSetImpl(DiskManagerFileInfoImpl[] files, DiskManagerHelper dm) {
        this.files = files;
        this.diskManager = dm;
    }

    @Override
    public void load(int[] priorities, boolean[] skipped) {
        int i = 0;
        while (i < priorities.length) {
            this.files[i].load(priorities[i], skipped[i]);
            ++i;
        }
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public int nbFiles() {
        return this.files.length;
    }

    @Override
    public void setPriority(int[] newPriorities) {
        if (newPriorities.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            int i = 0;
            while (i < this.files.length) {
                if (newPriorities[i] != 0) {
                    this.files[i].setPriority(newPriorities[i]);
                }
                ++i;
            }
        }
        finally {
            dmState.suppressStateSave(false);
        }
    }

    @Override
    public void setSkipped(boolean[] toChange, boolean setSkipped) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            if (!setSkipped) {
                String[] types = this.diskManager.getStorageTypes();
                boolean[] toLinear = new boolean[toChange.length];
                boolean[] toReorder = new boolean[toChange.length];
                int num_linear = 0;
                int num_reorder = 0;
                int i = 0;
                while (i < toChange.length) {
                    if (toChange[i]) {
                        int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                        if (old_type == 2) {
                            toLinear[i] = true;
                            ++num_linear;
                        } else if (old_type == 4) {
                            toReorder[i] = true;
                            ++num_reorder;
                        }
                    }
                    ++i;
                }
                if (num_linear > 0 && !Arrays.equals(toLinear, this.setStorageTypes(toLinear, 1))) {
                    return;
                }
                if (num_reorder > 0 && !Arrays.equals(toReorder, this.setStorageTypes(toReorder, 3))) {
                    return;
                }
            }
            int i = 0;
            while (i < this.files.length) {
                if (toChange[i]) {
                    this.files[i].setSkippedInternal(setSkipped);
                    this.diskManager.skippedFileSetChanged(this.files[i]);
                }
                ++i;
            }
        }
        finally {
            dmState.suppressStateSave(false);
        }
        DiskManagerUtil.doFileExistenceChecksAfterSkipChange(this, toChange, setSkipped, this.diskManager.getDownloadState().getDownloadManager());
    }

    @Override
    public boolean[] setStorageTypes(boolean[] toChange, int newStroageType, boolean force) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        if (this.files.length == 0) {
            return new boolean[0];
        }
        String[] types = this.diskManager.getStorageTypes();
        boolean[] modified = new boolean[this.files.length];
        DownloadManagerState dm_state = this.diskManager.getDownloadState();
        if (newStroageType == 2 || newStroageType == 4) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return modified;
        }
        try {
            dm_state.suppressStateSave(true);
            int i = 0;
            while (i < this.files.length) {
                if (toChange[i]) {
                    int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                    if (newStroageType == old_type) {
                        modified[i] = true;
                    } else {
                        DiskManagerFileInfoImpl file = this.files[i];
                        try {
                            try {
                                file.getCacheFile().setStorageType(DiskManagerUtil.convertDMStorageTypeToCache(newStroageType), force);
                                modified[i] = true;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                this.diskManager.setFailedAndRecheck(file, "Failed to change storage type for '" + file.getFile(true) + "': " + Debug.getNestedExceptionMessage(e));
                                types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
                            throw throwable;
                        }
                        types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
                    }
                }
                ++i;
            }
            dm_state.setListAttribute("storetypes", types);
            i = 0;
            while (i < this.files.length) {
                if (toChange[i]) {
                    this.diskManager.storageTypeChanged(this.files[i]);
                }
                ++i;
            }
        }
        finally {
            dm_state.suppressStateSave(false);
            dm_state.save(false);
        }
        return modified;
    }
}

