/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerOperationScheduler;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DiskManagerAllocationScheduler {
    private static Core core = CoreFactory.getSingleton();
    private static AsyncDispatcher async = new AsyncDispatcher(2000);
    private final Object lock = new Object();
    private final List<AllocationInstance> instances = new ArrayList<AllocationInstance>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocationInstance register(DiskManagerHelper helper) {
        AllocationInstance instance = new AllocationInstance(helper);
        Object object = this.lock;
        synchronized (object) {
            this.instances.add(instance);
        }
        CoreOperation op = instance.getOperation();
        core.addOperation(op);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRun(AllocationInstance instance) {
        boolean result;
        if (DiskManagerOperationScheduler.isEnabled()) {
            result = !instance.isPaused();
        } else {
            result = false;
            Object object = this.lock;
            synchronized (object) {
                for (AllocationInstance this_inst : this.instances) {
                    if (this_inst.isPaused()) continue;
                    if (this_inst != instance) break;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(AllocationInstance instance) {
        CoreOperation to_remove = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                Iterator<AllocationInstance> it = this.instances.iterator();
                while (it.hasNext()) {
                    AllocationInstance this_inst = it.next();
                    if (this_inst != instance) continue;
                    it.remove();
                    to_remove = this_inst.getOperation();
                    break;
                }
            }
        }
        finally {
            if (to_remove != null) {
                core.removeOperation(to_remove);
            }
        }
    }

    public class AllocationInstance {
        private final DiskManagerHelper helper;
        private final CoreOperation operation;
        private final boolean always_run;
        private volatile boolean paused;

        AllocationInstance(DiskManagerHelper _helper) {
            this.helper = _helper;
            this.always_run = this.helper.getTotalLength() < 0x100000L || this.helper.getDownloadState().getFlag(512L);
            final Callback progress = new Callback();
            final CoreOperationTask task2 = new CoreOperationTask(){

                @Override
                public String getName() {
                    return AllocationInstance.this.helper.getDisplayName();
                }

                @Override
                public DownloadManager getDownload() {
                    return AllocationInstance.this.helper.getDownload();
                }

                @Override
                public CoreOperationTask.ProgressCallback getProgressCallback() {
                    return progress;
                }
            };
            this.operation = new CoreOperation(){

                @Override
                public int getOperationType() {
                    return 5;
                }

                @Override
                public CoreOperationTask getTask() {
                    return task2;
                }
            };
        }

        protected CoreOperation getOperation() {
            return this.operation;
        }

        protected boolean isPaused() {
            return this.paused;
        }

        protected void setPaused(boolean b) {
            this.paused = b;
        }

        public boolean getPermission() {
            if (this.always_run) {
                return true;
            }
            boolean result = DiskManagerAllocationScheduler.this.canRun(this);
            if (!result) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }

        public void unregister() {
            DiskManagerAllocationScheduler.this.unregister(this);
        }

        class Callback
        extends CoreOperationTask.ProgressCallbackAdapter {
            final DownloadManager dm;
            boolean cancelled;

            Callback() {
                this.dm = AllocationInstance.this.helper.getDownload();
            }

            @Override
            public int getProgress() {
                return AllocationInstance.this.helper.getPercentAllocated();
            }

            @Override
            public long getSize() {
                return AllocationInstance.this.helper.getSizeExcludingDND();
            }

            @Override
            public String getSubTaskName() {
                return AllocationInstance.this.helper.getAllocationTask();
            }

            @Override
            public int getSupportedTaskStates() {
                if (AllocationInstance.this.always_run) {
                    return 12;
                }
                return 15;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaskState() {
                Object object = DiskManagerAllocationScheduler.this.lock;
                synchronized (object) {
                    block8: {
                        block7: {
                            block6: {
                                if (!this.cancelled) break block6;
                                return 4;
                            }
                            if (!AllocationInstance.this.isPaused()) break block7;
                            return 1;
                        }
                        if (!DiskManagerAllocationScheduler.this.canRun(AllocationInstance.this)) break block8;
                        return 0;
                    }
                    return 16;
                }
            }

            @Override
            public void setTaskState(int state) {
                if (state == 4) {
                    this.cancelled = true;
                    if (this.dm != null) {
                        async.dispatch(AERunnable.create(() -> this.dm.stopIt(70, false, false)));
                    }
                } else if (!AllocationInstance.this.always_run) {
                    if (state == 1) {
                        AllocationInstance.this.setPaused(true);
                    } else if (state == 2) {
                        AllocationInstance.this.setPaused(false);
                    }
                }
            }
        }
    }
}

