/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestKeyBlock
extends DHTUDPPacketRequest {
    private int random_id;
    private byte[] key_block_request;
    private byte[] key_block_signature;

    public DHTUDPPacketRequestKeyBlock(DHTTransportUDPImpl _transport, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_transport, 1036, _connection_id, _local_contact, _remote_contact);
    }

    protected DHTUDPPacketRequestKeyBlock(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, long con_id, int trans_id) throws IOException {
        super(network_handler, is, 1036, con_id, trans_id);
        this.random_id = is.readInt();
        this.key_block_request = DHTUDPUtils.deserialiseByteArray(is, 255);
        this.key_block_signature = DHTUDPUtils.deserialiseByteArray(is, 65535);
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeInt(this.random_id);
        DHTUDPUtils.serialiseByteArray(os, this.key_block_request, 255);
        DHTUDPUtils.serialiseByteArray(os, this.key_block_signature, 65535);
    }

    public void setKeyBlockDetails(byte[] req, byte[] sig) {
        this.key_block_request = req;
        this.key_block_signature = sig;
    }

    protected void setRandomID(int _random_id) {
        this.random_id = _random_id;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    public byte[] getKeyBlockRequest() {
        return this.key_block_request;
    }

    public byte[] getKeyBlockSignature() {
        return this.key_block_signature;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

