/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryListener;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.category.CategoryManagerListener;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.TranscodeManager;
import com.biglybt.core.devices.TranscodeManagerListener;
import com.biglybt.core.devices.TranscodeProfile;
import com.biglybt.core.devices.TranscodeProvider;
import com.biglybt.core.devices.TranscodeTarget;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.TranscodeProviderVuze;
import com.biglybt.core.devices.impl.TranscodeQueueImpl;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagFeatureListener;
import com.biglybt.core.tag.TagFeatureTranscode;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TranscodeManagerImpl
implements TranscodeManager {
    private DeviceManagerImpl device_manager;
    private Core core;
    private volatile TranscodeProviderVuze vuzexcode_provider;
    private CopyOnWriteList<TranscodeManagerListener> listeners = new CopyOnWriteList();
    private TranscodeQueueImpl queue = new TranscodeQueueImpl(this);
    AESemaphore init_sem = new AESemaphore("TM:init");
    private boolean hooked_categories;
    Map<Category, Object[]> category_map = new HashMap<Category, Object[]>();
    private CategoryListener category_listener;
    private GlobalManagerListener category_dl_listener;
    private TorrentAttribute category_ta;
    private boolean hooked_tags;
    Map<Tag, Object[]> tag_map = new HashMap<Tag, Object[]>();
    private TagListener tag_listener;
    private TorrentAttribute tag_ta;

    protected TranscodeManagerImpl(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
        this.core = CoreFactory.getSingleton();
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.category_ta = default_pi.getTorrentManager().getPluginAttribute("xcode.cat.done");
        this.tag_ta = default_pi.getTorrentManager().getPluginAttribute("xcode.tag.done");
        final AESemaphore plugin_sem = new AESemaphore("TM:plugin");
        default_pi.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                try {
                    PluginInterface[] plugins;
                    PluginInterface default_pi = PluginInitializer.getDefaultInterface();
                    default_pi.addEventListener(new PluginEventListener(){

                        @Override
                        public void handleEvent(PluginEvent ev) {
                            int type = ev.getType();
                            if (type == 8) {
                                TranscodeManagerImpl.this.pluginAdded((PluginInterface)ev.getValue());
                            }
                            if (type == 9) {
                                TranscodeManagerImpl.this.pluginRemoved((PluginInterface)ev.getValue());
                            }
                        }
                    });
                    PluginInterface[] pluginInterfaceArray = plugins = default_pi.getPluginManager().getPlugins();
                    int n = plugins.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PluginInterface pi = pluginInterfaceArray[n2];
                        if (pi.getPluginState().isOperational()) {
                            TranscodeManagerImpl.this.pluginAdded(pi);
                        }
                        ++n2;
                    }
                }
                finally {
                    plugin_sem.releaseForever();
                }
            }

            @Override
            public void closedownInitiated() {
                plugin_sem.releaseForever();
                TranscodeManagerImpl.this.init_sem.releaseForever();
            }

            @Override
            public void closedownComplete() {
            }
        });
        if (!plugin_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
    }

    protected void initialise() {
        this.queue.initialise();
        this.init_sem.releaseForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pi) {
        block13: {
            TranscodeProviderVuze provider;
            boolean updated;
            block14: {
                if (pi.getPluginState().isBuiltIn()) {
                    return;
                }
                String plugin_id = pi.getPluginID();
                if (!plugin_id.equals("vuzexcode")) break block13;
                boolean added = false;
                updated = false;
                provider = null;
                TranscodeManagerImpl transcodeManagerImpl = this;
                synchronized (transcodeManagerImpl) {
                    if (this.vuzexcode_provider == null) {
                        this.vuzexcode_provider = new TranscodeProviderVuze(this, pi);
                        added = true;
                    } else if (pi != this.vuzexcode_provider.getPluginInterface()) {
                        this.vuzexcode_provider.update(pi);
                        updated = true;
                    }
                    provider = this.vuzexcode_provider;
                }
                if (!added) break block14;
                for (TranscodeManagerListener listener : this.listeners) {
                    try {
                        listener.providerAdded(provider);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                break block13;
            }
            if (!updated) break block13;
            for (TranscodeManagerListener listener : this.listeners) {
                try {
                    listener.providerUpdated(provider);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pi) {
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("vuzexcode")) {
            TranscodeProviderVuze provider = null;
            TranscodeManagerImpl transcodeManagerImpl = this;
            synchronized (transcodeManagerImpl) {
                if (this.vuzexcode_provider != null) {
                    provider = this.vuzexcode_provider;
                    this.vuzexcode_provider.destroy();
                    this.vuzexcode_provider = null;
                }
            }
            if (provider != null) {
                for (TranscodeManagerListener listener : this.listeners) {
                    try {
                        listener.providerRemoved(provider);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
    }

    protected void updateStatus(int tick_count) {
        if (this.queue != null) {
            this.queue.updateStatus(tick_count);
            if (!this.hooked_categories) {
                this.hooked_categories = true;
                CategoryManager.addCategoryManagerListener(new CategoryManagerListener(){

                    @Override
                    public void categoryAdded(Category category) {
                    }

                    @Override
                    public void categoryRemoved(Category category) {
                    }

                    @Override
                    public void categoryChanged(Category category) {
                        TranscodeManagerImpl.this.checkCategories();
                    }
                });
                this.checkCategories();
            }
            if (!this.hooked_tags) {
                this.hooked_tags = true;
                TagManagerFactory.getTagManager().addTagFeatureListener(8, new TagFeatureListener(){

                    @Override
                    public void tagFeatureChanged(Tag tag, int feature) {
                        TranscodeManagerImpl.this.checkTags();
                    }
                });
                this.checkTags();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkCategories() {
        Category[] cats = CategoryManager.getCategories();
        HashMap<Category, Object[]> active_map = new HashMap<Category, Object[]>();
        Category[] categoryArray = cats;
        int n = cats.length;
        int n2 = 0;
        while (n2 < n) {
            Category cat = categoryArray[n2];
            String target = cat.getStringAttribute("at_att");
            if (target != null) {
                String device_id = null;
                if (target.endsWith("/blank")) {
                    device_id = target.substring(0, target.length() - 6);
                }
                DeviceMediaRenderer target_dmr = null;
                TranscodeProfile target_profile = null;
                DeviceImpl[] deviceImplArray = this.device_manager.getDevices();
                int n3 = deviceImplArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DeviceImpl device = deviceImplArray[n4];
                    if (device instanceof DeviceMediaRenderer) {
                        DeviceMediaRenderer dmr = (DeviceMediaRenderer)((Object)device);
                        if (device_id != null) {
                            if (device.getID().equals(device_id)) {
                                target_dmr = dmr;
                                target_profile = device.getBlankProfile();
                                break;
                            }
                        } else {
                            TranscodeProfile[] profs;
                            TranscodeProfile[] transcodeProfileArray = profs = device.getTranscodeProfiles();
                            int n5 = profs.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TranscodeProfile prof = transcodeProfileArray[n6];
                                if (prof.getUID().equals(target)) {
                                    target_dmr = dmr;
                                    target_profile = prof;
                                    break;
                                }
                                ++n6;
                            }
                        }
                    }
                    ++n4;
                }
                if (target_dmr != null) {
                    active_map.put(cat, new Object[]{target_dmr, target_profile});
                }
            }
            ++n2;
        }
        HashMap<Category, Object[]> to_process = new HashMap<Category, Object[]>();
        Map<Category, Object[]> map = this.category_map;
        synchronized (map) {
            if (this.category_listener == null) {
                this.category_listener = new CategoryListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadManagerAdded(Category cat, DownloadManager manager) {
                        Object[] details;
                        Map<Category, Object[]> map = TranscodeManagerImpl.this.category_map;
                        synchronized (map) {
                            details = TranscodeManagerImpl.this.category_map.get(cat);
                        }
                        if (details != null) {
                            TranscodeManagerImpl.this.processCategory(cat, details, manager);
                        }
                    }

                    @Override
                    public void downloadManagerRemoved(Category cat, DownloadManager removed) {
                    }
                };
            }
            Iterator<Category> iterator = this.category_map.keySet().iterator();
            while (iterator.hasNext()) {
                final Category c = iterator.next();
                if (active_map.containsKey(c)) continue;
                c.removeCategoryListener(this.category_listener);
                iterator.remove();
            }
            for (final Category c : active_map.keySet()) {
                if (this.category_map.containsKey(c)) continue;
                to_process.put(c, (Object[])active_map.get(c));
                c.addCategoryListener(this.category_listener);
                this.category_map.put(c, (Object[])active_map.get(c));
                if (c.getType() != 2 || this.category_dl_listener != null) continue;
                this.category_dl_listener = new GlobalManagerAdapter(){

                    @Override
                    public void downloadManagerAdded(final DownloadManager dm) {
                        new DelayedEvent("TM:cat-check", 10000L, new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Category dm_c = dm.getDownloadState().getCategory();
                                if (dm_c == null || dm_c == c) {
                                    Object[] details;
                                    Map<Category, Object[]> map = (this).TranscodeManagerImpl.this.category_map;
                                    synchronized (map) {
                                        details = (this).TranscodeManagerImpl.this.category_map.get(c);
                                    }
                                    if (details != null) {
                                        TranscodeManagerImpl.this.processCategory(c, details, dm);
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void downloadManagerRemoved(DownloadManager dm) {
                    }
                };
                this.core.getGlobalManager().addListener(this.category_dl_listener, false);
            }
        }
        if (to_process.size() > 0) {
            List<DownloadManager> downloads = this.core.getGlobalManager().getDownloadManagers();
            for (Map.Entry entry : to_process.entrySet()) {
                Category c = (Category)entry.getKey();
                Object[] details = (Object[])entry.getValue();
                List<DownloadManager> list = c.getDownloadManagers(downloads);
                for (DownloadManager dm : list) {
                    this.processCategory(c, details, dm);
                }
            }
        }
    }

    void processCategory(Category cat, Object[] details, DownloadManager dm) {
        Download download = PluginCoreUtils.wrap(dm);
        if (download == null) {
            return;
        }
        if (download.getFlag(16L)) {
            return;
        }
        String str = download.getAttribute(this.category_ta);
        String cat_name = cat.getName();
        if (cat.getType() == 2) {
            cat_name = "<none>";
        }
        String cat_tag = String.valueOf(cat_name) + ";";
        if (str != null && str.contains(cat_tag)) {
            return;
        }
        try {
            DeviceMediaRenderer device = (DeviceMediaRenderer)details[0];
            TranscodeProfile profile = (TranscodeProfile)details[1];
            this.log("Category " + cat_name + " - adding " + download.getName() + " to " + device.getName() + "/" + profile.getName());
            DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
            int num_added = 0;
            DiskManagerFileInfo[] diskManagerFileInfoArray = dm_files;
            int n = dm_files.length;
            int n2 = 0;
            while (n2 < n) {
                DiskManagerFileInfo dm_file = diskManagerFileInfoArray[n2];
                if (num_added > 64) break;
                if (dm_files.length == 1 || dm_file.getLength() >= 131072L) {
                    try {
                        this.queue.add(device, profile, dm_file, false);
                        ++num_added;
                    }
                    catch (Throwable e) {
                        this.log("    add failed", e);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            download.setAttribute(this.category_ta, str == null ? cat_tag : String.valueOf(str) + cat_tag);
            throw throwable;
        }
        download.setAttribute(this.category_ta, str == null ? cat_tag : String.valueOf(str) + cat_tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTags() {
        TagManager tm = TagManagerFactory.getTagManager();
        HashMap<Tag, Object[]> active_map = new HashMap<Tag, Object[]>();
        for (TagType tt : tm.getTagTypes()) {
            if (!tt.hasTagTypeFeature(8L)) continue;
            for (Tag tag : tt.getTags()) {
                String[] target_details;
                TagFeatureTranscode tfx = (TagFeatureTranscode)((Object)tag);
                if (!tfx.supportsTagTranscode() || (target_details = tfx.getTagTranscodeTarget()) == null) continue;
                String target = target_details[0];
                String device_id = null;
                if (target.endsWith("/blank")) {
                    device_id = target.substring(0, target.length() - 6);
                }
                DeviceMediaRenderer target_dmr = null;
                TranscodeProfile target_profile = null;
                DeviceImpl[] deviceImplArray = this.device_manager.getDevices();
                int n = deviceImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DeviceImpl device = deviceImplArray[n2];
                    if (device instanceof DeviceMediaRenderer) {
                        DeviceMediaRenderer dmr = (DeviceMediaRenderer)((Object)device);
                        if (device_id != null) {
                            if (device.getID().equals(device_id)) {
                                target_dmr = dmr;
                                target_profile = device.getBlankProfile();
                                break;
                            }
                        } else {
                            TranscodeProfile[] profs;
                            TranscodeProfile[] transcodeProfileArray = profs = device.getTranscodeProfiles();
                            int n3 = profs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                TranscodeProfile prof = transcodeProfileArray[n4];
                                if (prof.getUID().equals(target)) {
                                    target_dmr = dmr;
                                    target_profile = prof;
                                    break;
                                }
                                ++n4;
                            }
                        }
                    }
                    ++n2;
                }
                if (target_dmr == null) continue;
                active_map.put(tag, new Object[]{target_dmr, target_profile});
            }
        }
        HashMap<Tag, Object[]> to_process = new HashMap<Tag, Object[]>();
        Map<Tag, Object[]> map = this.tag_map;
        synchronized (map) {
            if (this.tag_listener == null) {
                this.tag_listener = new TagListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void taggableAdded(Tag tag, Taggable tagged) {
                        Object[] details;
                        Map<Tag, Object[]> map = TranscodeManagerImpl.this.tag_map;
                        synchronized (map) {
                            details = TranscodeManagerImpl.this.tag_map.get(tag);
                        }
                        if (details != null) {
                            TranscodeManagerImpl.this.processTag(tag, details, (DownloadManager)tagged);
                        }
                    }

                    @Override
                    public void taggableSync(Tag tag) {
                    }

                    @Override
                    public void taggableRemoved(Tag tag, Taggable tagged) {
                    }
                };
            }
            Iterator<Tag> it = this.tag_map.keySet().iterator();
            while (it.hasNext()) {
                Tag t = it.next();
                if (active_map.containsKey(t)) continue;
                t.removeTagListener(this.tag_listener);
                it.remove();
            }
            for (Tag tag : active_map.keySet()) {
                if (this.tag_map.containsKey(tag)) continue;
                to_process.put(tag, (Object[])active_map.get(tag));
                tag.addTagListener(this.tag_listener, false);
                this.tag_map.put(tag, (Object[])active_map.get(tag));
            }
        }
        if (to_process.size() > 0) {
            for (Map.Entry entry : to_process.entrySet()) {
                Tag tag;
                tag = (Tag)entry.getKey();
                Object[] details = (Object[])entry.getValue();
                Set<DownloadManager> list = ((TagDownload)tag).getTaggedDownloads();
                for (DownloadManager dm : list) {
                    this.processTag(tag, details, dm);
                }
            }
        }
    }

    void processTag(Tag tag, Object[] details, DownloadManager dm) {
        Download download = PluginCoreUtils.wrap(dm);
        if (download == null) {
            return;
        }
        if (download.getFlag(16L)) {
            return;
        }
        String str = download.getAttribute(this.tag_ta);
        String tag_name = tag.getTagName(true);
        String tag_tag = String.valueOf(tag.getTagType().getTagType()) + "." + tag.getTagID() + ";";
        if (str != null && str.contains(tag_tag)) {
            return;
        }
        try {
            DeviceMediaRenderer device = (DeviceMediaRenderer)details[0];
            TranscodeProfile profile = (TranscodeProfile)details[1];
            this.log("Tag " + tag_name + " - adding " + download.getName() + " to " + device.getName() + "/" + profile.getName());
            DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
            int num_added = 0;
            DiskManagerFileInfo[] diskManagerFileInfoArray = dm_files;
            int n = dm_files.length;
            int n2 = 0;
            while (n2 < n) {
                DiskManagerFileInfo dm_file = diskManagerFileInfoArray[n2];
                if (num_added > 64) break;
                if (dm_files.length == 1 || dm_file.getLength() >= 131072L) {
                    try {
                        this.queue.add(device, profile, dm_file, false);
                        ++num_added;
                    }
                    catch (Throwable e) {
                        this.log("    add failed", e);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            download.setAttribute(this.tag_ta, str == null ? tag_tag : String.valueOf(str) + tag_tag);
            throw throwable;
        }
        download.setAttribute(this.tag_ta, str == null ? tag_tag : String.valueOf(str) + tag_tag);
    }

    @Override
    public TranscodeProvider[] getProviders() {
        TranscodeProviderVuze vp = this.vuzexcode_provider;
        if (vp == null) {
            return new TranscodeProvider[0];
        }
        return new TranscodeProvider[]{vp};
    }

    protected TranscodeProvider getProvider(int p_id) throws TranscodeException {
        TranscodeProviderVuze vp = this.vuzexcode_provider;
        if (p_id == 1 && vp != null) {
            return vp;
        }
        throw new TranscodeException("Transcode provider not registered");
    }

    protected TranscodeProfile getProfileFromUID(String uid) {
        TranscodeProvider[] transcodeProviderArray = this.getProviders();
        int n = transcodeProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            TranscodeProvider provider = transcodeProviderArray[n2];
            TranscodeProfile profile = provider.getProfile(uid);
            if (profile != null) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public TranscodeQueueImpl getQueue() {
        if (!this.init_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
        return this.queue;
    }

    protected DeviceManagerImpl getManager() {
        return this.device_manager;
    }

    protected TranscodeTarget lookupTarget(String target_id) throws TranscodeException {
        DeviceImpl device = this.device_manager.getDevice(target_id);
        if (device instanceof TranscodeTarget) {
            return (TranscodeTarget)((Object)device);
        }
        throw new TranscodeException("Transcode target with id " + target_id + " not found");
    }

    protected DiskManagerFileInfo lookupFile(byte[] hash, int index) throws TranscodeException {
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            if (download == null) {
                throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(hash) + " not found");
            }
            return download.getDiskManagerFileInfo()[index];
        }
        catch (Throwable e) {
            throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(hash) + " not found", e);
        }
    }

    protected void close() {
        this.queue.close();
    }

    @Override
    public void addListener(TranscodeManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TranscodeManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void log(String str) {
        this.device_manager.log("Trans: " + str);
    }

    protected void log(String str, Throwable e) {
        this.device_manager.log("Trans: " + str, e);
    }

    public void generate(IndentWriter writer) {
        writer.println("Transcode Manager: vuze provider=" + this.vuzexcode_provider);
        this.queue.generate(writer);
    }
}

