/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceManagerException;
import com.biglybt.core.devices.DeviceMediaRendererTemplate;
import com.biglybt.core.devices.TranscodeProfile;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class DeviceMediaRendererTemplateImpl
implements DeviceMediaRendererTemplate {
    private List<TranscodeProfile> profiles = new ArrayList<TranscodeProfile>();
    private final DeviceManagerImpl manager;
    private final String classification;
    private final String name;
    private final String manufacturer;
    private final boolean auto;

    protected DeviceMediaRendererTemplateImpl(DeviceManagerImpl _manager, String _classification, boolean _auto) {
        this.manager = _manager;
        this.classification = _classification;
        this.auto = _auto;
        int pos = this.classification.indexOf(46);
        this.manufacturer = pos == -1 ? this.classification : this.classification.substring(0, pos);
        pos = this.classification.lastIndexOf(46);
        this.name = pos == -1 ? this.classification : this.classification.substring(pos + 1);
    }

    protected void addProfile(TranscodeProfile profile) {
        this.profiles.add(profile);
    }

    @Override
    public TranscodeProfile[] getProfiles() {
        return this.profiles.toArray(new TranscodeProfile[this.profiles.size()]);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public String getClassification() {
        return this.classification;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    @Override
    public int getRendererSpecies() {
        return 6;
    }

    @Override
    public boolean isAuto() {
        return this.auto;
    }

    @Override
    public Device createInstance(String name) throws DeviceManagerException {
        return this.createInstance(name, null, true);
    }

    @Override
    public Device createInstance(String name, String uid, boolean manual) throws DeviceManagerException {
        if (this.auto) {
            throw new DeviceManagerException("Device can't be added manually");
        }
        Device res = this.manager.createDevice(3, uid, this.classification, name, manual);
        return res;
    }
}

