/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.devices.DeviceManagerException;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceUPnPImpl;
import com.biglybt.core.devices.impl.TranscodeFileImpl;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.sharing.ShareResourceFile;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceMediaRendererImpl
extends DeviceUPnPImpl
implements DeviceMediaRenderer {
    private static final int INSTALL_CHECK_PERIOD = 60000;
    private static final int TAG_SHARE_CHECK_TICKS = 12;
    static TorrentAttribute share_ta;
    static List<Object[]> share_requests;
    private static AsyncDispatcher share_dispatcher;

    static {
        share_requests = new ArrayList<Object[]>();
        share_dispatcher = new AsyncDispatcher();
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, UPnPDevice _device) {
        super(_manager, _device, 3);
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, String _classification) {
        super(_manager, 3, _classification);
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, String _uuid, String _classification, boolean _manual, String _name) {
        super(_manager, 3, _uuid, _classification, _manual, _name);
    }

    public DeviceMediaRendererImpl(DeviceManagerImpl _manager, String _uuid, String _classification, boolean _manual) {
        super(_manager, 3, _uuid, _classification, _manual);
    }

    protected DeviceMediaRendererImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    public void setAddress(InetAddress address) {
        super.setAddress(address);
        if (this.getType() == 3) {
            DeviceImpl[] devices;
            boolean hasUPnPDevice = this.getUPnPDevice() != null;
            DeviceImpl[] deviceImplArray = devices = this.getManager().getDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceImpl device = deviceImplArray[n2];
                if (device != this && !device.getID().equals(this.getID()) && device instanceof DeviceUPnPImpl) {
                    DeviceUPnPImpl deviceUPnP = (DeviceUPnPImpl)device;
                    if (address.equals(device.getAddress()) && device.isAlive()) {
                        String manufacturer;
                        if (hasUPnPDevice) {
                            int fileCount;
                            boolean no_auto_hide = device.getPersistentBooleanProperty("rend_no_ah", false);
                            if (device.getType() != 3 || no_auto_hide || deviceUPnP.getUPnPDevice() == null || (fileCount = deviceUPnP.getFileCount()) != 0 || device.isHidden()) break;
                            this.log("Hiding " + device.getName() + "/" + device.getClassification() + "/" + device.getID() + " due to " + this.getName() + "/" + this.getClassification() + "/" + this.getID());
                            device.setHidden(true);
                            break;
                        }
                        if (device.getType() == 3) {
                            boolean no_auto_hide = this.getPersistentBooleanProperty("rend_no_ah", false);
                            if (no_auto_hide) break;
                            int fileCount = this.getFileCount();
                            if (fileCount == 0 && !this.isHidden()) {
                                this.log("hiding " + this.getName() + "/" + this.getClassification() + "/" + this.getID() + " due to " + device.getName() + "/" + device.getClassification() + "/" + device.getID());
                                this.setHidden(true);
                                break;
                            }
                            if (fileCount <= 0 || !Constants.IS_CVS_VERSION || !this.isHidden()) break;
                            this.setHidden(false);
                            break;
                        }
                        UPnPDevice upnpDevice = deviceUPnP.getUPnPDevice();
                        if (upnpDevice == null || (manufacturer = upnpDevice.getManufacturer()) != null && (manufacturer.startsWith("Vuze") || manufacturer.startsWith("BiglyBT"))) break;
                        this.log("Linked " + this.getName() + " to UPnP Device " + device.getName());
                        this.setUPnPDevice(upnpDevice);
                        this.setDirty();
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceMediaRendererImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceMediaRendererImpl other = (DeviceMediaRendererImpl)_other;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void updateStatus(int tick_count) {
        long tag_id;
        super.updateStatus(tick_count);
        if (tick_count <= 0 || tick_count % 12 != 0 || (tag_id = this.getAutoShareToTagID()) == -1L) return;
        Class<DeviceMediaRendererImpl> clazz = DeviceMediaRendererImpl.class;
        synchronized (DeviceMediaRendererImpl.class) {
            if (share_ta == null) {
                share_ta = PluginInitializer.getDefaultInterface().getTorrentManager().getPluginAttribute("DeviceMediaRendererImpl:tag_share");
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            TagManager tm = TagManagerFactory.getTagManager();
            Tag assigned_tag = tm.lookupTagByUID(tag_id);
            if (assigned_tag == null) return;
            assigned_tag.setPublic(false);
            List<Object[]> list = share_requests;
            synchronized (list) {
                TranscodeFileImpl[] files;
                if (share_requests.size() != 0) return;
                Set<Taggable> taggables = assigned_tag.getTagged();
                HashSet<String> done_files = new HashSet<String>();
                for (Taggable temp : taggables) {
                    DownloadManager dm;
                    Download download;
                    String attr;
                    if (!(temp instanceof DownloadManager) || (attr = (download = PluginCoreUtils.wrap(dm = (DownloadManager)temp)).getAttribute(share_ta)) == null) continue;
                    done_files.add(attr);
                }
                TranscodeFileImpl[] transcodeFileImplArray = files = this.getFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    TranscodeFileImpl file = transcodeFileImplArray[n2];
                    if (file.isComplete()) {
                        try {
                            File target_file = file.getTargetFile().getFile(true);
                            long size = target_file.length();
                            if (target_file.exists() && size > 0L) {
                                String suffix = " (" + file.getProfileName() + " - " + DisplayFormatters.formatByteCountToKiBEtc(size) + ")";
                                String share_name = String.valueOf(file.getName()) + suffix;
                                String key = String.valueOf(target_file.getName()) + suffix;
                                if (!done_files.contains(key)) {
                                    share_requests.add(new Object[]{key, target_file, share_name, assigned_tag});
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                if (share_requests.size() <= 0) return;
                this.shareRequestAdded();
                return;
            }
        }
    }

    private void shareRequestAdded() {
        share_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList<Object[]> to_process;
                List<Object[]> list = share_requests;
                synchronized (list) {
                    to_process = new ArrayList<Object[]>(share_requests);
                }
                for (Object[] entry : to_process) {
                    try {
                        String key = (String)entry[0];
                        File file = (File)entry[1];
                        String name = (String)entry[2];
                        Tag tag = (Tag)entry[3];
                        DeviceMediaRendererImpl.this.log("Auto sharing " + name + " (" + file + ") to tag " + tag.getTagName(true));
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("user_data", "device:autoshare");
                        String[] networks = AENetworkClassifier.getDefaultNetworks();
                        String networks_str = "";
                        String[] stringArray = networks;
                        int n = networks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String net = stringArray[n2];
                            networks_str = String.valueOf(networks_str) + (networks_str.length() == 0 ? "" : ",") + net;
                            ++n2;
                        }
                        properties.put("networks", networks_str);
                        properties.put("tags", String.valueOf(tag.getTagUID()));
                        PluginInterface pi = PluginInitializer.getDefaultInterface();
                        ShareResourceFile srf = pi.getShareManager().addFile(file, properties);
                        Torrent torrent = srf.getItem().getTorrent();
                        Download download = pi.getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(torrent.getHash());
                        if (download == null) {
                            throw new Exception("Download no longer exists");
                        }
                        DownloadManager dm = PluginCoreUtils.unwrap(download);
                        dm.getDownloadState().setDisplayName(name);
                        download.setAttribute(share_ta, key);
                    }
                    catch (Throwable e) {
                        DeviceMediaRendererImpl.this.log("Auto sharing failed", e);
                    }
                }
                list = share_requests;
                synchronized (list) {
                    share_requests.removeAll(to_process);
                }
            }
        });
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    @Override
    public boolean canCopyToDevice() {
        return false;
    }

    @Override
    public boolean getAutoCopyToDevice() {
        return false;
    }

    @Override
    public void setAutoCopyToDevice(boolean auto) {
    }

    @Override
    public int getCopyToDevicePending() {
        return 0;
    }

    @Override
    public boolean canAutoStartDevice() {
        return false;
    }

    @Override
    public boolean getAutoStartDevice() {
        return false;
    }

    @Override
    public void setAutoStartDevice(boolean auto) {
    }

    @Override
    public boolean canCopyToFolder() {
        return false;
    }

    @Override
    public void setCanCopyToFolder(boolean can) {
    }

    @Override
    public File getCopyToFolder() {
        return null;
    }

    @Override
    public void setCopyToFolder(File file) {
    }

    @Override
    public int getCopyToFolderPending() {
        return 0;
    }

    @Override
    public boolean getAutoCopyToFolder() {
        return false;
    }

    @Override
    public void setAutoCopyToFolder(boolean auto) {
    }

    @Override
    public void manualCopy() throws DeviceManagerException {
        throw new DeviceManagerException("Unsupported");
    }

    @Override
    public boolean canShowCategories() {
        return false;
    }

    @Override
    public void setShowCategories(boolean b) {
        this.setPersistentBooleanProperty("tt_show_cat", b);
    }

    @Override
    public boolean getShowCategories() {
        return this.getPersistentBooleanProperty("tt_show_cat", this.getShowCategoriesDefault());
    }

    protected boolean getShowCategoriesDefault() {
        return false;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        if (this.canCopyToFolder()) {
            this.addDP(dp, "devices.copy.folder.auto", this.getAutoCopyToFolder());
            this.addDP(dp, "devices.copy.folder.dest", this.getCopyToFolder());
        }
        if (this.canCopyToDevice()) {
            this.addDP(dp, "devices.copy.device.auto", this.getAutoCopyToDevice());
        }
        if (this.canShowCategories()) {
            this.addDP(dp, "devices.cat.show", this.getShowCategories());
        }
        super.getTTDisplayProperties(dp);
    }

    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            this.generateTT(writer);
        }
        finally {
            writer.exdent();
        }
    }
}

